package com.dtyunxi.yundt.cube.center.func.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.EoCreateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 功能包EO服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"基础数据中心：配置项管理：功能包EO服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-func-api-IEoApi",
        name = "${yundt.cube.center.data.name:yundt-cube-center-data}", path = "/v1/eo", url = "${yundt.cube.center.data.api:}")
public interface IEoApi {

    /**
     * 新增功能包EO
     *
     * @param addReqDto 功能包EO请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增功能包EO", notes = "新增功能包EO")
    @Capability(capabilityCode = "basicdata.eo.add-eo")
    RestResponse<Long> addEo(@RequestBody EoCreateReqDto addReqDto);

    /**
     * 修改功能包EO
     *
     * @param modifyReqDto 功能包EO请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改功能包EO", notes = "修改功能包EO")
    @Capability(capabilityCode = "basicdata.eo.modify-eo")
    RestResponse<Void> modifyEo(@RequestBody EoCreateReqDto modifyReqDto);

    /**
     * 删除功能包EO
     *
     * @param ids        功能包EO删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除功能包EO", notes = "删除功能包EO")
    @Capability(capabilityCode = "basicdata.eo.remove-eo")
    RestResponse<Void> removeEo(@PathVariable("ids") String ids,
                                @RequestParam("instanceId") Long instanceId);
}
