package com.dtyunxi.yundt.cube.center.func.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizid.BizConfigResDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizid.BizIdQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizid.SpaceIdQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizIdAndBizSpaceDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizIdQueryResDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizSpaceRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 业务身份服务接口
 *
 * @author 代码生成器
 */
@Validated
@Api(tags = {"基础数据中心：配置项管理：业务身份服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-query-IBizIdQueryApi",
        name = "${yundt.cube.center.data.name:yundt-cube-center-data}", path = "/v1/biz-id", url = "${yundt.cube.center.data.api:}")
public interface IBizIdQueryApi {

    /**
     * 根据code查询业务身份
     *
     * @param code 业务身份code
     * @return 业务身份数据
     */
    @GetMapping("")
    @ApiOperation(value = "根据code查询业务身份", notes = "根据code查询业务身份, tenantId废弃，改由上下文获取")
    @Capability(capabilityCode = "basicdata.biz-id.query-by-code")
    RestResponse<BizIdQueryResDto> queryByCode(@RequestParam(value = "tenantId", required = false) Long tenantId,
                                               @RequestParam("code") @NotBlank(message = "业务身份编码不能为空") String code);

    /**
     * 查询当前业务身份、业务空间信息
     *
     * @param bizIdCode    业务身份code
     * @param bizSpaceCode 业务空间code
     * @return 业务身份数据
     */
    @GetMapping("/biz-space")
    @ApiOperation(value = "查询当前业务身份、业务空间信息", notes = "查询当前业务身份、业务空间信息")
    @Capability(capabilityCode = "basicdata.biz-id.query-biz-id-and-biz-space")
    RestResponse<BizIdAndBizSpaceDto> queryBizIdAndBizSpace(@RequestParam("bizIdCode") String bizIdCode,
                                                            @RequestParam("bizSpaceCode") String bizSpaceCode);

    /**
     * 业务身份分页数据
     *
     * @param queryReqDto 业务身份查询条件
     * @param pageNum     当前页
     * @param pageSize    页大小
     * @return 业务身份分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "业务身份分页数据", notes = "查询业务身份数据")
    @Capability(capabilityCode = "basicdata.biz-id.query-by-page")
    RestResponse<PageInfo<BizIdQueryResDto>> queryByPage(@SpringQueryMap BizIdQueryReqDto queryReqDto,
                                                         @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                         @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据业务身份查询条件查询业务空间数据
     *
     * @param queryReqDto 查询Dto
     * @param pageNum     当前页
     * @param pageSize    分页大小
     * @return 分页数据
     */
    @GetMapping("/space")
    @ApiOperation(value = "根据业务身份查询条件查询业务空间数据", notes = "根据业务身份查询条件查询业务空间数据")
    @Capability(capabilityCode = "basicdata.biz-id.query-biz-space-by-page")
    RestResponse<PageInfo<BizSpaceRespDto>> queryBizSpaceByPage(@SpringQueryMap SpaceIdQueryReqDto queryReqDto,
                                                                @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据业务空间编码和业务身份编码查询配置
     *
     * @param spaceCode 业务空间编码
     * @param idCode    业务身份编码
     * @return 配置数据
     */
    @GetMapping("/space-id-configs")
    @ApiOperation(value = "根据业务空间编码和业务身份编码查询配置", notes = "根据业务空间编码和业务身份编码查询配置")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tenantId", value = "租户id 废弃，改由上下文获取", paramType = "query"),
            @ApiImplicitParam(name = "spaceCode", value = "业务空间编码", paramType = "query", required = true),
            @ApiImplicitParam(name = "idCode", value = "业务身份编码", paramType = "query", required = true)
    })
    @Capability(capabilityCode = "basicdata.biz-id.query-biz-space-id-configs")
    RestResponse<List<BizConfigResDto>> queryBizSpaceIdConfigs(@RequestParam(value = "tenantId", required = false) Long tenantId,
                                                               @RequestParam("spaceCode") @NotBlank(message = "业务空间编码不能为空") String spaceCode,
                                                               @RequestParam("idCode") @NotBlank(message = "业务身份编码不能为空") String idCode);
}
