package com.dtyunxi.yundt.cube.center.func.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizobj.BizObjPropertyQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizobj.BizObjQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizObjPropertyQueryResDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizObjQueryResDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 业务对象服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"基础数据中心：配置项管理：业务对象服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-query-IBizObjQueryApi",
        name = "${yundt.cube.center.data.name:yundt-cube-center-data}", path = "/v1/biz-obj", url = "${yundt.cube.center.data.api:}")
public interface IBizObjQueryApi {

    /**
     * 根据code查询业务对象
     *
     * @param code 业务对象code
     * @return 业务对象数据
     */
    @GetMapping("")
    @ApiOperation(value = "根据code查询业务对象", notes = "根据code查询业务对象")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "code", value = "业务对象code", dataType = "string", paramType = "query", required = true),
            @ApiImplicitParam(name = "withProperties", value = "是否查询属性", dataType = "boolean", paramType = "query")
    })
    @Capability(capabilityCode = "basicdata.biz-obj.query-by-code")
    RestResponse<BizObjQueryResDto> queryByCode(@RequestParam("code") String code,
                                                @RequestParam(value = "withProperties", required = false, defaultValue = "true") Boolean withProperties);

    /**
     * 业务对象分页数据
     *
     * @param queryReqDto 业务对象查询条件
     * @param pageNum     当前页
     * @param pageSize    页大小
     * @return 业务对象分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "业务对象分页数据", notes = "根据filter查询条件查询业务对象数据，filter=BizObjReqDto")
    @Capability(capabilityCode = "basicdata.biz-obj.query-by-page")
    RestResponse<PageInfo<BizObjQueryResDto>> queryByPage(@SpringQueryMap BizObjQueryReqDto queryReqDto,
                                                          @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                          @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 根据code查询业务对象属性
     *
     * @param code 业务对象属性code
     * @return 业务对象属性数据
     */
    @GetMapping("property")
    @ApiOperation(value = "根据code查询业务对象属性", notes = "根据code查询业务对象属性")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "code", value = "业务对象code", dataType = "string", paramType = "query", required = true)
    })
    @Capability(capabilityCode = "basicdata.biz-obj.query-property-by-code")
    RestResponse<BizObjPropertyQueryResDto> queryPropertyByCode(@RequestParam("code") String code);

    /**
     * 业务对象属性分页数据
     *
     * @param queryReqDto 业务对象属性查询条件
     * @param pageNum     当前页
     * @param pageSize    页大小
     * @return 业务对象属性分页数据
     */
    @GetMapping("property/page")
    @ApiOperation(value = "业务对象属性分页数据", notes = "根据filter查询条件查询业务对象属性数据，filter=BizObjPropertyReqDto")
    @Capability(capabilityCode = "basicdata.biz-obj.query-property-by-page")
    RestResponse<PageInfo<BizObjPropertyQueryResDto>> queryPropertyByPage(@SpringQueryMap BizObjPropertyQueryReqDto queryReqDto,
                                                                          @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                          @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);
}
