/**
 * @(#)IBundleQueryApi 1.0 2020/2/28
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BundleQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BundleReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;

/**
 * 功能包服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"基础数据中心：配置项管理：功能包服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-func-api-query-IBundleQueryApi",
        name = "${yundt.cube.center.data.name:yundt-cube-center-data}", path = "/v1/bundle", url = "${yundt.cube.center.data.api:}")
public interface IBundleQueryApi {

    /**
     * 根据id查询功能包
     *
     * @param id 功能包id
     * @return 功能包数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询功能包", notes = "根据id查询功能包")
    @Capability(capabilityCode = "basicdata.bundle.query-by-id")
    RestResponse<BundleRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据功能包编码查询功能包信息
     * 不包含历史版本信息
     *
     * @param code 功能包id
     * @return 功能包数据
     */
    @GetMapping("/by-code/{code:.+}")
    @ApiOperation(value = "根据功能包编码查询功能包信息", notes = "根据功能包编码查询功能包信息")
    @Capability(capabilityCode = "basicdata.bundle.query-by-code")
    RestResponse<BundleRespDto> queryByCode(@PathVariable("code") String code);

    /**
     * 根据功能包编码查询二级功能包及其自身
     *
     * @param parentCode 功能包编码
     * @param pageNum    当前页
     * @param pageSize   页大小
     * @return 功能包数据
     */
    @GetMapping("/by-parent-code/{parentCode:.+}")
    @ApiOperation(value = "根据功能包编码查询二级功能包及其自身", notes = "根据功能包编码查询二级功能包及其自身")
    @Capability(capabilityCode = "basicdata.bundle.query-by-parent-code")
    RestResponse<PageInfo<BundleRespDto>> queryByParentCode(@PathVariable("parentCode") String parentCode,
                                                            @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                            @RequestParam(name = "pageSize", required = false, defaultValue = "100") Integer pageSize);

    /**
     * 根据功能包编码，查询该功能包的版本列表
     *
     * @param bundleCode 功能包编码
     * @return 功能包数据
     */
    @GetMapping("/version/by-bundle-code/{bundleCode:.+}")
    @ApiOperation(value = "根据功能包编码，查询该功能包的版本列表", notes = "根据功能包编码，查询该功能包的版本列表")
    @Capability(capabilityCode = "basicdata.bundle.query-version-by-code")
    RestResponse<BundleVersionRespDto> queryVersionByCode(@PathVariable("bundleCode") String bundleCode);

    /**
     * 按照功能包DTO设置的条件查询功能包
     *
     * @param bundleQueryReqDto 功能包的查询条件，详细参考DTO定义
     * @param pageNum           当前页
     * @param pageSize          页大小
     * @return 产品功能包分页数据
     */
    @GetMapping
    @ApiOperation(value = "按照功能包DTO设置的条件查询功能包", notes = "根据BundleQueryReqDto指定的查询条件，查询功能包")
    @Capability(capabilityCode = "basicdata.bundle.query-by-page")
    RestResponse<PageInfo<BundleRespDto>> queryByPage(@SpringQueryMap @Valid BundleQueryReqDto bundleQueryReqDto,
                                                      @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                      @RequestParam(name = "pageSize", required = false, defaultValue = "2000") Integer pageSize);

    /**
     * 查询功能包关联的容器
     *
     * @param bundleId 功能包id
     * @param pageNum  当前页
     * @param pageSize 每页数据量
     * @return 容器分页信息
     */
    @GetMapping("/container/by-bundle-id")
    @ApiOperation(value = "根据功能包id查询关联的容器", notes = "查询功能包关联的容器")
    @Capability(capabilityCode = "basicdata.bundle.query-container-by-bundle-id")
    RestResponse<PageInfo<ContainerRespDto>> queryContainerByBundleId(@RequestParam("bundleId") Long bundleId,
                                                                      @RequestParam(name = "containerType", required = false) Integer containerType,
                                                                      @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                      @RequestParam(name = "pageSize", required = false, defaultValue = "2000") Integer pageSize);

    /**
     * 查询功能包基本信息
     *
     * @param bundleReqDto 查询条件
     * @return 功能包基本信息
     */
    @GetMapping("/base")
    @ApiOperation(value = "查询功能包基本信息", notes = "查询功能包基本信息")
    @Capability(capabilityCode = "basicdata.bundle.query-bundle-base-info")
    RestResponse<BundleQueryRespDto> queryBundleBaseInfo(@SpringQueryMap BundleReqDto bundleReqDto);

}
