package com.dtyunxi.yundt.cube.center.func.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.DtoAttributeQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.DtoQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.DtoAttributeQueryRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.DtoQueryRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 功能包DTO服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"基础数据中心：配置项管理：功能包DTO服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-func-api-query-IDtoQueryApi",
        name = "${yundt.cube.center.data.name:yundt-cube-center-data}", path = "/v1/dto", url = "${yundt.cube.center.data.api:}")
public interface IDtoQueryApi {

    /**
     * 功能包DTO分页数据
     *
     * @param queryReqDto 功能包DTO查询条件
     * @param pageNum     当前页
     * @param pageSize    页大小
     * @return 功能包DTO分页数据
     */
    @GetMapping("")
    @ApiOperation(value = "查询功能包DTO分页数据", notes = "查询功能包DTO分页数据")
    @Capability(capabilityCode = "basicdata.dto.query-dto-by-page")
    RestResponse<PageInfo<DtoQueryRespDto>> queryDtoByPage(@SpringQueryMap DtoQueryReqDto queryReqDto,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 功能包DTO属性分页数据
     *
     * @param queryReqDto 功能包DTO属性查询条件
     * @param pageNum     当前页
     * @param pageSize    页大小
     * @return 功能包DTO属性分页数据
     */
    @GetMapping("/attribute")
    @ApiOperation(value = "查询功能包DTO属性分页数据", notes = "查询功能包DTO属性分页数据")
    @Capability(capabilityCode = "basicdata.dto.query-dto-attribute-by-page")
    RestResponse<PageInfo<DtoAttributeQueryRespDto>> queryDtoAttributeByPage(@SpringQueryMap DtoAttributeQueryReqDto queryReqDto,
                                                                             @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                             @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    @GetMapping("/code-version")
    @ApiOperation(value = "根据应用编码和版本查询 dto 列表", notes = "根据应用编码和版本号查询 dto 列表")
    RestResponse<List<DtoQueryRespDto>> queryByAppCodeAndVersion(@RequestParam(name = "appCode") String appCode,
                                                                        @RequestParam(name = "appVersion") String appVersion);
}
