/**
 * @(#)ICapabilityQueryApi 1.0 2020/2/28
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BundleDepdSettingReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BundleSettingQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SettingQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BundleSettingTreeRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SettingDetailRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SettingRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author shuangqing  2020/2/28
 */
@Api(tags = {"基础数据中心：配置项管理：能力信息服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-func-api-query-ISettingQueryApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v1/setting", url = "${yundt.cube.center.data.api:}")
public interface ISettingQueryApi {

    /**
     * 根据编码查询配置项详细信息
     * <p>
     * 使用@PathVariable，如果其value值包括 . 号，会截取掉入参的部分字段，所以使用{code:.+}
     *
     * @param code 配置项code
     * @return 配置项详细信息
     */
    @GetMapping("/{code:.+}")
    @ApiOperation(value = "根据编码查询配置项详细信息", notes = "根据编码查询配置项详细信息")
    @Capability(capabilityCode = "basicdata.setting.query-by-code")
    RestResponse<SettingDetailRespDto> queryByCode(@PathVariable("code") String code);


    /**
     * 查询配置项的分页列表，只返回配置项编码、名称、值编辑方式、值类型、来源功能包
     *
     * @param settingQueryReqDto 查询配置项的分页列表请求参数
     * @param pageNum            页码数
     * @param pageSize           页大小
     * @return 返回配置项的分页列表
     */
    @GetMapping("")
    @ApiOperation(value = "查询配置项的分页列表，只返回配置项编码、名称、值编辑方式、值类型、来源功能包",
            notes = "查询配置项的分页列表，只返回配置项编码、名称、值编辑方式、值类型、来源功能包")
    @Capability(capabilityCode = "basicdata.setting.query-settings-page")
    RestResponse<PageInfo<SettingRespDto>> querySettingsPage(@SpringQueryMap SettingQueryReqDto settingQueryReqDto,
                                                             @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                             @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 查询功能包素材管理-配置项列表
     *
     * @param bundleSettingQueryReqDto
     * @return
     */
    @GetMapping("/by-bundle")
    @ApiOperation(value = "查询功能包素材管理-配置项列表", notes = "查询功能包素材管理-配置项列表")
    @Capability(capabilityCode = "basicdata.setting.query-bundle-setting")
    RestResponse<PageInfo<BundleSettingTreeRespDto>> queryBundleSetting(@SpringQueryMap BundleSettingQueryReqDto bundleSettingQueryReqDto);

    /**
     * 查询功能包素材管理-配置项引用的联动配置项
     *
     * @param bundleDepdSettingReqDto
     * @return
     */
    @GetMapping("/by-bundle/dependency/setting")
    @ApiOperation(value = "查询功能包素材管理-配置项引用的联动配置项", notes = "查询功能包素材管理-配置项引用的联动配置项")
    @Capability(capabilityCode = "basicdata.setting.get-bundle-setting-depd-setting")
    RestResponse<PageInfo<BundleSettingTreeRespDto>> getBundleSettingDepdSetting(@SpringQueryMap BundleDepdSettingReqDto bundleDepdSettingReqDto);
}
