/**
 * @(#) ISysParamApi.java 1.0 2019-10-26
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SysParamQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SysParamSingleQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SysParamItemRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SysParamRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SysParamValueRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.TenantSysParamRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author 黑马
 * @see com.dtyunxi.yundt.cube.center.func.api.query.ISettingQueryApi
 * @since 1.0.0
 */
@Api(tags = {"基础数据中心：配置项管理：业务参数服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-query-ISysParamQueryApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v2/param", url = "${yundt.cube.center.data.api:}")
@Deprecated
public interface ISysParamQueryApi {


    /**
     * 查询单个业务参数详情
     *
     * @param sysParamSingleQueryReqDto 其他查询条件或配置
     * @return
     */
    @RequestMapping(value = "/code", method = RequestMethod.GET)
    @ApiOperation(value = "查询单个业务参数详情", notes = "查询单个业务参数详情")
    @Capability(capabilityCode = "basicdata.sys-param.query-by-code")
    RestResponse<SysParamRespDto> queryByCode(@SpringQueryMap SysParamSingleQueryReqDto sysParamSingleQueryReqDto);


    /**
     * 根据查询条件查询数据
     *
     * @param sysParamQueryReqDto 查询条件
     * @param pageNum             当前页
     * @param pageSize            页大小
     * @return 分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "根据查询条件查询数据", notes = "filter=SysParamRespDto")
    @Capability(capabilityCode = "basicdata.sys-param.query-by-page")
    RestResponse<PageInfo<SysParamRespDto>> queryByPage(@SpringQueryMap SysParamQueryReqDto sysParamQueryReqDto,
                                                        @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                        @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 查询指定分组下的参数集合
     *
     * @param groupCode 分组
     * @return RestResponse
     */
    @RequestMapping(value = "/{groupCode}/list", method = RequestMethod.GET)
    @ApiOperation(value = "查询指定分组下的参数集合", notes = "查询指定分组下的参数集合,groupCode:分组。")
    @Capability(capabilityCode = "basicdata.sys-param.query-by-group-code")
    RestResponse<List<SysParamRespDto>> queryByGroupCode(@PathVariable("groupCode") String groupCode);

    /**
     * 根据 业务参数编码 查询参数选项
     * 如果请求是来自MPC系统,则返回 系统预制的所有可选项 TODO
     * 如果请求是来自BOC系统,则返回 当前租户的可选项 TODO
     *
     * @param paramCode 业务参数编码
     * @return 参数数据
     */
    @RequestMapping(value = "/{paramCode}/item", method = RequestMethod.GET)
    @ApiOperation(value = "根据系统编码查询参数选项", notes = "根据系统编码查询参数选项")
    @Capability(capabilityCode = "basicdata.sys-param.query-item-by-param-code")
    RestResponse<List<SysParamItemRespDto>> queryItemByParamCode(@PathVariable("paramCode") String paramCode);


    /**
     * 根据系统编码查询参数值
     *
     * @param paramCode 业务参数代码
     * @return 参数数据
     */
    @RequestMapping(value = "/{paramCode}/value", method = RequestMethod.GET)
    @ApiOperation(value = "根据系统编码查询参数值", notes = "根据系统编码查询参数值")
    @Capability(capabilityCode = "basicdata.sys-param.query-value-by-param-code")
    RestResponse<List<SysParamValueRespDto>> queryValueByParamCode(@PathVariable("paramCode") String paramCode);

    /**
     * 根据参数名称查询租户下各应用分配的参数列表
     *
     * @param tenantId            租户id
     * @param sysParamQueryReqDto 查询条件
     * @param pageNum             当前页
     * @param pageSize            页大小
     * @return 分页数据
     */
    @GetMapping("/tenant/page")
    @ApiOperation(value = "根据参数名称查询租户下各应用分配的参数列表", notes = "根据参数名称查询租户下各应用分配的参数列表")
    @Capability(capabilityCode = "basicdata.sys-param.query-by-page-for-instance")
    RestResponse<PageInfo<TenantSysParamRespDto>> queryByPageForInstance(@RequestParam("tenantId") Long tenantId,
                                                                         @SpringQueryMap SysParamQueryReqDto sysParamQueryReqDto,
                                                                         @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                         @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);


}
