/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.flow.biz.service.impl;

import com.dtyunxi.cube.starter.bundle.enums.BundleDataTypeEnum;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.das.AbstractBaseDas;
import com.dtyunxi.cube.utils.Pair;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.flow.api.constants.FlowSolutionType;
import com.dtyunxi.yundt.cube.center.flow.api.dto.base.IdBatchQueryDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.export.FlowDataDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.export.FlowDataImportReqDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.export.FlowNodeConvertMapDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.export.FlowNodeLinkDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.export.FlowSolutionDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.export.FlowStatusDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.request.FlowUploadRepDto;
import com.dtyunxi.yundt.cube.center.flow.biz.service.IFlowExportService;
import com.dtyunxi.yundt.cube.center.flow.biz.service.impl.BundleFlowsSyncService;
import com.dtyunxi.yundt.cube.center.flow.biz.util.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.flow.dao.das.FlwNodeConvertMapDas;
import com.dtyunxi.yundt.cube.center.flow.dao.das.FlwNodeDas;
import com.dtyunxi.yundt.cube.center.flow.dao.das.FlwNodeLinkDas;
import com.dtyunxi.yundt.cube.center.flow.dao.das.FlwSolutionDas;
import com.dtyunxi.yundt.cube.center.flow.dao.das.FlwStatusDas;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.FlwNodeConvertMapEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.FlwNodeLinkEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.FlwSolutionEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.FlwStatusEo;
import com.dtyunxi.yundt.cube.center.flow.dao.mapper.FlwSolutionMapper;
import com.dtyunxi.yundt.cube.center.func.biz.util.IDataImporter;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FlowExportServiceImpl
implements IFlowExportService {
    protected static Logger LOGGER = LoggerFactory.getLogger(FlowExportServiceImpl.class);
    @Resource
    private FlwNodeLinkDas flwNodeLinkDas;
    @Resource
    private FlwSolutionDas flwSolutionDas;
    @Resource
    private FlwStatusDas flwStatusDas;
    @Resource
    private FlwNodeDas flwNodeDas;
    @Resource
    private FlwNodeConvertMapDas flwNodeConvertMapDas;
    @Resource
    private FlwSolutionMapper flwSolutionMapper;
    @Resource
    private BundleFlowsSyncService bundleFlowsSyncService;

    private <T extends BaseEo, K> T getParam(T t, String key, Collection<K> solutionIds) {
        t.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter(key, solutionIds).get());
        return t;
    }

    private Set<String> collectNodeConvertMaps(IdBatchQueryDto idBatchQuery, FlowDataDto flowDataDto) {
        HashSet<String> actionCodeSet = new HashSet<String>();
        List nodeConvertMapEoList = this.flwNodeConvertMapDas.select((BaseEo)this.getParam(new FlwNodeConvertMapEo(), "flow_def_id", idBatchQuery.getIds()));
        if (CollectionUtils.isNotEmpty((Collection)nodeConvertMapEoList)) {
            flowDataDto.setNodeConvertMapList(nodeConvertMapEoList.stream().map(item -> {
                FlowNodeConvertMapDto nodeConvertMapDto = new FlowNodeConvertMapDto();
                actionCodeSet.add(item.getPrevNodeCode());
                actionCodeSet.add(item.getNextNodeCode());
                BeanUtils.copyProperties((Object)item, (Object)nodeConvertMapDto);
                return nodeConvertMapDto;
            }).collect(Collectors.toList()));
        }
        return actionCodeSet;
    }

    private Set<String> collectStatuses(FlowDataDto flowDataDto, Set<Long> statusIdSet) {
        if (CollectionUtils.isEmpty(statusIdSet)) {
            return new HashSet<String>();
        }
        HashSet<String> docSet = new HashSet<String>();
        List statusEoList = this.flwStatusDas.select((BaseEo)this.getParam(new FlwStatusEo(), "id", statusIdSet));
        if (CollectionUtils.isNotEmpty((Collection)statusEoList)) {
            flowDataDto.setStatusList(statusEoList.stream().map(item -> {
                FlowStatusDto statusDto = new FlowStatusDto();
                docSet.add(item.getDocType());
                BeanUtils.copyProperties((Object)item, (Object)statusDto);
                return statusDto;
            }).collect(Collectors.toList()));
        }
        return docSet;
    }

    private Pair<Set<Long>, Set<String>> collectNodeLinks(IdBatchQueryDto idBatchQuery, FlowDataDto flowDataDto) {
        HashSet statusIdList = new HashSet();
        HashSet actionCodeList = new HashSet();
        List nodeLinkEos = this.flwNodeLinkDas.select((BaseEo)this.getParam(new FlwNodeLinkEo(), "flow_def_id", idBatchQuery.getIds()));
        if (CollectionUtils.isNotEmpty((Collection)nodeLinkEos)) {
            flowDataDto.setNodeLinkList(nodeLinkEos.stream().map(item -> {
                if (2 == item.getPrevType()) {
                    actionCodeList.add(item.getPrevCode());
                }
                if (3 == item.getNextType()) {
                    statusIdList.add(Long.parseLong(item.getNextCode()));
                }
                FlowNodeLinkDto nodeLinkDto = new FlowNodeLinkDto();
                BeanUtils.copyProperties((Object)item, (Object)nodeLinkDto);
                return nodeLinkDto;
            }).collect(Collectors.toList()));
        }
        return new Pair(statusIdList, actionCodeList);
    }

    private void collectSolutions(IdBatchQueryDto idBatchQuery, FlowDataDto flowDataDto) {
        List solutionEoList = this.flwSolutionDas.select((BaseEo)this.getParam(new FlwSolutionEo(), "id", idBatchQuery.getIds()));
        if (CollectionUtils.isNotEmpty((Collection)solutionEoList)) {
            flowDataDto.setSolutionList(solutionEoList.stream().map(item -> {
                FlowSolutionDto solutionDto = new FlowSolutionDto();
                BeanUtils.copyProperties((Object)item, (Object)solutionDto);
                return solutionDto;
            }).collect(Collectors.toList()));
        }
    }

    @Override
    public FlowDataDto exportFlow(IdBatchQueryDto idBatchQuery) {
        FlowDataDto flowDataDto = new FlowDataDto();
        this.collectSolutions(idBatchQuery, flowDataDto);
        if (CollectionUtils.isEmpty((Collection)flowDataDto.getSolutionList())) {
            return flowDataDto;
        }
        CompletableFuture<Pair> pairCompletableFuture = CompletableFuture.supplyAsync(() -> this.collectNodeLinks(idBatchQuery, flowDataDto));
        CompletableFuture<Set> actionConvertCompletableFuture = CompletableFuture.supplyAsync(() -> this.collectNodeConvertMaps(idBatchQuery, flowDataDto));
        try {
            Set actionSet = actionConvertCompletableFuture.get();
            Pair pair = pairCompletableFuture.get();
            ((Set)pair.getValue()).addAll(actionSet);
            HashSet docSet = new HashSet();
            CompletableFuture<Set> statusDocCompletableFuture = CompletableFuture.supplyAsync(() -> this.collectStatuses(flowDataDto, (Set)pair.getKey()));
            docSet.addAll(statusDocCompletableFuture.get());
        }
        catch (InterruptedException e) {
            LOGGER.warn("\u7ebf\u7a0b\u4e2d\u65ad\u5f02\u5e38\uff1a", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.warn("\u7ebf\u7a0b\u6267\u884c\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return flowDataDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importFlow(FlowDataImportReqDto flowDataImportReqDto) {
        FlowDataDto flowDataDto = flowDataImportReqDto.getFlowData();
        if (CollectionUtils.isEmpty((Collection)flowDataDto.getSolutionList())) {
            LOGGER.info("\u65e0\u4ea4\u6613\u6d41\u7a0b\u65b9\u6848\u6570\u636e\uff0c\u4e0d\u5bfc\u5165");
            return;
        }
        Date createDate = new Date();
        HashMap exchangeIdMap = Maps.newHashMap();
        for (FlowSolutionDto solutionDto : flowDataDto.getSolutionList()) {
            Long newId = this.flwNodeDas.getId();
            if (StringUtils.isEmpty((CharSequence)solutionDto.getType())) {
                solutionDto.setType(FlowSolutionType.TRADE.getValue());
            }
            exchangeIdMap.put(solutionDto.getId(), newId);
            solutionDto.setId(newId);
        }
        if (CollectionUtils.isNotEmpty((Collection)flowDataDto.getNodeConvertMapList())) {
            for (FlowNodeConvertMapDto flowNodeConvertMapDto : flowDataDto.getNodeConvertMapList()) {
                flowNodeConvertMapDto.setFlowDefId((Long)exchangeIdMap.get(flowNodeConvertMapDto.getFlowDefId()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)flowDataDto.getNodeLinkList())) {
            for (FlowNodeLinkDto flowNodeLinkDto : flowDataDto.getNodeLinkList()) {
                flowNodeLinkDto.setFlowDefId((Long)exchangeIdMap.get(flowNodeLinkDto.getFlowDefId()));
            }
        }
        this.batchImportSolutions(flowDataImportReqDto, createDate);
        this.batchImportNodeLinks(flowDataImportReqDto, createDate);
        this.batchImportNodeConvertMaps(flowDataImportReqDto, createDate);
        this.batchImportStatusNodes(flowDataImportReqDto, createDate);
        List codes = flowDataImportReqDto.getFlowData().getSolutionList().stream().map(FlowSolutionDto::getCode).collect(Collectors.toList());
        this.flwSolutionMapper.disableCurShowOfDocTypes(codes);
        this.flwSolutionMapper.enableCurShowOfDocTypes(codes);
    }

    private void batchImportSolutions(FlowDataImportReqDto flowDataDto, Date createDate) {
        new IDataImporter<FlwSolutionEo, FlowSolutionDto, String, String>(){

            public FlwSolutionEo newEo() {
                return new FlwSolutionEo();
            }

            public String getCodeFromEo(FlwSolutionEo flwSolutionEo) {
                return flwSolutionEo.getCode();
            }

            public String getCodeFromDto(FlowSolutionDto flowSolutionDto) {
                return flowSolutionDto.getCode();
            }
        }.batchImport(flowDataDto.getRule(), flowDataDto.getFlowData().getSolutionList(), createDate, "code", (AbstractBaseDas)this.flwSolutionDas);
    }

    private void batchImportNodeLinks(FlowDataImportReqDto flowDataDto, Date createDate) {
        if (CollectionUtils.isNotEmpty((Collection)flowDataDto.getFlowData().getNodeLinkList())) {
            new IDataImporter<FlwNodeLinkEo, FlowNodeLinkDto, Long, String>(){

                public FlwNodeLinkEo newEo() {
                    return new FlwNodeLinkEo();
                }

                public Long getCodeFromEo(FlwNodeLinkEo flwNodeLinkEo) {
                    return flwNodeLinkEo.getFlowDefId();
                }

                public Long getCodeFromDto(FlowNodeLinkDto flowNodeLinkDto) {
                    return flowNodeLinkDto.getFlowDefId();
                }
            }.batchImport(flowDataDto.getRule(), flowDataDto.getFlowData().getNodeLinkList(), createDate, "flow_def_id", (AbstractBaseDas)this.flwNodeLinkDas);
        }
    }

    private void batchImportNodeConvertMaps(FlowDataImportReqDto flowDataDto, Date createDate) {
        if (CollectionUtils.isNotEmpty((Collection)flowDataDto.getFlowData().getNodeConvertMapList())) {
            new IDataImporter<FlwNodeConvertMapEo, FlowNodeConvertMapDto, Long, String>(){

                public FlwNodeConvertMapEo newEo() {
                    return new FlwNodeConvertMapEo();
                }

                public Long getCodeFromEo(FlwNodeConvertMapEo flwNodeConvertMapEo) {
                    return flwNodeConvertMapEo.getFlowDefId();
                }

                public Long getCodeFromDto(FlowNodeConvertMapDto flowNodeConvertMapDto) {
                    return flowNodeConvertMapDto.getFlowDefId();
                }
            }.batchImport(flowDataDto.getRule(), flowDataDto.getFlowData().getNodeConvertMapList(), createDate, "flow_def_id", (AbstractBaseDas)this.flwNodeConvertMapDas);
        }
    }

    private void batchImportStatusNodes(FlowDataImportReqDto flowDataDto, Date createDate) {
        if (CollectionUtils.isNotEmpty((Collection)flowDataDto.getFlowData().getStatusList())) {
            new IDataImporter<FlwStatusEo, FlowStatusDto, Long, String>(){

                public FlwStatusEo newEo() {
                    return new FlwStatusEo();
                }

                public Long getCodeFromEo(FlwStatusEo flwStatusEo) {
                    return flwStatusEo.getId();
                }

                public Long getCodeFromDto(FlowStatusDto flowStatusDto) {
                    return flowStatusDto.getId();
                }
            }.batchImport(flowDataDto.getRule(), flowDataDto.getFlowData().getStatusList(), createDate, "id", (AbstractBaseDas)this.flwStatusDas);
        }
    }

    @Override
    public void uploadFlow(FlowUploadRepDto flowUploadRepDto) {
        this.bundleFlowsSyncService.handle(flowUploadRepDto.getBundleFlows(), BundleDataTypeEnum.FLOW);
    }
}

