/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.flow.biz.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.flow.biz.service.IFlowNodeService;
import com.dtyunxi.yundt.cube.center.flow.biz.service.IFlowService;
import com.dtyunxi.yundt.cube.center.flow.biz.service.impl.FlowServiceImpl;
import com.dtyunxi.yundt.cube.center.flow.dao.das.FlwNodeDas;
import com.dtyunxi.yundt.cube.center.flow.dao.das.FlwSolutionDas;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.FlwColorPoolEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.FlwNodeEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.FlwSolutionEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.StdFlwNodeEo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowNodeServiceImpl
implements IFlowNodeService {
    public final String NODES = "nodes";
    public final String NODE_CODE = "code";
    public final String NODE_TYPE = "clazz";
    public final String STATUS_NODE = "status";
    public final String COLOR = "color";
    public final String LABEL = "label";
    public final String DOC_TYPE = "group";
    public final String STATUS_FIELD = "statusType";
    public final String STATUS_FIELD_CODE = "code";
    public final String STATUS_TYPE_LIST = "statusTypeList";
    public final String PROCESS_NODE = "task";
    public final String INPUT_CODE = "inputCode";
    public final String OUTPUT_CODE = "outputCode";
    @Resource
    private FlwSolutionDas flwSolutionDas;
    @Autowired
    private IFlowService flowService;
    @Autowired
    private FlwNodeDas flwNodeDas;

    @Override
    public boolean refreshStatusNodeColor(JSONObject extension, JSONObject node, List<FlwColorPoolEo> colorPools) {
        JSONArray statusFiedlList;
        boolean updated = false;
        String color = node.getString("color");
        String docType = node.getString("group");
        if (color != null) {
            String statusField = node.getString("statusType");
            String label = node.getString("label");
            String adaptedColor = FlowServiceImpl.getColor(docType, statusField, colorPools);
            if (!color.equals(adaptedColor)) {
                node.put("color", (Object)adaptedColor);
                extension.put(statusField + "#" + label, (Object)(color + ">>>" + adaptedColor));
                updated = true;
            }
        }
        if ((statusFiedlList = node.getJSONArray("statusTypeList")) != null) {
            for (Object item2 : statusFiedlList) {
                if (!(item2 instanceof JSONObject)) continue;
                JSONObject statusType = (JSONObject)item2;
                String statusField2 = statusType.getString("code");
                String label = node.getString("label");
                String statusFieldColor = statusType.getString("color");
                String adaptedColor2 = FlowServiceImpl.getColor(docType, statusField2, colorPools);
                if (statusFieldColor == null || statusFieldColor.equals(adaptedColor2)) continue;
                ((JSONObject)item2).put("color", (Object)adaptedColor2);
                extension.put(statusField2 + "#" + label, (Object)(color + ">>>" + adaptedColor2));
                updated = true;
            }
        }
        return updated;
    }

    @Override
    public boolean refreshInputAndOutPut(JSONObject extension, JSONObject node, Map<String, FlwNodeEo> nodeCode2EoMap) {
        if (nodeCode2EoMap == null) {
            return false;
        }
        boolean updated = false;
        String nodeCode = node.getString("code");
        FlwNodeEo flwNodeEo = nodeCode2EoMap.get(nodeCode);
        if (flwNodeEo != null) {
            String inputCode = node.getString("inputCode");
            String outputCode = node.getString("outputCode");
            if (!flwNodeEo.getInputCode().equals(inputCode)) {
                node.put("inputCode", (Object)flwNodeEo.getInputCode());
                extension.put("input", (Object)(inputCode + ">>>" + flwNodeEo.getInputCode()));
                updated = true;
            }
            if (!flwNodeEo.getOutputCode().equals(outputCode)) {
                node.put("outputCode", (Object)flwNodeEo.getOutputCode());
                extension.put("output", (Object)(outputCode + ">>>" + flwNodeEo.getOutputCode()));
                updated = true;
            }
        }
        return updated;
    }

    @Override
    public void refreshAfterReported() {
        List flwSolutionEos = this.flwSolutionDas.selectAll();
        if (CollectionUtils.isEmpty((Collection)flwSolutionEos)) {
            return;
        }
        List nodeEos = this.flwNodeDas.selectAll();
        Map<String, FlwNodeEo> nodeCode2EoMap = null;
        if (CollectionUtils.isNotEmpty((Collection)nodeEos)) {
            nodeCode2EoMap = nodeEos.stream().collect(Collectors.toMap(StdFlwNodeEo::getCode, Function.identity(), (old, newOne) -> old));
        }
        List<FlwColorPoolEo> colorPools = this.flowService.fetchColorPoolOrdered();
        for (FlwSolutionEo flwSolutionEo : flwSolutionEos) {
            JSONArray nodes;
            JSONObject style;
            JSONObject extension = JSONObject.parseObject((String)flwSolutionEo.getExtension());
            if (extension == null) {
                extension = new JSONObject();
            }
            if ((style = JSONObject.parseObject((String)flwSolutionEo.getStyle())) == null || (nodes = style.getJSONArray("nodes")) == null) continue;
            boolean processNodeUpdated = false;
            boolean statusNodeUpdated = false;
            for (Object item : nodes) {
                if (!(item instanceof JSONObject)) continue;
                JSONObject node = (JSONObject)item;
                if ("task".equals(node.getString("clazz"))) {
                    processNodeUpdated = processNodeUpdated ? true : this.refreshInputAndOutPut(extension, node, nodeCode2EoMap);
                    continue;
                }
                if (!"status".equals(node.getString("clazz"))) continue;
                statusNodeUpdated = statusNodeUpdated ? true : this.refreshStatusNodeColor(extension, node, colorPools);
            }
            if (!processNodeUpdated && !statusNodeUpdated) continue;
            FlwSolutionEo updateEo = new FlwSolutionEo();
            updateEo.setId(flwSolutionEo.getId());
            updateEo.setStyle(style.toJSONString());
            updateEo.setExtension(extension.toJSONString());
            this.flwSolutionDas.updateSelective((BaseEo)updateEo);
        }
    }
}

