/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.bundle.login.log.center.identity.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.RandomCodeUtil;
import com.dtyunxi.yundt.cube.bundle.login.log.center.identity.biz.logger.LoginLogger;
import com.dtyunxi.yundt.cube.bundle.login.log.center.identity.biz.service.ILoginLogService;
import com.dtyunxi.yundt.cube.bundle.login.log.center.identity.biz.vo.LoginLog;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.LoginLogAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRoleRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LoginLogServiceImpl
implements ILoginLogService {
    private static final Logger logger = LoggerFactory.getLogger(LoginLogServiceImpl.class);
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private IAccessQueryApi accessQueryApi;

    private Long getLoginLogId() {
        String code = RandomCodeUtil.generateTextCode((int)0, (int)4);
        String id = System.currentTimeMillis() + code;
        return Long.valueOf(id);
    }

    private String getRoleCodeStr(Long userId) {
        List userRoleRespDtoList;
        String roleCodeStr = "";
        UserRoleReqDto userRoleReqDto = new UserRoleReqDto();
        userRoleReqDto.setUserId(userId);
        RestResponse restResponse = null;
        try {
            restResponse = this.accessQueryApi.queryUserRole(userRoleReqDto);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        if (restResponse != null && restResponse.getResultCode().equals("0") && restResponse.getData() != null && !CollectionUtils.isEmpty((Collection)(userRoleRespDtoList = (List)restResponse.getData()))) {
            Set roleCodeSet = userRoleRespDtoList.stream().map(UserRoleRespDto::getCode).collect(Collectors.toSet());
            roleCodeStr = StringUtils.join(roleCodeSet, (String)",");
        }
        return roleCodeStr;
    }

    @Override
    public String addLoginLog(LoginLogAddReqDto addLog, String userId, String token, Integer loginStatus) {
        RestResponse resUserVo;
        if (StringUtils.isNumeric((CharSequence)userId) && (resUserVo = this.userQueryApi.queryById(Long.valueOf(userId), null)).getResultCode().equals("0") && resUserVo.getData() != null) {
            UserDto userVo = (UserDto)resUserVo.getData();
            LoginLog loginLog = new LoginLog();
            loginLog.setId(this.getLoginLogId());
            loginLog.setLogTime(new Date());
            loginLog.setAuthKey(token);
            loginLog.setApplicationId(userVo.getInstanceId());
            loginLog.setUserName(userVo.getUserName());
            loginLog.setUserId(userVo.getId());
            Object ip = ServiceContext.getContext().get("loginIp");
            loginLog.setClientIp(ip != null ? ip.toString() : "");
            loginLog.setInstanceId(userVo.getInstanceId());
            loginLog.setTenantId(userVo.getTenantId());
            loginLog.setStatus(loginStatus);
            loginLog.setUserType(String.valueOf(userVo.getUserType()));
            if (addLog != null) {
                loginLog.setLoginChannel(addLog.getLoginChannel());
                loginLog.setLoginSource(addLog.getLoginSource());
            }
            String roleCodeStr = this.getRoleCodeStr(Long.valueOf(userId));
            loginLog.setRoleCodeStr(roleCodeStr);
            logger.info("user login info:{}", (Object)JSON.toJSONString((Object)loginLog));
            LoginLogger.log(JSON.toJSONString((Object)loginLog));
            return JSON.toJSONString((Object)loginLog);
        }
        return "";
    }
}

