/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.apiimpl;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.EmployeeDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.EmployeeOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeOrgRelationBatchUpdateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAndOrgInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RelateEmployeesOrgReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.SortReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeeService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrganizationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserOrganizationService;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="organizationApi")
public class OrganizationApiImpl
implements IOrganizationApi {
    @Resource
    private IOrganizationService iOrganizationService;
    @Autowired
    private IEmployeeService employeeService;
    @Autowired
    private IUserOrganizationService userOrganizationService;

    public RestResponse<Long> add(Long instanceId, OrganizationDto organizationDto) {
        organizationDto.setInstanceId(instanceId);
        Long id = this.iOrganizationService.add(organizationDto);
        return new RestResponse((Object)id);
    }

    public RestResponse<Long> add(OrganizationDto organizationDto) {
        return new RestResponse((Object)this.iOrganizationService.add(organizationDto));
    }

    public RestResponse<Long> modifyOrg(Long instanceId, Long organizationId, OrganizationDto organizationDto) {
        organizationDto.setInstanceId(instanceId);
        organizationDto.setId(organizationId);
        this.iOrganizationService.update(organizationDto);
        return new RestResponse((Object)organizationDto.getId());
    }

    public RestResponse<Long> modifyOrg(OrganizationDto organizationDto) {
        this.iOrganizationService.update(organizationDto);
        return new RestResponse((Object)organizationDto.getId());
    }

    public RestResponse<Void> removeOrganization(Long organizationId) {
        this.iOrganizationService.removeOrganization(organizationId);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Long> add(EmployeeDto employeeDto) {
        Long id = this.employeeService.add(employeeDto);
        return new RestResponse((Object)id);
    }

    public RestResponse<Long> modify(Long oldOrganizationId, Long employeeId, EmployeeDto employeeDto) {
        employeeDto.setId(employeeId);
        Long id = this.employeeService.modify(oldOrganizationId, employeeDto);
        return new RestResponse((Object)id);
    }

    public RestResponse<Void> modifyEmployee(Long employeeId, EmployeeDto employeeDto) {
        employeeDto.setId(employeeId);
        this.employeeService.modifyEmployee(employeeDto);
        return RestResponse.VOID;
    }

    public RestResponse<Long> remove(Long organizationId, Long id) {
        this.employeeService.remove(organizationId, id);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> reBindRelation(Long organizationId, EmployeeOrgRelationBatchUpdateReqDto employeeOrgRelationReqDto) {
        this.employeeService.reBindRelation(organizationId, employeeOrgRelationReqDto);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> sortOrganization(Long id, SortReqDto sortReqDto) {
        this.iOrganizationService.sortOrganization(id, sortReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Long> addEmployeeOrgRelation(@Valid EmployeeOrgRelationReqDto employeeOrgRelationReqDto) {
        Long id = this.employeeService.addEmployeeOrgRelation(employeeOrgRelationReqDto);
        return new RestResponse((Object)id);
    }

    public RestResponse<Void> modifyStatus(Long employeeId, Integer status) {
        this.employeeService.modifyStatus(employeeId, status);
        return RestResponse.VOID;
    }

    public RestResponse<Void> deleteEmployee(Long employeeId) {
        this.employeeService.deleteEmployee(employeeId);
        return RestResponse.VOID;
    }

    public RestResponse<Long> removeEmployeeOrgRelationByPut(@Valid EmployeeOrgRelationReqDto employeeOrgRelationReqDto) {
        return this.removeEmployeeOrgRelation(employeeOrgRelationReqDto);
    }

    public RestResponse<Long> removeEmployeeOrgRelation(@Valid EmployeeOrgRelationReqDto employeeOrgRelationReqDto) {
        Long id = this.employeeService.removeEmployeeOrgRelation(employeeOrgRelationReqDto);
        return new RestResponse((Object)id);
    }

    public RestResponse<Void> relateEmployeesOrg(@Valid RelateEmployeesOrgReqDto relateEmployeesOrgReqDto) {
        this.iOrganizationService.relateEmployeesOrg(relateEmployeesOrgReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Long> addOrgAndOrgInfo(@Valid OrgAndOrgInfoReqDto orgAndOrgInfoReqDto) {
        Long id = this.iOrganizationService.addOrgAndOrgInfo(orgAndOrgInfoReqDto);
        return new RestResponse((Object)id);
    }

    public RestResponse<Void> modifyOrgAndOrgInfo(Long id, @Valid OrgAndOrgInfoReqDto orgAndOrgInfoReqDto) {
        OrganizationDto organizationDto = orgAndOrgInfoReqDto.getOrganizationDto();
        organizationDto.setId(id);
        this.iOrganizationService.modifyOrgAndOrgInfo(orgAndOrgInfoReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> relateEmployeeUser(Long employeeId, Long userId) {
        this.employeeService.relateEmployeeUser(employeeId, userId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeEmployeeUserRelation(Long employeeId) {
        this.employeeService.removeEmployeeUserRelation(employeeId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> addUserOrgRelationAll(UserOrgRelationReqDto userOrgRelationReqDto) {
        this.userOrganizationService.addUserOrgRelationAll(userOrgRelationReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> addUserOrgRelation(UserOrgRelationReqDto userOrgRelationReqDto) {
        this.userOrganizationService.addUserOrgRelation(userOrgRelationReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> deleteUserOrgRelation(UserOrgRelationReqDto userOrgRelationReqDto) {
        this.userOrganizationService.deleteUserOrgRelation(userOrgRelationReqDto);
        return RestResponse.VOID;
    }
}

