/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.apiimpl.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.EmployeeDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrgStructureTreeRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeeService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrganizationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserOrganizationService;
import com.dtyunxi.yundt.cube.center.user.biz.util.QueryUtil;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="organizationQueryApi")
public class OrganizationQueryApiImpl
implements IOrganizationQueryApi {
    @Resource
    private IOrganizationService iOrganizationService;
    @Autowired
    private IEmployeeService employeeService;
    @Autowired
    private IUserOrganizationService userOrganizationService;

    public RestResponse<OrganizationDto> queryOne(Long instanceId, String filter) {
        return new RestResponse((Object)this.iOrganizationService.queryOne(instanceId));
    }

    public RestResponse<OrganizationDto> queryById(Long id, String filter) {
        return new RestResponse((Object)this.iOrganizationService.queryById(id));
    }

    public RestResponse<PageInfo<EmployeeDto>> queryPage(Long organizationId, String example, String filter, Integer pageNum, Integer pageSize) {
        EmployeeQueryReqDto employeeFilter = (EmployeeQueryReqDto)QueryUtil.validateExampleAndReturn((String)(filter = QueryUtil.mergeFilter((String)example, (String)filter)), EmployeeQueryReqDto.class);
        if (employeeFilter != null) {
            if (employeeFilter.getReturnWithOrgIds() == null) {
                employeeFilter.setReturnWithOrgIds(Boolean.valueOf(true));
            }
            if (employeeFilter.getReturnWithUser() == null) {
                employeeFilter.setReturnWithUser(Boolean.valueOf(true));
            }
        }
        if (pageSize != null && pageSize > 1000) {
            pageSize = 1000;
        }
        return new RestResponse(this.employeeService.queryPage(organizationId, employeeFilter, pageNum, pageSize));
    }

    public RestResponse<PageInfo<EmployeeDto>> queryPage(Long organizationId, String filter, String[] userTypes, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.employeeService.queryPage(organizationId, filter, userTypes, pageNum, pageSize));
    }

    public RestResponse<PageInfo<EmployeeDto>> queryPageByActiveUser(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.employeeService.queryPageByActiveUser(filter, pageNum, pageSize));
    }

    public RestResponse<EmployeeDto> employeeDetail(Long id, String filter) {
        return new RestResponse((Object)this.employeeService.detail(id));
    }

    public RestResponse<List<EmployeeDto>> queryEmployeeByUserId(Long userId, String filter) {
        return new RestResponse(this.employeeService.queryByUserId(userId));
    }

    public RestResponse<List<EmployeeDto>> queryEmployeeByUserIdList(String ids, String filter) {
        return new RestResponse(this.employeeService.queryByUserIdList(ids));
    }

    public RestResponse<PageInfo<OrganizationDto>> queryByExample(String example, String filter, Integer pageNum, Integer pageSize, String sortStr) {
        filter = QueryUtil.mergeFilter((String)example, (String)filter);
        return new RestResponse(this.iOrganizationService.queryByExample(filter, pageNum, pageSize));
    }

    public RestResponse<OrganizationDto> queryOrgAndItemsById(Long id, String[] items, String filter) {
        return new RestResponse((Object)this.iOrganizationService.queryOrgAndItemsById(id, items));
    }

    public RestResponse<List<OrganizationDto>> queryRootByTenantId(Long tenantId, String filter) {
        return new RestResponse(this.iOrganizationService.queryRootByTenantId(tenantId));
    }

    public RestResponse<List<List<OrgStructureTreeRespDto>>> queryStructureTreeByOrgName(String name, Long tenantId) {
        return new RestResponse(this.iOrganizationService.queryStructureTreeByOrgName(name, tenantId));
    }

    public RestResponse<List<OrgStructureTreeRespDto>> queryStructureTreeByOrgId(Long orgId) {
        return new RestResponse(this.iOrganizationService.queryStructureTreeByOrgId(orgId));
    }

    public RestResponse<OrgAndOrgInfoRespDto> queryOrgAndOrgInfo(Long orgId) {
        return new RestResponse((Object)this.iOrganizationService.queryOrgAndOrgInfo(orgId));
    }

    public RestResponse<PageInfo<EmployeeDto>> queryNotRelateEmployeesByOrgId(Long orgId, String employeeName, String employeeNo, String phoneNum, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.iOrganizationService.queryNotRelateEmployee(orgId, employeeName, employeeNo, phoneNum, pageNum, pageSize));
    }

    public RestResponse<PageInfo<EmployeeDto>> queryRelateEmployeesByOrgId(Long orgId, String employeeName, String employeeNo, String phoneNum, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.iOrganizationService.queryRelateEmployee(orgId, employeeName, employeeNo, phoneNum, pageNum, pageSize));
    }

    public RestResponse<PageInfo<UserRespDto>> queryNotRelateEmployeeUsers(String userName, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.employeeService.queryNotRelateEmployeeUsers(userName, pageNum, pageSize));
    }

    public RestResponse<PageInfo<OrganizationDto>> queryUserOrgRelation(Long userId, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.userOrganizationService.queryUserOrgRelation(userId, pageNum, pageSize));
    }

    public RestResponse<List<OrganizationDto>> queryUserOrgList() {
        return new RestResponse(this.iOrganizationService.queryUserOrgList());
    }

    public RestResponse<PageInfo<UserRespDto>> queryUserOrgRelation(UserOrgRelationQueryReqDto userOrgRelationQueryReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.userOrganizationService.queryUserOrgRelation(userOrgRelationQueryReqDto, pageNum, pageSize));
    }

    public RestResponse<PageInfo<UserRespDto>> queryUserOrgNoRelation(UserOrgRelationQueryReqDto userOrgRelationQueryReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.userOrganizationService.queryUserOrgNoRelation(userOrgRelationQueryReqDto, pageNum, pageSize));
    }

    public RestResponse<List<OrganizationDto>> queryOrgByCurUser(UserOrgQueryReqDto reqDto) {
        return new RestResponse(this.iOrganizationService.queryOrgByCurUser(reqDto));
    }

    public RestResponse<List<OrganizationDto>> querySubordinateOrgByParentId(Long orgId) {
        return new RestResponse(this.iOrganizationService.querySubordinateOrgByParentId(orgId));
    }

    public RestResponse<List<Long>> queryDirectSuperiorOrgIds() {
        return new RestResponse(this.iOrganizationService.queryDirectSuperiorOrgIds());
    }

    public RestResponse<List<Long>> queryAllSuperiorOrgIdList() {
        return new RestResponse(this.iOrganizationService.queryAllSuperiorOrgList());
    }

    public RestResponse<List<Long>> queryDirectSubordinateOrgIds() {
        return new RestResponse(this.iOrganizationService.queryDirectSubordinateOrgIds());
    }

    public RestResponse<List<Long>> queryAllSubordinateOrgIds() {
        return new RestResponse(this.iOrganizationService.queryAllSubordinateOrgIds());
    }

    public RestResponse<List<Long>> queryBrotherOrgIds() {
        return new RestResponse(this.iOrganizationService.queryBrotherOrgIds());
    }

    public RestResponse<List<Long>> queryBrotherDirectSubordinateOrgIds() {
        return new RestResponse(this.iOrganizationService.queryBrotherDirectSubordinateOrgIds());
    }

    public RestResponse<List<Long>> queryBrotherAllSubordinateOrgIds() {
        return new RestResponse(this.iOrganizationService.queryBrotherAllSubordinateOrgIds());
    }

    public RestResponse<List<Long>> queryCurrentUserOrgIds() {
        return new RestResponse(this.iOrganizationService.queryUserOrgIdList());
    }

    public RestResponse<List<OrganizationDto>> queryBelongOrgByUserId(Long userId) {
        List<OrganizationDto> dtos = this.iOrganizationService.queryBelongOrgByUserId(userId);
        return new RestResponse(dtos);
    }

    public RestResponse<List<OrganizationDto>> queryDirectSuperiorOrgList() {
        return new RestResponse(this.iOrganizationService.queryDirectSuperiorOrgList());
    }

    public RestResponse<List<OrganizationDto>> queryDirectSubordinateOrgList() {
        return new RestResponse(this.iOrganizationService.queryDirectSubordinateOrgList());
    }

    public RestResponse<List<OrganizationDto>> queryAllSubordinateOrgList() {
        return new RestResponse(this.iOrganizationService.queryAllSubordinateOrgList());
    }

    public RestResponse<List<OrganizationDto>> queryAllSubordinateOrgTree() {
        return new RestResponse(this.iOrganizationService.queryAllSubordinateOrgTree());
    }

    public RestResponse<List<OrganizationDto>> queryBrotherOrgList() {
        return new RestResponse(this.iOrganizationService.queryBrotherOrgList());
    }

    public RestResponse<OrganizationDto> queryOneByOrgCode(Long instanceId, String orgCode) {
        return new RestResponse((Object)this.iOrganizationService.queryOneByOrgCode(instanceId, orgCode));
    }

    public RestResponse<List<OrganizationDto>> queryListByOrgCode(Long instanceId, List<String> orgCodeList) {
        return new RestResponse(this.iOrganizationService.queryListByOrgCode(instanceId, orgCodeList));
    }

    public RestResponse<List<OrgAndOrgInfoRespDto>> queryOrgAndOrgInfoByIds(List<Long> orgIds) {
        return new RestResponse(this.iOrganizationService.queryOrgAndOrgInfoByIds(orgIds));
    }
}

