/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.ext;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleAccessCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrganizationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.impl.RoleServiceImpl;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Primary
@Service
public class RoleServiceExtImpl
extends RoleServiceImpl {
    @Resource
    private IOrganizationService orgService;

    public void create(Long instanceId, List<RoleAccessCreateReqDto> createReqDtos) {
        boolean needSetUpOrg;
        if (!CollectionUtils.isEmpty(createReqDtos) && (needSetUpOrg = createReqDtos.stream().filter(dto -> dto.getRefRoleId() != null).anyMatch(dto -> dto.getBelongOrgId() == null))) {
            Long tenantId = ServiceContext.getContext().getRequestTenantId();
            Long orgId = Optional.ofNullable(this.orgService.queryLargestAndTopOrgByCurrUser(tenantId)).orElseThrow(() -> new BizException("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7ec4\u7ec7\u5931\u8d25"));
            createReqDtos.stream().filter(dto -> Objects.isNull(dto.getBelongOrgId())).filter(dto -> dto.getRefRoleId() != null).forEach(dto -> dto.setBelongOrgId(orgId));
        }
        super.create(instanceId, createReqDtos);
    }

    public RoleDto create(Long instanceId, RoleAccessCreateReqDto createReqDto) {
        if (createReqDto != null && createReqDto.getBelongOrgId() == null && createReqDto.getRefRoleId() != null) {
            Long tenantId = ServiceContext.getContext().getRequestTenantId();
            Long orgId = Optional.ofNullable(this.orgService.queryLargestAndTopOrgByCurrUser(tenantId)).orElseThrow(() -> new BizException("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7ec4\u7ec7\u5931\u8d25"));
            createReqDto.setBelongOrgId(orgId);
        }
        return super.create(instanceId, createReqDto);
    }
}

