/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.ext;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.yundt.cube.center.user.api.dto.EmployeeDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeeService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserOrganizationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.impl.UserServiceImpl;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.cube.center.user.param.UserLinkOrgStrategyParam;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Primary
@Service
public class UserServiceExtImpl
extends UserServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(UserServiceExtImpl.class);
    @CubeResource
    private UserLinkOrgStrategyParam userLinkOrgStrategyParam;
    @Resource
    private IUserOrganizationService userOrgService;
    @Resource
    private IEmployeeService employeeService;

    @Transactional(rollbackFor={Exception.class})
    public UserEo addUser(Long instanceId, UserDto userDto) {
        UserEo userEo = super.addUser(instanceId, userDto);
        this.linkOrg(userEo.getId(), userDto);
        return userEo;
    }

    public void update(UserDto userDto) {
        super.update(userDto);
        this.linkOrg(userDto.getId(), userDto);
    }

    private void linkOrg(Long id, UserDto userDto) {
        if (CollectionUtils.isEmpty((Collection)userDto.getBelongOrgIds())) {
            return;
        }
        UserLinkOrgStrategyParam.LinkStrategy linkStrategy = UserLinkOrgStrategyParam.getLinkStrategy((UserLinkOrgStrategyParam)this.userLinkOrgStrategyParam);
        if (linkStrategy == null) {
            throw new BizException("\u83b7\u53d6\u7528\u6237\u7ec4\u7ec7\u5173\u8054\u7b56\u7565\u5931\u8d25");
        }
        switch (linkStrategy) {
            case DIRECT: {
                this.directLinkUserAndOrg(id, userDto);
                break;
            }
            case THROUGH_EMPLOYEE: {
                this.throughEmployeeLinkUserAndOrg(id, userDto);
                break;
            }
            default: {
                throw new BizException("\u672a\u77e5\u7528\u6237\u7ec4\u7ec7\u5173\u8054\u7b56\u7565\uff0c| StrategyValue:" + this.userLinkOrgStrategyParam.getValue());
            }
        }
    }

    private void directLinkUserAndOrg(Long id, UserDto userDto) {
        if (CollectionUtils.isEmpty((Collection)userDto.getBelongOrgIds())) {
            return;
        }
        UserOrgRelationReqDto relationReqDto = new UserOrgRelationReqDto();
        relationReqDto.setUserId(id);
        relationReqDto.setOrgIds(userDto.getBelongOrgIds());
        this.userOrgService.addUserOrgRelationAll(relationReqDto);
    }

    private void throughEmployeeLinkUserAndOrg(Long id, UserDto userDto) {
        if (CollectionUtils.isEmpty((Collection)userDto.getBelongOrgIds())) {
            return;
        }
        HashSet orgIds = new HashSet(userDto.getBelongOrgIds());
        List<EmployeeDto> employeeDtos = this.employeeService.queryByUserId(id);
        if (CollectionUtils.isNotEmpty(employeeDtos)) {
            EmployeeDto employeeDto = employeeDtos.get(0);
            employeeDto.setName(userDto.getNickName());
            employeeDto.setNickName(userDto.getNickName());
            employeeDto.setPhoneNum(userDto.getPhone());
            employeeDto.setEmail(userDto.getEmail());
            employeeDto.setOrgIdSet(orgIds);
            this.employeeService.modifyEmployee(employeeDto);
        } else {
            EmployeeDto employeeDto = new EmployeeDto();
            userDto.setId(id);
            Long tenantId = ServiceContext.getContext().getRequestTenantId();
            Long instanceId = ServiceContext.getContext().getRequestInstanceId();
            employeeDto.setEmployeeNo(String.valueOf(id));
            employeeDto.setTenantId(tenantId);
            employeeDto.setInstanceId(instanceId);
            employeeDto.setUser(userDto);
            employeeDto.setName(userDto.getNickName());
            employeeDto.setNickName(userDto.getNickName());
            employeeDto.setPhoneNum(userDto.getPhone());
            employeeDto.setEmail(userDto.getEmail());
            employeeDto.setStatus(Integer.valueOf(1));
            employeeDto.setOrgIdSet(orgIds);
            this.employeeService.add(employeeDto);
        }
    }
}

