/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.core.assembler.Assembler;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.request.PostReqDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.response.EmployeePagerRespDto;
import com.dtyunxi.yundt.cube.center.meta.sql.api.dto.req.MetaQueryBodyReq;
import com.dtyunxi.yundt.cube.center.meta.sql.biz.service.IMetaToEntityQueryService;
import com.dtyunxi.yundt.cube.center.user.api.constant.BaseConstant;
import com.dtyunxi.yundt.cube.center.user.api.dto.AbacAttrConfigDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.EmployeeDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AbacAttrQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AbacAttrReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AbacRoleAttrBatchReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AbacRoleAttrSaveReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AbacRoleAttrUpdateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AbacRoleAttrValueDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.AbacAttrRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.AbacRoleAttrRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.AbacRoleRelationAttrValueRespDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAbacAttrApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAbacAttrService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeePostService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeeService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IPostService;
import com.dtyunxi.yundt.cube.center.user.dao.das.AbacAttrApplicationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.AbacAttrDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserRoleRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AbacAttrEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserRoleRelationEo;
import com.github.pagehelper.PageInfo;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.ReflectionUtils;

@Service
public class AbacAttrServiceImpl
implements IAbacAttrService {
    private static final Logger logger = LoggerFactory.getLogger(AbacAttrServiceImpl.class);
    @Autowired
    private AbacAttrDas abacAttrDas;
    @Autowired
    private UserRoleRelationDas roleRelationDas;
    @Autowired
    private RoleDas roleDas;
    @Autowired
    private IAbacAttrApplicationService abacAttrApplicationService;
    @Autowired
    private AbacAttrApplicationDas abacAttrApplicationDas;
    @Autowired
    private IMetaToEntityQueryService metaToEntityQueryService;
    @Autowired
    private AppInstanceDas appInstanceDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IPostService postService;
    @Resource
    private IEmployeePostService employeePostService;
    @Resource
    private IEmployeeService employeeService;

    @Override
    public List<AbacAttrRespDto> listAttrByInstanceId(Long instanceId) {
        AppInstanceEo instanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        Long appId = instanceEo.getApplicationId();
        return this.listAttrByAppId(appId);
    }

    @Override
    public List<AbacAttrRespDto> listAttrByAppId(Long appId) {
        return this.abacAttrApplicationService.queryAttrByAppId(appId).stream().map(e -> {
            AbacAttrRespDto attrRespDto = new AbacAttrRespDto();
            BeanUtils.copyProperties((Object)e, (Object)attrRespDto, (String[])new String[]{"attrConfig"});
            if (StringUtils.isNotEmpty((CharSequence)e.getAttrConfig())) {
                AbacAttrConfigDto abacAttrConfigDto = (AbacAttrConfigDto)JSONObject.parseObject((String)e.getAttrConfig(), AbacAttrConfigDto.class);
                attrRespDto.setAttrConfig(abacAttrConfigDto);
            }
            return attrRespDto;
        }).collect(Collectors.toList());
    }

    private String extractNameField(AbacAttrConfigDto attr) {
        List rowFiledList = attr.getRowFiledList();
        Set fieldNames = rowFiledList.stream().map(e -> e.getCode()).collect(Collectors.toSet());
        if (fieldNames.contains("name")) {
            return "name";
        }
        List fieldNameSorted = fieldNames.stream().sorted().collect(Collectors.toList());
        for (String name : fieldNameSorted) {
            boolean match = PatternMatchUtils.simpleMatch((String)"*name*", (String)name);
            if (!match) continue;
            return name;
        }
        return "name";
    }

    @Override
    public PageInfo<AbacRoleAttrRespDto> pageRoleAttrByRoleId(AbacAttrQueryReqDto query) {
        Long instanceId = query.getInstanceId();
        List<AbacAttrRespDto> abacAttrRespDtos = this.listAttrByInstanceId(instanceId);
        Set<String> attrFieldSet = abacAttrRespDtos.stream().map(AbacAttrRespDto::getFieldName).collect(Collectors.toSet());
        String attrType = query.getAttrType();
        QueryWrapper<UserRoleRelationEo> queryWrapper = null;
        queryWrapper = "1".equals(attrType) ? this.assembleCompositeAttrQueryWrapper(attrFieldSet, query.getRoleId()) : this.assembleSingleAttrQueryWrapper(attrFieldSet, this.attrFieldName(abacAttrRespDtos, query.getEntityCode()), query.getRoleId());
        IPage<UserRoleRelationEo> userRoleRelationPage = this.queryUserRoleRelationEoPage(query, queryWrapper);
        if (null == userRoleRelationPage || userRoleRelationPage.getTotal() == 0L) {
            return new PageInfo();
        }
        ArrayList<AbacRoleAttrRespDto> roleAttrList = new ArrayList<AbacRoleAttrRespDto>();
        HashMap<String, List<JSONObject>> fieldNameToJSONObjectMap = new HashMap<String, List<JSONObject>>();
        HashMap<Long, Map<String, Long>> userRoleAttrMap = new HashMap<Long, Map<String, Long>>(64);
        for (AbacAttrRespDto attr : abacAttrRespDtos) {
            HashSet<Long> ids = new HashSet<Long>();
            String fieldName = attr.getFieldName();
            for (UserRoleRelationEo item : userRoleRelationPage.getRecords()) {
                Long itemId = item.getId();
                Long id = this.getFieldValue(item, fieldName);
                if (BaseConstant.ATTR_VALUE_NULL.equals(id)) continue;
                ids.add(id);
                this.addAttr2Map(userRoleAttrMap, fieldName, itemId, id);
            }
            if (!CollectionUtils.isNotEmpty(ids)) continue;
            MetaQueryBodyReq queryBodyReq = new MetaQueryBodyReq();
            queryBodyReq.setPageSize(query.getPageSize());
            queryBodyReq.setTable(attr.getEntityCode());
            queryBodyReq.setColumns((List)Lists.newArrayList((Object[])new String[]{"id", this.extractNameField(attr.getAttrConfig())}));
            HashMap<String, HashSet<Long>> params = new HashMap<String, HashSet<Long>>();
            params.put("id@in", ids);
            queryBodyReq.setParams(params);
            PageInfo jsonObjectPageInfo = this.metaToEntityQueryService.queryPage(queryBodyReq);
            fieldNameToJSONObjectMap.put(fieldName, jsonObjectPageInfo.getList());
        }
        for (UserRoleRelationEo item : userRoleRelationPage.getRecords()) {
            AbacRoleAttrRespDto roleAttrRowData = this.getAbacRoleAttr(abacAttrRespDtos, fieldNameToJSONObjectMap, item);
            roleAttrList.add(roleAttrRowData);
        }
        PageInfo<AbacRoleAttrRespDto> result = this.convertPage(query, userRoleRelationPage, roleAttrList);
        return result;
    }

    private String attrFieldName(List<AbacAttrRespDto> abacAttrRespDtos, String entityCode) {
        for (AbacAttrRespDto abacAttrRespDto : abacAttrRespDtos) {
            if (!entityCode.equals(abacAttrRespDto.getEntityCode())) continue;
            return abacAttrRespDto.getFieldName();
        }
        return null;
    }

    private PageInfo<AbacRoleAttrRespDto> convertPage(AbacAttrQueryReqDto query, IPage<UserRoleRelationEo> userRoleRelationPage, List<AbacRoleAttrRespDto> roleAttrList) {
        PageInfo result = new PageInfo(roleAttrList);
        result.setTotal(userRoleRelationPage.getTotal());
        result.setPageNum(query.getPageNum().intValue());
        result.setPages(query.getPageSize().intValue());
        return result;
    }

    private IPage<UserRoleRelationEo> queryUserRoleRelationEoPage(AbacAttrQueryReqDto query, QueryWrapper<UserRoleRelationEo> queryWrapper) {
        Page page = new Page();
        page.setCurrent((long)query.getPageNum().intValue());
        page.setSize((long)query.getPageSize().intValue());
        return this.roleRelationDas.getMapper().selectPage((IPage)page, queryWrapper);
    }

    private QueryWrapper<UserRoleRelationEo> assembleSingleAttrQueryWrapper(Set<String> attrFieldSet, String entityCode, Long roleId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"role_id", (Object)roleId);
        queryWrapper.ne((Object)entityCode, (Object)BaseConstant.ATTR_VALUE_NULL);
        attrFieldSet.remove(entityCode);
        for (String field : attrFieldSet) {
            queryWrapper.eq((Object)field, (Object)BaseConstant.ATTR_VALUE_NULL);
        }
        return queryWrapper;
    }

    private QueryWrapper<UserRoleRelationEo> assembleCompositeAttrQueryWrapper(Set<String> attrFieldSet, Long roleId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (attrFieldSet.size() == 1) {
            queryWrapper.lt((Object)"id", (Object)0);
            return queryWrapper;
        }
        Set cartesianProduct = Sets.cartesianProduct((Set[])new Set[]{attrFieldSet, attrFieldSet});
        HashSet keySets = new HashSet();
        queryWrapper.eq((Object)"role_id", (Object)roleId);
        queryWrapper.and(wrapper -> {
            for (List item : cartesianProduct) {
                ArrayList list = Lists.newArrayList((Iterable)item);
                Collections.sort(list);
                String key1 = (String)list.get(0);
                String key2 = (String)list.get(1);
                String combineKey = key1 + "_" + key2;
                if (key1.equals(key2) || keySets.contains(combineKey)) continue;
                wrapper.ne((Object)key1, (Object)BaseConstant.ATTR_VALUE_NULL);
                wrapper.ne((Object)key2, (Object)BaseConstant.ATTR_VALUE_NULL);
                wrapper.or();
                keySets.add(combineKey);
            }
        });
        return queryWrapper;
    }

    private AbacRoleAttrRespDto getAbacRoleAttr(List<AbacAttrRespDto> abacAttrRespDtos, Map<String, List<JSONObject>> fieldNameToJSONObjectMap, UserRoleRelationEo item) {
        HashMap<String, AbacRoleRelationAttrValueRespDto> fileNameToAttValueMap = new HashMap<String, AbacRoleRelationAttrValueRespDto>();
        AbacRoleAttrRespDto roleAttrRowData = new AbacRoleAttrRespDto();
        for (AbacAttrRespDto attr : abacAttrRespDtos) {
            String fieldName = attr.getFieldName();
            List<JSONObject> jsonObjectList = fieldNameToJSONObjectMap.get(fieldName);
            if (!CollectionUtils.isNotEmpty(jsonObjectList)) continue;
            Map<Long, JSONObject> idToEntity = jsonObjectList.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
            Long id = this.getFieldValue(item, fieldName);
            AbacRoleRelationAttrValueRespDto attrValue = new AbacRoleRelationAttrValueRespDto();
            attrValue.setFieldName(fieldName);
            attrValue.setAttrName(attr.getName());
            attrValue.setValue(id);
            JSONObject jsonObject = idToEntity.get(id);
            if (Objects.nonNull(jsonObject)) {
                String name = this.extractNameField(attr.getAttrConfig());
                attrValue.setValueName(jsonObject.getString(name));
            }
            fileNameToAttValueMap.put(fieldName, attrValue);
        }
        roleAttrRowData.setFieldNameToAttrMap(fileNameToAttValueMap);
        roleAttrRowData.setId(item.getId());
        return roleAttrRowData;
    }

    private void addAttr2Map(Map<Long, Map<String, Long>> userRoleAttrMap, String fieldName, Long itemId, Long id) {
        Map attrObj = userRoleAttrMap.computeIfAbsent(itemId, k -> new HashMap());
        attrObj.put(fieldName, id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveRoleAttr(AbacRoleAttrSaveReqDto saveDto) {
        RoleEo roleEo = (RoleEo)this.roleDas.selectByPrimaryKey(saveDto.getRoleId());
        if (Objects.isNull(roleEo)) {
            throw new BizException("\u89d2\u8272\u4e0d\u5b58\u5728!");
        }
        UserRoleRelationEo toSave = new UserRoleRelationEo();
        toSave.setRoleId(roleEo.getId());
        toSave.setInstanceId(roleEo.getInstanceId());
        List attrValueDtos = saveDto.getAttrValueDtos();
        this.fillDefaultAttrValue(roleEo.getInstanceId(), attrValueDtos);
        this.setField(toSave, attrValueDtos);
        List userRoleRelationEoList = this.roleRelationDas.selectList((BaseEo)toSave);
        if (!userRoleRelationEoList.isEmpty()) {
            return ((UserRoleRelationEo)userRoleRelationEoList.get(0)).getId();
        }
        toSave.setRoleCode(roleEo.getCode());
        toSave.setTenantId(roleEo.getTenantId());
        toSave.setCreateTime(new Date());
        toSave.setUpdateTime(new Date());
        this.roleRelationDas.insert((BaseEo)toSave);
        return toSave.getId();
    }

    private void clearUserRoleCache(UserRoleRelationEo userRoleRelationEo) {
        PageInfo<EmployeeDto> employeePage;
        List<EmployeePagerRespDto> employeeList;
        PostReqDto postReqDto;
        if (null == userRoleRelationEo) {
            return;
        }
        Long userId = userRoleRelationEo.getUserId();
        Long postId = userRoleRelationEo.getPostId();
        Long orgId = userRoleRelationEo.getOrgId();
        ArrayList<Long> userIdList = new ArrayList<Long>();
        if (!BaseConstant.ATTR_VALUE_NULL.equals(userId)) {
            userIdList.add(userId);
        }
        if (!BaseConstant.ATTR_VALUE_NULL.equals(postId) && null != (postReqDto = this.postService.queryById(postId)) && CollectionUtils.isNotEmpty(employeeList = this.employeePostService.employeeList(postReqDto.getCode()))) {
            userIdList.addAll(employeeList.stream().filter(employee -> employee.getUserId() != null).map(EmployeePagerRespDto::getUserId).collect(Collectors.toSet()));
        }
        if (!BaseConstant.ATTR_VALUE_NULL.equals(orgId) && null != (employeePage = this.employeeService.queryPage(orgId, new EmployeeQueryReqDto(), 1, 10000)) && employeePage.getTotal() > 0L) {
            List employeeDtos = employeePage.getList();
            userIdList.addAll(employeeDtos.stream().filter(employee -> employee.getUserId() != null).map(EmployeeDto::getUserId).collect(Collectors.toSet()));
        }
        ArrayList<String> cacheKeyList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(userIdList)) {
            for (Long cachedUserId : userIdList) {
                cacheKeyList.add("AccessServiceImpl:queryUserRoleByUserId:" + cachedUserId);
            }
            this.cacheService.delCache(cacheKeyList);
        }
    }

    private List<AbacRoleAttrValueDto> getNotContainsAttrValue(Long instanceId, List<AbacRoleAttrValueDto> attrValueDtos) {
        List<AbacAttrRespDto> abacAttrRespDtos = this.listAll();
        Map<String, AbacRoleAttrValueDto> fieldNameToAttr = attrValueDtos.stream().collect(Collectors.toMap(AbacRoleAttrValueDto::getFieldName, e -> e));
        ArrayList<AbacRoleAttrValueDto> defaultValues = new ArrayList<AbacRoleAttrValueDto>();
        for (AbacAttrRespDto item : abacAttrRespDtos) {
            String fieldName = item.getFieldName();
            if (!Objects.isNull(fieldNameToAttr.get(fieldName))) continue;
            AbacRoleAttrValueDto valueDto = new AbacRoleAttrValueDto();
            valueDto.setValue(BaseConstant.ATTR_VALUE_NULL);
            valueDto.setAttrName(item.getName());
            valueDto.setFieldName(fieldName);
            defaultValues.add(valueDto);
        }
        return defaultValues;
    }

    private void fillDefaultAttrValue(Long instanceId, List<AbacRoleAttrValueDto> attrValueDtos) {
        List<AbacRoleAttrValueDto> defaultAttrValue = this.getNotContainsAttrValue(instanceId, attrValueDtos);
        if (CollectionUtils.isNotEmpty(defaultAttrValue)) {
            attrValueDtos.addAll(defaultAttrValue);
        }
    }

    @Override
    public List<AbacAttrRespDto> listAll() {
        List attrEoList = this.abacAttrDas.selectAll();
        if (CollectionUtils.isEmpty((Collection)attrEoList)) {
            return Lists.newArrayList();
        }
        return attrEoList.stream().map(c -> {
            AbacAttrRespDto dto = new AbacAttrRespDto();
            BeanUtils.copyProperties((Object)c, (Object)dto, (String[])new String[]{"attrConfig"});
            if (StringUtils.isNotEmpty((CharSequence)c.getAttrConfig())) {
                AbacAttrConfigDto abacAttrConfigDto = (AbacAttrConfigDto)JSONObject.parseObject((String)c.getAttrConfig(), AbacAttrConfigDto.class);
                dto.setAttrConfig(abacAttrConfigDto);
            }
            return dto;
        }).collect(Collectors.toList());
    }

    @Override
    public AbacAttrRespDto queryById(Long id) {
        if (id == null) {
            return null;
        }
        AbacAttrEo eo = (AbacAttrEo)this.abacAttrDas.selectByPrimaryKey(id);
        if (eo == null) {
            return null;
        }
        AbacAttrRespDto dto = new AbacAttrRespDto();
        BeanUtils.copyProperties((Object)eo, (Object)dto, (String[])new String[]{"attrConfig"});
        if (StringUtils.isNotEmpty((CharSequence)eo.getAttrConfig())) {
            AbacAttrConfigDto abacAttrConfigDto = (AbacAttrConfigDto)JSONObject.parseObject((String)eo.getAttrConfig(), AbacAttrConfigDto.class);
            dto.setAttrConfig(abacAttrConfigDto);
        }
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateRoleAttr(AbacRoleAttrUpdateReqDto updateReqDto) {
        UserRoleRelationEo userRoleRelationEo = (UserRoleRelationEo)this.roleRelationDas.selectByPrimaryKey(updateReqDto.getId());
        if (Objects.isNull(userRoleRelationEo)) {
            throw new BizException("\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        UserRoleRelationEo dbUserRelationEo = (UserRoleRelationEo)Assembler.assemble(UserRoleRelationEo.class, (Object)userRoleRelationEo);
        List attrValueDtos = updateReqDto.getAttrValueDtos();
        this.fillDefaultAttrValue(userRoleRelationEo.getInstanceId(), attrValueDtos);
        this.setField(userRoleRelationEo, attrValueDtos);
        UserRoleRelationEo query = new UserRoleRelationEo();
        query.setRoleId(userRoleRelationEo.getRoleId());
        this.setField(query, updateReqDto.getAttrValueDtos());
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.ne((String)"id", (Object)userRoleRelationEo.getId()));
        query.setSqlFilters(sqlFilterList);
        List userRoleRelationEoList = this.roleRelationDas.selectList((BaseEo)query);
        if (CollectionUtils.isNotEmpty((Collection)userRoleRelationEoList)) {
            return;
        }
        userRoleRelationEo.setUpdateTime(new Date());
        this.roleRelationDas.update((BaseEo)userRoleRelationEo);
    }

    @Override
    public Long insert(AbacAttrReqDto reqDto) {
        List existList = this.abacAttrDas.selectByEntityCode(reqDto.getEntityCode());
        if (CollectionUtils.isNotEmpty((Collection)existList)) {
            throw new BizException("\u5df2\u7ecf\u521b\u5efa\u76f8\u540c\u5b9e\u4f53\u7684\u5c5e\u6027\u9879");
        }
        AbacAttrEo eo = new AbacAttrEo();
        BeanUtils.copyProperties((Object)reqDto, (Object)eo, (String[])new String[]{"attrConfig"});
        if (reqDto.getAttrConfig() != null) {
            eo.setAttrConfig(JSONObject.toJSONString((Object)reqDto.getAttrConfig()));
        }
        this.abacAttrDas.insert((BaseEo)eo);
        return eo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchRoleAttr(AbacRoleAttrBatchReqDto saveDto) {
        RoleEo roleEo = (RoleEo)this.roleDas.selectByPrimaryKey(saveDto.getRoleId());
        if (Objects.isNull(roleEo)) {
            throw new BizException("\u89d2\u8272\u4e0d\u5b58\u5728!");
        }
        if (CollectionUtils.isEmpty((Collection)saveDto.getAttrValueDtos())) {
            return;
        }
        List attrValueDtos = saveDto.getAttrValueDtos();
        AbacRoleAttrValueDto valueDto = (AbacRoleAttrValueDto)attrValueDtos.get(0);
        List<AbacRoleAttrValueDto> defaultAttrValue = this.getNotContainsAttrValue(roleEo.getInstanceId(), Lists.newArrayList((Object[])new AbacRoleAttrValueDto[]{valueDto}));
        ArrayList<UserRoleRelationEo> userRoleRelationEoList = new ArrayList<UserRoleRelationEo>();
        ArrayList<Long> userIdList = new ArrayList<Long>();
        for (AbacRoleAttrValueDto abacRoleAttrValueDto : attrValueDtos) {
            UserRoleRelationEo userRoleRelationEo = new UserRoleRelationEo();
            ArrayList<AbacRoleAttrValueDto> roleAttrValueDtos = new ArrayList<AbacRoleAttrValueDto>(defaultAttrValue);
            roleAttrValueDtos.add(abacRoleAttrValueDto);
            this.setField(userRoleRelationEo, roleAttrValueDtos);
            userRoleRelationEo.setRoleId(saveDto.getRoleId());
            userRoleRelationEo.setTenantId(roleEo.getTenantId());
            userRoleRelationEo.setInstanceId(roleEo.getInstanceId());
            userRoleRelationEoList.add(userRoleRelationEo);
            Long userId = userRoleRelationEo.getUserId();
            if (BaseConstant.ATTR_VALUE_NULL.equals(userId)) continue;
            userIdList.add(userId);
        }
        for (UserRoleRelationEo userRoleRelationEo : userRoleRelationEoList) {
            userRoleRelationEo.setRoleCode(roleEo.getCode());
            userRoleRelationEo.setExtension("");
        }
        this.roleRelationDas.insertBatch(userRoleRelationEoList);
    }

    private void deleteUserRoleCache(List<Long> userIds) {
        ArrayList<String> keys = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(userIds)) {
            for (Long userId : userIds) {
                keys.add("AccessServiceImpl:queryUserRoleByUserId:" + userId);
            }
            this.cacheService.delCache(keys);
        }
    }

    @Override
    public void update(AbacAttrReqDto reqDto) {
        if (reqDto == null || reqDto.getId() == null) {
            return;
        }
        AbacAttrEo eo = new AbacAttrEo();
        BeanUtils.copyProperties((Object)reqDto, (Object)eo, (String[])new String[]{"attrConfig"});
        if (reqDto.getAttrConfig() != null) {
            eo.setAttrConfig(JSONObject.toJSONString((Object)reqDto.getAttrConfig()));
        }
        this.abacAttrDas.updateSelective((BaseEo)eo);
    }

    @Override
    public void deleteRoleAttById(Long id) {
        this.roleRelationDas.deleteById(id);
    }

    private void setField(UserRoleRelationEo toSetFieldObject, List<AbacRoleAttrValueDto> sourceData) {
        for (AbacRoleAttrValueDto item : sourceData) {
            String fieldName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, item.getFieldName());
            Field field = ReflectionUtils.findField(UserRoleRelationEo.class, (String)fieldName);
            if (Objects.isNull(field)) continue;
            try {
                field.setAccessible(true);
                if (Objects.isNull(item.getValue())) {
                    field.set(toSetFieldObject, BaseConstant.ATTR_VALUE_NULL);
                    continue;
                }
                field.set(toSetFieldObject, item.getValue());
            }
            catch (IllegalAccessException ex) {
                logger.error("\u8bbe\u7f6e\u89d2\u8272\u5c5e\u6027\u503c\u5f02\u5e38", (Throwable)ex);
                throw new BizException("\u8bbe\u7f6e\u89d2\u8272\u5c5e\u6027\u503c\u5f02\u5e38");
            }
        }
    }

    private Long getFieldValue(UserRoleRelationEo source, String fieldName) {
        fieldName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, fieldName);
        try {
            Method method = ReflectionUtils.findMethod(UserRoleRelationEo.class, (String)("get" + fieldName));
            method.setAccessible(true);
            Object value = method.invoke((Object)source, new Object[0]);
            return (Long)value;
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            logger.error("\u83b7\u53d6\u89d2\u8272\u5c5e\u6027\u503c\u5f02\u5e38", (Throwable)ex);
            throw new BizException("\u83b7\u53d6\u89d2\u8272\u5c5e\u6027\u503c\u5f02\u5e38");
        }
    }

    @Override
    public void deleteById(Long id) {
        if (id == null) {
            return;
        }
        AbacAttrEo existEo = (AbacAttrEo)this.abacAttrDas.selectByPrimaryKey(id);
        if (existEo == null) {
            return;
        }
        if ("us_user".equals(existEo.getEntityCode())) {
            throw new BizException("\u7528\u6237\u4e3a\u9ed8\u8ba4\u5c5e\u6027\u9879\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        List attrAppList = this.abacAttrApplicationDas.selectByAttrId(id);
        if (CollectionUtils.isNotEmpty((Collection)attrAppList)) {
            throw new BizException("\u8be5\u5c5e\u6027\u9879\u5df2\u7ecf\u88ab\u5f15\u7528");
        }
        this.abacAttrDas.deleteById(id);
    }
}

