/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.ds.BaseEoUtil;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.constants.OrgType;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationTreeDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgSyncReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrganizationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.BizOrganizationRespDto;
import com.dtyunxi.yundt.cube.center.user.api.enums.OrgTypeEnum;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.BizExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.condition.Criteria;
import com.dtyunxi.yundt.cube.center.user.biz.exception.BizException;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IBizOrganizationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrganizationEventService;
import com.dtyunxi.yundt.cube.center.user.biz.util.QueryUtil;
import com.dtyunxi.yundt.cube.center.user.biz.utils.CompareUtils;
import com.dtyunxi.yundt.cube.center.user.dao.das.BizOrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeOrgDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeOrgEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdOrganizationEo;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizOrganizationServiceImpl
implements IBizOrganizationService {
    private static final Logger logger = LoggerFactory.getLogger(BizOrganizationServiceImpl.class);
    @Autowired
    private OrganizationDas organizationDas;
    @Resource
    private EmployeeDas employeeDas;
    @Resource
    private EmployeeOrgDas employeeOrganizationRelationDas;
    @Resource
    private IApplicationService applicationService;
    @Resource
    private BizOrganizationDas bizOrganizationDas;
    @Autowired
    private ILockService lockService;
    @Value(value="${lppz.tenantId:}")
    private Long defaultTenantId;
    @Autowired
    private IDictQueryApi dictQueryApi;
    public static final String GROUP_CODE = "LPPZ_ORG";
    public static final String ONLINE_CODE = "ONLINE_ORG_CODE";
    public static final String UNDERLINE_CODE = "UNDERLINE_ORG_CODE";
    @Resource
    private IOrganizationEventService organizationEventService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(OrgReqDto orgReqDto) {
        this.verifyOrgCode(orgReqDto);
        if (null == orgReqDto.getParentId()) {
            orgReqDto.setParentId(this.getRootOrgId(orgReqDto.getInstanceId()));
        }
        OrganizationEo insertOrgEo = new OrganizationEo();
        BeanUtils.copyProperties((Object)orgReqDto, (Object)insertOrgEo);
        insertOrgEo.setType(OrgType.ORG.getCode());
        Long parentId = insertOrgEo.getParentId();
        OrganizationEo parentOrg = (OrganizationEo)this.organizationDas.selectByPrimaryKey(parentId);
        if (null == parentOrg) {
            throw new BizException(BizExceptionCode.NON_EXIST_FAIL);
        }
        insertOrgEo.setSortNO(this.getSortNo(this.getByParent(parentId)));
        AppInstanceDto appInstanceDto = this.applicationService.queryInstanceOne(orgReqDto.getInstanceId());
        insertOrgEo.setTenantId(appInstanceDto.getTenantId());
        this.bizOrganizationDas.updateForInsert(insertOrgEo);
        this.bizOrganizationDas.insert((BaseEo)insertOrgEo);
        this.updateIsLeaf(parentId);
        this.organizationEventService.pushEvent(insertOrgEo, null, "ADD");
        return insertOrgEo.getId();
    }

    private void updateIsLeaf(Long parentId) {
        OrganizationEo ex = new OrganizationEo();
        ex.setParentId(parentId);
        this.organizationDas.count((BaseEo)ex);
        ex.setParentId(null);
        ex.setId(parentId);
        this.organizationDas.updateSelective((BaseEo)ex);
        this.organizationEventService.pushEvent(ex, null, "UPDATE");
    }

    @Override
    public void updateOrgLvRv(Long orgId) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrgs(Long instanceId, List<OrgReqDto> orgReqDtos) {
        AppInstanceDto appInstanceDto = this.applicationService.queryInstanceOne(instanceId);
        Long tenantId = appInstanceDto.getTenantId();
        Long rootOrgId = this.getRootOrgId(instanceId);
        ArrayList organizationEos = Lists.newArrayList();
        boolean updateAllLvRv = false;
        if (orgReqDtos.size() > 50) {
            updateAllLvRv = true;
        }
        for (OrgReqDto dto : orgReqDtos) {
            OrganizationEo orgEo = new OrganizationEo();
            BeanUtils.copyProperties((Object)dto, (Object)orgEo);
            orgEo.setType(OrgType.ORG.getCode());
            orgEo.setInstanceId(instanceId);
            orgEo.setTenantId(tenantId);
            if (null == dto.getParentCode()) {
                orgEo.setParentId(rootOrgId);
            } else {
                orgEo.setParentId(this.getIdByCode(dto.getParentCode()));
            }
            if (null != orgEo.getParentId()) {
                orgEo.setSortNO(this.getSortNo(this.getByParent(orgEo.getParentId())));
            }
            organizationEos.add(orgEo);
            if (!updateAllLvRv) {
                this.bizOrganizationDas.updateForInsert(orgEo);
            }
            this.bizOrganizationDas.insert((BaseEo)orgEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(OrgReqDto orgReqDto) {
        this.verifyOrgCode(orgReqDto);
        OrganizationDto orgDto = new OrganizationDto();
        BeanUtils.copyProperties((Object)orgReqDto, (Object)orgDto);
        orgDto.setExtFields(CompareUtils.getDiffField((Object)orgReqDto, (Object)orgDto));
        OrganizationEo organizationEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(orgReqDto.getId());
        if (organizationEo == null) {
            throw new BizException(UserExceptionCode.ORGANIZATION__IDCHECK_FAIL.getCode(), UserExceptionCode.ORGANIZATION__IDCHECK_FAIL.getMsg());
        }
        DtoHelper.dto2Eo((BaseVo)orgDto, (BaseEo)organizationEo, (String[])new String[]{"id"});
        this.organizationDas.updateSelective((BaseEo)organizationEo);
        this.organizationEventService.pushEvent(organizationEo, null, "UPDATE");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sort(Long parentId, Long orgId, Integer sort) {
        Class<OrganizationEo> orgClass = OrganizationEo.class;
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock(BaseEoUtil.tableName(orgClass), BaseEoUtil.idName(orgClass), 10);
            if (null != mutex) {
                if (null == parentId || null == orgId) {
                    throw new BizException(BizExceptionCode.PARAM_ERROR);
                }
            } else {
                throw new RuntimeException("aquire lock fail");
            }
            OrganizationEo orgEo = (OrganizationEo)this.bizOrganizationDas.getMapper().findById(orgClass, orgId);
            Long oldParentId = this.sortOrg(parentId, sort, orgEo);
            this.updateIsLeaf(parentId);
            this.updateIsLeaf(oldParentId);
        }
        catch (Exception e) {
            try {
                logger.warn("\u7ec4\u7ec7\u6392\u5e8f\u5f02\u5e38 ", (Throwable)e);
                throw new RuntimeException("aquire lock fail");
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
    }

    private Long sortOrg(Long parentId, Integer sort, OrganizationEo orgEo) {
        Long oldParentId = orgEo.getParentId();
        List<OrganizationEo> children = this.getByParent(parentId);
        if (CollectionUtils.isNotEmpty(children)) {
            children.removeIf(next -> next.getId().equals(orgEo.getId()));
            if (null == sort || sort > children.size() + 1) {
                sort = children.size() + 1;
            }
            if (sort < 1) {
                sort = 1;
            }
            orgEo.setParentId(parentId);
            sort = sort - 1;
            children.add(sort, orgEo);
            this.updateSort(children);
        } else {
            orgEo.setParentId(parentId);
            orgEo.setSortNO(Integer.valueOf(1));
            this.organizationDas.update((BaseEo)orgEo);
        }
        this.updateSort(this.getByParent(oldParentId));
        return oldParentId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(Long orgId) {
        OrganizationEo orgEo = (OrganizationEo)this.bizOrganizationDas.getMapper().findById(OrganizationEo.class, orgId);
        if (orgEo == null) {
            return;
        }
        this.bizOrganizationDas.updateForDelete(orgEo);
        this.updateIsLeaf(orgEo.getParentId());
        this.organizationEventService.pushEvent(orgEo, null, "DELETE");
    }

    @Override
    public List<OrganizationTreeDto> getOrganizationTree(Long instanceId, Long userId) {
        OrganizationEo organization = new OrganizationEo();
        organization.setInstanceId(instanceId);
        organization.setOrderBy("sortno");
        List allOrganizationList = this.organizationDas.select((BaseEo)organization, Integer.valueOf(1), Integer.valueOf(10000));
        EmployeeEo employee = new EmployeeEo();
        employee.setUserId(userId);
        employee.setInstanceId(instanceId);
        employee = (EmployeeEo)this.employeeDas.selectOne((BaseEo)employee);
        if (employee == null) {
            return Collections.emptyList();
        }
        EmployeeOrgEo relation = new EmployeeOrgEo();
        relation.setInstanceId(instanceId);
        relation.setEmployeeId(employee.getId());
        List relationList = this.employeeOrganizationRelationDas.select((BaseEo)relation);
        HashSet<Long> relationIdSet = new HashSet<Long>();
        relationList.forEach(o -> relationIdSet.add(o.getOrganizationId()));
        return this.buildOrganizationTree(allOrganizationList, relationIdSet);
    }

    @Override
    public List<OrganizationDto> getOrganizations(List<String> orgNos) {
        if (CollectionUtils.isEmpty(orgNos)) {
            return Lists.newArrayList();
        }
        OrganizationEo ex = new OrganizationEo();
        ex.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"code", orgNos)));
        List organizationEos = this.organizationDas.select((BaseEo)ex);
        ArrayList results = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)organizationEos, (Collection)results, OrganizationDto.class);
        return results;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncOrg(String parentCode, List<OrgSyncReqDto> orgSyncReqDtos) {
        Class<OrganizationEo> orgClass = OrganizationEo.class;
        Mutex mutex = null;
        try {
            OrganizationEo parent;
            mutex = this.lockService.lock(BaseEoUtil.tableName(orgClass), BaseEoUtil.idName(orgClass), 10);
            if (null != mutex) {
                parent = this.getByCode(parentCode);
                if (null == parent || null == parent.getId()) {
                    throw new BizException(BizExceptionCode.NON_EXIST_FAIL);
                }
                if (CollectionUtils.isEmpty(orgSyncReqDtos)) {
                    throw new BizException(BizExceptionCode.PARAM_ERROR);
                }
            } else {
                throw new RuntimeException("aquire lock fail");
            }
            this.start(orgSyncReqDtos, parent);
            this.updateIsLeaf(parent.getId());
        }
        catch (Exception e) {
            try {
                logger.warn("\u540c\u6b65\u7ec4\u7ec7\u5f02\u5e38 ", (Throwable)e);
                throw new RuntimeException("aquire lock fail");
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
    }

    private void start(List<OrgSyncReqDto> orgSyncReqDtos, OrganizationEo parent) {
        Long parentId = parent.getId();
        Integer sortNo = this.getSortNo(this.getByParent(parentId));
        for (OrgSyncReqDto dto : orgSyncReqDtos) {
            OrganizationEo byCode = this.getByCode(dto.getCode());
            if (null == byCode) {
                OrganizationEo insertEo = new OrganizationEo();
                BeanUtils.copyProperties((Object)dto, (Object)insertEo);
                if (OrgType.UNDERLINE.getCode().equals(dto.getType())) {
                    insertEo.setName(dto.getShopName());
                }
                insertEo.setParentId(parentId);
                Integer n = sortNo;
                Integer n2 = sortNo = Integer.valueOf(sortNo + 1);
                insertEo.setSortNO(n);
                insertEo.setTenantId(parent.getTenantId());
                insertEo.setInstanceId(parent.getInstanceId());
                insertEo.setCreatePerson("sys");
                insertEo.setUpdatePerson("sys");
                this.bizOrganizationDas.updateForInsert(insertEo);
                this.organizationDas.insert((BaseEo)insertEo);
                continue;
            }
            if (null != dto.getDelFlag() && 1 == dto.getDelFlag()) {
                this.bizOrganizationDas.updateForDelete(byCode);
                continue;
            }
            BeanUtils.copyProperties((Object)dto, (Object)byCode);
            if (OrgType.UNDERLINE.getCode().equals(dto.getType())) {
                byCode.setName(dto.getShopName());
            }
            byCode.setName(dto.getShopName());
            byCode.setParentId(parentId);
            this.organizationDas.updateSelective((BaseEo)byCode);
        }
    }

    @Override
    public List<OrganizationDto> getOrg(Long instanceId, Long parentId) {
        if (null == parentId) {
            Long rootOrgId = this.getRootOrgId(instanceId);
            OrganizationEo organizationEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(rootOrgId);
            OrganizationDto organizationDto = new OrganizationDto();
            DtoHelper.eo2Dto((BaseEo)organizationEo, (BaseVo)organizationDto);
            return Collections.singletonList(organizationDto);
        }
        List<OrganizationEo> byParent = this.getByParent(parentId);
        ArrayList result = Lists.newArrayList();
        DtoHelper.eoList2DtoList(byParent, (Collection)result, OrganizationDto.class);
        return result;
    }

    @Override
    public List<OrganizationDto> getOrganizationsByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        OrganizationEo ex = new OrganizationEo();
        ex.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"id", ids)));
        List organizationEos = this.organizationDas.select((BaseEo)ex);
        if (CollectionUtils.isNotEmpty((Collection)organizationEos)) {
            for (OrganizationEo eo : organizationEos) {
                String entityPropCode = eo.getEntityPropCode();
                if (StringUtils.isBlank((CharSequence)entityPropCode) || entityPropCode.equals("company")) {
                    eo.setType(Integer.toString(OrgTypeEnum.COMPANY.getKey()));
                    continue;
                }
                eo.setType(Integer.toString(OrgTypeEnum.DEPARTMENT.getKey()));
            }
        }
        ArrayList results = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)organizationEos, (Collection)results, OrganizationDto.class);
        return results;
    }

    @Override
    public OrganizationDto getOrganizationByShopId(String shopId) {
        OrganizationEo query = new OrganizationEo();
        query.setSqlFilters(Collections.singletonList(SqlFilter.eq((String)"shopId", (Object)shopId)));
        PageInfo onePageInfo = this.organizationDas.selectPage((BaseEo)query, Integer.valueOf(1), Integer.valueOf(1));
        OrganizationEo organizationEo = null;
        if (CollectionUtils.isNotEmpty((Collection)onePageInfo.getList())) {
            organizationEo = (OrganizationEo)onePageInfo.getList().get(0);
            OrganizationDto dto = new OrganizationDto();
            DtoHelper.eo2Dto((BaseEo)organizationEo, (BaseVo)dto);
            return dto;
        }
        return null;
    }

    @Override
    public List<OrganizationDto> queryInfoByCodeList(List<String> codeList) {
        OrganizationEo query = new OrganizationEo();
        query.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"code", codeList)));
        List organizationEoList = this.organizationDas.select((BaseEo)query);
        ArrayList<OrganizationDto> dtoList = new ArrayList<OrganizationDto>();
        if (CollectionUtils.isNotEmpty((Collection)organizationEoList)) {
            DtoHelper.eoList2DtoList((Collection)organizationEoList, dtoList, OrganizationDto.class);
            return dtoList;
        }
        return null;
    }

    @Override
    public List<OrganizationDto> listOrganizationByUpdateTime(Long instanceId, String updateTime) {
        DictDto underlineDictDto = (DictDto)this.dictQueryApi.queryByGroupCodeAndCode(this.defaultTenantId, GROUP_CODE, UNDERLINE_CODE).getData();
        DictDto onlineDictDto = (DictDto)this.dictQueryApi.queryByGroupCodeAndCode(this.defaultTenantId, GROUP_CODE, ONLINE_CODE).getData();
        List<Object> underlineOrganization = new ArrayList();
        List<Object> onlineOrganization = new ArrayList();
        if (underlineDictDto != null && StringUtils.isNotBlank((CharSequence)underlineDictDto.getValue())) {
            underlineOrganization = this.listOrganizationByUpdateTimeAndParentCode(instanceId, updateTime, underlineDictDto.getValue());
        }
        if (onlineDictDto != null && StringUtils.isNotBlank((CharSequence)onlineDictDto.getValue())) {
            onlineOrganization = this.listOrganizationByUpdateTimeAndParentCode(instanceId, updateTime, onlineDictDto.getValue());
        }
        ArrayList organizationList = new ArrayList();
        organizationList.addAll(underlineOrganization);
        organizationList.addAll(onlineOrganization);
        if (CollectionUtils.isNotEmpty(organizationList)) {
            return organizationList.stream().map(o -> {
                OrganizationDto dto = new OrganizationDto();
                DtoHelper.eo2Dto((BaseEo)o, (BaseVo)dto);
                return dto;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<OrganizationEo> listOrganizationByUpdateTimeAndParentCode(Long instanceId, String updateTime, String parentCode) {
        OrganizationEo parent = new OrganizationEo();
        parent.setCode(parentCode);
        parent = (OrganizationEo)this.organizationDas.selectOne((BaseEo)parent);
        OrganizationEo query = new OrganizationEo();
        ArrayList<SqlFilter> filterList = new ArrayList<SqlFilter>();
        filterList.add(SqlFilter.eq((String)"instanceId", (Object)instanceId));
        filterList.add(SqlFilter.ge((String)"updateTime", (Object)updateTime));
        filterList.add(SqlFilter.eq((String)"parentId", (Object)parent.getId()));
        query.setSqlFilters(filterList);
        return this.organizationDas.select((BaseEo)query);
    }

    @Override
    public PageInfo<OrganizationDto> queryPageByCondition(OrganizationReqDto reqDto, Integer pageNum, Integer pageSize) {
        OrganizationEo organizationEo = new OrganizationEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getCode())) {
            organizationEo.setCode(reqDto.getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getName())) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + reqDto.getName() + "%")));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getTypes())) {
            sqlFilters.add(SqlFilter.in((String)"type", (Object)StringUtils.join((Iterable)reqDto.getTypes(), (String)"','")));
        }
        organizationEo.setSqlFilters(sqlFilters);
        PageInfo page = this.organizationDas.selectPage((BaseEo)organizationEo, pageNum, pageSize);
        return QueryUtil.eoPage2DtoPage((PageInfo)page, OrganizationDto.class);
    }

    public OrganizationEo getByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        OrganizationEo deleteEx = new OrganizationEo();
        deleteEx.setCode(code);
        return (OrganizationEo)this.organizationDas.selectOne((BaseEo)deleteEx);
    }

    private List<OrganizationTreeDto> buildOrganizationTree(List<OrganizationEo> allOrganizationList, Set<Long> relationIdSet) {
        if (CollectionUtils.isEmpty(allOrganizationList)) {
            return Collections.emptyList();
        }
        HashMap<Long, List<OrganizationTreeDto>> organizationMap = new HashMap<Long, List<OrganizationTreeDto>>();
        allOrganizationList.forEach(organization -> {
            ArrayList<OrganizationTreeDto> list;
            Long parentId = organization.getParentId();
            if (parentId == null) {
                parentId = 0L;
            }
            if ((list = (ArrayList<OrganizationTreeDto>)organizationMap.get(parentId)) == null) {
                list = new ArrayList<OrganizationTreeDto>();
            }
            OrganizationTreeDto dto = new OrganizationTreeDto();
            BeanUtils.copyProperties((Object)organization, (Object)dto);
            dto.setSelectAble(Boolean.valueOf(relationIdSet.contains(dto.getId())));
            list.add(dto);
            organizationMap.put(parentId, list);
        });
        List<OrganizationTreeDto> organizationTree = this.buildTreeRecursion(organizationMap, 0L);
        ArrayList<OrganizationTreeDto> viewOrganizationTree = new ArrayList<OrganizationTreeDto>();
        this.splitOrganizationTree(viewOrganizationTree, organizationTree);
        return viewOrganizationTree;
    }

    private void splitOrganizationTree(List<OrganizationTreeDto> viewOrganizationTree, List<OrganizationTreeDto> organizationTree) {
        if (organizationTree == null) {
            return;
        }
        organizationTree.forEach(organization -> {
            if (organization.getSelectAble().booleanValue()) {
                viewOrganizationTree.add((OrganizationTreeDto)organization);
            } else {
                this.splitOrganizationTree(viewOrganizationTree, organization.getChildren());
            }
        });
    }

    private List<OrganizationTreeDto> buildTreeRecursion(Map<Long, List<OrganizationTreeDto>> organizationMap, Long parentId) {
        List<OrganizationTreeDto> organizationList = organizationMap.get(parentId);
        if (CollectionUtils.isNotEmpty(organizationList)) {
            organizationList.forEach(organization -> organization.setChildren(this.buildTreeRecursion(organizationMap, organization.getId())));
        }
        return organizationList;
    }

    private void verifyOrgCode(OrgReqDto orgReqDto) {
        OrganizationEo ex = new OrganizationEo();
        ex.setCode(orgReqDto.getCode());
        OrganizationEo one = (OrganizationEo)this.organizationDas.selectOne((BaseEo)ex);
        if (null != one && !one.getId().equals(orgReqDto.getId())) {
            throw new BizException(BizExceptionCode.ORG_NO_ERROR);
        }
    }

    private List<OrganizationEo> getByParent(Long parentId) {
        OrganizationEo ex = new OrganizationEo();
        ex.setParentId(parentId);
        ex.setOrderBy("sortno");
        return this.organizationDas.select((BaseEo)ex);
    }

    private void updateSort(List<OrganizationEo> orgs) {
        int order = 1;
        for (OrganizationEo org : orgs) {
            org.setSortNO(Integer.valueOf(order++));
            this.organizationDas.update((BaseEo)org);
        }
    }

    private Integer getSortNo(List<OrganizationEo> orgEos) {
        if (CollectionUtils.isEmpty(orgEos)) {
            return 1;
        }
        Optional<Integer> maxOptional = orgEos.stream().map(StdOrganizationEo::getSortNO).filter(Objects::nonNull).max(Integer::compareTo);
        if (maxOptional.isPresent()) {
            int max = maxOptional.get();
            return ++max;
        }
        return 1;
    }

    private Long getRootOrgId(Long instanceId) {
        OrganizationEo root = this.organizationDas.findRootByInstanceId(instanceId);
        if (root == null) {
            throw new BizException(BizExceptionCode.ROOT_ORG_ERROR);
        }
        return root.getId();
    }

    private Long getIdByCode(String code) {
        OrganizationEo organizationEo = this.getByCode(code);
        if (null == organizationEo) {
            throw new BizException(BizExceptionCode.NON_EXIST_FAIL);
        }
        return organizationEo.getId();
    }

    @Override
    public PageInfo<BizOrganizationRespDto> queryBizOrganizationByPage(String filter, Integer pageNum, Integer pageSize) {
        Preconditions.checkState((pageNum != null && pageNum > 0 ? 1 : 0) != 0, (Object)"\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        Preconditions.checkState((pageSize != null && pageSize > 0 ? 1 : 0) != 0, (Object)"\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        Criteria criteria = (Criteria)ObjectHelper.Json2Bean((String)filter, Criteria.class);
        OrganizationEo bizOrganizationEo = new OrganizationEo();
        bizOrganizationEo.setSqlFilters(criteria.getFilters());
        bizOrganizationEo.setOrderByDesc("createTime");
        PageInfo organizationEoPageInfo = this.bizOrganizationDas.selectPage((BaseEo)bizOrganizationEo, pageNum, pageSize);
        return QueryUtil.eoPage2DtoPage((PageInfo)organizationEoPageInfo, BizOrganizationRespDto.class);
    }

    @Override
    public List<OrganizationDto> getOrganizationByShopIds(List<String> shopIds) {
        OrganizationEo organizationEo = new OrganizationEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"shop_id", (Object)StringUtils.join(shopIds, (String)",")));
        organizationEo.setSqlFilters((List)sqlFilters);
        ArrayList organizationDtoList = Lists.newArrayList();
        List organizationEoList = this.bizOrganizationDas.select((BaseEo)organizationEo);
        DtoHelper.eoList2DtoList((Collection)organizationEoList, (Collection)organizationDtoList, OrganizationDto.class);
        return organizationDtoList;
    }
}

