/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.commons.MyMapUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.base.EmployeeBaseDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.base.PostBase;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.request.EmployeePostQueryReqDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.request.PostAssignmentReqDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.request.PostEmployeeQueryReqDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.response.EmployeePagerRespDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.response.EmployeePostPagerRespDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.response.PostEmployeePagerRespDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.response.PostPagerRespDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.BundleExceptionCode;
import com.dtyunxi.yundt.cube.center.user.api.exception.IExceptionEnum;
import com.dtyunxi.yundt.cube.center.user.api.interfaces.IConvert;
import com.dtyunxi.yundt.cube.center.user.biz.service.IDataCollectionAndBind;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeePostService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IPostService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeOrgDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeePostDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.PostDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeOrgEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeePostEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.PostEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdEmployeePostEo;
import com.dtyunxi.yundt.cube.center.user.dao.vo.EmployeePostQueryVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EmployeePostServiceImpl
implements IEmployeePostService {
    @Resource
    protected EmployeePostDas employeePostDas;
    @Resource
    protected EmployeeOrgDas employeeOrganizationRelationDas;
    @Resource
    protected EmployeeDas employeeDas;
    @Resource
    protected OrganizationDas organizationDas;
    @Resource
    protected PostDas postDas;
    @Autowired
    protected IPostService postService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void assign(PostAssignmentReqDto postAssignmentReqDto) {
        EmployeeEo employeeExistsParam = new EmployeeEo();
        employeeExistsParam.setEmployeeNo(postAssignmentReqDto.getEmployeeNo());
        EmployeeEo employeeEoDb = (EmployeeEo)this.employeeDas.selectOne((BaseEo)employeeExistsParam);
        AssertUtil.isTrue((employeeEoDb != null ? 1 : 0) != 0, (IExceptionEnum)BundleExceptionCode.EMPLOYEE_NOT_FOUND);
        if (StringUtils.isEmpty((CharSequence)postAssignmentReqDto.getEmployeeNo())) {
            throw new BizException(BundleExceptionCode.POST_ASSIGNMENT_INFO_INTEGRALITY_ERROR.getMsg());
        }
        List list = null;
        if (CollectionUtils.isNotEmpty((Collection)postAssignmentReqDto.getPostCodes())) {
            PostEo postSelectParam = new PostEo();
            postSelectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("code", postAssignmentReqDto.getPostCodes()).get());
            List postEoList = this.postDas.select((BaseEo)postSelectParam);
            if (CollectionUtils.isNotEmpty((Collection)postEoList)) {
                if (postEoList.stream().anyMatch(postEo -> postEo.getStatus() == null || 0 == postEo.getStatus())) {
                    throw new BizException(BundleExceptionCode.CAN_NOT_BIND_DISABLE_POST.getMsg());
                }
                list = postEoList.stream().map(postEo -> {
                    EmployeePostEo rUserPostEo = new EmployeePostEo();
                    rUserPostEo.setEmployeeNo(postAssignmentReqDto.getEmployeeNo());
                    rUserPostEo.setPostCode(postEo.getCode());
                    rUserPostEo.setEmployeeId(employeeEoDb.getId());
                    rUserPostEo.setPostId(postEo.getId());
                    rUserPostEo.setStatus(Integer.valueOf(1));
                    rUserPostEo.setExtension("");
                    return rUserPostEo;
                }).collect(Collectors.toList());
            }
        }
        EmployeePostEo deleteParam = new EmployeePostEo();
        deleteParam.setEmployeeNo(postAssignmentReqDto.getEmployeeNo());
        deleteParam.setStatus(Integer.valueOf(1));
        this.employeePostDas.delete((BaseEo)deleteParam);
        if (CollectionUtils.isNotEmpty(list)) {
            this.employeePostDas.insertBatch(list);
        }
    }

    @Override
    public List<EmployeePagerRespDto> employeeList(String postCode) {
        EmployeePostEo selectParam = new EmployeePostEo();
        selectParam.setPostCode(postCode);
        List rUserPostEoList = this.employeePostDas.select((BaseEo)selectParam);
        if (CollectionUtils.isEmpty((Collection)rUserPostEoList)) {
            return Collections.emptyList();
        }
        final List employeeNos = rUserPostEoList.stream().map(StdEmployeePostEo::getEmployeeNo).collect(Collectors.toList());
        return new IDataCollectionAndBind<Long, EmployeePagerRespDto, EmployeeEo, OrganizationEo>(){

            @Override
            public List<EmployeeEo> search() {
                EmployeeEo employeeSelectParam = new EmployeeEo();
                employeeSelectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("employee_no", employeeNos).get());
                employeeSelectParam.setOrderByDesc("create_time");
                return EmployeePostServiceImpl.this.employeeDas.select((BaseEo)employeeSelectParam);
            }

            @Override
            public List<EmployeePagerRespDto> collect(List<EmployeeEo> list, Map<Long, List<EmployeePagerRespDto>> map) {
                LinkedList finalList = Lists.newLinkedList();
                LinkedList employeeIds = Lists.newLinkedList();
                HashMap employeeId2DtoMap = Maps.newHashMap();
                finalList.addAll(list.stream().map(employeeEo -> {
                    EmployeePagerRespDto employeePagerRespDto = new EmployeePagerRespDto();
                    employeePagerRespDto.setId(employeeEo.getId());
                    employeePagerRespDto.setName(employeeEo.getName());
                    employeePagerRespDto.setPhone(employeeEo.getPhoneNum());
                    employeePagerRespDto.setNo(employeeEo.getEmployeeNo());
                    employeePagerRespDto.setStatus(employeeEo.getStatus());
                    employeePagerRespDto.setCreateTime(employeeEo.getCreateTime());
                    employeePagerRespDto.setUserId(employeeEo.getUserId());
                    employeeId2DtoMap.put(employeeEo.getId(), employeePagerRespDto);
                    employeeIds.add(employeeEo.getId());
                    return employeePagerRespDto;
                }).collect(Collectors.toList()));
                EmployeeOrgEo employeeOrganizationRelationEo = new EmployeeOrgEo();
                employeeOrganizationRelationEo.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("employee_id", employeeIds).get());
                List relationEos = EmployeePostServiceImpl.this.employeeOrganizationRelationDas.select((BaseEo)employeeOrganizationRelationEo);
                if (CollectionUtils.isNotEmpty((Collection)relationEos)) {
                    relationEos.forEach(relationEo -> MyMapUtils.appendElement2ListMap((Map)map, (Object)relationEo.getOrganizationId(), employeeId2DtoMap.get(relationEo.getEmployeeId())));
                }
                return finalList;
            }

            @Override
            public Long getKey(OrganizationEo source) {
                return source.getId();
            }

            @Override
            public void bind(EmployeePagerRespDto target, OrganizationEo source) {
                if (target.getOrgName() != null) {
                    target.setOrgName(String.format("%s,%s", target.getOrgName(), source.getName()));
                } else {
                    target.setOrgName(source.getName());
                }
            }
        }.process(new OrganizationEo(), "id", this.organizationDas);
    }

    @Override
    public void unAssign(String employeeNo, String postCode) {
        EmployeePostEo removeParam = new EmployeePostEo();
        removeParam.setEmployeeNo(employeeNo);
        removeParam.setPostCode(postCode);
        this.employeePostDas.delete((BaseEo)removeParam);
    }

    @Override
    public List<PostPagerRespDto> postList(String employeeNo) {
        EmployeePostEo rParam = new EmployeePostEo();
        rParam.setEmployeeNo(employeeNo);
        List list = this.employeePostDas.select((BaseEo)rParam);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        PostEo selectParam = new PostEo();
        selectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("code", list.stream().map(StdEmployeePostEo::getPostCode).collect(Collectors.toList())).get());
        List postEoList = this.postDas.select((BaseEo)selectParam);
        if (CollectionUtils.isEmpty((Collection)postEoList)) {
            return Collections.emptyList();
        }
        return this.postService.assemblePostInfo(postEoList);
    }

    @Override
    public List<EmployeePostPagerRespDto> employeePostList(EmployeePostQueryReqDto employeePostQueryReqDto) {
        if (employeePostQueryReqDto == null) {
            return Collections.emptyList();
        }
        EmployeePostQueryVo employeePostQueryVo = new EmployeePostQueryVo();
        BeanUtils.copyProperties((Object)employeePostQueryReqDto, (Object)employeePostQueryVo);
        List list = this.employeePostDas.list(employeePostQueryVo);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        HashMap employeeNo2DtoMap = Maps.newHashMap();
        HashMap postCode2DtoMap = Maps.newHashMap();
        List<EmployeePostPagerRespDto> finalList = this.collectAndClassifyEmployeePost(list, employeeNo2DtoMap, postCode2DtoMap);
        this.collectPostInfoAndBindOrgName(postCode2DtoMap, (IConvert<PostBase, PostEo>)((IConvert)(post, postEo) -> post.setName(postEo.getName())));
        this.bindEmployeeInfo(employeeNo2DtoMap, (IConvert<EmployeeBaseDto, EmployeeEo>)((IConvert)(employeePostPagerRespDto, employeeEo) -> {
            EmployeePostPagerRespDto employee = (EmployeePostPagerRespDto)employeePostPagerRespDto;
            employee.setNickName(employeeEo.getNickName());
            employee.setPhone(employeeEo.getPhoneNum());
            employee.setName(employeeEo.getName());
        }));
        return finalList;
    }

    private List<EmployeePostPagerRespDto> collectAndClassifyEmployeePost(List<EmployeePostEo> list, Map<String, List<EmployeeBaseDto>> employeeNo2DtoMap, Map<String, List<PostBase>> postCode2DtoMap) {
        LinkedList finalList = Lists.newLinkedList();
        list.forEach(rEmployeePostEo -> {
            List employeeBaseDtoList = (List)employeeNo2DtoMap.get(rEmployeePostEo.getEmployeeNo());
            if (CollectionUtils.isEmpty((Collection)employeeBaseDtoList)) {
                EmployeePostPagerRespDto employeePostPagerRespDto = new EmployeePostPagerRespDto();
                employeePostPagerRespDto.setNo(rEmployeePostEo.getEmployeeNo());
                employeePostPagerRespDto.setPosts((List)Lists.newLinkedList());
                MyMapUtils.appendElement2ListMap((Map)employeeNo2DtoMap, (Object)rEmployeePostEo.getEmployeeNo(), (Object)employeePostPagerRespDto);
                this.appendPost2Employee(postCode2DtoMap, (EmployeePostEo)rEmployeePostEo, employeePostPagerRespDto);
                finalList.add(employeePostPagerRespDto);
            } else {
                employeeBaseDtoList.forEach(employeeBaseDto -> {
                    EmployeePostPagerRespDto employeePostPagerRespDto = (EmployeePostPagerRespDto)employeeBaseDto;
                    this.appendPost2Employee(postCode2DtoMap, (EmployeePostEo)rEmployeePostEo, employeePostPagerRespDto);
                });
            }
        });
        return finalList;
    }

    private void appendPost2Employee(Map<String, List<PostBase>> postCode2DtoMap, EmployeePostEo rEmployeePostEo, EmployeePostPagerRespDto employeePostPagerRespDto) {
        PostBase post = new PostBase();
        post.setCode(rEmployeePostEo.getPostCode());
        MyMapUtils.appendElement2ListMap(postCode2DtoMap, (Object)post.getCode(), (Object)post);
        employeePostPagerRespDto.getPosts().add(post);
    }

    private void collectPostInfoAndBindOrgName(final Map<String, List<PostBase>> postCode2DtoMap, final IConvert<PostBase, PostEo> convert) {
        new IDataCollectionAndBind<String, PostBase, PostEo, OrganizationEo>(){

            @Override
            public List<PostEo> search() {
                PostEo postSelectParam = new PostEo();
                postSelectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("code", postCode2DtoMap.keySet()).get());
                return EmployeePostServiceImpl.this.postDas.select((BaseEo)postSelectParam);
            }

            @Override
            public List<PostBase> collect(List<PostEo> postEoList, Map<String, List<PostBase>> map) {
                ArrayList<PostBase> list = new ArrayList<PostBase>();
                postCode2DtoMap.values().forEach(list::addAll);
                postEoList.forEach(postEo -> {
                    List posts = (List)postCode2DtoMap.get(postEo.getCode());
                    if (CollectionUtils.isNotEmpty((Collection)posts)) {
                        posts.forEach(post -> {
                            convert.convert(post, postEo);
                            MyMapUtils.appendElement2ListMap((Map)map, (Object)postEo.getOrgCode(), (Object)post);
                        });
                    }
                });
                return list;
            }

            @Override
            public String getKey(OrganizationEo source) {
                return source.getCode();
            }

            @Override
            public void bind(PostBase target, OrganizationEo source) {
                target.setOrgName(source.getName());
            }
        }.process(new OrganizationEo(), "code", this.organizationDas);
    }

    @Override
    public List<PostEmployeePagerRespDto> postEmployeeList(PostEmployeeQueryReqDto postEmployeeQueryReqDto) {
        if (postEmployeeQueryReqDto == null) {
            return Collections.emptyList();
        }
        EmployeePostQueryVo employeePostQueryVo = new EmployeePostQueryVo();
        BeanUtils.copyProperties((Object)postEmployeeQueryReqDto, (Object)employeePostQueryVo);
        List list = this.employeePostDas.list(employeePostQueryVo);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        HashMap postCode2DtoMap = Maps.newHashMap();
        HashMap no2DtoMap = Maps.newHashMap();
        List<PostEmployeePagerRespDto> finalList = this.collectAndClassifyPostEmployee(list, postCode2DtoMap, no2DtoMap);
        this.collectPostInfoAndBindOrgName(postCode2DtoMap, (IConvert<PostBase, PostEo>)((IConvert)(post, postEo) -> post.setName(postEo.getName())));
        this.bindEmployeeInfo(no2DtoMap, (IConvert<EmployeeBaseDto, EmployeeEo>)((IConvert)(employeeBaseDto, employeeEo) -> employeeBaseDto.setName(employeeEo.getName())));
        return finalList;
    }

    private List<PostEmployeePagerRespDto> collectAndClassifyPostEmployee(List<EmployeePostEo> list, Map<String, List<PostBase>> postCode2DtoMap, Map<String, List<EmployeeBaseDto>> no2DtoMap) {
        LinkedList finalList = Lists.newLinkedList();
        list.forEach(rEmployeePostEo -> {
            List postBaseList = (List)postCode2DtoMap.get(rEmployeePostEo.getPostCode());
            if (CollectionUtils.isEmpty((Collection)postBaseList)) {
                PostEmployeePagerRespDto postEmployeePagerRespDto = new PostEmployeePagerRespDto();
                postEmployeePagerRespDto.setCode(rEmployeePostEo.getPostCode());
                postEmployeePagerRespDto.setEmployees((List)Lists.newLinkedList());
                MyMapUtils.appendElement2ListMap((Map)postCode2DtoMap, (Object)rEmployeePostEo.getPostCode(), (Object)postEmployeePagerRespDto);
                this.appendEmployee2Post(no2DtoMap, (EmployeePostEo)rEmployeePostEo, postEmployeePagerRespDto);
                finalList.add(postEmployeePagerRespDto);
            } else {
                postBaseList.forEach(postBase -> {
                    PostEmployeePagerRespDto postEmployeePagerRespDto = (PostEmployeePagerRespDto)postBase;
                    this.appendEmployee2Post(no2DtoMap, (EmployeePostEo)rEmployeePostEo, postEmployeePagerRespDto);
                });
            }
        });
        return finalList;
    }

    private void appendEmployee2Post(Map<String, List<EmployeeBaseDto>> no2DtoMap, EmployeePostEo rEmployeePostEo, PostEmployeePagerRespDto postEmployeePagerRespDto) {
        EmployeeBaseDto employee = new EmployeeBaseDto();
        employee.setNo(rEmployeePostEo.getEmployeeNo());
        MyMapUtils.appendElement2ListMap(no2DtoMap, (Object)employee.getNo(), (Object)employee);
        postEmployeePagerRespDto.getEmployees().add(employee);
    }

    private void bindEmployeeInfo(Map<String, List<EmployeeBaseDto>> no2DtoMap, IConvert<EmployeeBaseDto, EmployeeEo> convert) {
        EmployeeEo employeeSelectParam = new EmployeeEo();
        employeeSelectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("employee_no", no2DtoMap.keySet()).get());
        List employeeEoList = this.employeeDas.select((BaseEo)employeeSelectParam);
        if (CollectionUtils.isNotEmpty((Collection)employeeEoList)) {
            employeeEoList.forEach(employeeEo -> {
                List employees = (List)no2DtoMap.get(employeeEo.getEmployeeNo());
                if (CollectionUtils.isNotEmpty((Collection)employees)) {
                    employees.forEach(employee -> convert.convert(employee, employeeEo));
                }
            });
        }
    }
}

