/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.tree.TreeBuilder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.constants.OrgUserConstants;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgGroupAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgGroupModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgGroupQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgSortReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvTreeRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgGroupRespDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrgGroupService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.conf.param.IOrgModelParam;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeOrgDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrgGroupDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrgOrgDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrgPostDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeOrgEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrgGroupEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrgOrgEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrgPostEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class OrgGroupServiceImpl
implements IOrgGroupService {
    @Resource
    private OrgGroupDas orgGroupDas;
    @Resource
    private OrganizationDas organizationDas;
    @Resource
    private OrgPostDas orgPostDas;
    @Resource
    private EmployeeOrgDas employeeOrgDas;
    @Resource
    private OrgOrgDas orgOrgDas;
    @CubeResource
    private IOrgModelParam orgModelParam;

    private Long getTenantId(Long tenantId) {
        return tenantId == null ? ServiceContext.getContext().getRequestTenantId() : tenantId;
    }

    private Long getInstanceId(Long instanceId) {
        return instanceId == null ? ServiceContext.getContext().getRequestInstanceId() : instanceId;
    }

    private boolean queryOrgModel() {
        Boolean orgModel = (Boolean)this.orgModelParam.getValue();
        return orgModel == null || orgModel != false;
    }

    @Override
    public Long addOrgGroup(OrgGroupAddReqDto reqDto) {
        reqDto.setTenantId(this.getTenantId(reqDto.getTenantId()));
        String funcTypeCode = reqDto.getFuncTypeCode();
        if (!StringUtils.hasText((String)funcTypeCode)) {
            throw new BizException("\u7ec4\u7ec7\u804c\u80fd\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrgGroupEo record = new OrgGroupEo();
        record.setTenantId(reqDto.getTenantId());
        record.setFuncTypeCode(funcTypeCode);
        if (this.orgGroupDas.count((BaseEo)record) > 0) {
            throw new BizException("500", "\u5df2\u5b58\u5728\u8be5\u7ec4\u7ec7\u804c\u80fd\u7c7b\u578b\u7684\u7ec4\u7ec7");
        }
        record.setFuncTypeCode(null);
        record.setCode(reqDto.getCode());
        if (this.orgGroupDas.count((BaseEo)record) > 0) {
            throw new BizException("500", "\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728");
        }
        OrganizationEo orgEo = this.organizationDas.queryByCode(reqDto.getCode(), reqDto.getTenantId());
        if (orgEo != null) {
            throw new BizException("500", "\u8f93\u5165\u7f16\u7801\u548c\u7ec4\u7ec7\u5355\u5143\u7f16\u7801[code=" + reqDto.getCode() + "]\u91cd\u590d,\u8bf7\u91cd\u8f93");
        }
        OrgGroupEo orgGroupEo = new OrgGroupEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)orgGroupEo);
        if (this.queryOrgModel()) {
            orgGroupEo.setFuncTypeCode("human_resource");
        }
        this.orgGroupDas.insert((BaseEo)orgGroupEo);
        return orgGroupEo.getId();
    }

    @Override
    public void modifyOrgGroup(OrgGroupModifyReqDto reqDto) {
        reqDto.setTenantId(this.getTenantId(reqDto.getTenantId()));
        Long id = reqDto.getId();
        String funcTypeCode = reqDto.getFuncTypeCode();
        if (StringUtils.hasText((String)funcTypeCode)) {
            OrgGroupEo record = new OrgGroupEo();
            record.setTenantId(reqDto.getTenantId());
            record.setFuncTypeCode(funcTypeCode);
            record.setSqlFilters(Collections.singletonList(SqlFilter.ne((String)"id", (Object)id)));
            if (this.orgGroupDas.count((BaseEo)record) > 0) {
                throw new BizException("500", "\u5df2\u5b58\u5728\u8be5\u7ec4\u7ec7\u804c\u80fd\u7c7b\u578b\u7684\u7ec4\u7ec7");
            }
        }
        OrgGroupEo orgGroupEo = new OrgGroupEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)orgGroupEo);
        orgGroupEo.setTenantId(null);
        orgGroupEo.setCode(null);
        if (!StringUtils.isEmpty((Object)reqDto.getFuncTypeCode()) && !"human_resource".equals(reqDto.getFuncTypeCode()) && this.queryOrgModel()) {
            orgGroupEo.setFuncTypeCode("human_resource");
        }
        this.orgGroupDas.updateSelective((BaseEo)orgGroupEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrgGroup(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            Long idLong = Long.valueOf(id.trim());
            OrgGroupEo orgGroupEo = (OrgGroupEo)this.orgGroupDas.selectByPrimaryKey(idLong);
            if (orgGroupEo == null) continue;
            Long tenantId = orgGroupEo.getTenantId();
            Long orgGroupId = orgGroupEo.getId();
            OrgOrgEo orgOrgEo = new OrgOrgEo();
            orgOrgEo.setTenantId(orgGroupEo.getTenantId());
            orgOrgEo.setOrgGroupId(orgGroupId);
            List orgOrgEos = this.orgOrgDas.selectList((BaseEo)orgOrgEo, Integer.valueOf(1), Integer.valueOf(100));
            if (orgOrgEos.size() > 0) {
                throw new BizException("500", "\u8be5\u7ec4\u7ec7\u5df2\u5173\u8054\u7ec4\u7ec7\u5355\u5143[orgIds=" + orgOrgEos.stream().map(e -> e.getId().toString()).collect(Collectors.joining(",")) + "],\u8bf7\u5148\u5220\u9664\u7ec4\u7ec7\u5355\u5143");
            }
            OrgPostEo orgPostEo = new OrgPostEo();
            orgPostEo.setTenantId(tenantId);
            orgPostEo.setOrgGroupId(orgGroupId);
            List orgPostEos = this.orgPostDas.selectList((BaseEo)orgPostEo, Integer.valueOf(1), Integer.valueOf(100));
            if (orgPostEos.size() > 0) {
                throw new BizException("500", "\u8be5\u7ec4\u7ec7\u5df2\u5173\u8054\u5c97\u4f4d[postIds=" + orgPostEos.stream().map(e -> e.getPostId().toString()).collect(Collectors.joining(",")) + "],\u8bf7\u5148\u5220\u9664\u5c97\u4f4d");
            }
            EmployeeOrgEo employeeOrgEo = new EmployeeOrgEo();
            employeeOrgEo.setTenantId(tenantId);
            employeeOrgEo.setOrgGroupId(orgGroupId);
            List employeeOrgEos = this.employeeOrgDas.selectList((BaseEo)employeeOrgEo, Integer.valueOf(1), Integer.valueOf(100));
            if (employeeOrgEos.size() > 0) {
                throw new BizException("500", "\u8be5\u7ec4\u7ec7\u5df2\u5173\u8054\u5c97\u4f4d[employeeNos=" + employeeOrgEos.stream().map(e -> e.getEmployeeId().toString()).collect(Collectors.joining(",")) + "],\u8bf7\u5148\u5220\u9664\u5458\u5de5");
            }
            this.orgGroupDas.logicDeleteById(idLong);
        }
    }

    @Override
    public void updateSortNo(OrgSortReqDto reqDto) {
        int i;
        String type = reqDto.getType();
        Long id = reqDto.getId();
        List ids = reqDto.getIds();
        AssertUtil.isTrue(("UP".equalsIgnoreCase(type) || "DOWN".equalsIgnoreCase(type) ? 1 : 0) != 0, (String)"\u7c7b\u578b\u53ea\u80fd\u4e3aUP\u6216DOWN");
        AssertUtil.isTrue((id != null ? 1 : 0) != 0, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((!CollectionUtils.isEmpty((Collection)ids) && ids.size() > 1 ? 1 : 0) != 0, (String)"ids\u7684\u5927\u5c0f\u5fc5\u987b\u5927\u4e8e1");
        AssertUtil.isTrue((boolean)ids.contains(id), (String)"\u6570\u636e\u4e0d\u6b63\u786e,ids\u6ca1\u5305\u542bid");
        OrganizationEo record = new OrganizationEo();
        record.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"id", (Object)ids)));
        List select = this.organizationDas.select((BaseEo)record, Integer.valueOf(1), Integer.valueOf(1000));
        if (select.size() < ids.size()) {
            List dbSelect = select.stream().map(BaseEo::getId).collect(Collectors.toList());
            ids.removeAll(dbSelect);
            throw new BizException("500", "\u90e8\u5206\u7ec4\u7ec7\u5355\u5143\u4e0d\u5b58\u5728,id[" + StringUtils.collectionToCommaDelimitedString((Collection)ids) + "]");
        }
        Map<Long, OrganizationEo> orgMap = select.stream().collect(Collectors.toMap(BaseEo::getId, k -> k));
        for (i = 0; i < ids.size(); ++i) {
            if (!id.equals(ids.get(i))) continue;
            if ("UP".equalsIgnoreCase(type)) {
                if (i == 0) break;
                ids.set(i, ids.get(i - 1));
                ids.set(i - 1, id);
                break;
            }
            if (!"DOWN".equalsIgnoreCase(type) || i == ids.size() - 1) break;
            ids.set(i, ids.get(i + 1));
            ids.set(i + 1, id);
            break;
        }
        for (i = 0; i < ids.size(); ++i) {
            Long currentId = (Long)ids.get(i);
            OrganizationEo organizationEo = orgMap.get(currentId);
            if (new Integer(i).equals(organizationEo.getSortNO())) continue;
            organizationEo = new OrganizationEo();
            organizationEo.setId(currentId);
            organizationEo.setSortNO(Integer.valueOf(i));
            this.organizationDas.updateSelective((BaseEo)organizationEo);
        }
    }

    @Override
    public OrgGroupRespDto queryById(Long id) {
        OrgGroupEo orgGroupEo = (OrgGroupEo)this.orgGroupDas.selectByPrimaryKey(id);
        if (orgGroupEo == null) {
            return null;
        }
        OrgGroupRespDto orgGroupRespDto = new OrgGroupRespDto();
        DtoHelper.eo2Dto((BaseEo)orgGroupEo, (BaseVo)orgGroupRespDto);
        return orgGroupRespDto;
    }

    @Override
    public PageInfo<OrgGroupRespDto> queryByPage(OrgGroupQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        String name;
        reqDto.setTenantId(this.getTenantId(reqDto.getTenantId()));
        OrgGroupEo orgGroupEo = new OrgGroupEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)orgGroupEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        String code = reqDto.getCode();
        if (StringUtils.hasText((String)code)) {
            orgGroupEo.setCode(null);
            sqlFilters.add(SqlFilter.like((String)"code", (Object)("%" + code.trim() + "%")));
        }
        if (StringUtils.hasText((String)(name = reqDto.getName()))) {
            orgGroupEo.setName(null);
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + name.trim() + "%")));
        }
        orgGroupEo.setSqlFilters(sqlFilters);
        if (this.queryOrgModel()) {
            orgGroupEo.setFuncTypeCode("human_resource");
        }
        PageInfo eoPageInfo = this.orgGroupDas.selectPage((BaseEo)orgGroupEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OrgGroupRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<OrgAdvTreeRespDto> queryOrgTree(Long orgGroupId) {
        OrgGroupEo orgGroupEo = (OrgGroupEo)this.orgGroupDas.selectByPrimaryKey(orgGroupId);
        if (orgGroupEo == null) {
            throw new BizException("500", "\u7ec4\u7ec7\u4e0d\u5b58\u5728[id=" + orgGroupId + "]");
        }
        Long tenantId = orgGroupEo.getTenantId();
        HashMap<Long, OrgAdvTreeRespDto> allOrgMap = new HashMap<Long, OrgAdvTreeRespDto>();
        OrgAdvTreeRespDto bizRootOrg = this.findAllOrg(tenantId, allOrgMap);
        List bizOrgEos = this.organizationDas.queryBizOrg(orgGroupEo.getFuncTypeCode(), tenantId);
        ArrayList<OrgAdvTreeRespDto> bizOrgDtos = new ArrayList<OrgAdvTreeRespDto>();
        CubeBeanUtils.copyCollection(bizOrgDtos, (Collection)bizOrgEos, OrgAdvTreeRespDto.class);
        Map<Long, OrgAdvTreeRespDto> bizOrgDtoMap = bizOrgDtos.stream().collect(Collectors.toMap(OrgAdvTreeRespDto::getId, Function.identity(), (k1, k2) -> k1));
        this.handleOrg(bizOrgDtos, bizOrgDtoMap, allOrgMap, bizRootOrg);
        List<OrgAdvTreeRespDto> result = this.buildOrgTree(bizOrgDtos);
        this.handleAdditionOrgs(orgGroupEo, bizOrgDtoMap);
        return result;
    }

    private void handleAdditionOrgs(OrgGroupEo orgGroup, Map<Long, OrgAdvTreeRespDto> bizOrgDtoMap) {
        Long orgGroupId = orgGroup.getId();
        List additionOrgEos = this.organizationDas.queryAdditionOrgs(orgGroupId, orgGroup.getTenantId());
        ArrayList additionOrgDtos = new ArrayList();
        CubeBeanUtils.copyCollection(additionOrgDtos, (Collection)additionOrgEos, OrgAdvTreeRespDto.class);
        Map<Long, OrgAdvTreeRespDto> additionVirtualOrgMap = additionOrgDtos.stream().filter(e -> "3".equals(e.getType())).collect(Collectors.toMap(OrgAdvTreeRespDto::getId, e -> e));
        for (OrgAdvTreeRespDto dto : additionOrgDtos) {
            Integer sortNO;
            ArrayList<OrgAdvTreeRespDto> children;
            OrgAdvTreeRespDto parent = null;
            if ("3".equals(dto.getType())) {
                Long parentId = dto.getParentId();
                parent = bizOrgDtoMap.get(parentId);
                if (parent == null) {
                    parent = additionVirtualOrgMap.get(parentId);
                }
                if (parent == null) {
                    throw new BizException("500", "\u865a\u62df\u5355\u5143\u6839\u636eparentId\u627e\u4e0d\u5230\u7236\u7ea7");
                }
            } else {
                if (!"2".equals(dto.getType())) continue;
                parent = additionVirtualOrgMap.get(dto.getParentId());
                if ((dto = bizOrgDtoMap.get(dto.getId())) == null) {
                    throw new BizException("500", "\u6839\u636eparentId\u627e\u4e0d\u5230\u865a\u62df\u5355\u5143\u5173\u8054\u7684\u4e1a\u52a1\u5355\u5143");
                }
            }
            if ((children = parent.getChildren()) == null) {
                children = new ArrayList<OrgAdvTreeRespDto>();
                parent.setChildren(children);
            }
            if ((sortNO = dto.getSortNO()) == null || sortNO < 0 || sortNO > children.size()) {
                sortNO = children.size();
            }
            children.add(sortNO, dto);
        }
    }

    private List<OrgAdvTreeRespDto> buildOrgTree(List<OrgAdvTreeRespDto> bizOrgDtos) {
        TreeBuilder treeBuilder = new TreeBuilder();
        List results = treeBuilder.buildByParentKey(bizOrgDtos, Boolean.valueOf(false), Comparator.comparing(OrgAdvTreeRespDto::getSortNO, Comparator.nullsLast(Integer::compareTo)));
        if (CollectionUtils.isEmpty((Collection)results)) {
            return null;
        }
        return results;
    }

    private OrgAdvTreeRespDto findAllOrg(Long tenantId, Map<Long, OrgAdvTreeRespDto> allOrgMap) {
        List allOrg = this.organizationDas.queryAllForTree(tenantId);
        OrgAdvTreeRespDto bizRootOrg = null;
        for (OrganizationEo e : allOrg) {
            OrgAdvTreeRespDto dto = new OrgAdvTreeRespDto();
            CubeBeanUtils.copyProperties((Object)dto, (Object)e, (String[])new String[0]);
            if (OrgUserConstants.ORG_ROOT_ID.equals(e.getParentId()) && "2".equals(e.getType())) {
                bizRootOrg = dto;
            }
            allOrgMap.put(e.getId(), dto);
        }
        if (bizRootOrg == null) {
            throw new BizException("500", "\u4e1a\u52a1\u5355\u5143\u6811\u6839\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        return bizRootOrg;
    }

    private List<OrgAdvTreeRespDto> handleOrg(List<OrgAdvTreeRespDto> bizOrgDtos, Map<Long, OrgAdvTreeRespDto> bizOrgDtoMap, Map<Long, OrgAdvTreeRespDto> allOrgMap, OrgAdvTreeRespDto bizRootOrg) {
        Long bizRootOrgId = bizRootOrg.getId();
        block0: for (OrgAdvTreeRespDto e : bizOrgDtos) {
            Long parentId = e.getParentId();
            if (OrgUserConstants.ORG_ROOT_ID.equals(e.getParentId())) continue;
            int i = 0;
            do {
                OrgAdvTreeRespDto parent = allOrgMap.get(parentId);
                if (bizRootOrgId.equals(parentId)) continue block0;
                if (parent != null && bizOrgDtoMap.get(parent.getId()) != null) {
                    e.setParentId(parentId);
                    continue block0;
                }
                if (parent == null) {
                    throw new BizException("500", "\u627e\u4e0d\u5230\u7236\u4e1a\u52a1\u5355\u5143\u8282\u70b9[" + e.getTenantId() + "," + parentId + "]");
                }
                parentId = parent.getParentId();
            } while (i++ != 12);
            throw new BizException("500", "\u627e\u4e0d\u5230\u7236\u4e1a\u52a1\u5355\u5143\u8282\u70b9[" + e.getTenantId() + "," + e.getCode() + "]");
        }
        return bizOrgDtos;
    }

    @Override
    public List<OrgAdvTreeRespDto> bizOrgTreeByVirtual(Long orgGroupId, Long virtualOrgId) {
        OrganizationEo virtualOrg = (OrganizationEo)this.organizationDas.selectByPrimaryKey(virtualOrgId);
        if (!"3".equals(virtualOrg.getType())) {
            throw new BizException("500", "\u5f53\u524d\u865a\u62df\u5355\u5143\u4e0d\u5b58\u5728[id=" + virtualOrgId + "]");
        }
        OrgGroupEo orgGroupEo = (OrgGroupEo)this.orgGroupDas.selectByPrimaryKey(orgGroupId);
        if (orgGroupEo == null) {
            throw new BizException("500", "\u7ec4\u7ec7\u4e0d\u5b58\u5728[id=" + orgGroupId + "]");
        }
        Long tenantId = orgGroupEo.getTenantId();
        HashMap<Long, OrgAdvTreeRespDto> allOrgMap = new HashMap<Long, OrgAdvTreeRespDto>();
        OrgAdvTreeRespDto bizRootOrg = this.findAllOrg(tenantId, allOrgMap);
        List bizOrgEos = this.organizationDas.queryBizOrg(orgGroupEo.getFuncTypeCode(), tenantId);
        ArrayList<OrgAdvTreeRespDto> bizOrgDtos = new ArrayList<OrgAdvTreeRespDto>();
        CubeBeanUtils.copyCollection(bizOrgDtos, (Collection)bizOrgEos, OrgAdvTreeRespDto.class);
        Map<Long, OrgAdvTreeRespDto> bizOrgDtoMap = bizOrgDtos.stream().collect(Collectors.toMap(OrgAdvTreeRespDto::getId, Function.identity(), (k1, k2) -> k1));
        this.handleOrg(bizOrgDtos, bizOrgDtoMap, allOrgMap, bizRootOrg);
        List<OrgAdvTreeRespDto> rootOrgTrees = this.buildOrgTree(bizOrgDtos);
        Long bizParentId = this.findParentBizOrg(orgGroupEo.getId(), tenantId, virtualOrg.getParentId());
        if (bizParentId != null) {
            OrgAdvTreeRespDto rootOrgTree = bizOrgDtoMap.get(bizParentId);
            return rootOrgTree == null ? null : rootOrgTree.getChildren();
        }
        return rootOrgTrees;
    }

    private Long findParentBizOrg(Long orgGroupId, Long tenantId, Long parentId) {
        for (int i = 0; i < 12; ++i) {
            OrganizationEo current;
            OrganizationEo record = new OrganizationEo();
            record.setTenantId(tenantId);
            record.setId(parentId);
            List select = this.organizationDas.select((BaseEo)record, Integer.valueOf(1), Integer.valueOf(1));
            if (!CollectionUtils.isEmpty((Collection)select)) {
                current = (OrganizationEo)select.get(0);
                if ("2".equals(current.getType())) {
                    parentId = current.getId();
                    break;
                }
            } else {
                throw new BizException("500", "\u865a\u62df\u5355\u5143\u627e\u7236\u7ea7\u4e1a\u52a1\u5355\u5143\u51fa\u9519[tenantId=" + tenantId + "parentId=" + parentId + "]");
            }
            parentId = current.getParentId();
        }
        return parentId;
    }

    @Override
    public List<OrgAdvTreeRespDto> queryHumanResourceTree(Long tenantId) {
        tenantId = this.getTenantId(tenantId);
        OrgGroupEo record = new OrgGroupEo();
        record.setTenantId(tenantId);
        record.setFuncTypeCode("human_resource");
        List humanResourceList = this.orgGroupDas.select((BaseEo)record, Integer.valueOf(1), Integer.valueOf(20));
        if (CollectionUtils.isEmpty((Collection)humanResourceList)) {
            return null;
        }
        ArrayList<OrgAdvTreeRespDto> result = new ArrayList<OrgAdvTreeRespDto>();
        HashMap<Long, OrgAdvTreeRespDto> allOrgMap = new HashMap<Long, OrgAdvTreeRespDto>();
        OrgAdvTreeRespDto bizRootOrg = this.findAllOrg(tenantId, allOrgMap);
        List bizOrgEos = this.organizationDas.queryBizOrg("human_resource", tenantId);
        for (OrgGroupEo orgGroupEo : humanResourceList) {
            ArrayList<OrgAdvTreeRespDto> bizOrgDtos = new ArrayList<OrgAdvTreeRespDto>();
            CubeBeanUtils.copyCollection(bizOrgDtos, (Collection)bizOrgEos, OrgAdvTreeRespDto.class);
            Map<Long, OrgAdvTreeRespDto> bizOrgDtoMap = bizOrgDtos.stream().collect(Collectors.toMap(OrgAdvTreeRespDto::getId, Function.identity(), (k1, k2) -> k1));
            this.handleOrg(bizOrgDtos, bizOrgDtoMap, allOrgMap, bizRootOrg);
            List<OrgAdvTreeRespDto> tree = this.buildOrgTree(bizOrgDtos);
            this.handleAdditionOrgs(orgGroupEo, bizOrgDtoMap);
            if (CollectionUtils.isEmpty(tree)) continue;
            result.addAll(tree);
        }
        return result;
    }

    @Override
    public Long queryDefaultHumanOrgGroup(Long tenantId) {
        if (tenantId == null) {
            return null;
        }
        OrgGroupEo queryEo = new OrgGroupEo();
        queryEo.setTenantId(tenantId);
        queryEo.setFuncTypeCode("human_resource");
        List results = this.orgGroupDas.select((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(1));
        return CollectionUtils.isEmpty((Collection)results) ? null : ((OrgGroupEo)results.get(0)).getId();
    }
}

