/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgThirdReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ThridOrganizationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrgThirdService;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrgThirdDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrgThirdEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class OrgThirdServiceImpl
implements IOrgThirdService {
    @Resource
    private OrgThirdDas orgThirdDas;

    @Override
    public Long addOrgThird(OrgThirdReqDto addReqDto) {
        Assert.hasText((String)addReqDto.getThirdOrgId(), (String)"\u7b2c\u4e09\u65b9\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.paramCheck(addReqDto.getOrgId(), addReqDto.getType());
        OrgThirdEo orgThirdEo = new OrgThirdEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)orgThirdEo);
        this.orgThirdDas.insert((BaseEo)orgThirdEo);
        return orgThirdEo.getId();
    }

    @Override
    public void removeOrgThird(Long orgId, Integer type) {
        this.paramCheck(orgId, type);
        OrgThirdEo orgThirdEo = new OrgThirdEo();
        orgThirdEo.setOrgId(orgId);
        orgThirdEo.setType(type);
        this.orgThirdDas.delete((BaseEo)orgThirdEo);
    }

    private void paramCheck(Long orgId, Integer type) {
        Assert.notNull((Object)orgId, (String)"\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)type, (String)"\u7b2c\u4e09\u65b9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    @Override
    public OrgThirdReqDto queryById(Long orgId, Integer type) {
        this.paramCheck(orgId, type);
        OrgThirdEo orgThirdEo = new OrgThirdEo();
        orgThirdEo.setOrgId(orgId);
        orgThirdEo.setType(type);
        List dbEoList = this.orgThirdDas.selectList((BaseEo)orgThirdEo, Integer.valueOf(1), Integer.valueOf(1));
        if (CollectionUtil.isEmpty((Collection)dbEoList)) {
            return null;
        }
        OrgThirdEo dbEo = (OrgThirdEo)dbEoList.get(0);
        OrgThirdReqDto db = new OrgThirdReqDto();
        DtoHelper.eo2Dto((BaseEo)dbEo, (BaseVo)db);
        return db;
    }

    @Override
    public List<OrgThirdEo> queryByIdList(List<Long> orgIds, Integer type) {
        if (CollectionUtil.isEmpty(orgIds)) {
            return null;
        }
        OrgThirdEo orgThirdEo = this.getOrgThirdEo(orgIds, type);
        return this.orgThirdDas.select((BaseEo)orgThirdEo);
    }

    private OrgThirdEo getOrgThirdEo(List<Long> orgIds, Integer type) {
        OrgThirdEo orgThirdEo = new OrgThirdEo();
        orgThirdEo.setType(type);
        LinkedList<SqlFilter> sqlFilters = new LinkedList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"org_id", orgIds));
        orgThirdEo.setSqlFilters(sqlFilters);
        return orgThirdEo;
    }

    @Override
    public void deleteByIdList(List<Long> orgIds, Integer type) {
        if (CollectionUtil.isEmpty(orgIds)) {
            return;
        }
        OrgThirdEo orgThirdEo = this.getOrgThirdEo(orgIds, type);
        this.orgThirdDas.delete((BaseEo)orgThirdEo);
    }

    @Override
    public List<OrgThirdEo> queryNotInIdList(List<Long> orgIds, Integer type) {
        if (CollectionUtil.isEmpty(orgIds)) {
            return null;
        }
        return this.orgThirdDas.queryNotInIdList(orgIds, type);
    }

    @Override
    public List<OrgThirdEo> queryByThirdIdList(List<String> thirdOrgIds, Integer type) {
        if (CollectionUtil.isEmpty(thirdOrgIds)) {
            return null;
        }
        return this.orgThirdDas.queryByThirdIdList(thirdOrgIds, type);
    }

    @Override
    public List<OrgAdvDetailRespDto> queryOrgDetailByThirdCode(List<String> thirdCodeList) {
        ArrayList orgAdvDetailRespDtoList = Lists.newArrayList();
        if (CollectionUtil.isEmpty(thirdCodeList) || StringUtils.isEmpty((Object)thirdCodeList.get(0))) {
            return orgAdvDetailRespDtoList;
        }
        List thirdOrgVoList = this.orgThirdDas.queryOrgDetailByThirdCode(thirdCodeList, Integer.valueOf(1));
        if (CollectionUtil.isEmpty((Collection)thirdOrgVoList)) {
            return orgAdvDetailRespDtoList;
        }
        CubeBeanUtils.copyCollection((Collection)orgAdvDetailRespDtoList, (Collection)thirdOrgVoList, OrgAdvDetailRespDto.class);
        return orgAdvDetailRespDtoList;
    }

    @Override
    public List<OrgAdvDetailRespDto> queryOrgDetailByOrgCode(List<String> orgCodeList) {
        ArrayList orgAdvDetailRespDtoList = Lists.newArrayList();
        if (CollectionUtil.isEmpty(orgCodeList) || StringUtils.isEmpty((Object)orgCodeList.get(0))) {
            return orgAdvDetailRespDtoList;
        }
        List thirdOrgVoList = this.orgThirdDas.queryOrgDetailByThirdCode(orgCodeList, Integer.valueOf(2));
        if (CollectionUtil.isEmpty((Collection)thirdOrgVoList)) {
            return orgAdvDetailRespDtoList;
        }
        CubeBeanUtils.copyCollection((Collection)orgAdvDetailRespDtoList, (Collection)thirdOrgVoList, OrgAdvDetailRespDto.class);
        return orgAdvDetailRespDtoList;
    }

    @Override
    public PageInfo<OrgAdvDetailRespDto> queryOrgList(ThridOrganizationReqDto thridOrganizationReqDto) {
        PageHelper.startPage((int)thridOrganizationReqDto.getPageNum(), (int)3000);
        PageInfo pageInfo = new PageInfo();
        PageInfo pageInfo1 = new PageInfo();
        List thirdOrgVoList = this.orgThirdDas.queryOrgList(thridOrganizationReqDto);
        if (CollectionUtil.isEmpty((Collection)thirdOrgVoList)) {
            return pageInfo;
        }
        pageInfo1.setList(thirdOrgVoList);
        BeanUtils.copyProperties((Object)pageInfo1, (Object)pageInfo);
        ArrayList orgAdvDetailRespDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)orgAdvDetailRespDtoList, (Collection)thirdOrgVoList, OrgAdvDetailRespDto.class);
        pageInfo.setList((List)orgAdvDetailRespDtoList);
        return pageInfo;
    }
}

