/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.datalimit.aop.DataLimitAspect;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.constant.SortEnum;
import com.dtyunxi.yundt.cube.center.user.api.constants.OrgUserConstants;
import com.dtyunxi.yundt.cube.center.user.api.constants.RedisKeyConstants;
import com.dtyunxi.yundt.cube.center.user.api.dto.EmployeeDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrgStructureTreeRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAndOrgInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RelateEmployeesOrgReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.SortReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.enums.OrgTypeEnum;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.BizExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrgGroupService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrganizationEventService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrganizationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserOrganizationService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.util.QueryUtil;
import com.dtyunxi.yundt.cube.center.user.biz.utils.DataLimitCacheUtil;
import com.dtyunxi.yundt.cube.center.user.biz.utils.PageInfoUtil;
import com.dtyunxi.yundt.cube.center.user.conf.ext.IOrgTypeValidationExt;
import com.dtyunxi.yundt.cube.center.user.conf.ext.IRemoveOrgValidationExt;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeOrgDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeOrgEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationInfoEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdEmployeeOrgEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdOrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdOrganizationInfoEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class OrganizationServiceImpl
implements IOrganizationService {
    private static final Logger logger = LoggerFactory.getLogger(OrganizationServiceImpl.class);
    @Resource
    private AppInstanceDas appInstanceDas;
    @Resource
    private EmployeeDas employeeDas;
    @Resource
    private OrganizationDas organizationDas;
    @Resource
    private OrganizationInfoDas organizationInfoDas;
    @Resource
    private EmployeeOrgDas employeeOrganizationRelationDas;
    @Resource
    private IContext iContext;
    @Resource
    private IOrganizationEventService organizationEventService;
    @Resource
    private IOrgTypeValidationExt orgTypeValidationExt;
    @Resource
    private IRemoveOrgValidationExt removeOrgValidationExt;
    @Resource
    private IContext context;
    @Resource
    private IOrgGroupService orgGroupService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private DataLimitCacheUtil dataLimitCacheUtil;
    @Resource
    private IUserOrganizationService userOrganizationService;

    @Override
    public Long add(OrganizationDto organizationDto) {
        this.verifyOrgCode(organizationDto.getCode(), null, organizationDto.getTenantId() == null ? this.iContext.tenantId() : organizationDto.getTenantId());
        this.orgTypeValidationExt.execute(organizationDto);
        if (organizationDto.getInstanceId() != null && this.appInstanceDas.selectByPrimaryKey(organizationDto.getInstanceId()) == null) {
            logger.info("\u67e5\u8be2\u5e94\u7528\u8be6\u60c5\uff0c\u65e0\u6cd5\u901a\u8fc7\u5e94\u7528id\u67e5\u8be2\u5230\u5e94\u7528\u4fe1\u606f,\u5e94\u7528id\u4e3a:" + organizationDto.getInstanceId());
            throw new BizException(UserExceptionCode.APPLICATION_EXCEPTION_CODE.getCode(), UserExceptionCode.APPLICATION_EXCEPTION_CODE.getMsg());
        }
        OrganizationEo organizationEo = new OrganizationEo();
        DtoHelper.dto2Eo((BaseVo)organizationDto, (BaseEo)organizationEo);
        if (organizationDto.getParentId() != null) {
            OrganizationEo parentOrganization = (OrganizationEo)this.organizationDas.selectByPrimaryKey(organizationDto.getParentId());
            if (parentOrganization == null) {
                throw new BizException(UserExceptionCode.ORGANIZATION__IDCHECK_FAIL.getCode(), UserExceptionCode.ORGANIZATION__IDCHECK_FAIL.getMsg());
            }
            organizationEo.setParentId(parentOrganization.getId());
        } else {
            OrganizationEo organizationEoo = this.organizationDas.findRootByInstanceId(organizationDto.getInstanceId());
            if (organizationEoo != null) {
                organizationEo.setParentId(organizationEoo.getId());
            }
        }
        this.organizationDas.insert((BaseEo)organizationEo);
        this.organizationEventService.pushEvent(organizationEo, null, "ADD");
        this.dataLimitCacheUtil.cleanDataLimitOrgCache();
        return organizationEo.getId();
    }

    @Override
    public Long update(OrganizationDto organizationDto) {
        OrganizationEo organizationEo1;
        this.verifyOrgCode(organizationDto.getCode(), organizationDto.getId(), organizationDto.getTenantId() == null ? this.iContext.tenantId() : organizationDto.getTenantId());
        this.orgTypeValidationExt.execute(organizationDto);
        AssertUtil.isTrue((organizationDto.getId() != null ? 1 : 0) != 0, (String)"organizationDto \u7684 id \u4e0d\u80fd\u4e3a\u7a7a");
        if (organizationDto.getInstanceId() != null && this.appInstanceDas.selectByPrimaryKey(organizationDto.getInstanceId()) == null) {
            logger.info("\u67e5\u8be2\u5e94\u7528\u8be6\u60c5\uff0c\u65e0\u6cd5\u901a\u8fc7\u5e94\u7528id\u67e5\u8be2\u5230\u5e94\u7528\u4fe1\u606f,\u5e94\u7528id\u4e3a:" + organizationDto.getInstanceId());
            throw new BizException(UserExceptionCode.APPLICATION_EXCEPTION_CODE.getCode(), UserExceptionCode.APPLICATION_EXCEPTION_CODE.getMsg());
        }
        if (organizationDto.getParentId() != null && (organizationEo1 = (OrganizationEo)this.organizationDas.selectByPrimaryKey(organizationDto.getParentId())) == null) {
            throw new BizException(UserExceptionCode.ORGANIZATION__IDCHECK_FAIL.getCode(), UserExceptionCode.ORGANIZATION__IDCHECK_FAIL.getMsg());
        }
        OrganizationEo organizationEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(organizationDto.getId());
        if (organizationEo == null) {
            logger.info("\u901a\u8fc7\u7ec4\u7ec7id\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5f02\u5e38\uff0c\u7ec4\u7ec7id\u4e3a" + organizationDto.getId());
            throw new BizException(UserExceptionCode.ORGANIZATION__IDCHECK_FAIL.getCode(), UserExceptionCode.ORGANIZATION__IDCHECK_FAIL.getMsg());
        }
        DtoHelper.dto2Eo((BaseVo)organizationDto, (BaseEo)organizationEo, (String[])new String[]{"id"});
        try {
            this.organizationDas.update((BaseEo)organizationEo);
        }
        catch (Exception e) {
            logger.info("\u66f4\u65b0\u7ec4\u7ec7\u90e8\u95e8\u4fe1\u606f\u5f02\u5e38\uff0c\u7ec4\u7ec7id\u4e3a" + organizationDto.getId());
            throw new BizException(UserExceptionCode.ORGANIZATION_UPDATE_FAIL.getCode(), UserExceptionCode.ORGANIZATION_UPDATE_FAIL.getMsg());
        }
        this.organizationEventService.pushEvent(organizationEo, null, "UPDATE");
        this.dataLimitCacheUtil.cleanDataLimitOrgCache();
        return organizationDto.getId();
    }

    @Override
    public OrganizationDto queryOne(Long instanceId) {
        OrganizationEo organizationEo = this.organizationDas.findRootByInstanceId(instanceId);
        if (organizationEo == null) {
            logger.info("\u901a\u8fc7\u5b9e\u4f8bid\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5f02\u5e38\uff0c\u5b9e\u4f8bid\u4e3a" + instanceId);
            OrganizationDto organizationDto = new OrganizationDto();
            DtoHelper.eo2Dto((BaseEo)organizationEo, (BaseVo)organizationDto);
            return organizationDto;
        }
        return this.buildOrgTree(organizationEo.getId());
    }

    private OrganizationDto buildOrgTree(Long rootOrgId) {
        OrganizationEo rootOrg = (OrganizationEo)this.organizationDas.selectByPrimaryKey(rootOrgId);
        Assert.notNull((Object)rootOrg, (String)("\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0corgId:" + rootOrgId));
        List children = this.organizationDas.findOrganizationTreeByParentId(rootOrgId);
        ArrayList childrenDto = Lists.newArrayList();
        this.organizationEoList2DtoList(children, childrenDto);
        OrganizationDto organizationDto = new OrganizationDto();
        DtoHelper.eo2Dto((BaseEo)rootOrg, (BaseVo)organizationDto);
        organizationDto.setChildren((List)childrenDto);
        return organizationDto;
    }

    private void organizationEoList2DtoList(List<OrganizationEo> organizationEos, List<OrganizationDto> organizationDtos) {
        if (CollectionUtils.isNotEmpty(organizationEos)) {
            for (OrganizationEo organizationEo : organizationEos) {
                OrganizationDto organizationDto = new OrganizationDto();
                DtoHelper.eo2Dto((BaseEo)organizationEo, (BaseVo)organizationDto);
                organizationDtos.add(organizationDto);
                if (!CollectionUtils.isNotEmpty((Collection)organizationEo.getChildren())) continue;
                ArrayList childrenDtos = Lists.newArrayList();
                this.organizationEoList2DtoList(organizationEo.getChildren(), childrenDtos);
                organizationDto.setChildren((List)childrenDtos);
            }
        }
    }

    @Override
    public void removeOrganization(Long organizationId) {
        this.removeOrgValidationExt.execute(organizationId);
        OrganizationEo organizationEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(organizationId);
        if (organizationEo == null) {
            logger.info("\u901a\u8fc7\u7ec4\u7ec7id\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5f02\u5e38\uff0c\u7ec4\u7ec7id\u4e3a" + organizationId);
            throw new BizException(UserExceptionCode.ORGANIZATION__IDCHECK_FAIL.getCode(), UserExceptionCode.ORGANIZATION__IDCHECK_FAIL.getMsg());
        }
        List employeeEos = this.employeeDas.findByOrganizationId(organizationId);
        List childrenOrgs = this.organizationDas.findByParentId(organizationId);
        if (!CollectionUtils.isEmpty((Collection)childrenOrgs) || !CollectionUtils.isEmpty((Collection)employeeEos)) {
            throw new BizException(UserExceptionCode.DELETE_ORG_FAIL.getCode(), UserExceptionCode.DELETE_ORG_FAIL.getMsg());
        }
        this.organizationDas.logicDeleteById(organizationId);
        OrganizationInfoEo organizationInfoEo = new OrganizationInfoEo();
        organizationInfoEo.setOrgCode(organizationEo.getCode());
        organizationInfoEo.setTenantId(this.iContext.tenantId());
        this.organizationInfoDas.logicDelete((BaseEo)organizationInfoEo);
        this.organizationEventService.pushEvent(organizationEo, null, "DELETE");
        this.dataLimitCacheUtil.cleanDataLimitOrgCache();
    }

    @Override
    public OrganizationDto queryById(Long id) {
        OrganizationEo organizationEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(id);
        if (organizationEo != null) {
            String entityPropCode = organizationEo.getEntityPropCode();
            if (StringUtils.isBlank((CharSequence)entityPropCode) || entityPropCode.equals("company")) {
                organizationEo.setType(Integer.toString(OrgTypeEnum.COMPANY.getKey()));
            } else {
                organizationEo.setType(Integer.toString(OrgTypeEnum.DEPARTMENT.getKey()));
            }
        }
        OrganizationDto organizationDto = new OrganizationDto();
        try {
            DtoHelper.eo2Dto((BaseEo)organizationEo, (BaseVo)organizationDto);
        }
        catch (Exception e) {
            logger.info("\u901a\u8fc7\u7ec4\u7ec7id\u67e5\u8be2\u7ec4\u7ec7\u5217\u8868\u5f02\u5e38");
            throw new BizException(UserExceptionCode.BEAN_COPY_FAIL.getCode(), UserExceptionCode.BEAN_COPY_FAIL.getMsg());
        }
        return organizationDto;
    }

    @Override
    public PageInfo<OrganizationDto> queryByExample(String example, Integer pageNum, Integer pageSize) {
        PageInfo page;
        OrganizationEo organizationEo = (OrganizationEo)QueryUtil.validateExampleAndReturn((String)example, OrganizationEo.class);
        if (StringUtils.isNotEmpty((CharSequence)organizationEo.getName())) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            SqlFilter sqlFilter = new SqlFilter();
            sqlFilter.setProperty("name");
            sqlFilter.setValue((Object)("%" + organizationEo.getName() + "%"));
            sqlFilter.setOperator(SqlFilter.Operator.like);
            sqlFilters.add(sqlFilter);
            organizationEo.setSqlFilters(sqlFilters);
            organizationEo.setName(null);
        }
        if ((page = this.organizationDas.selectPage((BaseEo)organizationEo, pageNum, pageSize)) != null && CollectionUtils.isNotEmpty((Collection)page.getList())) {
            for (OrganizationEo eo : page.getList()) {
                String entityPropCode = eo.getEntityPropCode();
                if (StringUtils.isBlank((CharSequence)entityPropCode) || entityPropCode.equals("company")) {
                    eo.setType(Integer.toString(OrgTypeEnum.COMPANY.getKey()));
                    continue;
                }
                eo.setType(Integer.toString(OrgTypeEnum.DEPARTMENT.getKey()));
            }
        }
        return QueryUtil.eoPage2DtoPage((PageInfo)page, OrganizationDto.class);
    }

    @Override
    public OrganizationDto queryOrgAndItemsById(Long id, String[] items) {
        OrganizationEo organizationEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(id);
        if (organizationEo == null) {
            return null;
        }
        OrganizationDto organizationDto = new OrganizationDto();
        DtoHelper.eo2Dto((BaseEo)organizationEo, (BaseVo)organizationDto);
        if (items != null && items.length > 0) {
            for (String item : items) {
                if (!"employee".equals(item)) continue;
                this.addEmployeeToOrg(organizationDto, organizationEo);
            }
        }
        return organizationDto;
    }

    private void addEmployeeToOrg(OrganizationDto organizationDto, OrganizationEo organizationEo) {
        List employeeEos = this.employeeDas.findByOrganizationId(organizationEo.getId());
        ArrayList employeeDtos = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)employeeEos, employeeDtos, EmployeeDto.class);
        organizationDto.setEmployees(employeeDtos);
    }

    @Override
    public List<OrganizationDto> queryRootByTenantId(Long tenantId) {
        List organizationEos = this.organizationDas.findRootByTenantId(tenantId);
        ArrayList<OrganizationDto> organizationDtos = new ArrayList<OrganizationDto>();
        DtoHelper.eoList2DtoList((Collection)organizationEos, organizationDtos, OrganizationDto.class);
        return organizationDtos;
    }

    @Override
    public List<List<OrgStructureTreeRespDto>> queryStructureTreeByOrgName(String name, Long tenantId) {
        ArrayList<List<OrgStructureTreeRespDto>> treeList = new ArrayList<List<OrgStructureTreeRespDto>>();
        OrgStructureTreeRespDto orgStructureTreeRespDto = new OrgStructureTreeRespDto();
        OrganizationEo organizationEo = new OrganizationEo();
        organizationEo.setName(name);
        organizationEo.setTenantId(tenantId);
        List organizationEoList = this.organizationDas.select((BaseEo)organizationEo);
        for (OrganizationEo curOrg : organizationEoList) {
            orgStructureTreeRespDto.setInstanceId(curOrg.getInstanceId());
            orgStructureTreeRespDto.setOrgId(curOrg.getId());
            orgStructureTreeRespDto.setOrgName(curOrg.getName());
            List<OrgStructureTreeRespDto> tree = this.queryStructureTreeByOrgId(curOrg.getId());
            treeList.add(tree);
        }
        return treeList;
    }

    @Override
    public List<OrgStructureTreeRespDto> queryStructureTreeByOrgId(Long orgId) {
        ArrayList<OrgStructureTreeRespDto> tree = new ArrayList<OrgStructureTreeRespDto>();
        OrganizationEo organizationEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(orgId);
        if (null == organizationEo) {
            throw new BizException(UserExceptionCode.ORGANIZATION__IDCHECK_FAIL.getCode(), UserExceptionCode.ORGANIZATION__IDCHECK_FAIL.getMsg());
        }
        return this.buildTree(organizationEo, tree);
    }

    private List<OrgStructureTreeRespDto> buildTree(OrganizationEo organizationEo, List<OrgStructureTreeRespDto> tree) {
        tree.add(this.buildNode(organizationEo));
        if (null != organizationEo.getParentId() && null != (organizationEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(organizationEo.getParentId()))) {
            return this.buildTree(organizationEo, tree);
        }
        return tree;
    }

    private OrgStructureTreeRespDto buildNode(OrganizationEo organizationEo) {
        OrgStructureTreeRespDto orgStructureTreeRespDto = new OrgStructureTreeRespDto();
        orgStructureTreeRespDto.setInstanceId(organizationEo.getInstanceId());
        orgStructureTreeRespDto.setTenantId(organizationEo.getTenantId());
        orgStructureTreeRespDto.setOrgId(organizationEo.getId());
        orgStructureTreeRespDto.setOrgName(organizationEo.getName());
        return orgStructureTreeRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sortOrganization(Long id, SortReqDto sortReqDto) {
        Assert.notNull((Object)id, (String)"\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        String sortType = sortReqDto.getSortType();
        Assert.hasLength((String)sortType, (String)"\u6392\u5e8f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        String desc = SortEnum.getDescByType((String)sortType);
        Assert.hasLength((String)desc, (String)"\u6392\u5e8f\u7c7b\u578b\u4e0d\u652f\u6301");
        OrganizationEo organizationEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(id);
        if (organizationEo == null) {
            throw new BizException(UserExceptionCode.ORGANIZATION__IDCHECK_FAIL.getCode(), UserExceptionCode.ORGANIZATION__IDCHECK_FAIL.getMsg());
        }
        List<OrganizationEo> organizationEoList = this.findChild4Sort(sortReqDto, organizationEo);
        if (CollectionUtils.isEmpty(organizationEoList) || organizationEoList.size() == 1) {
            return;
        }
        ArrayList newSortOrganizationEoList = Lists.newArrayList();
        if (SortEnum.TOP.getType().equals(sortType)) {
            newSortOrganizationEoList.add(organizationEo);
            for (OrganizationEo eo : organizationEoList) {
                if (eo.getId().equals(organizationEo.getId())) continue;
                newSortOrganizationEoList.add(eo);
            }
        } else if (SortEnum.BOTTOM.getType().equals(sortType)) {
            for (OrganizationEo eo : organizationEoList) {
                if (eo.getId().equals(organizationEo.getId())) continue;
                newSortOrganizationEoList.add(eo);
            }
            newSortOrganizationEoList.add(organizationEo);
        } else {
            int size = organizationEoList.size();
            for (int i = 0; i < size; ++i) {
                OrganizationEo eo = organizationEoList.get(i);
                if (!eo.getId().equals(organizationEo.getId())) continue;
                Integer relatedIndex = null;
                if (SortEnum.INCR.getType().equals(sortType) && i != 0) {
                    relatedIndex = i - 1;
                } else if (SortEnum.DECR.getType().equals(sortType) && i != size - 1) {
                    relatedIndex = i + 1;
                }
                if (relatedIndex == null) break;
                organizationEoList.set(i, organizationEoList.get(relatedIndex));
                organizationEoList.set(relatedIndex, organizationEo);
                newSortOrganizationEoList.addAll(organizationEoList);
                break;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)newSortOrganizationEoList)) {
            int sortno = 1;
            for (OrganizationEo eo : newSortOrganizationEoList) {
                eo.setSortNO(Integer.valueOf(sortno++));
                this.organizationDas.updateSelective((BaseEo)eo);
            }
        }
    }

    protected List<OrganizationEo> findChild4Sort(SortReqDto sortReqDto, OrganizationEo organizationEo) {
        OrganizationEo selectEo = new OrganizationEo();
        selectEo.setParentId(organizationEo.getParentId());
        selectEo.setTenantId(organizationEo.getTenantId());
        selectEo.setInstanceId(sortReqDto.getInstanceId());
        selectEo.setOrderBy("sortno");
        return this.organizationDas.select((BaseEo)selectEo);
    }

    @Override
    public OrgAndOrgInfoRespDto queryOrgAndOrgInfo(Long orgId) {
        OrganizationEo organizationEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(orgId);
        OrganizationDto organizationDto = new OrganizationDto();
        DtoHelper.eo2Dto((BaseEo)organizationEo, (BaseVo)organizationDto);
        organizationDto.setName_i1(organizationEo.getNameI1());
        organizationDto.setName_i2(organizationEo.getNameI2());
        OrganizationInfoEo organizationInfoEo = new OrganizationInfoEo();
        organizationInfoEo.setTenantId(this.iContext.tenantId());
        organizationInfoEo.setOrgCode(organizationEo.getCode());
        OrganizationInfoEo organizationInfo = new OrganizationInfoEo();
        List organizationInfoEoList = this.organizationInfoDas.select((BaseEo)organizationInfoEo);
        if (CollectionUtils.isNotEmpty((Collection)organizationInfoEoList)) {
            organizationInfo = (OrganizationInfoEo)organizationInfoEoList.get(0);
        }
        OrganizationInfoDto organizationInfoDto = new OrganizationInfoDto();
        DtoHelper.eo2Dto((BaseEo)organizationInfo, (BaseVo)organizationInfoDto);
        OrgAndOrgInfoRespDto orgAndOrgInfoRespDto = new OrgAndOrgInfoRespDto();
        orgAndOrgInfoRespDto.setOrganizationDto(organizationDto);
        orgAndOrgInfoRespDto.setOrganizationInfoDto(organizationInfoDto);
        return orgAndOrgInfoRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addOrgAndOrgInfo(@Valid @RequestBody OrgAndOrgInfoReqDto orgAndOrgInfoReqDto) {
        this.orgTypeValidationExt.execute(orgAndOrgInfoReqDto.getOrganizationDto());
        OrganizationEo organizationEo = new OrganizationEo();
        organizationEo.setCode(orgAndOrgInfoReqDto.getOrganizationDto().getCode());
        organizationEo.setTenantId(this.iContext.tenantId());
        if (this.organizationDas.count((BaseEo)organizationEo) > 0) {
            throw new BizException(UserExceptionCode.ORG_CODE_EXIST.getCode(), UserExceptionCode.ORG_CODE_EXIST.getMsg());
        }
        DtoHelper.dto2Eo((BaseVo)orgAndOrgInfoReqDto.getOrganizationDto(), (BaseEo)organizationEo, (String[])new String[]{"tenantId", "instanceId"});
        organizationEo.setNameI1(orgAndOrgInfoReqDto.getOrganizationDto().getName_i1());
        organizationEo.setNameI2(orgAndOrgInfoReqDto.getOrganizationDto().getName_i2());
        this.organizationDas.insert((BaseEo)organizationEo);
        OrganizationInfoEo organizationInfoEo = new OrganizationInfoEo();
        DtoHelper.dto2Eo((BaseVo)orgAndOrgInfoReqDto.getOrganizationInfoDto(), (BaseEo)organizationInfoEo, (String[])new String[]{"tenantId", "instanceId"});
        organizationInfoEo.setOrgName(organizationEo.getName());
        organizationInfoEo.setOrgCode(organizationEo.getCode());
        this.organizationInfoDas.insert((BaseEo)organizationInfoEo);
        this.organizationEventService.pushEvent(organizationEo, organizationInfoEo, "ADD");
        this.dataLimitCacheUtil.cleanDataLimitOrgCache();
        return organizationEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyOrgAndOrgInfo(@Valid OrgAndOrgInfoReqDto orgAndOrgInfoReqDto) {
        this.orgTypeValidationExt.execute(orgAndOrgInfoReqDto.getOrganizationDto());
        OrganizationEo organizationEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(orgAndOrgInfoReqDto.getOrganizationDto().getId());
        if (null == organizationEo) {
            throw new BizException(UserExceptionCode.NON_EXIST_FAIL.getCode(), UserExceptionCode.NON_EXIST_FAIL.getMsg());
        }
        DtoHelper.dto2Eo((BaseVo)orgAndOrgInfoReqDto.getOrganizationDto(), (BaseEo)organizationEo, (String[])new String[]{"tenantId", "instanceId"});
        organizationEo.setNameI1(orgAndOrgInfoReqDto.getOrganizationDto().getName_i1());
        organizationEo.setNameI2(orgAndOrgInfoReqDto.getOrganizationDto().getName_i2());
        this.organizationDas.updateSelective((BaseEo)organizationEo);
        OrganizationInfoEo organizationInfoEo = new OrganizationInfoEo();
        organizationInfoEo.setOrgCode(organizationEo.getCode());
        organizationInfoEo.setTenantId(organizationEo.getTenantId());
        List check = this.organizationInfoDas.select((BaseEo)organizationInfoEo);
        if (CollectionUtils.isNotEmpty((Collection)check)) {
            organizationInfoEo = (OrganizationInfoEo)check.get(0);
        }
        DtoHelper.dto2Eo((BaseVo)orgAndOrgInfoReqDto.getOrganizationInfoDto(), (BaseEo)organizationInfoEo, (String[])new String[]{"tenantId", "instanceId"});
        this.organizationInfoDas.updateSelective((BaseEo)organizationInfoEo);
        this.organizationEventService.pushEvent(organizationEo, organizationInfoEo, "UPDATE");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void relateEmployeesOrg(RelateEmployeesOrgReqDto relateEmployeesOrgReqDto) {
        Long tenantId = this.context.tenantId();
        Long orgGroupId = this.orgGroupService.queryDefaultHumanOrgGroup(tenantId);
        List employeeIds = relateEmployeesOrgReqDto.getEmployeeIds();
        for (Long employeeId : employeeIds) {
            EmployeeOrgEo employeeOrganizationRelationEo = new EmployeeOrgEo();
            employeeOrganizationRelationEo.setOrganizationId(relateEmployeesOrgReqDto.getOrgId());
            employeeOrganizationRelationEo.setEmployeeId(employeeId);
            employeeOrganizationRelationEo.setOrgGroupId(orgGroupId);
            if (this.employeeOrganizationRelationDas.count((BaseEo)employeeOrganizationRelationEo) > 1) {
                throw new BizException(UserExceptionCode.EXIST_FAIL.getCode(), UserExceptionCode.EXIST_FAIL.getMsg());
            }
            this.employeeOrganizationRelationDas.insert((BaseEo)employeeOrganizationRelationEo);
        }
    }

    @Override
    public PageInfo<EmployeeDto> queryNotRelateEmployee(Long orgId, String employeeName, String employeeNo, String phoneNum, Integer pageNum, Integer pageSize) {
        EmployeeEo employeeEo = new EmployeeEo();
        employeeEo.setTenantId(this.iContext.tenantId());
        List allEmployees = this.employeeDas.select((BaseEo)employeeEo);
        ArrayList employeeDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)allEmployees, employeeDtoList, EmployeeDto.class);
        EmployeeOrgEo employeeOrganizationRelationEo = new EmployeeOrgEo();
        employeeOrganizationRelationEo.setOrganizationId(orgId);
        this.employeeOrganizationRelationDas.select((BaseEo)employeeOrganizationRelationEo).forEach(relationEo -> {
            for (int i = 0; i < employeeDtoList.size(); ++i) {
                if (!relationEo.getEmployeeId().equals(((EmployeeDto)employeeDtoList.get(i)).getId())) continue;
                employeeDtoList.remove(i);
                --i;
            }
        });
        if (null != employeeName || null != employeeNo || null != phoneNum) {
            ArrayList<EmployeeDto> filterResult = new ArrayList<EmployeeDto>();
            for (EmployeeDto employeeDto : employeeDtoList) {
                if (StringUtils.isNotEmpty((CharSequence)employeeName)) {
                    Pattern namePattern = Pattern.compile(employeeName, 2);
                    if (!namePattern.matcher(employeeDto.getName()).find()) continue;
                    if (StringUtils.isNotEmpty((CharSequence)employeeNo)) {
                        Pattern employeeNoPattern = Pattern.compile(employeeNo, 2);
                        if (!employeeNoPattern.matcher(employeeDto.getEmployeeNo()).find()) continue;
                        if (StringUtils.isNotEmpty((CharSequence)phoneNum)) {
                            if (!employeeDto.getPhoneNum().equals(phoneNum)) continue;
                            filterResult.add(employeeDto);
                            continue;
                        }
                        filterResult.add(employeeDto);
                        continue;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)phoneNum)) {
                        if (!employeeDto.getPhoneNum().equals(phoneNum)) continue;
                        filterResult.add(employeeDto);
                        continue;
                    }
                    filterResult.add(employeeDto);
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)employeeNo)) {
                    Pattern employeeNoPattern = Pattern.compile(employeeNo, 2);
                    if (!employeeNoPattern.matcher(employeeDto.getEmployeeNo()).find()) continue;
                    if (StringUtils.isNotEmpty((CharSequence)phoneNum)) {
                        if (!employeeDto.getPhoneNum().equals(phoneNum)) continue;
                        filterResult.add(employeeDto);
                        continue;
                    }
                    filterResult.add(employeeDto);
                    continue;
                }
                if (!StringUtils.isNotEmpty((CharSequence)phoneNum) || !employeeDto.getPhoneNum().equals(phoneNum)) continue;
                filterResult.add(employeeDto);
            }
            return PageInfoUtil.doPage(filterResult, (Integer)pageNum, (Integer)pageSize);
        }
        return PageInfoUtil.doPage(employeeDtoList, (Integer)pageNum, (Integer)pageSize);
    }

    @Override
    public PageInfo<EmployeeDto> queryRelateEmployee(Long orgId, String employeeName, String employeeNo, String phoneNum, Integer pageNum, Integer pageSize) {
        EmployeeEo condition = new EmployeeEo();
        condition.setTenantId(this.iContext.tenantId());
        List allEmployees = this.employeeDas.select((BaseEo)condition);
        EmployeeOrgEo relationEo = new EmployeeOrgEo();
        relationEo.setOrganizationId(orgId);
        List employeeOrganizationRelationEoList = this.employeeOrganizationRelationDas.select((BaseEo)relationEo);
        ArrayList<EmployeeEo> employeeEoList = new ArrayList<EmployeeEo>();
        for (EmployeeEo employeeEo : allEmployees) {
            for (EmployeeOrgEo employeeOrganizationRelationEo : employeeOrganizationRelationEoList) {
                if (!employeeOrganizationRelationEo.getEmployeeId().equals(employeeEo.getId())) continue;
                if (null != employeeName || null != employeeNo || null != phoneNum) {
                    if (StringUtils.isNotEmpty((CharSequence)employeeName)) {
                        Pattern namePattern = Pattern.compile(employeeName, 2);
                        if (!namePattern.matcher(employeeEo.getName()).find()) continue;
                        if (StringUtils.isNotEmpty((CharSequence)employeeNo)) {
                            Pattern employeeNoPattern = Pattern.compile(employeeNo, 2);
                            if (!employeeNoPattern.matcher(employeeEo.getEmployeeNo()).find()) continue;
                            if (StringUtils.isNotEmpty((CharSequence)phoneNum)) {
                                if (!employeeEo.getPhoneNum().equals(phoneNum)) continue;
                                employeeEoList.add(employeeEo);
                                continue;
                            }
                            employeeEoList.add(employeeEo);
                            continue;
                        }
                        if (StringUtils.isNotEmpty((CharSequence)phoneNum)) {
                            if (!employeeEo.getPhoneNum().equals(phoneNum)) continue;
                            employeeEoList.add(employeeEo);
                            continue;
                        }
                        employeeEoList.add(employeeEo);
                        continue;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)employeeNo)) {
                        Pattern employeeNoPattern = Pattern.compile(employeeNo, 2);
                        if (!employeeNoPattern.matcher(employeeEo.getEmployeeNo()).find()) continue;
                        if (StringUtils.isNotEmpty((CharSequence)phoneNum)) {
                            if (!employeeEo.getPhoneNum().equals(phoneNum)) continue;
                            employeeEoList.add(employeeEo);
                            continue;
                        }
                        employeeEoList.add(employeeEo);
                        continue;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)phoneNum) || !employeeEo.getPhoneNum().equals(phoneNum)) continue;
                    employeeEoList.add(employeeEo);
                    continue;
                }
                employeeEoList.add(employeeEo);
            }
        }
        ArrayList employeeDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)employeeEoList.stream().distinct().collect(Collectors.toList()), employeeDtoList, EmployeeDto.class);
        return PageInfoUtil.doPage(employeeDtoList, (Integer)pageNum, (Integer)pageSize);
    }

    @Override
    public List<Long> queryDirectSuperiorOrgIds() {
        DataLimitAspect.skipAllTable();
        List<Object> orgIdList = Lists.newArrayList();
        List<OrganizationDto> organizationDtoList = this.queryDirectSuperiorOrgList();
        if (CollectionUtils.isNotEmpty(organizationDtoList)) {
            orgIdList = organizationDtoList.parallelStream().map(OrganizationDto::getId).distinct().collect(Collectors.toList());
        }
        DataLimitAspect.cleanSkipTable();
        return orgIdList;
    }

    @Override
    public List<Long> queryAllSuperiorOrgList() {
        List parentOrgIds;
        DataLimitAspect.skipAllTable();
        ArrayList allParentOrgIdList = Lists.newArrayList();
        List<Long> userOrgIds = this.getOrgIdsByUserId();
        if (CollectionUtils.isEmpty(userOrgIds)) {
            return allParentOrgIdList;
        }
        allParentOrgIdList.addAll(userOrgIds);
        List eoList = this.organizationDas.findByIds(userOrgIds);
        while (CollectionUtils.isNotEmpty((Collection)eoList) && CollectionUtils.isNotEmpty(parentOrgIds = eoList.stream().filter(eo -> eo.getParentId() != null && eo.getParentId() > 0L).map(StdOrganizationEo::getParentId).collect(Collectors.toList()))) {
            allParentOrgIdList.addAll(parentOrgIds);
            eoList = this.organizationDas.findByIds(parentOrgIds);
        }
        DataLimitAspect.cleanSkipTable();
        return allParentOrgIdList.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public List<OrganizationDto> queryDirectSuperiorOrgList() {
        List parentOrgIds;
        DataLimitAspect.skipAllTable();
        ArrayList organizationDtoList = Lists.newArrayList();
        List<Long> userOrgIds = this.getOrgIdsByUserId();
        if (CollectionUtils.isEmpty(userOrgIds)) {
            return organizationDtoList;
        }
        List eoList = this.organizationDas.findByIds(userOrgIds);
        if (CollectionUtils.isNotEmpty((Collection)eoList) && CollectionUtils.isNotEmpty(parentOrgIds = eoList.stream().filter(eo -> eo.getParentId() != null && eo.getParentId() > 0L).map(StdOrganizationEo::getParentId).collect(Collectors.toList()))) {
            List organizationEoList = this.organizationDas.findByIds(parentOrgIds);
            if (CollectionUtils.isNotEmpty((Collection)organizationEoList)) {
                eoList.addAll(organizationEoList);
            }
            DtoHelper.eoList2DtoList((Collection)eoList, (Collection)organizationDtoList, OrganizationDto.class);
        }
        DataLimitAspect.cleanSkipTable();
        return organizationDtoList;
    }

    @Override
    public List<Long> queryDirectSubordinateOrgIds() {
        DataLimitAspect.skipAllTable();
        List<Object> orgIdList = Lists.newArrayList();
        List<OrganizationDto> organizationDtoList = this.queryDirectSubordinateOrgList();
        if (CollectionUtils.isNotEmpty(organizationDtoList)) {
            orgIdList = organizationDtoList.parallelStream().map(OrganizationDto::getId).distinct().collect(Collectors.toList());
        }
        DataLimitAspect.cleanSkipTable();
        return orgIdList;
    }

    @Override
    public List<OrganizationDto> queryDirectSubordinateOrgList() {
        return this.querySubordinateOrgList(false);
    }

    private List<OrganizationDto> querySubordinateOrgList(boolean queryAll) {
        DataLimitAspect.skipAllTable();
        List orgList = Lists.newArrayList();
        List<Long> userOrgIds = this.getOrgIdsByUserId();
        if (CollectionUtils.isNotEmpty(userOrgIds)) {
            orgList = this.organizationDas.findByIds(userOrgIds);
            this.getDirectSubordinateOrgList(orgList, userOrgIds, queryAll);
        }
        ArrayList organizationDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)orgList, (Collection)organizationDtoList, OrganizationDto.class);
        DataLimitAspect.cleanSkipTable();
        return organizationDtoList;
    }

    @Override
    public List<Long> queryAllSubordinateOrgIds() {
        DataLimitAspect.skipAllTable();
        List<Object> orgIdList = Lists.newArrayList();
        List<OrganizationDto> organizationDtoList = this.queryAllSubordinateOrgList();
        if (CollectionUtils.isNotEmpty(organizationDtoList)) {
            orgIdList = organizationDtoList.parallelStream().map(OrganizationDto::getId).distinct().collect(Collectors.toList());
        }
        DataLimitAspect.cleanSkipTable();
        return orgIdList;
    }

    @Override
    public List<OrganizationDto> queryAllSubordinateOrgList() {
        return this.querySubordinateOrgList(true);
    }

    @Override
    public List<OrganizationDto> queryAllSubordinateOrgTree() {
        DataLimitAspect.skipAllTable();
        ArrayList organizationDtoList = Lists.newArrayList();
        List<Long> userOrgIds = this.getOrgIdsByUserId();
        if (CollectionUtils.isEmpty(userOrgIds)) {
            logger.warn("\u7528\u6237\u6ca1\u6709\u5173\u8054\u7ec4\u7ec7");
            return organizationDtoList;
        }
        List organizationEoList = this.organizationDas.findByIds(userOrgIds);
        for (OrganizationEo organizationEo : organizationEoList) {
            organizationDtoList.add(this.buildOrgTree(organizationEo.getId()));
        }
        DataLimitAspect.cleanSkipTable();
        return organizationDtoList;
    }

    private void getDirectSubordinateOrgList(List<OrganizationEo> orgList, List<Long> queryOrgIds, boolean queryAll) {
        List eoList = this.organizationDas.findByParentIds(queryOrgIds);
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            List<Long> ids = eoList.stream().map(StdOrganizationEo::getId).collect(Collectors.toList());
            orgList.addAll(eoList);
            if (queryAll) {
                this.getDirectSubordinateOrgList(orgList, ids, true);
            }
        }
    }

    @Override
    public List<Long> queryBrotherOrgIds() {
        DataLimitAspect.skipAllTable();
        List<Object> orgIdList = Lists.newArrayList();
        List<OrganizationDto> organizationDtoList = this.queryBrotherOrgList();
        if (CollectionUtils.isNotEmpty(organizationDtoList)) {
            orgIdList = organizationDtoList.parallelStream().map(OrganizationDto::getId).distinct().collect(Collectors.toList());
        }
        DataLimitAspect.cleanSkipTable();
        return orgIdList;
    }

    @Override
    public List<OrganizationDto> queryBrotherOrgList() {
        List orgEoList;
        DataLimitAspect.skipAllTable();
        ArrayList organizationDtoList = Lists.newArrayList();
        List<Long> userOrgIds = this.getOrgIdsByUserId();
        if (CollectionUtils.isNotEmpty(userOrgIds) && CollectionUtils.isNotEmpty((Collection)(orgEoList = this.organizationDas.findByIds(userOrgIds)))) {
            List<Long> parentOrgIds = orgEoList.stream().filter(eo -> eo.getParentId() != null && eo.getParentId() > 0L).map(StdOrganizationEo::getParentId).collect(Collectors.toList());
            List<OrganizationEo> brotherEoList = this.findByParentIdsExcludeCurrentIds(parentOrgIds, userOrgIds);
            if (CollectionUtils.isNotEmpty(brotherEoList)) {
                orgEoList.addAll(brotherEoList);
            }
            DtoHelper.eoList2DtoList((Collection)orgEoList, (Collection)organizationDtoList, OrganizationDto.class);
        }
        DataLimitAspect.cleanSkipTable();
        return organizationDtoList;
    }

    private List<OrganizationEo> findByParentIdsExcludeCurrentIds(List<Long> parentOrgIds, List<Long> curOrgIds) {
        List eoList = this.organizationDas.findByParentIds(parentOrgIds);
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            return eoList.stream().filter(eo -> !curOrgIds.contains(eo.getId())).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<Long> queryBrotherDirectSubordinateOrgIds() {
        DataLimitAspect.skipAllTable();
        List<Object> orgIdList = Lists.newArrayList();
        List<OrganizationDto> organizationDtoList = this.queryBrotherDirectSubordinateOrgList();
        if (CollectionUtils.isNotEmpty(organizationDtoList)) {
            orgIdList = organizationDtoList.stream().map(OrganizationDto::getId).distinct().collect(Collectors.toList());
        }
        DataLimitAspect.cleanSkipTable();
        return orgIdList;
    }

    @Override
    public List<OrganizationDto> queryBrotherDirectSubordinateOrgList() {
        return this.queryBrotherSubordinateOrgList(false);
    }

    private List<OrganizationDto> queryBrotherSubordinateOrgList(boolean queryAll) {
        List eoList;
        DataLimitAspect.skipAllTable();
        ArrayList organizationDtoList = Lists.newArrayList();
        List<Long> userOrgIds = this.getOrgIdsByUserId();
        if (CollectionUtils.isNotEmpty(userOrgIds) && CollectionUtils.isNotEmpty((Collection)(eoList = this.organizationDas.findByIds(userOrgIds)))) {
            List<Long> parentOrgIds = eoList.stream().filter(eo -> eo.getParentId() != null && eo.getParentId() > 0L).map(StdOrganizationEo::getParentId).collect(Collectors.toList());
            List<OrganizationEo> brotherEoList = this.findByParentIdsExcludeCurrentIds(parentOrgIds, userOrgIds);
            if (CollectionUtils.isNotEmpty(brotherEoList)) {
                List<Long> brotherOrgIds = brotherEoList.stream().map(StdOrganizationEo::getId).collect(Collectors.toList());
                eoList.addAll(brotherEoList);
                this.getDirectSubordinateOrgList(eoList, brotherOrgIds, queryAll);
            }
            DtoHelper.eoList2DtoList((Collection)eoList, (Collection)organizationDtoList, OrganizationDto.class);
        }
        DataLimitAspect.cleanSkipTable();
        return organizationDtoList;
    }

    @Override
    public List<Long> queryBrotherAllSubordinateOrgIds() {
        DataLimitAspect.skipAllTable();
        List<Object> orgIdList = Lists.newArrayList();
        List<OrganizationDto> organizationDtoList = this.queryBrotherAllSubordinateOrgList();
        if (CollectionUtils.isNotEmpty(organizationDtoList)) {
            orgIdList = organizationDtoList.stream().map(OrganizationDto::getId).distinct().collect(Collectors.toList());
        }
        DataLimitAspect.cleanSkipTable();
        return orgIdList;
    }

    @Override
    public List<OrganizationDto> queryBrotherAllSubordinateOrgList() {
        return this.queryBrotherSubordinateOrgList(true);
    }

    @Override
    public List<OrganizationDto> queryOrgByCurUser(UserOrgQueryReqDto reqDto) {
        ArrayList dtoList = Lists.newArrayList();
        OrganizationEo queryEo = new OrganizationEo();
        if (reqDto.getInstanceId() != null) {
            queryEo.setInstanceId(reqDto.getInstanceId());
        } else {
            Long tenantId = ServiceContext.getContext().getRequestTenantId();
            queryEo.setTenantId(tenantId != null && tenantId > 0L ? tenantId : null);
        }
        List organizationEoList = this.organizationDas.select((BaseEo)queryEo);
        if (CollectionUtils.isEmpty((Collection)organizationEoList)) {
            return dtoList;
        }
        List allOrgIdList = organizationEoList.stream().map(StdOrganizationEo::getId).collect(Collectors.toList());
        ArrayList treeRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)organizationEoList, (Collection)treeRespDtoList, OrganizationDto.class);
        Map<Long, List<OrganizationDto>> childrenMap = treeRespDtoList.stream().filter(dto -> dto.getParentId() != null && dto.getParentId() > 0L).collect(Collectors.groupingBy(OrganizationDto::getParentId));
        if (CollectionUtils.isNotEmpty((Collection)treeRespDtoList)) {
            for (OrganizationDto dto2 : treeRespDtoList) {
                if (dto2.getParentId() != null && dto2.getParentId() != 0L && allOrgIdList.contains(dto2.getParentId())) continue;
                this.buildDtoTreeRespDto(dto2, childrenMap);
                dtoList.add(dto2);
            }
        }
        return dtoList;
    }

    @Override
    public List<OrganizationDto> queryUserOrgList() {
        DataLimitAspect.skipAllTable();
        ArrayList organizationDtoList = Lists.newArrayList();
        Long userId = ServiceContext.getContext().getRequestUserId();
        Assert.notNull((Object)userId, (String)"\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
        List<Long> userOrgIds = this.getUserOrgIdList(userId);
        if (CollectionUtils.isEmpty(userOrgIds)) {
            return organizationDtoList;
        }
        List organizationEoList = this.organizationDas.findByIds(userOrgIds);
        if (CollectionUtils.isNotEmpty((Collection)organizationEoList)) {
            DtoHelper.eoList2DtoList((Collection)organizationEoList, (Collection)organizationDtoList, OrganizationDto.class);
        }
        DataLimitAspect.cleanSkipTable();
        return organizationDtoList;
    }

    @Override
    public List<Long> queryUserOrgIdList() {
        Long userId = ServiceContext.getContext().getRequestUserId();
        Assert.notNull((Object)userId, (String)"\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
        return this.getUserOrgIdList(userId);
    }

    private void buildDtoTreeRespDto(OrganizationDto organizationDto, Map<Long, List<OrganizationDto>> childrenMap) {
        List<OrganizationDto> children = childrenMap.get(organizationDto.getId());
        if (CollectionUtils.isNotEmpty(children)) {
            organizationDto.setChildren(children);
            for (OrganizationDto dto : children) {
                this.buildDtoTreeRespDto(dto, childrenMap);
            }
        }
    }

    private List<Long> getOrgIdsByUserId() {
        Long userId = ServiceContext.getContext().getRequestUserId();
        Assert.notNull((Object)userId, (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        return this.getUserOrgIdList(userId);
    }

    private List<Long> getUserOrgIdList(Long userId) {
        List<EmployeeOrgEo> relationEoList;
        List<Long> orgIdList = new ArrayList<Long>();
        EmployeeEo employeeEo = this.getEmployeeEo(userId);
        if (employeeEo != null && CollectionUtils.isNotEmpty(relationEoList = this.getEmployeeOrgEos(employeeEo))) {
            orgIdList = relationEoList.stream().map(StdEmployeeOrgEo::getOrganizationId).distinct().collect(Collectors.toList());
        }
        UserOrgRelationQueryReqDto userOrgRelationQueryReqDto = new UserOrgRelationQueryReqDto();
        userOrgRelationQueryReqDto.setUserId(userId);
        orgIdList.addAll(this.userOrganizationService.queryUserRelatedOrgId(userOrgRelationQueryReqDto));
        return orgIdList;
    }

    private List<EmployeeOrgEo> getEmployeeOrgEos(EmployeeEo employeeEo) {
        List relationEoList;
        String key = RedisKeyConstants.combineKey((String)"findByEmployeeId", (Object[])new Object[]{employeeEo.getId()});
        String value = (String)this.cacheService.getCache(key, String.class);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            relationEoList = JSON.parseArray((String)value, EmployeeOrgEo.class);
        } else {
            EmployeeOrgEo employeeOrgEo = new EmployeeOrgEo();
            employeeOrgEo.setEmployeeId(employeeEo.getId());
            relationEoList = this.employeeOrganizationRelationDas.select((BaseEo)employeeOrgEo, Integer.valueOf(1), Integer.valueOf(100));
            if (CollectionUtils.isNotEmpty((Collection)relationEoList)) {
                this.cacheService.setCache(key, (Object)JSONObject.toJSONString((Object)relationEoList));
            }
        }
        return relationEoList;
    }

    private EmployeeEo getEmployeeEo(Long userId) {
        EmployeeEo employeeEo = null;
        String key = RedisKeyConstants.combineKey((String)"findByUserId", (Object[])new Object[]{userId});
        String value = (String)this.cacheService.getCache(key, String.class);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            employeeEo = (EmployeeEo)JSON.parseObject((String)value, EmployeeEo.class);
        } else {
            List employeeList = this.employeeDas.findByUserId(userId);
            if (CollectionUtils.isNotEmpty((Collection)employeeList)) {
                employeeEo = (EmployeeEo)employeeList.get(0);
                this.cacheService.setCache(key, (Object)JSONObject.toJSONString((Object)employeeEo));
            }
        }
        return employeeEo;
    }

    private void verifyOrgCode(String code, Long id, Long tenantId) {
        OrganizationEo ex = new OrganizationEo();
        ex.setCode(code);
        OrganizationEo one = (OrganizationEo)this.organizationDas.selectOne((BaseEo)ex);
        if (null != one && !one.getId().equals(id)) {
            throw new com.dtyunxi.yundt.cube.center.user.biz.exception.BizException(BizExceptionCode.ORG_NO_ERROR);
        }
    }

    @Override
    public Long queryLargestAndTopOrgByCurrUser(Long tenantId) {
        DataLimitAspect.skipAllTable();
        tenantId = tenantId == null ? ServiceContext.getContext().getRequestTenantId() : tenantId;
        OrganizationEo queryEo = new OrganizationEo();
        queryEo.setType("2");
        queryEo.setTenantId(tenantId);
        HashMap idEoCacheMap = new HashMap();
        HashMap idDepthCacheMap = new HashMap();
        DataLimitAspect.skipAllTable();
        List<Long> ids = this.queryUserOrgIdList();
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        ids.forEach(id -> this.findOrgDepth((Long)id, idEoCacheMap, idDepthCacheMap, null));
        int depth = Integer.MAX_VALUE;
        Long depthId = Long.MAX_VALUE;
        for (Long id2 : ids) {
            Integer tmpDepth = (Integer)idDepthCacheMap.get(id2);
            if (tmpDepth < depth) {
                depth = tmpDepth;
                depthId = id2;
                continue;
            }
            if (tmpDepth != depth) continue;
            depthId = Math.min(depthId, id2);
        }
        DataLimitAspect.cleanSkipTable();
        return ((OrganizationEo)idEoCacheMap.get(depthId)).getId();
    }

    private Integer findOrgDepth(Long orgId, HashMap<Long, OrganizationEo> idEoMap, HashMap<Long, Integer> idDepthMap, List<OrganizationEo> tmpEos) {
        if (tmpEos == null) {
            tmpEos = new ArrayList<OrganizationEo>();
        }
        if (Objects.equals(OrgUserConstants.ORG_ROOT_ID, orgId)) {
            if (tmpEos.isEmpty()) {
                return 0;
            }
            int depth = tmpEos.size();
            for (OrganizationEo tmpEo : tmpEos) {
                idDepthMap.putIfAbsent(tmpEo.getId(), depth);
                --depth;
            }
            return tmpEos.size();
        }
        if (idDepthMap.containsKey(orgId)) {
            int depth = tmpEos.size() + idDepthMap.get(orgId);
            for (int i = 0; i < tmpEos.size(); ++i) {
                idDepthMap.putIfAbsent(tmpEos.get(i).getId(), depth);
                --depth;
            }
            return tmpEos.size();
        }
        OrganizationEo eo = Optional.ofNullable(idEoMap.get(orgId)).orElseGet(() -> (OrganizationEo)this.organizationDas.selectByPrimaryKey(orgId));
        idEoMap.putIfAbsent(orgId, eo);
        tmpEos.add(eo);
        return this.findOrgDepth(eo.getParentId(), idEoMap, idDepthMap, tmpEos);
    }

    @Override
    public List<OrganizationDto> queryBelongOrgByUserId(Long userId) {
        DataLimitAspect.skipAllTable();
        List<Long> ids = this.getUserOrgIdList(userId);
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<OrganizationDto>();
        }
        List eos = this.organizationDas.selectByIds(ids);
        ArrayList<OrganizationDto> dots = new ArrayList<OrganizationDto>();
        DtoHelper.eoList2DtoList((Collection)eos, dots, OrganizationDto.class);
        DataLimitAspect.cleanSkipTable();
        return dots;
    }

    @Override
    public List<OrganizationDto> querySubordinateOrgByParentId(Long orgId) {
        ArrayList dtos = Lists.newArrayList();
        if (null == orgId) {
            return dtos;
        }
        OrganizationEo currEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(orgId);
        if (null == currEo) {
            return dtos;
        }
        List eos = this.organizationDas.selectAll();
        Map<Long, List<OrganizationEo>> parentIdEosMap = eos.stream().collect(Collectors.groupingBy(StdOrganizationEo::getParentId));
        HashSet parentIdSet = Sets.newHashSet((Object[])new Long[]{orgId});
        ArrayList<OrganizationEo> childrenEos = new ArrayList<OrganizationEo>();
        while (!parentIdSet.isEmpty()) {
            HashSet tmpParentIdSet = Sets.newHashSet();
            parentIdSet.stream().map(parentIdEosMap::get).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).forEach(childrenEo -> {
                childrenEos.add((OrganizationEo)childrenEo);
                tmpParentIdSet.add(childrenEo.getId());
            });
            parentIdSet = tmpParentIdSet;
        }
        childrenEos.add(currEo);
        DtoHelper.eoList2DtoList(childrenEos, (Collection)dtos, OrganizationDto.class);
        return dtos;
    }

    @Override
    public OrganizationDto queryOneByOrgCode(Long instanceId, String orgCode) {
        OrganizationEo organizationEo = this.organizationDas.queryByCodeAndInstanceId(orgCode, instanceId);
        if (organizationEo == null) {
            return null;
        }
        OrganizationDto organizationDto = new OrganizationDto();
        BeanUtils.copyProperties((Object)organizationEo, (Object)organizationDto);
        return organizationDto;
    }

    @Override
    public List<OrganizationDto> queryListByOrgCode(Long instanceId, List<String> orgCodeList) {
        List organizationEoList = this.organizationDas.queryByCodeList(orgCodeList, instanceId);
        if (CollectionUtils.isEmpty((Collection)organizationEoList)) {
            return null;
        }
        ArrayList organizationDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)organizationEoList, (Collection)organizationDtoList, OrganizationDto.class);
        return organizationDtoList;
    }

    @Override
    public List<OrgAndOrgInfoRespDto> queryOrgAndOrgInfoByIds(List<Long> orgIds) {
        List organizationEos = this.organizationDas.selectByIds(orgIds);
        if (CollectionUtils.isEmpty((Collection)organizationEos)) {
            return new ArrayList<OrgAndOrgInfoRespDto>(0);
        }
        Map<String, OrganizationInfoEo> infoEoMap = this.organizationInfoDas.selectByOrgCodesAndTenant(this.iContext.tenantId(), organizationEos.stream().map(StdOrganizationEo::getCode).collect(Collectors.toList())).stream().collect(Collectors.toMap(StdOrganizationInfoEo::getOrgCode, o -> o, (o1, o2) -> o1));
        return organizationEos.stream().map(organizationEo -> {
            OrganizationDto organizationDto = new OrganizationDto();
            DtoHelper.eo2Dto((BaseEo)organizationEo, (BaseVo)organizationDto);
            organizationDto.setName_i1(organizationEo.getNameI1());
            organizationDto.setName_i2(organizationEo.getNameI2());
            OrganizationInfoEo organizationInfo = infoEoMap.getOrDefault(organizationEo.getCode(), new OrganizationInfoEo());
            OrganizationInfoDto organizationInfoDto = new OrganizationInfoDto();
            DtoHelper.eo2Dto((BaseEo)organizationInfo, (BaseVo)organizationInfoDto);
            OrgAndOrgInfoRespDto orgAndOrgInfoRespDto = new OrgAndOrgInfoRespDto();
            orgAndOrgInfoRespDto.setOrganizationDto(organizationDto);
            orgAndOrgInfoRespDto.setOrganizationInfoDto(organizationInfoDto);
            return orgAndOrgInfoRespDto;
        }).collect(Collectors.toList());
    }
}

