/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserOrganizationService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.util.QueryUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserOrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserOrganizationEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserOrganizationServiceImpl
implements IUserOrganizationService {
    @Resource
    private UserOrganizationDas userOrganizationDas;
    @Resource
    private OrganizationDas organizationDas;
    @Resource
    private UserDas userDas;
    @Resource
    private IContext context;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addUserOrgRelationAll(UserOrgRelationReqDto userOrgRelationReqDto) {
        this.paramsCheck(userOrgRelationReqDto);
        if (CollectionUtils.isNotEmpty((Collection)userOrgRelationReqDto.getOrgIds())) {
            ArrayList eoList = Lists.newArrayList();
            for (Long orgId : userOrgRelationReqDto.getOrgIds()) {
                UserOrganizationEo eo = this.buildUserOrganizationEo(userOrgRelationReqDto, orgId);
                eoList.add(eo);
            }
            List list = this.userOrganizationDas.selectListByUserId(userOrgRelationReqDto.getUserId());
            for (UserOrganizationEo eo : list) {
                this.userOrganizationDas.logicDelete((BaseEo)eo);
            }
            this.userOrganizationDas.insertBatch((List)eoList);
        }
    }

    private void paramsCheck(UserOrgRelationReqDto userOrgRelationReqDto) {
        AssertUtil.isTrue((userOrgRelationReqDto.getUserId() != null ? 1 : 0) != 0, (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)userOrgRelationReqDto.getOrgIds()), (String)"\u7ec4\u7ec7id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        this.userCheck(userOrgRelationReqDto.getUserId());
        for (Long id : userOrgRelationReqDto.getOrgIds()) {
            this.orgCheck(id);
        }
    }

    private void orgCheck(Long id) {
        OrganizationEo eo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(id);
        if (eo == null) {
            throw new BizException(UserExceptionCode.ORGANIZATION__IDCHECK_FAIL.getCode(), UserExceptionCode.ORGANIZATION__IDCHECK_FAIL.getMsg() + "\uff0c\u7ec4\u7ec7id\u4e3a[" + id + "]");
        }
    }

    private void userCheck(Long userId) {
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        if (userEo == null) {
            throw new BizException(UserExceptionCode.USER_NOTEXIST_FAIL.getCode(), UserExceptionCode.USER_NOTEXIST_FAIL.getMsg());
        }
    }

    private UserOrganizationEo buildUserOrganizationEo(UserOrgRelationReqDto userOrgRelationReqDto, Long orgId) {
        UserOrganizationEo eo = new UserOrganizationEo();
        eo.setUserId(userOrgRelationReqDto.getUserId());
        eo.setOrganizationId(orgId);
        eo.setTenantId(userOrgRelationReqDto.getTenantId() != null ? userOrgRelationReqDto.getTenantId() : this.context.tenantId());
        eo.setInstanceId(userOrgRelationReqDto.getInstanceId() != null ? userOrgRelationReqDto.getInstanceId() : this.context.instanceId());
        eo.setExtension(StringUtils.isNotBlank((CharSequence)userOrgRelationReqDto.getExtension()) ? userOrgRelationReqDto.getExtension() : "");
        return eo;
    }

    @Override
    public void addUserOrgRelation(UserOrgRelationReqDto userOrgRelationReqDto) {
        this.paramsCheck(userOrgRelationReqDto);
        if (CollectionUtils.isNotEmpty((Collection)userOrgRelationReqDto.getOrgIds())) {
            List<Long> orgIdList = this.getOrgIdList(userOrgRelationReqDto.getUserId());
            ArrayList eoList = Lists.newArrayList();
            for (Long orgId : userOrgRelationReqDto.getOrgIds()) {
                if (!CollectionUtils.isEmpty(orgIdList) && orgIdList.contains(orgId)) continue;
                UserOrganizationEo eo = this.buildUserOrganizationEo(userOrgRelationReqDto, orgId);
                eoList.add(eo);
            }
            this.userOrganizationDas.insertBatch((List)eoList);
        }
    }

    private List<Long> getOrgIdList(Long userId) {
        this.userCheck(userId);
        List list = this.userOrganizationDas.selectListByUserId(userId);
        List<Object> orgIdList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            orgIdList = list.stream().map(UserOrganizationEo::getOrganizationId).collect(Collectors.toList());
        }
        return orgIdList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteUserOrgRelation(UserOrgRelationReqDto userOrgRelationReqDto) {
        this.paramsCheck(userOrgRelationReqDto);
        if (CollectionUtils.isNotEmpty((Collection)userOrgRelationReqDto.getOrgIds())) {
            List list = this.userOrganizationDas.selectListByUserIdAndOrgIdList(userOrgRelationReqDto.getUserId(), userOrgRelationReqDto.getOrgIds());
            for (UserOrganizationEo eo : list) {
                this.userOrganizationDas.logicDelete((BaseEo)eo);
            }
        }
    }

    @Override
    public PageInfo<OrganizationDto> queryUserOrgRelation(Long userId, Integer pageNum, Integer pageSize) {
        List<Long> orgIdList = this.getOrgIdList(userId);
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            OrganizationEo queryEo = new OrganizationEo();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"id", (Object)StringUtils.join(orgIdList, (String)",")));
            queryEo.setSqlFilters(sqlFilterList);
            queryEo.setOrderByDesc("update_time");
            PageInfo eoPageInfo = this.organizationDas.selectPage((BaseEo)queryEo, pageNum, pageSize);
            return QueryUtil.eoPage2DtoPage((PageInfo)eoPageInfo, OrganizationDto.class);
        }
        return new PageInfo();
    }

    @Override
    public PageInfo<UserRespDto> queryUserOrgRelation(UserOrgRelationQueryReqDto userOrgRelationQueryReqDto, Integer pageNum, Integer pageSize) {
        AssertUtil.isTrue((userOrgRelationQueryReqDto.getOrgId() != null ? 1 : 0) != 0, (String)"\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        List<Long> userIdList = this.getUserIdList(userOrgRelationQueryReqDto.getOrgId());
        if (CollectionUtils.isNotEmpty(userIdList)) {
            UserEo queryEo = this.buildUserQueryEo(userOrgRelationQueryReqDto);
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"id", (Object)StringUtils.join(userIdList, (String)",")));
            queryEo.setSqlFilters(sqlFilterList);
            if (StringUtils.isNotBlank((CharSequence)userOrgRelationQueryReqDto.getUserName())) {
                sqlFilterList.add(SqlFilter.like((String)"user_name", (Object)("%" + userOrgRelationQueryReqDto.getUserName() + "%")));
                queryEo.setUserName(null);
            }
            queryEo.setOrderByDesc("update_time");
            PageInfo eoPageInfo = this.userDas.selectPage((BaseEo)queryEo, pageNum, pageSize);
            return QueryUtil.eoPage2DtoPage((PageInfo)eoPageInfo, UserRespDto.class);
        }
        return new PageInfo();
    }

    private UserEo buildUserQueryEo(UserOrgRelationQueryReqDto userOrgRelationQueryReqDto) {
        UserEo queryEo = new UserEo();
        DtoHelper.dto2Eo((BaseVo)userOrgRelationQueryReqDto, (BaseEo)queryEo);
        if (queryEo.getTenantId() == null) {
            queryEo.setTenantId(this.context.tenantId());
        }
        return queryEo;
    }

    private List<Long> getUserIdList(Long orgId) {
        this.orgCheck(orgId);
        List list = this.userOrganizationDas.selectListByOrgId(orgId);
        List<Object> userIdList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            userIdList = list.stream().map(UserOrganizationEo::getUserId).collect(Collectors.toList());
        }
        return userIdList;
    }

    @Override
    public PageInfo<UserRespDto> queryUserOrgNoRelation(UserOrgRelationQueryReqDto userOrgRelationQueryReqDto, Integer pageNum, Integer pageSize) {
        AssertUtil.isTrue((userOrgRelationQueryReqDto.getOrgId() != null ? 1 : 0) != 0, (String)"\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        List<Long> userIdList = this.getUserIdList(userOrgRelationQueryReqDto.getOrgId());
        if (CollectionUtils.isNotEmpty(userIdList)) {
            UserEo queryEo = this.buildUserQueryEo(userOrgRelationQueryReqDto);
            PageHelper.startPage((int)pageNum, (int)pageSize);
            List list = this.userDas.selectListNotInIdsAndUserInfo(queryEo, userIdList);
            PageInfo eoPageInfo = new PageInfo(list);
            return QueryUtil.eoPage2DtoPage((PageInfo)eoPageInfo, UserRespDto.class);
        }
        return new PageInfo();
    }

    @Override
    public List<Long> queryUserRelatedOrgId(UserOrgRelationQueryReqDto userOrgRelationQueryReqDto) {
        List<Long> orgIdList = new ArrayList<Long>();
        Long userId = userOrgRelationQueryReqDto.getUserId();
        AssertUtil.isTrue((null != userId ? 1 : 0) != 0, (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        List userOrganizationEos = this.userOrganizationDas.selectListByUserId(userId);
        if (!CollectionUtils.isEmpty((Collection)userOrganizationEos)) {
            orgIdList = userOrganizationEos.stream().map(UserOrganizationEo::getOrganizationId).collect(Collectors.toList());
        }
        return orgIdList;
    }
}

