/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.svr.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.IBizOrganizationApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationTreeDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgSyncReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrganizationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.BizOrganizationRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/organization"})
public class BizOrganizationRest
implements IBizOrganizationQueryApi,
IBizOrganizationApi {
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Resource
    private IBizOrganizationApi bizOrganizationApi;

    public RestResponse<List<OrganizationTreeDto>> getOrganizationTree(@PathVariable(value="instanceId") Long instanceId, @PathVariable(value="userId") Long userId) {
        return this.bizOrganizationQueryApi.getOrganizationTree(instanceId, userId);
    }

    public RestResponse<List<OrganizationDto>> getOrganizations(@RequestBody List<String> orgNos) {
        return this.bizOrganizationQueryApi.getOrganizations(orgNos);
    }

    public RestResponse<List<OrganizationDto>> getOrganizationsByIds(@RequestBody List<Long> ids) {
        return this.bizOrganizationQueryApi.getOrganizationsByIds(ids);
    }

    public RestResponse<List<OrganizationDto>> getOrg(@PathVariable(value="instanceId") Long instanceId, @RequestParam(value="parentId", required=false) Long parentId) {
        return this.bizOrganizationQueryApi.getOrg(instanceId, parentId);
    }

    public RestResponse<OrganizationDto> getOrganizationByShopId(@PathVariable(value="shopId") String shopId) {
        return this.bizOrganizationQueryApi.getOrganizationByShopId(shopId);
    }

    public RestResponse<List<OrganizationDto>> getOrganizationByShopIds(@RequestParam(value="shopIds") List<String> shopIds) {
        return this.bizOrganizationQueryApi.getOrganizationByShopIds(shopIds);
    }

    public RestResponse<List<OrganizationDto>> queryInfoByCodeList(@RequestParam(value="codeList") List<String> codeList) {
        return this.bizOrganizationQueryApi.queryInfoByCodeList(codeList);
    }

    public RestResponse<List<OrganizationDto>> listOrganizationByUpdateTime(@PathVariable(value="instanceId") Long instanceId, @PathVariable(value="updateTime") String updateTime) {
        return this.bizOrganizationQueryApi.listOrganizationByUpdateTime(instanceId, updateTime);
    }

    public RestResponse<PageInfo<OrganizationDto>> queryPageByCondition(@SpringQueryMap OrganizationReqDto reqDto, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return this.bizOrganizationQueryApi.queryPageByCondition(reqDto, pageNum, pageSize);
    }

    public RestResponse<PageInfo<BizOrganizationRespDto>> queryBizOrganizationByPage(@RequestParam(value="filter") String filter, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        return this.bizOrganizationQueryApi.queryBizOrganizationByPage(filter, pageNum, pageSize);
    }

    public RestResponse<PageInfo<BizOrganizationRespDto>> queryBizOrganizationByPagePost(@RequestBody String filter, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        return this.bizOrganizationQueryApi.queryBizOrganizationByPagePost(filter, pageNum, pageSize);
    }

    public RestResponse<Long> addOrg(@PathVariable(value="instanceId") Long instanceId, @Valid @RequestBody OrgReqDto orgReqDto) {
        return this.bizOrganizationApi.addOrg(instanceId, orgReqDto);
    }

    public RestResponse<String> addOrgs(@PathVariable(value="instanceId") Long instanceId, @Valid @RequestBody List<OrgReqDto> orgReqDtos) {
        return this.bizOrganizationApi.addOrgs(instanceId, orgReqDtos);
    }

    public RestResponse<String> modifyOrg(@PathVariable(value="instanceId") Long instanceId, @PathVariable(value="organizationId") Long organizationId, @Valid @RequestBody OrgReqDto orgReqDto) {
        return this.bizOrganizationApi.modifyOrg(instanceId, organizationId, orgReqDto);
    }

    public RestResponse<String> sort(@RequestParam(name="parentId") Long parentId, @RequestParam(name="orgId") Long orgId, @RequestParam(name="sort") Integer sort) {
        return this.bizOrganizationApi.sort(parentId, orgId, sort);
    }

    public RestResponse<String> delete(@PathVariable(name="organizationId") Long orgId) {
        return this.bizOrganizationApi.delete(orgId);
    }

    public RestResponse<String> syncOrg(@PathVariable(name="parentCode") String parentCode, @RequestBody List<OrgSyncReqDto> orgSyncReqDtos) {
        return this.bizOrganizationApi.syncOrg(parentCode, orgSyncReqDtos);
    }

    public RestResponse<String> updateOrgLvRv(@PathVariable(name="orgId") Long orgId) {
        return this.bizOrganizationApi.updateOrgLvRv(orgId);
    }
}

