/**
 * @(#) IStorageApi.java 1.0 2018-11-30
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.ExchangeActivityTargetDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.ItemSkuActivityPriceDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.*;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.ActivityMutexQueryRespDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.BatchActivityStockRespDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.ExchangeActivityTargetRespDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.RemainingStockBatchRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityPriceDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityPriceQueryReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * B端活动库存接口服务
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Api(tags = {"促销中心:B端活动库存接口服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-biz-promotion-api-stock-service-IItemActivityStockApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        url = "${yundt.cube.center.promotion.api:}",
        path = "/v2/activity/stock/"
)
public interface IItemActivityStockApi {

    /**
     * 批量操作商品活动库存
     *
     * @param batchActivityStockReqDto 业务请求参数
     * @return 成功的操作库存的商品列表
     */
    @PostMapping("/batch")
    @ApiOperation(value = "新增/扣减活动库存", notes = "新增/扣减活动库存(balance大于0为新增，PS：balance为增量值不为库存总值;balance小于0为扣减)")
    RestResponse<BatchActivityStockRespDto> batchOperatingActivityStock(@RequestBody BatchActivityStockReqDto batchActivityStockReqDto);

    /**
     * 获取活动库存策略
     *
     * @return 库存类型（1预占商品库存 2独立活动库存 3共享商品库存）
     */
    @GetMapping("/stock-type")
    @ApiOperation(value = "获取活动库存策略", notes = "获取活动库存策略（1预占商品库存 2独立活动库存 3共享商品库存）")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "instanceId", dataType = "Long", paramType = "query", value = "实例id")
    })
    RestResponse<Integer> queryActivityStockType(@RequestParam(value = "instanceId", required = false) Long instanceId);

    /**
     * 查询商品还有剩余库存的活动价格列表
     *
     * @param queryReqDto
     * @return
     */
    @GetMapping("/price/enable-list")
    @ApiOperation(value = "查询商品还有剩余库存的活动价格列表", notes = "查询商品还有剩余库存的活动价格列表")
    RestResponse<List<ItemActivityPriceDto>> queryEnableList(@SpringQueryMap ItemActivityPriceQueryReqDto queryReqDto);

    /**
     * 查询商品还有剩余库存的活动价格列表
     *
     * @param queryReqDto
     * @return
     */
    @PostMapping("/branch/activity-price")
    @ApiOperation(value = "批量查询商品SKU可用的活动最低价格列表", notes = "批量查询商品SKU可用的活动最低价格列表")
    RestResponse<List<ItemSkuActivityPriceDto>> queryBranchItemSkuActivityPrice(@RequestBody ActivityPriceBranchQueryReqDto queryReqDto);

    /**
     * 查询活动以及对应的活动互斥列表
     *
     * @param queryReqDto
     * @return
     */
    @PostMapping("/mutex-list")
    @ApiOperation(value = "查询活动以及对应的活动互斥列表", notes = "查询活动以及对应的活动互斥列表")
    RestResponse<List<ActivityMutexQueryRespDto>> queryActivityMutexList(@RequestBody ActivityMutexQueryReqDto queryReqDto);

    /**
     * 批量获取活动剩余库存
     *
     * @param reqDto
     * @return
     */
    @PostMapping("/batch/remaining")
    @ApiOperation(value = "批量获取活动剩余库存", notes = "批量获取活动剩余库存")
    RestResponse<RemainingStockBatchRespDto> getActivityRemainingStockBatch(@RequestBody RemainingStockBatchReqDto reqDto);

    /**
     * 获取活动剩余库存
     *
     * @param activityStockReqDto
     * @return
     */
    @PostMapping("/remaining")
    @ApiOperation(value = "获取活动剩余库存", notes = "获取活动剩余库存")
    RestResponse<Map<String, Long>> getActivityRemainingStock(@RequestBody ActivityStockReqDto activityStockReqDto);


    /**
     * 校验是否目标用户
     *
     * @return
     */
    @PostMapping("/target/{activityId}/{customerId}")
    @ApiOperation(value = "校验是否目标用户", notes = "校验是否目标用户 true：是")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "activityId", value = "活动ID", dataType = "Long", paramType = "path", required =
                    true),
            @ApiImplicitParam(name = "customerId", value = "客户id", dataType = "Long", paramType = "path", required =
                    true),
            @ApiImplicitParam(name = "customerInfo", value = "客户信息响应Dto", dataType = "CustomerRespDto", paramType = "body", required = true)
    })
    RestResponse<Boolean> validateTargetCustomer(
            @PathVariable("activityId") Long activityId,
            @PathVariable("customerId") Long customerId,
            @RequestBody CustomerRespDto customerInfo);


    /**
     * 校验是否目标用户
     *
     * @return
     */
    @PostMapping("/target")
    @ApiOperation(value = "校验是否目标用户和目标商城类型集合", notes = "校验是否目标用户和目标商城类型集合")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "targetCustomerReqDto", value = "目标请求", dataType = "TargetCustomerReqDto",
                    paramType = "body", required = true)
    })
    RestResponse<List<Long>> validateTargetCustomersAndMallType(@RequestBody TargetCustomerReqDto targetCustomerReqDto);

    /**
     * 区分购物车换购活动商品
     *
     * @return
     */
    @PostMapping("/exchange/target")
    @ApiOperation(value = "区分购物车换购活动商品", notes = "区分购物车换购活动商品")
    RestResponse<List<ExchangeActivityTargetRespDto>> validateExchangeActivityTarget(@RequestBody ExchangeActivityTargetDto exchangeActivityTargetDto);

    /**
     * 查询购物车商品参与的换购活动
     *
     * @return
     */
    @PostMapping("/exchange/targetList")
    @ApiOperation(value = "查询购物车商品参与的换购活动", notes = "查询购物车商品参与的换购活动")
    RestResponse<List<ExchangeActivityTargetRespDto>> validateExchangeActivityList(@RequestBody ExchangeActivityTargetDto exchangeActivityTargetDto);
}
