package com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto;

import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.ItemSkuDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.util.Map;

@ApiModel(value = "ExchangeActivityTargetDto", description = "ExchangeActivityTargetDto")
public class ExchangeActivityTargetDto extends BaseVo {
    @ApiModelProperty(name = "shopIds", value = "店铺商品id集合")
    private Map<Long, List<ItemSkuDto>> shopSkuIds;
    @ApiModelProperty(name = "mallType", value = "商城类型（1:H5商城，2:PC商城）")
    private Integer mallType = 1;
    @ApiModelProperty(name = "activityTemplateId", value = "活动模板id")
    private Long activityTemplateId;
    @ApiModelProperty(name = "customerRespDtos", value = "客户信息集合")
    List<CustomerRespDto> customerRespDtos;

    public List<CustomerRespDto> getCustomerRespDtos() {
        return customerRespDtos;
    }

    public void setCustomerRespDtos(List<CustomerRespDto> customerRespDtos) {
        this.customerRespDtos = customerRespDtos;
    }

    public Long getActivityTemplateId() {
        return activityTemplateId;
    }

    public void setActivityTemplateId(Long activityTemplateId) {
        this.activityTemplateId = activityTemplateId;
    }

    public Integer getMallType() {
        return mallType;
    }

    public void setMallType(Integer mallType) {
        this.mallType = mallType;
    }

    public Map<Long, List<ItemSkuDto>> getShopSkuIds() {
        return shopSkuIds;
    }

    public void setShopSkuIds(Map<Long, List<ItemSkuDto>> shopSkuIds) {
        this.shopSkuIds = shopSkuIds;
    }

}
