package com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivitySimpleInfoDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
 * 商品sku活动价Dto
 */
@ApiModel(value = "ItemSkuActivityPriceDto",description = "商品sku活动价Dto")
public class ItemSkuActivityPriceDto {

    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID", required = true)
    private Long shopId;


    /**
     * 商品ID
     */
    @ApiModelProperty(name = "itemId", value = "商品ID", required = true)
    private Long itemId;

    /**
     * skuId
     */
    @ApiModelProperty(name = "skuId", value = "skuId", required = true)
    private Long skuId;

    /**
     * 客户ID
     */
    @ApiModelProperty(name = "customerId", value = "客户ID", required = true)
    private Long customerId;

    @ApiModelProperty(name = "sellPrice", value = "售价")
    private BigDecimal sellPrice;

    @ApiModelProperty(name = "activityPrice", value = "活动价")
    private BigDecimal activityPrice;

    @ApiModelProperty(name = "type", value = "类型：1活动价，2折扣价")
    private Integer type;

    @ApiModelProperty(name = "activityId", value = "活动id")
    private Long activityId;

    @ApiModelProperty(name = "activityTag", value = "活动标签")
    private String activityTag;

    @ApiModelProperty(name = "activityTemplateId", value = "活动模板id")
    private Long activityTemplateId;

    @ApiModelProperty(name = "remainingStock", value = "剩余活动库存")
    private Long remainingStock;

    public Long getRemainingStock() {
        return remainingStock;
    }

    public void setRemainingStock(Long remainingStock) {
        this.remainingStock = remainingStock;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getActivityTag() {
        return activityTag;
    }

    public void setActivityTag(String activityTag) {
        this.activityTag = activityTag;
    }

    public Long getActivityTemplateId() {
        return activityTemplateId;
    }

    public void setActivityTemplateId(Long activityTemplateId) {
        this.activityTemplateId = activityTemplateId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public BigDecimal getSellPrice() {
        return sellPrice;
    }

    public void setSellPrice(BigDecimal sellPrice) {
        this.sellPrice = sellPrice;
    }

    public BigDecimal getActivityPrice() {
        return activityPrice;
    }

    public void setActivityPrice(BigDecimal activityPrice) {
        this.activityPrice = activityPrice;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
}
