/**
 * @(#)ItemActivityPriceQueryReqDto.java 1.0 2021/3/9
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.ItemSkuDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 活动互斥查询dto
 *
 */
@ApiModel(value = "ActivityMutexQueryReqDto", description = "活动互斥查询dto")
public class ActivityMutexQueryReqDto extends RequestDto {


    @ApiModelProperty(name = "activityIds", value = "活动id列表",required = true)
    private List<Long> activityIds;

    @ApiModelProperty(name = "itemSkuList", value = "商品sku列表",required = true)
    private List<ItemSkuDto> itemSkuList;

    public List<ItemSkuDto> getItemSkuList() {
        return itemSkuList;
    }

    public void setItemSkuList(List<ItemSkuDto> itemSkuList) {
        this.itemSkuList = itemSkuList;
    }

    public List<Long> getActivityIds() {
        return activityIds;
    }

    public void setActivityIds(List<Long> activityIds) {
        this.activityIds = activityIds;
    }
}
