package com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request;

import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.ItemSkuActivityPriceDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 活动价批量查询Dto
 */
@ApiModel(value = "ActivityPriceBranchQueryReqDto",description = "活动价批量查询Dto")
public class ActivityPriceBranchQueryReqDto {

    /**
     * 商品sku活动价查询集合
     */
    @ApiModelProperty(name = "itemSkuActivityPriceList", value = "商品sku活动价查询集合")
    private List<ItemSkuActivityPriceDto> itemSkuActivityPriceList;

    @ApiModelProperty(name = "srcType", value = "来源类型（1:H5商城，2:PC商城）")
    private Integer srcType = 1;

    @ApiModelProperty(name = "filterSecKill", value = "是否过滤秒杀活动：默认false")
    private Boolean filterSecKill = false;

    @ApiModelProperty(name = "filterSecKill", value = "是否过滤未开始的活动：默认false")
    private Boolean filterNotBegin = false;

    public Boolean getFilterNotBegin() {
        return filterNotBegin;
    }

    public void setFilterNotBegin(Boolean filterNotBegin) {
        this.filterNotBegin = filterNotBegin;
    }

    public Boolean getFilterSecKill() {
        return filterSecKill;
    }

    public void setFilterSecKill(Boolean filterSecKill) {
        this.filterSecKill = filterSecKill;
    }

    public Integer getSrcType() {
        return srcType;
    }

    public void setSrcType(Integer srcType) {
        this.srcType = srcType;
    }

    public List<ItemSkuActivityPriceDto> getItemSkuActivityPriceList() {
        return itemSkuActivityPriceList;
    }

    public void setItemSkuActivityPriceList(List<ItemSkuActivityPriceDto> itemSkuActivityPriceList) {
        this.itemSkuActivityPriceList = itemSkuActivityPriceList;
    }
}
