/**
 * @(#) ItemStorageReqDto.java 1.0 2018-11-30
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
* @Description:  活动剩余库存请求Dto
* @Author: sanqiu.qwz@dtyunxi.com
* @CreateDate: 2021/6/21 18:01
* @Version V1.0
*/
@ApiModel(value = "ActivityStockReqDto", description = "活动剩余库存请求Dto")
public class ActivityStockReqDto extends RequestDto {

    /**
     * 商品ID
     */
    @ApiModelProperty(name = "itemId", value = "商品ID，必填")
    private Long itemId;
    /**
     * 活动ids
     */
    @ApiModelProperty(name = "activityIds", value = "多个活动id，必填")
    private List<Long> activityIds;

    /**
     * 店铺id
     */
    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public List<Long> getActivityIds() {
        return activityIds;
    }

    public void setActivityIds(List<Long> activityIds) {
        this.activityIds = activityIds;
    }
}
