/*
 * @(#)BatchItemStorageReqDto.java 1.0 2021-01-22
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 批量操作活动库存Dto
 * @author zhuiming
 * @since 2.0.0
 */
@ApiModel(value = "BatchActivityStockReqDto", description = "批量操作活动库存Dto")
public class BatchActivityStockReqDto extends RequestDto {
    public final  static Integer ADD=2;
    public final  static Integer SUB=1;
    @ApiModelProperty(name = "itemActivityStockList", value = "操作库存列表")
    private List<ItemActivityStockReqDto> itemActivityStockList;
    @ApiModelProperty(name = "opt", value = "操作类型：1 扣减 2 新增")
    private Integer opt;
    @ApiModelProperty(name = "activityIds", value = "活动id集合")
    private List<Long> activityIds;

    public List<Long> getActivityIds() {
        return activityIds;
    }

    public void setActivityIds(List<Long> activityIds) {
        this.activityIds = activityIds;
    }

    public Integer getOpt() {
        return opt;
    }

    public void setOpt(Integer opt) {
        this.opt = opt;
    }

    public List<ItemActivityStockReqDto> getItemActivityStockList() {
        return itemActivityStockList;
    }

    public void setItemActivityStockList(List<ItemActivityStockReqDto> itemActivityStockList) {
        this.itemActivityStockList = itemActivityStockList;
    }
}