/**
 * @(#) ItemStorageReqDto.java 1.0 2018-11-30
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 商品活动库存请求Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "ItemActivityStockReqDto", description = "商品活动库存请求Dto")
public class ItemActivityStockReqDto extends RequestDto {

    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID，必填")
    private Long shopId;
    /**
     * skuId
     */
    @NotNull(message = "skuId不允许为空")
    @ApiModelProperty(name = "skuId", value = "skuId，必填")
    private Long skuId;
    /**
     * 库存数
     */
    @NotNull(message = "库存数(balance)不能为空，必填")
    @ApiModelProperty(name = "balance", value = "库存数，该数据值为增量(原库存100，新增100库存，数值传100而不是200)，为负数时为商品库存扣减。在操作库存页面时，可能会有商品库存扣减，所以需要传增量数据")
    private Long balance;
    /**
     * 活动id集合(一个商品sku会参加多个活动)内部排序一定是根据活动id从小到大，用于回滚时
     */
    @ApiModelProperty(name = "activityIds", value = "活动id集合(内部排序一定是根据活动id从小到大，用于回滚时)")
    private List<Long> activityIds;

    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    @ApiModelProperty(name = "orderNo", value = "订单号，选填")
    private String orderNo;

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getBalance() {
        return balance;
    }

    public void setBalance(Long balance) {
        this.balance = balance;
    }

    public List<Long> getActivityIds() {
        return activityIds;
    }

    public void setActivityIds(List<Long> activityIds) {
        this.activityIds = activityIds;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }
}
