package com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @Description: 目标用户
 * @Author: sanqiu.qwz@dtyunxi.com
 * @CreateDate: 2021/6/23 20:02
 * @Version V1.0
 */
public class TargetCustomerReqDto extends RequestDto {

    /**
     * 客户信息
     */
    @ApiModelProperty(name = "customerInfo", value = "客户信息，必填")
    private CustomerReqDto customerInfo;
    /**
     * 活动ids
     */
    @ApiModelProperty(name = "activityIds", value = "多个活动id，必填")
    private List<Long> activityIds;

    /**
     * 客户信息列表
     */
    @ApiModelProperty(name = "customerInfoList", value = "客户信息列表")
    private List<CustomerRespDto> customerInfoList;

    @ApiModelProperty(name = "srcType", value = "来源类型（1:H5商城，2:PC商城）")
    private Integer srcType = 1;

    public Integer getSrcType() {
        return srcType;
    }

    public void setSrcType(Integer srcType) {
        this.srcType = srcType;
    }

    public List<CustomerRespDto> getCustomerInfoList() {
        return customerInfoList;
    }

    public void setCustomerInfoList(List<CustomerRespDto> customerInfoList) {
        this.customerInfoList = customerInfoList;
    }

    public CustomerReqDto getCustomerInfo() {
        return customerInfo;
    }

    public void setCustomerInfo(CustomerReqDto customerInfo) {
        this.customerInfo = customerInfo;
    }

    public List<Long> getActivityIds() {
        return activityIds;
    }

    public void setActivityIds(List<Long> activityIds) {
        this.activityIds = activityIds;
    }
}
