/**
 * @(#) ItemStorageReqDto.java 1.0 2018-11-30
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.util.Map;

/**
* @Description:  活动剩余库存批量响应Dto
* @CreateDate: 2021/7/14
* @Version V1.0
*/
@ApiModel(value = "RemainingStockBatchRespDto", description = "活动剩余库存批量响应Dto")
public class RemainingStockBatchRespDto extends BaseVo {

    /**
     * 活动剩余库存 key=skuID value=所有活动的剩余库存
     */
    @ApiModelProperty(name = "remainingStockMap", value = "活动剩余库存 key=shopId＋skuID value=该sku对应的所有活动剩余库存")
    private Map<String, Long> remainingStockMap;

    /**
     * 可用活动ID集合 key=shopId＋itemId value=该店铺商品可用活动ID集合
     */
    @ApiModelProperty(name = "activityListMap", value = "可用活动ID集合 key=shopId＋itemId value=该店铺商品可用活动ID集合")
    private Map<String, List<Long>> activityListMap;

    public Map<String, Long> getRemainingStockMap() {
        return remainingStockMap;
    }

    public void setRemainingStockMap(Map<String, Long> remainingStockMap) {
        this.remainingStockMap = remainingStockMap;
    }

    public Map<String, List<Long>> getActivityListMap() {
        return activityListMap;
    }

    public void setActivityListMap(Map<String, List<Long>> activityListMap) {
        this.activityListMap = activityListMap;
    }
}
