/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.apiimpl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsReceiveNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentActionEnum;
import com.dtyunxi.yundt.cube.center.trade.api.IAfterSalesTobApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.AuditTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.FinReviewToBReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.GiftAccountReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnAuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnConfirmRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnItemConfirmDetailReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnItemConfirmReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnItemDataReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnModTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.action.ReturnFlowTobAction;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.produce.RefundOrderProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.ReturnOrderReviewMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IAfterSalesService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IAfterSalesTobService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.tob.IOptLogService;
import com.dtyunxi.yundt.cube.center.trade.conf.ext.domain.FinReviewTobAuditBo;
import com.dtyunxi.yundt.cube.center.trade.conf.ext.domain.ReturnAuditTobBo;
import com.dtyunxi.yundt.cube.center.trade.conf.ext.domain.ReturnConfirmRefundTobBo;
import com.dtyunxi.yundt.cube.center.trade.conf.ext.domain.ReturnItemConfirmBo;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IReturnRefundActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.ReturnBo;
import java.math.BigDecimal;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service(value="afterSalesTobApiImpl")
public class AfterSalesTobApiImpl
implements IAfterSalesTobApi {
    private static Logger logger = LoggerFactory.getLogger(AfterSalesTobApiImpl.class);
    @Resource
    IAfterSalesTobService afterSalesTobService;
    @Resource
    IAfterSalesService afterSalesService;
    @Resource
    IOptLogService optLogService;
    @Resource
    private ReturnFlowTobAction returnFlowTobAction;
    @CubeResource
    private IReturnRefundActionExtPt returnRefundActionExtPt;
    @Resource
    private RefundOrderProducer refundOrderProducer;
    @Resource
    private ReturnDas returnDas;
    @Resource
    private ICsReceiveNoticeOrderApi receiveNoticeOrderApi;

    public RestResponse<Void> modifyReturnInfo(ReturnModTobReqDto returnModTobReqDto) {
        this.afterSalesTobService.modifyReturnInfo(returnModTobReqDto);
        return new RestResponse();
    }

    public RestResponse<String> auditReturnRefactor(String returnNo, ReturnAuditReqDto returnAuditReqDto) {
        ReturnAuditTobBo returnAuditBo = new ReturnAuditTobBo();
        returnAuditBo.setReturnAuditReq(returnAuditReqDto);
        returnAuditReqDto.setReturnNo(returnNo);
        returnAuditBo.setReturnNo(returnNo);
        returnAuditBo.setDriveFlowParam(this.returnRefundActionExtPt.getFlowDefId(), this.returnRefundActionExtPt.getFlowDefName(), returnNo);
        if (StringUtils.isEmpty((Object)returnAuditReqDto.getAuditType()) || AuditTypeEnum.RETURN_AUDIT.getType().equals(returnAuditReqDto.getAuditType())) {
            this.returnFlowTobAction.auditReturnOrder(returnAuditBo);
        }
        if (AuditTypeEnum.REFUND_AUDIT.getType().equals(returnAuditReqDto.getAuditType())) {
            this.returnFlowTobAction.auditRefundOrder(returnAuditBo);
        }
        return new RestResponse((Object)"success");
    }

    public RestResponse<String> confirmReturnItem(ReturnItemConfirmReqDto returnItemConfirmReqDto) {
        ReturnItemConfirmBo returnItemConfirmBo = new ReturnItemConfirmBo();
        returnItemConfirmBo.setReturnItemConfirmReqDto(returnItemConfirmReqDto);
        returnItemConfirmBo.setDriveFlowParam(this.returnRefundActionExtPt.getFlowDefId(), this.returnRefundActionExtPt.getFlowDefName(), returnItemConfirmReqDto.getReturnNo());
        this.returnFlowTobAction.confirmReturnItem(returnItemConfirmBo);
        return new RestResponse();
    }

    public RestResponse<String> confirmRefund(ReturnConfirmRefundReqDto returnConfirmRefundReqDto) {
        ReturnConfirmRefundTobBo returnConfirmRefundTobBo = new ReturnConfirmRefundTobBo();
        returnConfirmRefundTobBo.setReturnConfirmRefundReqDto(returnConfirmRefundReqDto);
        returnConfirmRefundTobBo.setDriveFlowParam(this.returnRefundActionExtPt.getFlowDefId(), this.returnRefundActionExtPt.getFlowDefName(), returnConfirmRefundReqDto.getReturnNo());
        this.returnFlowTobAction.doRefund(returnConfirmRefundTobBo);
        return new RestResponse();
    }

    public RestResponse<Void> changeReturnItem(ReturnItemDataReqDto returnConfirmRefundReqDto) {
        this.afterSalesTobService.changeReturnItem(returnConfirmRefundReqDto);
        return new RestResponse();
    }

    public RestResponse<Void> removeRefund(ReturnConfirmRefundReqDto returnConfirmRefundReqDto) {
        this.afterSalesTobService.removeRefund(returnConfirmRefundReqDto);
        return new RestResponse();
    }

    public RestResponse<Void> modifyUncertainItemReturnInfo(ReturnModTobReqDto returnModTobReqDto) {
        this.afterSalesTobService.modifyUncertainItemReturnInfo(returnModTobReqDto);
        return new RestResponse();
    }

    public RestResponse<String> finReviewOrder(String returnNo, FinReviewToBReqDto finReviewToBReqDto) {
        FinReviewTobAuditBo finReviewTobAuditBo = new FinReviewTobAuditBo();
        finReviewTobAuditBo.setFinReviewToBReqDto(finReviewToBReqDto);
        finReviewTobAuditBo.setReturnNo(returnNo);
        finReviewTobAuditBo.setDriveFlowParam(this.returnRefundActionExtPt.getFlowDefId(), this.returnRefundActionExtPt.getFlowDefName(), returnNo);
        this.returnFlowTobAction.finReviewOrder(finReviewTobAuditBo);
        logger.info("\u9000\u5355\u590d\u5408\u5b8c\u6210\uff0c\u53d1\u9001MQ\uff1a{}", (Object)returnNo);
        if (finReviewToBReqDto.getAuditResult() == 1) {
            this.sendReviewPassMq(finReviewTobAuditBo);
        }
        return new RestResponse();
    }

    private void sendReviewPassMq(FinReviewTobAuditBo finReviewTobAuditBo) {
        try {
            ReturnEo returnEo = finReviewTobAuditBo.getReturnEo();
            if (returnEo == null) {
                returnEo = this.returnDas.selectByTradeNo(finReviewTobAuditBo.getReturnNo());
                finReviewTobAuditBo.setReturnEo(returnEo);
            }
            ReturnOrderReviewMessageVo msg = new ReturnOrderReviewMessageVo();
            msg.setAuditResult(1);
            msg.setOrderTradeNo(returnEo.getOrderTradeNo());
            msg.setReturnNo(returnEo.getReturnNo());
            this.refundOrderProducer.sendRefundOrderReviewPassMessage(msg);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
        }
    }

    public RestResponse<String> rejectAuditOrder(String returnNo, ReturnAuditReqDto returnAuditReqDto) {
        ReturnAuditTobBo returnAuditBo = new ReturnAuditTobBo();
        returnAuditBo.setReturnAuditReq(returnAuditReqDto);
        returnAuditReqDto.setReturnNo(returnNo);
        returnAuditBo.setReturnNo(returnNo);
        returnAuditBo.setDriveFlowParam(this.returnRefundActionExtPt.getFlowDefId(), this.returnRefundActionExtPt.getFlowDefName(), returnNo);
        this.returnFlowTobAction.rejectAuditOrder(returnAuditBo);
        logger.info("\u901a\u77e5\u5e93\u5b58\u4e2d\u5fc3\u53d6\u6d88\u901a\u77e5\u5355,\u9000\u8d27\u5355\u53f7\u4e3a\uff1a{}", (Object)returnNo);
        this.receiveNoticeOrderApi.updateOrderStatus(returnNo, CsDocumentActionEnum.REVERSE_AUDIT.getCode());
        return new RestResponse((Object)returnNo);
    }

    public RestResponse<BigDecimal> giftRefund(GiftAccountReqDto dto) {
        return new RestResponse((Object)this.afterSalesTobService.giftRefund(dto));
    }

    public RestResponse<Void> returnOrderReceived(String returnNo) {
        ReturnEo returnEo = this.afterSalesService.getByTradeNo(returnNo);
        if (returnEo == null) {
            throw new BizException(String.format("\u6839\u636e\u9000\u8ba2\u5355\u53f7[%s]\uff0c\u67e5\u8be2\u4e0d\u5230\u9000\u8ba2\u5355", returnNo));
        }
        ReturnBo returnBo = new ReturnBo();
        returnBo.setReturnEo(returnEo);
        returnBo.setDriveFlowParam(this.returnRefundActionExtPt.getFlowDefId(), this.returnRefundActionExtPt.getFlowDefName(), returnNo);
        this.returnFlowTobAction.receptItemAll(returnBo);
        logger.info(String.format("\u9000\u8ba2\u5355\uff1a[%s]\uff0c\u6536\u8d27\u6210\u529f\uff01", returnNo));
        return new RestResponse();
    }

    public RestResponse<Void> saveOuterReturnItem(ReturnItemConfirmReqDto returnItemConfirmReqDto) {
        logger.info("saveOuterReturnItem-param={}", (Object)returnItemConfirmReqDto.getReturnNo());
        ReturnEo returnEo = this.afterSalesService.getByTradeNo(returnItemConfirmReqDto.getReturnNo());
        if (returnEo == null) {
            logger.warn("\u627e\u4e0d\u5230\u9000\u8ba2\u5355\u53f7{}", (Object)returnItemConfirmReqDto.getReturnNo());
            return new RestResponse();
        }
        Assert.notEmpty((Collection)returnItemConfirmReqDto.getReturnItemConfirmDetailReqDtos(), (String)"\u9000\u8d27\u5165\u5e93\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        if (Strings.isNotBlank((String)returnEo.getOrderTradeNo())) {
            logger.info("\u539f\u5355\u9000\u8bbe\u7f6e\u539f\u8ba2\u5355\u53f7:{}", (Object)returnEo.getOrderTradeNo());
            for (ReturnItemConfirmDetailReqDto returnItemConfirmDetailReqDto : returnItemConfirmReqDto.getReturnItemConfirmDetailReqDtos()) {
                returnItemConfirmDetailReqDto.setOrderNo(returnEo.getOrderTradeNo());
            }
        }
        this.afterSalesTobService.saveOuterReturnItem(returnEo, returnItemConfirmReqDto);
        return new RestResponse();
    }
}

