/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.apiimpl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseDto;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.VerifyException;
import com.dtyunxi.yundt.cube.center.payment.dto.notify.RefundOrderNotifyRequest;
import com.dtyunxi.yundt.cube.center.trade.api.IPayTobApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.flow.RefundNotifyDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.tob.PayMethodRecordTobRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.biz.config.PayConfig;
import com.dtyunxi.yundt.cube.center.trade.biz.constants.BaseFlowDef;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.action.ReturnFlowTobAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.RefundNotifyBo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IContextService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.tob.IOptLogService;
import com.dtyunxi.yundt.cube.center.trade.conf.ext.domain.ReturnConfirmRefundTobBo;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PayRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefundDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefundDetailDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PayRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundDetailEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdPayRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdRefundEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdReturnEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.tob.OptLogEo;
import com.dtyunxi.yundt.cube.center.trade.ext.api.constants.OrderBizStatusTobEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IRefundActionExtPt;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="payTobApiImpl")
public class PayTobApiImpl
implements IPayTobApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayRecordDas payRecordDas;
    @Resource
    private IContextService contextService;
    @Value(value="${yundt.cube.center.payment.appvo.apiSecret}")
    public String apiSecret;
    @Resource
    private ReturnFlowTobAction returnFlowTobAction;
    @CubeResource
    private IRefundActionExtPt refundActionExtPt;
    @Autowired
    private PayConfig payConfig;
    @Resource
    private OrderDas orderDas;
    @Resource
    private IContext context;
    @Resource
    private IOptLogService optLogService;
    @Resource
    private ReturnDas returnDas;
    @Resource
    private RefundDas refundDas;
    @Resource
    private RefundDetailDas refundDetailDas;

    public RestResponse<Void> abandonPayRecord(String payNo) {
        PayRecordEo recordEo = this.payRecordDas.selectByPayNo(payNo);
        String payMethod = recordEo.getPayMethod();
        if (StringUtils.isNotEmpty((CharSequence)payMethod) && !"OFFLINE_AMOUNT_PAY".equals(payMethod) && !"OFFLINE_PUBLIC_REMIT_PAY".equals(payMethod)) {
            throw new BizException(TradeExceptionCode.PAY_RECORD_NOT_ABANDON.getCode(), TradeExceptionCode.PAY_RECORD_NOT_ABANDON.getMsg());
        }
        recordEo.setPayStatus(PayStatusEnum.ABANDON.getName());
        this.payRecordDas.updateSelective((BaseEo)recordEo);
        String orderNo = recordEo.getOrderNo();
        OrderEo orderEo = this.orderDas.findByOrderNo(orderNo);
        if (null != orderEo) {
            PayRecordEo querypayRecordEo = PayRecordEo.newInstance();
            querypayRecordEo.setOrderNo(orderNo);
            List payRecordEos = this.payRecordDas.select((BaseEo)querypayRecordEo);
            BigDecimal reduce = payRecordEos.stream().filter(bean -> PayStatusEnum.SUCCESS.getName().equals(bean.getPayStatus())).map(StdPayRecordEo::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (null == reduce || reduce.compareTo(BigDecimal.ZERO) == 0) {
                orderEo.setPayStatus(OrderBizStatusTobEnum.WAIT_PAY.getCode());
            } else {
                orderEo.setPayStatus(OrderBizStatusTobEnum.PART_PAY.getCode());
            }
            this.orderDas.updateSelective((BaseEo)orderEo);
            OptLogEo optLogEo = new OptLogEo();
            optLogEo.setBizType(OptBizTypeEnum.ORDER.getType());
            optLogEo.setBizNo(orderEo.getOrderNo());
            optLogEo.setOptTime(new Date());
            optLogEo.setOptPerson(this.context.userName());
            optLogEo.setOptType(OptTypeEnum.ORDER_PAY_RECORD.getType());
            optLogEo.setDescription(String.format("\u3010\u5e9f\u5f03\u6536\u6b3e\u3011\u652f\u4ed8\u6d41\u6c34\uff1a%s\uff0c\u5e9f\u5f03\u3002", payNo));
            this.optLogService.addBoOptLog(optLogEo);
        }
        return new RestResponse();
    }

    public RestResponse<List<PayMethodRecordTobRespDto>> queryPayMethodRecordByOrderNo(String orderNo) {
        ArrayList payMethodRecordList = Lists.newArrayList();
        PayRecordEo payRecordEo = new PayRecordEo();
        payRecordEo.setOrderNo(orderNo);
        payRecordEo.setPayStatus(PayStatusEnum.SUCCESS.getName());
        List payRecordEos = this.payRecordDas.select((BaseEo)payRecordEo);
        if (CollectionUtils.isNotEmpty((Collection)payRecordEos)) {
            Map<String, List<PayRecordEo>> payRecordMap = payRecordEos.stream().collect(Collectors.groupingBy(StdPayRecordEo::getPayMethod));
            for (Map.Entry<String, List<PayRecordEo>> payRecordEntryMap : payRecordMap.entrySet()) {
                PayMethodRecordTobRespDto payMethodRecordResp = new PayMethodRecordTobRespDto();
                String key = payRecordEntryMap.getKey();
                List<PayRecordEo> value = payRecordEntryMap.getValue();
                BigDecimal payAmount = BigDecimal.ZERO;
                for (PayRecordEo recordEo : value) {
                    payAmount = payAmount.add(recordEo.getPayAmount());
                }
                payMethodRecordResp.setPayMethod(key);
                payMethodRecordResp.setPayAmount(payAmount);
                payMethodRecordList.add(payMethodRecordResp);
            }
            HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>();
            ReturnEo returnEo = new ReturnEo();
            returnEo.setOrderTradeNo(orderNo);
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.ne((String)"return_type", (Object)"RETURN_ONLY"));
            returnEo.setSqlFilters(sqlFilters);
            List returnEos = this.returnDas.select((BaseEo)returnEo);
            if (CollectionUtils.isNotEmpty((Collection)returnEos)) {
                List returnNos = returnEos.stream().map(StdReturnEo::getReturnNo).collect(Collectors.toList());
                RefundEo refundEo = new RefundEo();
                refundEo.setRefundStatus(RefundStatusEnum.SUCCESS.getName());
                ArrayList<SqlFilter> refundFilters = new ArrayList<SqlFilter>();
                refundFilters.add(SqlFilter.in((String)"return_no", returnNos));
                refundEo.setSqlFilters(refundFilters);
                List refundEos = this.refundDas.select((BaseEo)refundEo);
                if (CollectionUtils.isNotEmpty((Collection)refundEos)) {
                    List refundNos = refundEos.stream().map(StdRefundEo::getRefundNo).collect(Collectors.toList());
                    RefundDetailEo refundDetailEo = new RefundDetailEo();
                    ArrayList<SqlFilter> detailFilters = new ArrayList<SqlFilter>();
                    detailFilters.add(SqlFilter.in((String)"refund_no", refundNos));
                    refundDetailEo.setSqlFilters(detailFilters);
                    List refundDetailEos = this.refundDetailDas.select((BaseEo)refundDetailEo);
                    Map<String, List<RefundDetailEo>> refundDetailMap = refundDetailEos.stream().collect(Collectors.groupingBy(RefundDetailEo::getPayMethod));
                    for (Map.Entry<String, List<RefundDetailEo>> refundDetailEntryMap : refundDetailMap.entrySet()) {
                        String key = refundDetailEntryMap.getKey();
                        List<RefundDetailEo> value = refundDetailEntryMap.getValue();
                        BigDecimal alreadyReturnAmount = BigDecimal.ZERO;
                        for (RefundDetailEo detailEo : value) {
                            alreadyReturnAmount = alreadyReturnAmount.add(detailEo.getRefundAmount());
                        }
                        amountMap.put(key, alreadyReturnAmount);
                    }
                }
            }
            for (PayMethodRecordTobRespDto respDto : payMethodRecordList) {
                BigDecimal alreadyReturnAmount = (BigDecimal)amountMap.get(respDto.getPayMethod());
                if (Objects.nonNull(alreadyReturnAmount)) {
                    respDto.setAlreadyReturnAmount(alreadyReturnAmount);
                    continue;
                }
                respDto.setAlreadyReturnAmount(BigDecimal.ZERO);
            }
        }
        return new RestResponse((Object)payMethodRecordList);
    }

    private void validSign(BaseDto notify) {
        try {
            notify.verifySign(this.payConfig.getApiSecret());
        }
        catch (VerifyException ex) {
            try {
                notify.verifyGlobalSign(this.apiSecret);
            }
            catch (VerifyException e) {
                this.logger.error("\u7b7e\u540d\u4e0d\u4e00\u81f4", (Throwable)ex);
                throw new BizException(ex.getErrCode(), ex.getErrMsg());
            }
        }
    }

    public String toBHandleRefundNotify(String orderNo, String appKey, HttpServletRequest request, String refundNo) {
        this.logger.info("\u9000\u6b3e\u901a\u77e5\u4ea4\u6613\u53f7{}\u83b7\u53d6\u7684appKey{}", (Object)orderNo, (Object)appKey);
        if (appKey != null) {
            this.contextService.getAndSetInstanceInfo(Long.valueOf(appKey));
        }
        TreeMap<String, String> paramsMap = new TreeMap<String, String>();
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String paraName = (String)enu.nextElement();
            paramsMap.put(paraName, request.getParameter(paraName));
        }
        RefundOrderNotifyRequest notify = new RefundOrderNotifyRequest();
        notify = (RefundOrderNotifyRequest)notify.map2Bean(paramsMap);
        this.logger.info("\u6536\u5230\u9000\u6b3e\u901a\u77e5{},\u89e3\u6790\u7d50\u679c\u70ba{}", (Object)orderNo, JSON.toJSON((Object)notify));
        this.validSign((BaseDto)notify);
        RefundNotifyBo refundNotifyBo = new RefundNotifyBo();
        refundNotifyBo.setDriveFlowParam(BaseFlowDef.BASE_RETURN_TOB.getFlowId(), BaseFlowDef.BASE_RETURN_TOB.getFlowName(), orderNo);
        refundNotifyBo.setRefundNotifyDto(RefundNotifyDto.init((String)orderNo, (String)notify.getRefundStatus(), (String)notify.getRefundId()));
        ReturnConfirmRefundTobBo returnConfirmRefundTobBo = new ReturnConfirmRefundTobBo();
        returnConfirmRefundTobBo.setRefundNotifyDto(RefundNotifyDto.init((String)orderNo, (String)notify.getRefundStatus(), (String)notify.getRefundId()));
        this.logger.info("\u7ec4\u88c5\u9000\u6b3e\u6d41\u7a0breturnConfirmRefundTobBo[{}]", JSON.toJSON((Object)returnConfirmRefundTobBo));
        if (!StringUtils.isEmpty((CharSequence)refundNo)) {
            RefundEo refundEoSearch = new RefundEo();
            refundEoSearch.setRefundNo(refundNo);
            RefundEo refundEo = (RefundEo)this.refundDas.selectOne((BaseEo)refundEoSearch);
            returnConfirmRefundTobBo.setRefundEo(refundEo);
            this.logger.info("\u67e5\u627erefundEo[{}]", (Object)(refundEo == null ? "\u672a\u627e\u5230" : "\u627e\u5230"));
            ReturnEo returnEo = refundEo == null || refundEo.getReturnNo() == null ? null : this.returnDas.selectByTradeNo(refundEo.getReturnNo());
            this.logger.info("\u67e5\u627ereturnEo[{}]", (Object)(returnEo == null ? "\u672a\u627e\u5230" : "\u627e\u5230"));
            returnConfirmRefundTobBo.setReturnEo(returnEo);
        }
        this.logger.info("\u7ec4\u88c5\u9000\u6b3e\u6d41\u7a0b\u7ed3\u675freturnConfirmRefundTobBo[{}]", JSON.toJSON((Object)returnConfirmRefundTobBo));
        this.returnFlowTobAction.toBHandleRefundNotify(returnConfirmRefundTobBo);
        return "success";
    }

    public String toBHandleRefundNotify(String orderNo, String appKey, HttpServletRequest request) {
        return this.toBHandleRefundNotify(orderNo, appKey, request, null);
    }
}

