/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.apiimpl;

import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.IStorageOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderCreateDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.IThirdAfterSalesTobApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.AfterSalesItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnItemConfirmDetailReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnItemConfirmReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.action.ReturnFlowTobAction;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IAfterSalesService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IAfterSalesTobService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.conf.ext.domain.ReturnItemConfirmBo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IReturnRefundActionExtPt;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThirdAfterSalesTobApiImpl
implements IThirdAfterSalesTobApi {
    @Resource
    private ReturnFlowTobAction returnFlowTobAction;
    @CubeResource
    private IReturnRefundActionExtPt returnRefundActionExtPt;
    @Resource
    private IStorageOrderApi storageOrderApi;
    @Autowired
    private IAfterSalesTobService afterSalesTobService;
    @Autowired
    private IAfterSalesService afterSalesService;
    @Resource
    private ITradeItemService tradeItemService;
    @Autowired
    private IItemSkuQueryApi itemSkuQueryApi;
    @Autowired
    private IWarehouseQueryApi warehouseQueryApi;
    @Autowired
    private IItemQueryApi itemQueryApi;
    @Resource
    private IContext context;

    public RestResponse<String> confirmReturnItem(ReturnReqDto returnReqDto) {
        this.saveReturnItem(returnReqDto);
        WarehouseRespDto warehouseRespDto = (WarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.warehouseQueryApi.queryWarehouseByCode(returnReqDto.getWarehouseCode(), null));
        List itemIds = returnReqDto.getAfterSalesItems().stream().map(AfterSalesItemReqDto::getItemSerial).filter(e -> StringUtils.isNumeric((CharSequence)e)).map(Long::valueOf).collect(Collectors.toList());
        List itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryByItemIds(StringUtils.join(itemIds, (String)",")));
        Map<Long, ItemRespDto> itemRespDtoMap = itemRespDtos.stream().collect(Collectors.toMap(ItemRespDto::getId, e -> e, (e1, e2) -> e1));
        List returnItemConfirmDetailReqDtos = returnReqDto.getAfterSalesItems().stream().map(e -> {
            ReturnItemConfirmDetailReqDto returnItemConfirmDetailReqDto = new ReturnItemConfirmDetailReqDto();
            CubeBeanUtils.copyProperties((Object)returnItemConfirmDetailReqDto, (Object)e, (String[])new String[0]);
            returnItemConfirmDetailReqDto.setBuyNum(Long.valueOf(0L));
            returnItemConfirmDetailReqDto.setCurrentNum(Long.valueOf(e.getItemNum().longValue()));
            returnItemConfirmDetailReqDto.setItemId(e.getItemSerial());
            if (itemRespDtoMap.containsKey(Long.valueOf(e.getSkuSerial()))) {
                ItemRespDto itemRespDto = (ItemRespDto)itemRespDtoMap.get(Long.valueOf(e.getSkuSerial()));
                returnItemConfirmDetailReqDto.setItemName(itemRespDto.getName());
            }
            return returnItemConfirmDetailReqDto;
        }).collect(Collectors.toList());
        ReturnItemConfirmReqDto returnItemConfirmReqDto = new ReturnItemConfirmReqDto();
        returnItemConfirmReqDto.setInstanceId(this.context.instanceId());
        returnItemConfirmReqDto.setTenantId(this.context.tenantId());
        returnItemConfirmReqDto.setReturnItemConfirmDetailReqDtos(returnItemConfirmDetailReqDtos);
        returnItemConfirmReqDto.setReturnNo(returnReqDto.getReturnNo());
        if (warehouseRespDto != null) {
            returnItemConfirmReqDto.setWarehouseId(warehouseRespDto.getId());
        }
        ReturnItemConfirmBo returnItemConfirmBo = new ReturnItemConfirmBo();
        returnItemConfirmBo.setReturnItemConfirmReqDto(returnItemConfirmReqDto);
        returnItemConfirmBo.setDriveFlowParam(this.returnRefundActionExtPt.getFlowDefId(), this.returnRefundActionExtPt.getFlowDefName(), returnItemConfirmReqDto.getReturnNo());
        this.returnFlowTobAction.confirmReturnItem(returnItemConfirmBo);
        if (returnItemConfirmReqDto.getStorageOrderId() != null) {
            StorageOrderCreateDto storageOrderCreateDto = new StorageOrderCreateDto();
            StorageOrderReqDto storageOrderReqDto = new StorageOrderReqDto();
            storageOrderReqDto.setId(returnItemConfirmReqDto.getStorageOrderId());
            storageOrderReqDto.setStatus(Integer.valueOf(6));
            storageOrderCreateDto.setStorageOrderReqDto(storageOrderReqDto);
            this.storageOrderApi.modifyStorageOrder(storageOrderCreateDto);
        }
        return new RestResponse();
    }

    private void saveReturnItem(ReturnReqDto returnReqDto) {
        List<ReturnItemEo> returnItemEos = returnReqDto.getAfterSalesItems().stream().map(bean -> {
            AfterSalesItemReqDto afterSalesItemReqDto = (AfterSalesItemReqDto)EoUtil.transformExtFieldsToDto((BaseVo)bean, (Class)this.returnRefundActionExtPt.getDetailDtoClass());
            ReturnItemEo returnItemEo = new ReturnItemEo();
            if (StringUtils.isNotBlank((CharSequence)bean.getOrderTradeNo())) {
                TradeItemEo tradeItemEo = this.tradeItemService.queryByTradeNoAndTradeItemNo(bean.getOrderTradeNo(), bean.getTradeItemNo());
                BigDecimal rebateAmount = tradeItemEo.getRebateAmount() == null ? BigDecimal.ZERO : tradeItemEo.getRebateAmount();
                BigDecimal divide = rebateAmount.divide(BigDecimal.valueOf(tradeItemEo.getItemNum().intValue()), 1);
                BeanUtils.copyProperties((Object)tradeItemEo, (Object)returnItemEo);
                returnItemEo.setId(null);
                returnItemEo.setCreatePerson(null);
                returnItemEo.setUpdatePerson(null);
                returnItemEo.setCreateTime(null);
                returnItemEo.setUpdateTime(null);
                returnItemEo.setItemId(tradeItemEo.getItemSerial());
                returnItemEo.setBrandId(tradeItemEo.getBrandSerial());
                returnItemEo.setSkuSerial(tradeItemEo.getSkuSerial());
                returnItemEo.setReturnNo(returnReqDto.getReturnNo());
                returnItemEo.setGift(tradeItemEo.getGift());
                returnItemEo.setItemNum(afterSalesItemReqDto.getItemNum());
                returnItemEo.setReturnRebate(divide.multiply(BigDecimal.valueOf(afterSalesItemReqDto.getItemNum().intValue())));
                returnItemEo.setRefundAmount(tradeItemEo.getItemPrice());
            } else {
                BeanUtils.copyProperties((Object)bean, (Object)returnItemEo);
                returnItemEo.setId(null);
                returnItemEo.setCreatePerson(null);
                returnItemEo.setUpdatePerson(null);
                returnItemEo.setCreateTime(null);
                returnItemEo.setUpdateTime(null);
                if (StringUtils.isNumeric((CharSequence)bean.getSkuSerial())) {
                    ArrayList skuIds = Lists.newArrayList();
                    skuIds.add(Long.valueOf(bean.getSkuSerial()));
                    List itemSkuRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuQueryApi.queryBySkuId((List)skuIds));
                    if (CollectionUtils.isNotEmpty((Collection)itemSkuRespDtos)) {
                        ItemSkuRespDto itemSkuRespDto = (ItemSkuRespDto)itemSkuRespDtos.get(0);
                        returnItemEo.setItemId(itemSkuRespDto.getItemId().toString());
                        returnItemEo.setSkuSerial(itemSkuRespDto.getId().toString());
                        returnItemEo.setReturnNo(returnReqDto.getReturnNo());
                        returnItemEo.setGift(bean.getGift());
                        returnItemEo.setItemNum(afterSalesItemReqDto.getItemNum());
                        returnItemEo.setRefundAmount(bean.getItemPrice());
                    }
                }
            }
            return returnItemEo;
        }).collect(Collectors.toList());
        this.afterSalesTobService.batchInsertReturnItems(returnItemEos);
    }

    public RestResponse<String> modifyReturn(ReturnTobReqDto returnTobReqDto) {
        this.afterSalesTobService.modifyReturn(returnTobReqDto);
        return RestResponse.SUCCEED;
    }
}

