/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.apiimpl.tob.query;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.BasicConfigEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BasicConfigReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BasicConfigRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IBasicConfigQueryApi;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IBasicConfigService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BasicConfigQueryApiImpl
implements IBasicConfigQueryApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicConfigQueryApiImpl.class);
    @Resource
    private IBasicConfigService basicConfigService;
    @Autowired
    private ICustomerExtQueryApi customerExtQueryApi;
    @Autowired
    private IContext context;

    public RestResponse<BasicConfigRespDto> queryById(Long id) {
        return new RestResponse((Object)this.basicConfigService.queryById(id));
    }

    public RestResponse<PageInfo<BasicConfigRespDto>> queryByPage(BasicConfigReqDto basicConfigReqDto) {
        return new RestResponse(this.basicConfigService.queryByPage(basicConfigReqDto));
    }

    public RestResponse<BasicConfigRespDto> queryCurrOrgConfig(BasicConfigEnum basicConfigEnum) {
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        LOGGER.info("\u67e5\u8be2\u5f53\u524d\u767b\u9646\u7528\u6237\u5bf9\u5e94\u7ec4\u7ec7\u7684\u57fa\u7840\u914d\u7f6e\uff0c\u5f53\u524d\u767b\u9646\u7528\u6237\u7ec4\u7ec7id:{}", (Object)orgId);
        if (orgId == null) {
            return new RestResponse();
        }
        return new RestResponse((Object)this.basicConfigService.queryByCodeAndType(basicConfigEnum.getCode(), basicConfigEnum.getType(), orgId));
    }

    public RestResponse<BasicConfigRespDto> queryConfigByOrgIdAndCode(Long orgId, BasicConfigEnum basicConfigEnum) {
        if (orgId == null) {
            throw new BizException("\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new RestResponse((Object)this.basicConfigService.queryByCodeAndType(basicConfigEnum.getCode(), basicConfigEnum.getType(), orgId));
    }
}

