/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.action;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.IStorageOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.StorageCategoryEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsReceiveNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderCreateDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageOrderCombineRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IMqMessageApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.order.adjust.ITcbjAdjustApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IStorageOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.MqContentOrderDetailDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.MqContentOrderDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.req.TcbjAdjustUpReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveNoticeOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.base.ContactDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.IBalanceApi;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.ChangeTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalanceReturnReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.BasicConfigEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayResultEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundResultEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReturnTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.SaleChannelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.AuditStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.MqContentOrderExtDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.flow.RefundNotifyDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.FinReviewToBReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.RefundTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnAuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnConfirmRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnItemConfirmReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ApplyReturnItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BasicConfigRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IAfterSalesService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IBasicConfigService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.tob.IOptLogService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.BeanUtil;
import com.dtyunxi.yundt.cube.center.trade.conf.ext.domain.FinReviewTobAuditBo;
import com.dtyunxi.yundt.cube.center.trade.conf.ext.domain.ReturnAuditTobBo;
import com.dtyunxi.yundt.cube.center.trade.conf.ext.domain.ReturnCheckTobBo;
import com.dtyunxi.yundt.cube.center.trade.conf.ext.domain.ReturnConfirmRefundTobBo;
import com.dtyunxi.yundt.cube.center.trade.conf.ext.domain.ReturnItemConfirmBo;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderAuditDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefundDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefundDetailDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefundItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderAuditEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PayRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundDetailEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdRefundEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdReturnItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.tob.OptLogEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.ReturnBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.ReturnCreateBo;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="returnFlowTobAction")
@ActionNodeComponent
public class ReturnFlowTobAction {
    private static Logger logger = LoggerFactory.getLogger(ReturnFlowTobAction.class);
    @Resource
    private OrderAuditDas orderAuditDas;
    @Resource
    private ReturnDas returnDas;
    @Resource
    private RefundDetailDas refundDetailDas;
    @Resource
    private RefundDas refundDas;
    @Resource
    private IBalanceApi iBalanceApi;
    @Resource
    private IStorageOrderApi storageOrderApi;
    @Resource
    private ReturnItemDas returnItemDas;
    @Resource
    private RefundItemDas refundItemDas;
    @Resource
    private DeliveryItemDas deliveryItemDas;
    @Resource
    private IStorageOrderQueryApi iStorageOrderQueryApi;
    @Resource
    private ICargoQueryApi cargoQueryApi;
    @Resource
    private IPayService payService;
    @Autowired
    private IBasicConfigService basicConfigService;
    @Resource
    IOptLogService optLogService;
    @Autowired
    private ICustomerExtQueryApi customerExtQueryApi;
    @Autowired
    private IContext context;
    @Autowired
    private IShopQueryApi shopQueryApi;
    @Autowired
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Autowired
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ITcbjAdjustApi tcbjAdjustApi;
    @Resource
    private IMqMessageApi mqMessageApi;
    @Resource
    private IAfterSalesService afterSalesService;
    @Autowired
    private ITcbjInventoryApi tcbjInventoryApi;
    @Resource
    private ICsReceiveNoticeOrderApi createReceiveOrderProcess;

    @ActionNode(entity=ReturnEo.class, name="\u8d22\u52a1\u590d\u6838")
    @Transactional(rollbackFor={Exception.class})
    public FinReviewTobAuditBo finReviewOrder(FinReviewTobAuditBo finReviewTobAuditBo) {
        FinReviewToBReqDto returnReviewReqDto = finReviewTobAuditBo.getFinReviewToBReqDto();
        OrderAuditEo orderAuditEo = OrderAuditEo.newInstance();
        CubeBeanUtils.copyProperties((Object)orderAuditEo, (Object)returnReviewReqDto, (String[])new String[0]);
        orderAuditEo.setOrderType(OptBizTypeEnum.RETURN.getType());
        orderAuditEo.setTradeNo(returnReviewReqDto.getReturnNo());
        this.orderAuditDas.insert((BaseEo)orderAuditEo);
        finReviewTobAuditBo.setAuditResult(1 == returnReviewReqDto.getAuditResult() ? "pass" : "reject");
        ReturnEo returnEo = finReviewTobAuditBo.getReturnEo();
        if (returnEo == null) {
            returnEo = this.returnDas.selectByTradeNo(finReviewTobAuditBo.getReturnNo());
            finReviewTobAuditBo.setReturnEo(returnEo);
        }
        returnEo.setReturnReason(returnReviewReqDto.getReqReason());
        returnEo.setRefundAmount(returnReviewReqDto.getRefundTotalAmount());
        returnEo.setTotalAmount(returnReviewReqDto.getRefundTotalAmount());
        this.returnDas.update((BaseEo)returnEo);
        StringBuilder description = new StringBuilder();
        if (0 == returnReviewReqDto.getAuditResult()) {
            description.append("\u9000\u8ba2\u5355\u9000\u6b3e\u590d\u5ba1\u4e0d\u901a\u8fc7\uff0c\u539f\u56e0\uff1a");
            description.append(returnReviewReqDto.getAuditDesc());
        } else {
            description.append("\u9000\u8ba2\u5355\u9000\u6b3e\u5ba1\u6838\u901a\u8fc7");
        }
        OptLogEo optLogEo = this.buildOptLogEo(returnReviewReqDto.getReturnNo(), OptBizTypeEnum.RETURN.getType(), returnReviewReqDto.getAuditor(), OptTypeEnum.REFUND_AUDIT.getType(), description.toString());
        this.optLogService.addBoOptLog(optLogEo);
        return finReviewTobAuditBo;
    }

    private OptLogEo buildOptLogEo(String returnNo, String bizType, String optPerson, String optType, String auditDesc) {
        OptLogEo optLogEo = new OptLogEo();
        optLogEo.setBizType(bizType);
        optLogEo.setBizNo(returnNo);
        optLogEo.setOptTime(new Date());
        optLogEo.setOptPerson(optPerson);
        optLogEo.setOptType(optType);
        optLogEo.setDescription(auditDesc);
        return optLogEo;
    }

    @ActionNode(entity=ReturnEo.class, name="\u53d1\u8d77\u9000\u6b3e")
    @Transactional(rollbackFor={Exception.class})
    public String startRefund(FinReviewTobAuditBo finReviewTobAuditBo) {
        FinReviewToBReqDto finReviewToBReqDto = finReviewTobAuditBo.getFinReviewToBReqDto();
        ReturnEo returnEo = finReviewTobAuditBo.getReturnEo();
        if (returnEo == null) {
            returnEo = this.returnDas.selectByTradeNo(finReviewToBReqDto.getReturnNo());
            finReviewTobAuditBo.setReturnEo(returnEo);
        }
        RefundTobReqDto refundTobReqDto = finReviewToBReqDto.getRefundTobReqDto();
        refundTobReqDto.setRefundNo(TradeUtil.generateTradeNo());
        refundTobReqDto.setTradeNo(refundTobReqDto.getRefundNo());
        RefundEo refundEo = new RefundEo();
        CubeBeanUtils.copyProperties((Object)refundEo, (Object)refundTobReqDto, (String[])new String[0]);
        refundEo.setRefundTime(new Date());
        refundEo.setCreateTime(new Date());
        refundEo.setRefundPaymentType("2");
        refundEo.setRefundFreightAmount(BigDecimal.ZERO);
        refundEo.setDiscountRefundAmount(BigDecimal.ZERO);
        refundEo.setShopId(Long.valueOf(Long.parseLong(returnEo.getShopId())));
        refundEo.setPayMethod(finReviewToBReqDto.getPayMethod());
        refundEo.setPayNo("");
        refundEo.setInstanceId(returnEo.getInstanceId());
        refundEo.setTenantId(returnEo.getTenantId());
        refundEo.setStatus("refundStatus", PayResultEnum.ACCEPT.getName());
        refundEo.setRefundItemAmount(refundTobReqDto.getRefundTotalAmount());
        ArrayList refundDetailEoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)refundTobReqDto.getRefundDetails())) {
            List refundDetailEos = refundTobReqDto.getRefundDetails().stream().map(bean -> {
                RefundDetailEo refundDetailEo = RefundDetailEo.newInstance();
                CubeBeanUtils.copyProperties((Object)refundDetailEo, (Object)bean, (String[])new String[0]);
                refundDetailEo.setRefundNo(refundEo.getRefundNo());
                refundDetailEo.setPayNo(refundEo.getPayNo());
                return refundDetailEo;
            }).collect(Collectors.toList());
            refundDetailEoList.addAll(refundDetailEos);
        }
        logger.info("\u552e\u540e\u5355{}\u7684\u6e20\u9053\u6765\u6e90={}", (Object)returnEo.getReturnNo(), (Object)returnEo.getSaleChannel());
        if (SaleChannelEnum.SALECHANNEL_ZYSC.getCode().equals(returnEo.getSaleChannel())) {
            this.refundDas.insert((BaseEo)refundEo);
            if (CollectionUtils.isNotEmpty((Collection)refundDetailEoList)) {
                this.refundDetailDas.insertBatch((List)refundDetailEoList);
            }
            this.saveRefundItem(returnEo.getReturnNo());
        }
        return "TRUE";
    }

    private void saveRefundItem(String returnNo) {
        List returnItemEos = this.returnItemDas.getReturnItemEos(Arrays.asList(returnNo));
        if (CollectionUtils.isNotEmpty((Collection)returnItemEos)) {
            List refundItems = BeanUtil.copyList((List)returnItemEos, RefundItemEo.class);
            refundItems.forEach(vo -> vo.setId(null));
            this.refundItemDas.insertBatch(refundItems);
        }
    }

    @ActionNode(entity=ReturnEo.class, name="\u5904\u7406\u9000\u6b3e")
    @Transactional(rollbackFor={Exception.class})
    public String processRefund(FinReviewTobAuditBo finReviewTobAuditBo) {
        ReturnEo returnEo = finReviewTobAuditBo.getReturnEo();
        RefundTobReqDto refundTobReqDto = finReviewTobAuditBo.getFinReviewToBReqDto().getRefundTobReqDto();
        logger.info("\u66f4\u65b0\u9000\u6b3e\u8bb0\u5f55\u72b6\u6001");
        List refundEoList = this.refundDas.selectByReturnNo(returnEo.getReturnNo());
        RefundEo refundEo = (RefundEo)refundEoList.get(0);
        refundEo.setStatus("refundStatus", PayResultEnum.SUCCESS.getName());
        refundEo.setRefundTime(new Date());
        int i = this.refundDas.updateSelective((BaseEo)refundEo);
        logger.info("\u66f4\u65b0\u9000\u8ba2\u5355={} \u7684\u9000\u6b3e\u8bb0\u5f55\uff1ai={}", (Object)refundTobReqDto.getReturnNo(), (Object)i);
        return "success";
    }

    @ActionNode(entity=ReturnEo.class, name="\u552e\u540e\u7533\u8bf7\u5ba1\u6838")
    @Transactional(rollbackFor={Exception.class})
    public ReturnAuditTobBo auditReturnOrder(ReturnAuditTobBo returnAuditBo) {
        ReturnAuditReqDto returnAuditReqDto = returnAuditBo.getReturnAuditReq();
        OrderAuditEo orderAuditEo = OrderAuditEo.newInstance();
        CubeBeanUtils.copyProperties((Object)orderAuditEo, (Object)returnAuditReqDto, (String[])new String[0]);
        orderAuditEo.setOrderType(OptBizTypeEnum.RETURN.getType());
        orderAuditEo.setTradeNo(returnAuditReqDto.getReturnNo());
        this.orderAuditDas.insert((BaseEo)orderAuditEo);
        returnAuditBo.setAuditResult(returnAuditReqDto.getAuditStatus());
        return returnAuditBo;
    }

    @ActionNode(entity=ReturnEo.class, name="\u66f4\u65b0\u901a\u77e5\u5355\u72b6\u6001")
    @Transactional(rollbackFor={Exception.class})
    public ReturnAuditTobBo changeOrderStatus(ReturnAuditTobBo returnAuditBo) {
        String returnNo = returnAuditBo.getReturnNo();
        logger.info("\u9000\u8d27\u5ba1\u6838\u62d2\u7edd\uff0c\u4fee\u6539\u901a\u77e5\u5355\u72b6\u6001\u5165\u53c2\uff0c\u524d\u7f6e\u4e1a\u52a1\u5355\u53f7\uff1a{}\uff0c\u72b6\u6001\uff1a{}", (Object)returnNo, (Object)3013);
        return returnAuditBo;
    }

    @ActionNode(entity=ReturnEo.class, name="\u5ba1\u6838\u901a\u8fc7")
    @Transactional(rollbackFor={Exception.class})
    public ReturnAuditTobBo auditPass(ReturnAuditTobBo returnAuditBo) {
        returnAuditBo.setReturnType(null != returnAuditBo.getReturnEo() ? returnAuditBo.getReturnEo().getReturnType() : ReturnTypeEnum.RETURN_BASE.getName());
        return returnAuditBo;
    }

    @ActionNode(entity=ReturnEo.class, name="\u9000\u6b3e\u5ba1\u6838")
    @Transactional(rollbackFor={Exception.class})
    public ReturnAuditTobBo auditRefundOrder(ReturnAuditTobBo returnAuditBo) {
        List collect;
        RefundEo queryRefundEo = RefundEo.newInstance();
        queryRefundEo.setReturnNo(returnAuditBo.getReturnAuditReq().getReturnNo());
        List refundEos = this.refundDas.select((BaseEo)queryRefundEo);
        if (AuditStatusEnum.PASS.getType().equals(returnAuditBo.getReturnAuditReq().getAuditStatus()) && CollectionUtils.isEmpty(collect = refundEos.stream().filter(bean -> RefundStatusEnum.SUCCESS.getName().equals(bean.getRefundStatus())).collect(Collectors.toList()))) {
            throw new BizException("\u9000\u6b3e\u5ba1\u6838\u524d\u8bf7\u5148\u6dfb\u52a0\u9000\u6b3e\u8bb0\u5f55\u540e\u518d\u5ba1\u6838\u901a\u8fc7\u3002");
        }
        if (AuditStatusEnum.REJECT.getType().equals(returnAuditBo.getReturnAuditReq().getAuditStatus()) && CollectionUtils.isNotEmpty((Collection)refundEos)) {
            refundEos.stream().forEach(bean -> {
                bean.setRefundStatus(RefundStatusEnum.FAIL.getName());
                this.refundDas.updateSelective((BaseEo)bean);
            });
        }
        this.auditReturnOrder(returnAuditBo);
        return returnAuditBo;
    }

    @ActionNode(entity=ReturnEo.class, name="\u552e\u540e\u5165\u5e93")
    @Transactional(rollbackFor={Exception.class})
    public ReturnItemConfirmBo confirmReturnItem(ReturnItemConfirmBo returnItemConfirmBo) {
        ReturnItemConfirmReqDto returnItemConfirmReqDto = returnItemConfirmBo.getReturnItemConfirmReqDto();
        ReturnEo queryReturnEo = ReturnEo.newInstance();
        queryReturnEo.setReturnNo(returnItemConfirmReqDto.getReturnNo());
        List returnEos = this.returnDas.select((BaseEo)queryReturnEo);
        StorageOrderCreateDto requestDto = new StorageOrderCreateDto();
        StorageOrderReqDto storageOrderReqDto = new StorageOrderReqDto();
        CubeBeanUtils.copyProperties((Object)storageOrderReqDto, (Object)returnItemConfirmReqDto, (String[])new String[0]);
        storageOrderReqDto.setWarehouseId(returnItemConfirmReqDto.getWarehouseId());
        if (CollectionUtils.isNotEmpty((Collection)returnEos)) {
            ReturnEo returnEo = (ReturnEo)returnEos.get(0);
            storageOrderReqDto.setOrderNo(returnEo.getOrderTradeNo());
        }
        storageOrderReqDto.setBusinessId(returnItemConfirmReqDto.getReturnNo());
        storageOrderReqDto.setType(Integer.valueOf(10));
        storageOrderReqDto.setCategory(StorageCategoryEnum.CATEGORY_IN.getCategory());
        storageOrderReqDto.setStatus(Integer.valueOf(4));
        requestDto.setStorageOrderReqDto(storageOrderReqDto);
        List storageOrderDetailReqDtos = returnItemConfirmReqDto.getReturnItemConfirmDetailReqDtos().stream().map(bean -> {
            StorageOrderDetailReqDto storageOrderDetailReqDto = new StorageOrderDetailReqDto();
            storageOrderDetailReqDto.setNum(bean.getCurrentNum());
            storageOrderDetailReqDto.setWarehouseId(returnItemConfirmReqDto.getWarehouseId());
            if (StringUtils.isNotEmpty((CharSequence)bean.getCargoSerial())) {
                storageOrderDetailReqDto.setCargoId(Long.valueOf(Long.parseLong(bean.getCargoSerial())));
            }
            HashMap<String, String> extFields = new HashMap<String, String>();
            extFields.put("extension", bean.getSkuSerial() + "_" + bean.getGift());
            storageOrderDetailReqDto.setExtFields(extFields);
            storageOrderDetailReqDto.setStatus("VERIFIED");
            return storageOrderDetailReqDto;
        }).collect(Collectors.toList());
        requestDto.setStorageOrderDetailReqDtoList(storageOrderDetailReqDtos);
        Long storageOrderId = (Long)RestResponseHelper.extractData((RestResponse)this.storageOrderApi.addStorageOrder(requestDto));
        returnItemConfirmReqDto.setStorageOrderId(storageOrderId);
        return returnItemConfirmBo;
    }

    @ActionNode(entity=ReturnEo.class, name="\u5224\u65ad\u662f\u5426\u5df2\u5168\u90e8\u5165\u5e93")
    @Transactional(rollbackFor={Exception.class})
    public ReturnCheckTobBo checkIsAllInStorage(ReturnCheckTobBo returnCheckTobBo) {
        Boolean flag = false;
        ReturnEo returnEo = returnCheckTobBo.getReturnEo();
        JSONObject sjon = new JSONObject();
        sjon.put("category", (Object)"CATEGORY_IN");
        sjon.put("groupId", (Object)"");
        sjon.put("businessId", (Object)returnEo.getReturnNo());
        sjon.put("instanceId", (Object)returnEo.getInstanceId());
        sjon.put("tenantId", (Object)returnEo.getTenantId());
        RestResponse pageInfoRestResponse = this.iStorageOrderQueryApi.queryFilterByPage(sjon.toJSONString(), Integer.valueOf(1), Integer.valueOf(999));
        PageInfo storageOrderCombineRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        List storageOrderCombineRespDtos = storageOrderCombineRespDtoPageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)storageOrderCombineRespDtos)) {
            logger.info("\u552e\u540e\u5355\uff1a{},\u5e93\u5b58\u4e2d\u5fc3\u5165\u5e93\u4fe1\u606f{}", (Object)returnEo.getReturnNo(), (Object)JSONObject.toJSONString((Object)storageOrderCombineRespDtos));
            List<StorageOrderCombineRespDto> target = storageOrderCombineRespDtos.stream().filter(bean -> "6".equals(bean.getStorageOrderRespDto().getStatus().toString())).collect(Collectors.toList());
            Map<String, Integer> itemInNum = this.getItemInNum(target);
            logger.info("\u552e\u540e\u5355\uff1a{},\u5165\u5e93\u4fe1\u606f{}", (Object)returnEo.getReturnNo(), (Object)JSONObject.toJSONString(itemInNum));
            ReturnItemEo queryReturnItemEo = ReturnItemEo.newInstance();
            queryReturnItemEo.setReturnNo(returnEo.getReturnNo());
            List returnItemEos = this.returnItemDas.select((BaseEo)queryReturnItemEo);
            if (CollectionUtils.isNotEmpty((Collection)returnItemEos)) {
                Map<String, List<ReturnItemEo>> returnItemBycargoMap = returnItemEos.stream().collect(Collectors.groupingBy(StdReturnItemEo::getSkuSerial));
                for (Map.Entry<String, List<ReturnItemEo>> returnItemEnteryMap : returnItemBycargoMap.entrySet()) {
                    flag = true;
                    String key = returnItemEnteryMap.getKey();
                    List<ReturnItemEo> value = returnItemEnteryMap.getValue();
                    if (!CollectionUtils.isNotEmpty(value)) continue;
                    Integer returnNum = value.stream().map(ReturnItemEo::getReturnNum).reduce(Integer::sum).orElse(0);
                    Integer inNum = itemInNum.get(key);
                    logger.info("\u552e\u540e\u5355\uff1a{},\u5e94\u552e\u540e\u6570\u91cf\uff1a{}", (Object)returnEo.getReturnNo(), (Object)returnNum);
                    if (null == inNum || returnNum == inNum) continue;
                    flag = false;
                    break;
                }
            }
        }
        if (flag.booleanValue()) {
            returnCheckTobBo.setResult("TRUE");
        } else {
            returnCheckTobBo.setResult("FALSE");
        }
        if ("PART_REFUND".equals(returnEo.getStatus("bizStatus")) || "WAIT_REFUND".equals(returnEo.getStatus("bizStatus"))) {
            returnCheckTobBo.setResult("default");
        }
        return returnCheckTobBo;
    }

    @ActionNode(entity=ReturnEo.class, name="\u5168\u90e8\u5165\u5e93\uff08\u4ec5\u8bb0\u5f55\u65e5\u5fd7\uff09")
    public ReturnBo receptItemAll(ReturnBo returnBo) {
        returnBo.getReturnEo().setUpdateTime(new Date());
        this.optLogService.saveOptLog(OptBizTypeEnum.RETURN.getType(), returnBo.getReturnEo().getReturnNo(), OptTypeEnum.RETURN_RECEIVE_ALL.getType(), "\u9000\u8ba2\u5355\u5df2\u6536\u8d27\u5165\u5e93");
        return returnBo;
    }

    @ActionNode(entity=ReturnEo.class, name="\u5224\u65ad\u662f\u5426\u5df2\u5b8c\u5355")
    @Transactional(rollbackFor={Exception.class})
    public ReturnItemConfirmBo checkIsComplete(ReturnItemConfirmBo returnItemConfirmBo) {
        returnItemConfirmBo.setResult("FALSE");
        if (null != returnItemConfirmBo.getReturnEo() && "RETURN_ONLY".equals(returnItemConfirmBo.getReturnEo().getReturnType())) {
            returnItemConfirmBo.setResult("TRUE");
        }
        return returnItemConfirmBo;
    }

    @ActionNode(entity=ReturnEo.class, name="\u786e\u8ba4\u9000\u6b3e")
    @Transactional(rollbackFor={Exception.class})
    public String doRefund(ReturnConfirmRefundTobBo returnConfirmRefundTobBo) {
        PayRecordEo payRecordEo;
        ReturnConfirmRefundReqDto returnConfirmRefundReqDto = returnConfirmRefundTobBo.getReturnConfirmRefundReqDto();
        if (CollectionUtils.isEmpty((Collection)returnConfirmRefundReqDto.getRefundNos())) {
            throw new BizException("\u53c2\u6570\u5f02\u5e38");
        }
        ReturnEo returnEo = this.returnDas.selectByTradeNo(returnConfirmRefundReqDto.getReturnNo());
        List payRecordEos = this.payService.getPayRecordSuccessByOrderNo(returnEo.getOrderTradeNo());
        if (CollectionUtils.isEmpty((Collection)payRecordEos)) {
            throw new BizException("\u627e\u4e0d\u5230\u6210\u529f\u652f\u4ed8\u8bb0\u5f55");
        }
        BigDecimal totalAmout = returnEo.getTotalAmount();
        RefundEo tempRefundEo = RefundEo.newInstance();
        tempRefundEo.setReturnNo(returnConfirmRefundReqDto.getReturnNo());
        List refundEos = this.refundDas.select((BaseEo)tempRefundEo);
        if (CollectionUtils.isNotEmpty((Collection)refundEos)) {
            BigDecimal refundedAmount = refundEos.stream().filter(bean -> PayResultEnum.SUCCESS.getName().equals(bean.getStatus("refundStatus")) || returnConfirmRefundReqDto.getRefundNos().contains(bean.getRefundNo())).map(StdRefundEo::getRefundTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            logger.info("\u552e\u540e\u5355\uff1a{}\uff0c\u5e94\u9000\u91d1\u989d\uff1a{}\uff0c\u5df2\u9000\u91d1\u989d+\u672c\u6b21\u9000\u6b3e\u91d1\u989d\uff1a{}", new Object[]{returnConfirmRefundReqDto.getReturnNo(), totalAmout, refundedAmount});
            BigDecimal subtract = refundedAmount.subtract(totalAmout);
            if (null != subtract && subtract.compareTo(BigDecimal.ZERO) > 0) {
                throw new BizException("\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5e94\u9000\u91d1\u989d");
            }
        }
        if (returnEo.getReturnRebate() != null && returnEo.getReturnRebate().compareTo(BigDecimal.ZERO) > 0) {
            BalanceReturnReqDto balanceReturnReqDto = new BalanceReturnReqDto();
            balanceReturnReqDto.setChangeType(ChangeTypeEnum.RETURN_ORDER.toCode());
            balanceReturnReqDto.setOrderNo(((PayRecordEo)payRecordEos.get(0)).getOrderNo());
            balanceReturnReqDto.setRefundNo(CollectionUtils.isEmpty((Collection)returnConfirmRefundReqDto.getRefundNos()) ? null : (String)returnConfirmRefundReqDto.getRefundNos().get(0));
            balanceReturnReqDto.setReturnAmount(returnEo.getReturnRebate());
            balanceReturnReqDto.setUserId(Long.valueOf(returnEo.getCustomerId()));
            this.iBalanceApi.returnBalance(balanceReturnReqDto);
        }
        if (StringUtils.isNotEmpty((CharSequence)(payRecordEo = (PayRecordEo)payRecordEos.get(0)).getParentPayNo()) && !payRecordEo.getParentPayNo().equals("0")) {
            payRecordEo = this.payService.getPayRecordByTradeNo(payRecordEo.getParentPayNo());
        }
        if ("OFFLINE_AMOUNT_PAY".equals(payRecordEo.getPayMethod()) || "OFFLINE_PUBLIC_REMIT_PAY".equals(payRecordEo.getPayMethod()) || "STORED_AMOUNT_PAY".equals(payRecordEo.getPayMethod()) || "CREDIT_PAY".equals(payRecordEo.getPayMethod())) {
            returnConfirmRefundReqDto.getRefundNos().stream().forEach(bean -> {
                RefundEo queryRefundEo = RefundEo.newInstance();
                queryRefundEo.setRefundNo(bean);
                RefundEo refundEo = (RefundEo)this.refundDas.selectOne((BaseEo)queryRefundEo);
                refundEo.setStatus("refundStatus", PayResultEnum.SUCCESS.getName());
                refundEo.setRefundTime(new Date());
                this.refundDas.updateSelective((BaseEo)refundEo);
            });
            return "success";
        }
        return "fail";
    }

    @ActionNode(entity=ReturnEo.class, name="\u7b49\u5f85\u9000\u6b3e\u7ed3\u679c")
    @Transactional(rollbackFor={Exception.class})
    public String toBHandleRefundNotify(ReturnConfirmRefundTobBo returnConfirmRefundTobBo) {
        logger.info("\u6536\u5230\u9000\u6b3e\u901a\u77e5\u7b49\u5f85\u9000\u6b3e\u7ed3\u679c,\u5165\u53c2\u89e3\u6790[{}]", JSON.toJSON((Object)returnConfirmRefundTobBo));
        RefundNotifyDto refundNotifyBo = returnConfirmRefundTobBo.getRefundNotifyDto();
        RefundEo refundEo = returnConfirmRefundTobBo.getRefundEo();
        if (refundEo != null && RefundResultEnum.S.getName().equals(refundNotifyBo.getRefundStatus())) {
            refundEo.setStatus("refundStatus", PayResultEnum.SUCCESS.getName());
            refundEo.setRefundTime(new Date());
            this.refundDas.updateSelective((BaseEo)refundEo);
            return "success";
        }
        return "fail";
    }

    @ActionNode(entity=ReturnEo.class, name="\u5224\u65ad\u662f\u5426\u5df2\u90e8\u5206\u9000\u6b3e")
    @Transactional(rollbackFor={Exception.class})
    public String checkIsPartRefund(ReturnBo returnBo) {
        ReturnEo returnEo = returnBo.getReturnEo();
        if ("PART_REFUND".equals(returnEo.getStatus("bizStatus"))) {
            return "TRUE";
        }
        return "FALSE";
    }

    @ActionNode(entity=ReturnEo.class, name="\u5224\u65ad\u9000\u8d27\u9000\u6b3e\u662f\u5426\u81ea\u52a8\u5ba2\u670d\u5ba1\u6838")
    public String isAutoCSAudit(ReturnCreateBo returnBo) {
        logger.info("\u5224\u65ad\u9000\u8d27\u9000\u6b3e\u662f\u5426\u81ea\u52a8\u5ba2\u670d\u5ba1\u6838\uff0c\u5165\u53c2\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)returnBo));
        ReturnEo returnEo = returnBo.getReturnEo();
        String autoCSAudit = "FALSE";
        ShopBaseDto shopBaseDto = (ShopBaseDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryBaseById(Long.valueOf(returnEo.getShopId())));
        if (shopBaseDto == null) {
            returnBo.setAutoCSAudit(autoCSAudit);
            return autoCSAudit;
        }
        SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryById(shopBaseDto.getSellerId()));
        if (sellerRespDto == null) {
            returnBo.setAutoCSAudit(autoCSAudit);
            return autoCSAudit;
        }
        logger.info("\u5224\u65ad\u9000\u8d27\u9000\u6b3e\u662f\u5426\u81ea\u52a8\u5ba2\u670d\u5ba1\u6838\uff0c\u5ba2\u6237\u5bf9\u5e94\u7ec4\u7ec7id\u4fe1\u606f\uff1a{}", (Object)sellerRespDto.getOrganizationId());
        if (sellerRespDto.getOrganizationId() == null) {
            returnBo.setAutoCSAudit(autoCSAudit);
            return autoCSAudit;
        }
        BasicConfigRespDto basicConfigRespDto = this.basicConfigService.queryByCodeAndType(BasicConfigEnum.REFUND_CS_AUDIT.getCode(), BasicConfigEnum.REFUND_CS_AUDIT.getType(), sellerRespDto.getOrganizationId());
        if (basicConfigRespDto != null && "2".equals(basicConfigRespDto.getValue())) {
            autoCSAudit = "TRUE";
            returnBo.setAutoCSAudit(autoCSAudit);
        }
        return autoCSAudit;
    }

    @ActionNode(entity=ReturnEo.class, name="\u901a\u77e5\u81f3\u8425\u9500\u4e91")
    public ReturnCreateBo sendReciptInform(ReturnCreateBo returnBo) {
        String returnNo = returnBo.getReturnEo().getReturnNo();
        this.sendReciptInformToTcbj(returnNo);
        return returnBo;
    }

    public void sendReciptInformToTcbj(String returnNo) {
        ReturnDetailRespDto returnDetailRespDto = this.afterSalesService.queryReturnDetail(returnNo, "");
        logger.info("------------>\u83b7\u53d6\u552e\u540e\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)returnDetailRespDto));
        if (returnDetailRespDto == null) {
            logger.info("------------>\u83b7\u53d6\u552e\u540e\u5355\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)returnNo);
            return;
        }
        String orgCode = this.getOrgCode(returnDetailRespDto.getOrganizationId());
        CustomerRespDto customerRespDto = this.getCustomerDetail(returnDetailRespDto.getCustomerId());
        this.createReceiveOrder(returnDetailRespDto, returnNo);
        MqContentOrderExtDto mqContentOrderDto = new MqContentOrderExtDto();
        mqContentOrderDto.setOrgId(orgCode);
        mqContentOrderDto.setApplyerId(customerRespDto.getThirdPartyId());
        mqContentOrderDto.setApplyerName(customerRespDto.getName());
        mqContentOrderDto.setNo(returnDetailRespDto.getReturnNo());
        mqContentOrderDto.setDt(returnDetailRespDto.getCreateTime());
        mqContentOrderDto.setShippingAddress(null);
        mqContentOrderDto.setPhone(null);
        mqContentOrderDto.setContacts(null);
        mqContentOrderDto.setApproverId(this.getCurrentCustomer());
        mqContentOrderDto.setRemark(returnDetailRespDto.getRemark());
        mqContentOrderDto.setDepotNo(returnDetailRespDto.getWarehouseCode());
        mqContentOrderDto.setTotalMoney(Double.valueOf(returnDetailRespDto.getRefundAmount().doubleValue()));
        ArrayList<MqContentOrderDetailDto> detailList = new ArrayList<MqContentOrderDetailDto>();
        for (ApplyReturnItemRespDto item : returnDetailRespDto.getApplyReturnItemRespDtoList()) {
            MqContentOrderDetailDto detailDto = new MqContentOrderDetailDto();
            detailDto.setEasNo(item.getCargoSerial());
            detailDto.setActQuantity(item.getReturnNum());
            detailDto.setQuantity(item.getReturnNum());
            detailDto.setRemark(item.getRemark());
            detailDto.setBatchNum(null);
            detailDto.setPrice(Double.valueOf(item.getItemPrice().doubleValue()));
            detailDto.setActPrice(Double.valueOf(item.getItemPrice().doubleValue()));
            detailDto.setMoney(Double.valueOf(item.getItemAmount().doubleValue()));
            detailList.add(detailDto);
        }
        logger.info("------------>\u751f\u6210\u62a5\u6587\uff1a{}", (Object)JSONObject.toJSONString((Object)mqContentOrderDto));
        mqContentOrderDto.setOrderApplyItems(detailList);
        this.mqMessageApi.sendReceiveOrderInformMq((MqContentOrderDto)mqContentOrderDto);
    }

    private void createReceiveOrder(ReturnDetailRespDto returnDetailRespDto, String returnNo) {
        JSONObject jsonObject;
        ReturnEo returnEo = this.afterSalesService.getByTradeNo(returnNo);
        CsReceiveNoticeOrderAddReqDto tcbjNotiGenReqDto = new CsReceiveNoticeOrderAddReqDto();
        ContactDto contactDto = new ContactDto();
        if (StringUtils.isNotEmpty((CharSequence)returnEo.getBuyerAddrInfo()) && (jsonObject = JSONObject.parseObject((String)returnEo.getBuyerAddrInfo())) != null) {
            contactDto.setReciveName(jsonObject.getString("contact"));
            contactDto.setRecivePhone(jsonObject.getString("phone"));
            contactDto.setAddress(jsonObject.getString("address"));
            logger.info("\u4e0a\u95e8\u53d6\u8d27\u5730\u5740id{}", (Object)jsonObject.getString("id"));
        }
        tcbjNotiGenReqDto.setExternalOrderNo(returnDetailRespDto.getExtlReturnSerial());
        tcbjNotiGenReqDto.setShopId(Long.valueOf(returnDetailRespDto.getShopId()));
        tcbjNotiGenReqDto.setRemark(returnEo.getRemark());
        tcbjNotiGenReqDto.setContactDto(contactDto);
        tcbjNotiGenReqDto.setPreOrderNo(returnDetailRespDto.getReturnNo());
        tcbjNotiGenReqDto.setWarehouseCode(returnDetailRespDto.getWarehouseCode());
        ArrayList notiGenItemReqDtos = Lists.newArrayList();
        for (ApplyReturnItemRespDto item : returnDetailRespDto.getApplyReturnItemRespDtoList()) {
            CsReceiveNoticeOrderDetailAddReqDto dto = new CsReceiveNoticeOrderDetailAddReqDto();
            dto.setBatch(item.getBatchNo());
            dto.setCargoCode(item.getCargoSerial());
            dto.setPlanQuantity(new BigDecimal(item.getReturnNum()));
            notiGenItemReqDtos.add(dto);
        }
        tcbjNotiGenReqDto.setReceiveNoticeOrderDetailAddReqDtoList((List)notiGenItemReqDtos);
        tcbjNotiGenReqDto.setBusinessType(BusinessTypeEnum.INVOKE_CUBE_ORDER_TYPE_EXCHANGE_IN.getCode());
        RestResponse receiveOrderProcess = this.createReceiveOrderProcess.createReceiveOrderProcess(tcbjNotiGenReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)receiveOrderProcess);
    }

    private void updateInformOrder(String proNo, String status) {
        logger.info("------------>\u66f4\u65b0\u901a\u77e5\u5355\u72b6\u6001\uff1a{}:{}", (Object)proNo, (Object)status);
        TcbjAdjustUpReqDto tcbjAdjustUpReqDto = new TcbjAdjustUpReqDto();
        tcbjAdjustUpReqDto.setPreNo(proNo);
        tcbjAdjustUpReqDto.setStatus(status);
        this.tcbjAdjustApi.updateNoti(tcbjAdjustUpReqDto);
    }

    private String getCurrentCustomer() {
        RestResponse orgRest = this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId());
        RestResponse organizationDtoRestResponse = this.organizationQueryApi.queryById((Long)orgRest.getData(), "");
        if (ObjectUtil.isNotEmpty((Object)organizationDtoRestResponse.getData()) && ObjectUtil.isNotEmpty((Object)((OrganizationDto)organizationDtoRestResponse.getData()).getCode())) {
            return ((OrganizationDto)organizationDtoRestResponse.getData()).getCode();
        }
        return "";
    }

    private CustomerRespDto getCustomerDetail(String customerId) {
        if (StringUtils.isNotEmpty((CharSequence)customerId)) {
            Long id = Long.valueOf(customerId);
            RestResponse customerRespDtoRestResponse = this.customerQueryApi.queryById(id);
            logger.info("------------>\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)customerRespDtoRestResponse));
            if (ObjectUtil.isNotEmpty((Object)customerRespDtoRestResponse.getData())) {
                return (CustomerRespDto)customerRespDtoRestResponse.getData();
            }
        }
        return new CustomerRespDto();
    }

    private String getOrgCode(Long orgId) {
        RestResponse organizationDtoRestResponse = this.organizationQueryApi.queryById(orgId, "");
        logger.info("------------>\u83b7\u53d6\u79df\u6237\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)organizationDtoRestResponse));
        if (ObjectUtil.isNotEmpty((Object)organizationDtoRestResponse.getData())) {
            return ((OrganizationDto)organizationDtoRestResponse.getData()).getCode();
        }
        return "";
    }

    private Map<String, Integer> getItemInNum(List<StorageOrderCombineRespDto> target) {
        HashMap<String, Integer> returnedNumMap = new HashMap<String, Integer>();
        for (StorageOrderCombineRespDto storageOrderCombineRespDto : target) {
            for (StorageOrderDetailRespDto storageOrderDetailRespDto : storageOrderCombineRespDto.getDetailRespDtoList()) {
                String skuId = storageOrderDetailRespDto.getExtension();
                if (returnedNumMap.get(skuId) != null) {
                    returnedNumMap.put(skuId, (Integer)returnedNumMap.get(skuId) + storageOrderDetailRespDto.getNum().intValue());
                    continue;
                }
                returnedNumMap.put(skuId, storageOrderDetailRespDto.getNum().intValue());
            }
        }
        return returnedNumMap;
    }

    @ActionNode(entity=ReturnEo.class, name="\u53cd\u5ba1\u6838")
    @Transactional(rollbackFor={Exception.class})
    public ReturnAuditTobBo rejectAuditOrder(ReturnAuditTobBo returnAuditBo) {
        ReturnAuditReqDto returnAuditReqDto = returnAuditBo.getReturnAuditReq();
        returnAuditBo.setAuditResult(returnAuditReqDto.getAuditStatus());
        ReturnItemEo returnItemEo = new ReturnItemEo();
        returnItemEo.setReturnNo(returnAuditBo.getReturnNo());
        this.returnItemDas.logicDelete((BaseEo)returnItemEo);
        StringBuilder description = new StringBuilder();
        description.append("\u9000\u8ba2\u5355\u53cd\u5ba1\u6838\u6210\u529f\uff0c\u9000\u8ba2\u5355\u72b6\u6001\u56de\u9000\u5230\u5f85\u5ba1\u6838,\u5ba1\u6838\u610f\u89c1\uff1a");
        description.append(returnAuditReqDto.getAuditDesc());
        OptLogEo optLogEo = this.buildOptLogEo(returnAuditBo.getReturnNo(), OptBizTypeEnum.RETURN.getType(), returnAuditReqDto.getAuditor(), OptTypeEnum.RETURN_REJECT_AUDIT.getType(), description.toString());
        this.optLogService.addBoOptLog(optLogEo);
        return returnAuditBo;
    }
}

