/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.extptimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.enhance.extension.CubeExtImpl;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.AuditStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.AuditTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.placeTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OrderAuditTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.biz.service.tob.IOptLogService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderAuditDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PayRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderAuditEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PayRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdPayRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.tob.OptLogEo;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.OrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IAuditOrderActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderAuditBo;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
@CubeExtImpl(name="B\u7aef\u8ba2\u5355\u5ba1\u6838\u6269\u5c55", descr="B\u7aef\u8ba2\u5355\u5ba1\u6838\u6269\u5c55")
public class AuditOrderActionTobExtPtImpl
implements IAuditOrderActionExtPt {
    @Resource
    private IOptLogService optLogService;
    @Resource
    private PayRecordDas payRecordDas;
    @Resource
    private OrderAuditDas orderAuditDas;
    @Resource
    private OrderDas orderDas;
    @Resource
    private IContext context;

    public Long getFlowDefId() {
        return 0L;
    }

    public Class getDtoClass() {
        return OrderAuditTobReqDto.class;
    }

    public OrderAuditReqDto validate(OrderAuditReqDto orderAuditReq) {
        OrderAuditTobReqDto orderAuditTobReqDto = (OrderAuditTobReqDto)orderAuditReq;
        String tradeNo = orderAuditReq.getTradeNo();
        OrderEo orderEo = this.orderDas.findByOrderNo(tradeNo);
        if (null != orderEo && AuditTypeEnum.FINANCE_AUDIT.getType().equals(orderAuditReq.getAuditType()) && AuditStatusEnum.PASS.getType().equals(orderAuditTobReqDto.getAuditStatus()) && placeTypeEnum.DEALER_ORDER.getType().equals(orderEo.getPlaceType())) {
            PayRecordEo queryPayRecordEo = PayRecordEo.newInstance();
            queryPayRecordEo.setOrderNo(tradeNo);
            List payRecordEos = this.payRecordDas.select((BaseEo)queryPayRecordEo);
            if (CollectionUtils.isNotEmpty((Collection)payRecordEos)) {
                BigDecimal reduce = payRecordEos.stream().filter(bean -> (AuditStatusEnum.PASS.getType().equals(bean.getAuditStatus()) || AuditStatusEnum.WAIT.getType().equals(bean.getAuditStatus())) && !PayStatusEnum.ABANDON.getCode().equals(bean.getPayStatus())).map(StdPayRecordEo::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (null != orderEo.getPayAmount() && orderEo.getPayAmount().compareTo(reduce) > 0) {
                    throw new BizException(TradeExceptionCode.FINANCE_AUDIT_PASS_CHECK.getCode(), TradeExceptionCode.FINANCE_AUDIT_PASS_CHECK.getMsg());
                }
            }
        }
        return orderAuditReq;
    }

    public OrderAuditBo packBo(OrderAuditBo orderAuditBo, OrderAuditReqDto orderAuditReq) {
        OrderAuditTobReqDto orderAuditTobReqDto = (OrderAuditTobReqDto)orderAuditReq;
        orderAuditBo.getOrderAuditEo().setAuditStatus(orderAuditTobReqDto.getAuditStatus());
        orderAuditBo.getOrderAuditEo().setAuditType(orderAuditTobReqDto.getAuditType());
        orderAuditBo.getOrderAuditEo().setAuditTime(new Date());
        return orderAuditBo;
    }

    public OrderAuditBo save(OrderAuditBo orderAuditBo, OrderAuditReqDto orderAuditReq) {
        return orderAuditBo;
    }

    public OrderAuditBo postProcessor(OrderAuditBo orderAuditBo, OrderAuditReqDto orderAuditReq) {
        orderAuditBo.setAuditResult(orderAuditBo.getOrderAuditEo().getAuditStatus());
        this.saveOptLog(orderAuditReq.getTradeNo(), orderAuditBo.getOrderAuditEo().getAuditType(), orderAuditBo.getOrderAuditEo().getAuditStatus(), orderAuditReq.getAuditDesc(), orderAuditReq.getAuditor());
        if (AuditTypeEnum.FINANCE_AUDIT.getType().equals(orderAuditReq.getAuditType())) {
            this.updatePayRecord(orderAuditReq.getTradeNo(), orderAuditBo.getOrderAuditEo());
        }
        if (AuditTypeEnum.ORDER_REFUND_AUDIT.getType().equals(orderAuditReq.getAuditType())) {
            this.updatePayRecordForReturn(orderAuditReq.getTradeNo(), orderAuditBo.getOrderAuditEo());
        }
        return orderAuditBo;
    }

    private void updatePayRecord(String orderNo, OrderAuditEo orderAuditEo) {
        PayRecordEo queryPayRecord = PayRecordEo.newInstance();
        queryPayRecord.setOrderNo(orderNo);
        List payRecordEos = this.payRecordDas.select((BaseEo)queryPayRecord);
        if (CollectionUtils.isNotEmpty((Collection)payRecordEos)) {
            for (PayRecordEo payRecordEo : payRecordEos) {
                if (AuditStatusEnum.WAIT.getType().equals(payRecordEo.getAuditStatus())) {
                    payRecordEo.setAuditStatus(orderAuditEo.getAuditStatus());
                }
                JSONObject jsonObject = JSON.parseObject((String)payRecordEo.getExtension());
                jsonObject.put("auditTime", (Object)orderAuditEo.getAuditTime());
                jsonObject.put("auditDesc", (Object)orderAuditEo.getAuditDesc());
                payRecordEo.setExtension(jsonObject.toJSONString());
                this.payRecordDas.updateSelective((BaseEo)payRecordEo);
            }
        }
    }

    private void updatePayRecordForReturn(String orderNo, OrderAuditEo orderAuditEo) {
        PayRecordEo queryPayRecord = PayRecordEo.newInstance();
        queryPayRecord.setOrderNo(orderNo);
        List payRecordEos = this.payRecordDas.select((BaseEo)queryPayRecord);
        if (CollectionUtils.isNotEmpty((Collection)payRecordEos)) {
            for (PayRecordEo payRecordEo : payRecordEos) {
                if ("OFFLINE_AMOUNT_PAY".equals(payRecordEo.getPayMethod()) || "OFFLINE_PUBLIC_REMIT_PAY".equals(payRecordEo.getPayMethod())) {
                    payRecordEo.setAuditStatus(AuditStatusEnum.WAIT.getType());
                }
                JSONObject jsonObject = JSON.parseObject((String)payRecordEo.getExtension());
                jsonObject.put("auditTime", (Object)orderAuditEo.getAuditTime());
                jsonObject.put("auditDesc", (Object)orderAuditEo.getAuditDesc());
                payRecordEo.setExtension(jsonObject.toJSONString());
                this.payRecordDas.updateSelective((BaseEo)payRecordEo);
            }
        }
    }

    private void saveOptLog(String bizNo, String auditType, String auditStatus, String auditDesc, String auditor) {
        OptLogEo optLogEo = new OptLogEo();
        optLogEo.setBizType(OptBizTypeEnum.ORDER.getType());
        optLogEo.setBizNo(bizNo);
        AuditTypeEnum auditTypeEnum = AuditTypeEnum.getByCode((String)auditType);
        switch (auditTypeEnum) {
            case CS_AUDIT: {
                optLogEo.setOptType(OptTypeEnum.ORDER_CUSTOMER_AUDIT.getType());
                if (AuditStatusEnum.PASS.getType().equals(auditStatus)) {
                    optLogEo.setDescription("\u3010\u5f85\u8d22\u52a1\u5ba1\u6838\u3011\u8ba2\u8d27\u5355\u5df2\u901a\u8fc7\u5ba2\u670d\u5ba1\u6838");
                    break;
                }
                optLogEo.setDescription("\u3010\u5df2\u53d6\u6d88\u3011\u8ba2\u8d27\u5355\u672a\u901a\u8fc7\u5ba2\u670d\u5ba1\u6838, \u539f\u56e0: " + auditDesc);
                break;
            }
            case FINANCE_AUDIT: {
                optLogEo.setOptType(OptTypeEnum.ORDER_FINANCE_AUDIT.getType());
                if (AuditStatusEnum.PASS.getType().equals(auditStatus)) {
                    optLogEo.setDescription("\u3010\u5f85\u51fa\u5e93\u3011\u8ba2\u8d27\u5355\u5df2\u901a\u8fc7\u8d22\u52a1\u5ba1\u6838");
                    break;
                }
                optLogEo.setDescription("\u3010\u5f85\u8d22\u52a1\u5ba1\u6838\u3011\u8ba2\u8d27\u5355\u672a\u901a\u8fc7\u8d22\u52a1\u5ba1\u6838, \u539f\u56e0: " + auditDesc);
                break;
            }
            case RETURN_AUDIT: {
                break;
            }
            case REFUND_AUDIT: {
                break;
            }
            case FIN_REFUND_CHECK: {
                break;
            }
            case ORDER_REFUND_AUDIT: {
                optLogEo.setOptType(OptTypeEnum.ORDER_REFUND_AUDIT.getType());
                optLogEo.setDescription("\u3010\u5f85\u8d22\u52a1\u5ba1\u6838\u3011\u8ba2\u8d27\u5355\u53cd\u5ba1\u6838\u901a\u8fc7,\u5f85\u8d22\u52a1\u5ba1\u6838");
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + auditTypeEnum);
            }
        }
        optLogEo.setOptTime(new Date());
        optLogEo.setOptPerson(this.context.userName());
        if (StringUtils.isNotBlank((String)auditor)) {
            optLogEo.setOptPerson(auditor);
        }
        this.optLogService.addBoOptLog(optLogEo);
    }
}

