/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.extptimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.enhance.extension.CubeExtImpl;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.IStorageOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.StorageCategoryEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageOrderCombineRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IStorageOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BaseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CreateOrderDeliveryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OrderDeliveryTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.utils.TransformUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.constants.BaseFlowDef;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.conf.ext.domain.OrderDeliveryCreateTobBo;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IOrderDeliveryCreateActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderDeliveryCreateBo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@CubeExtImpl(name="B\u7aef\u751f\u6210\u53d1\u8d27\u5355\u6269\u5c55", descr="B\u7aef\u751f\u6210\u53d1\u8d27\u5355\u6269\u5c55")
public class CreateOrderDeliveryTobExtImpl
implements IOrderDeliveryCreateActionExtPt {
    @Resource
    private IOrderDeliveryService orderDeliveryService;
    @Autowired
    private TradeItemDas tradeItemDas;
    @Resource
    private IStorageOrderApi storageOrderApi;
    @Resource
    private IContext context;
    @Resource
    private IStorageOrderQueryApi iStorageOrderQueryApi;

    public Long getFlowDefId() {
        return BaseFlowDef.BASE_DELIVERY_TOB.getFlowId();
    }

    public String getFlowDefName() {
        return BaseFlowDef.BASE_DELIVERY_TOB.getFlowName();
    }

    public Class getDtoClass() {
        return OrderDeliveryCreateBo.class;
    }

    public CreateOrderDeliveryReqDto validate(CreateOrderDeliveryReqDto createOrderDeliveryReqDto) {
        return createOrderDeliveryReqDto;
    }

    public OrderDeliveryCreateBo packBo(OrderDeliveryCreateBo orderDeliveryCreateBo, CreateOrderDeliveryReqDto createOrderDeliveryReqDto) {
        OrderDeliveryCreateTobBo orderDeliveryCreateTobBo = (OrderDeliveryCreateTobBo)TransformUtil.transformParentToChild((BaseReqDto)orderDeliveryCreateBo, OrderDeliveryCreateTobBo.class);
        OrderDeliveryTobReqDto orderDeliveryTobReqDto = orderDeliveryCreateTobBo.getOrderDeliveryTobReqDto();
        if (StringUtils.isNotEmpty((CharSequence)orderDeliveryTobReqDto.getWarehouseSerial())) {
            orderDeliveryCreateTobBo.getOrderDeliveryEo().setWarehouseSerial(orderDeliveryTobReqDto.getWarehouseSerial());
        }
        String outStorageIds = orderDeliveryTobReqDto.getOutStorageIds();
        OrderDeliveryEo orderDeliveryEo = orderDeliveryCreateTobBo.getOrderDeliveryEo();
        orderDeliveryEo.setShippingTime(orderDeliveryTobReqDto.getShippingTime());
        orderDeliveryEo.setRemark(orderDeliveryTobReqDto.getRemark());
        orderDeliveryEo.setExpressCode(orderDeliveryTobReqDto.getExpressCode());
        orderDeliveryEo.setShippingCompanyCode(orderDeliveryTobReqDto.getShippingCompanyCode());
        orderDeliveryEo.setShippingCompany(orderDeliveryTobReqDto.getShippingCompany());
        orderDeliveryEo.setDeliveryOrderCode(outStorageIds);
        orderDeliveryEo.setDeliveryTime(new Date());
        if (StringUtils.isNotEmpty((CharSequence)outStorageIds)) {
            List<String> split = Arrays.asList(outStorageIds.split(","));
            JSONObject sjon = new JSONObject();
            sjon.put("category", (Object)StorageCategoryEnum.CATEGORY_OUT.getCategory());
            sjon.put("groupId", (Object)"");
            sjon.put("businessId", (Object)orderDeliveryCreateTobBo.getOrderEo().getOrderNo());
            sjon.put("instanceId", (Object)this.context.instanceId());
            sjon.put("tenantId", (Object)this.context.tenantId());
            RestResponse pageInfoRestResponse = this.iStorageOrderQueryApi.queryFilterByPage(sjon.toJSONString(), Integer.valueOf(1), Integer.valueOf(999));
            PageInfo storageOrderCombineRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
            List storageOrderCombineRespDtos = storageOrderCombineRespDtoPageInfo.getList();
            if (CollectionUtils.isNotEmpty((Collection)storageOrderCombineRespDtos)) {
                List targetStorageOrders = storageOrderCombineRespDtos.stream().filter(bean -> {
                    if (null == bean.getStorageOrderRespDto()) {
                        return false;
                    }
                    return split.contains(bean.getStorageOrderRespDto().getId().toString());
                }).collect(Collectors.toList());
                ArrayList tempStorageOrderDetailRespDtos = new ArrayList();
                for (StorageOrderCombineRespDto targetStorageOrder : targetStorageOrders) {
                    List detailRespDtoList = targetStorageOrder.getDetailRespDtoList();
                    if (!CollectionUtils.isNotEmpty((Collection)detailRespDtoList)) continue;
                    List filterDetailRespDtoList = detailRespDtoList.stream().filter(bean -> StringUtils.isNotEmpty((CharSequence)bean.getExtension())).collect(Collectors.toList());
                    tempStorageOrderDetailRespDtos.addAll(filterDetailRespDtoList);
                }
                if (CollectionUtils.isNotEmpty(tempStorageOrderDetailRespDtos)) {
                    TradeItemEo tradeItemSelect = TradeItemEo.newInstance();
                    tradeItemSelect.setTradeNo(orderDeliveryCreateTobBo.getOrderEo().getOrderNo());
                    List tradeItemEos = this.tradeItemDas.select((BaseEo)tradeItemSelect, Integer.valueOf(0), Integer.valueOf(1024));
                    Map<String, List<StorageOrderDetailRespDto>> detailMap = tempStorageOrderDetailRespDtos.stream().collect(Collectors.groupingBy(StorageOrderDetailRespDto::getExtension));
                    if (null != detailMap) {
                        ArrayList<DeliveryItemEo> deliveryItemEos = new ArrayList<DeliveryItemEo>();
                        ArrayList<TradeItemEo> waitUpdate = new ArrayList<TradeItemEo>();
                        for (Map.Entry<String, List<StorageOrderDetailRespDto>> bean2 : detailMap.entrySet()) {
                            String key = bean2.getKey();
                            List<StorageOrderDetailRespDto> value = bean2.getValue();
                            Long deliveryNum = value.stream().map(StorageOrderDetailRespDto::getNum).reduce(Long::sum).orElse(0L);
                            Optional<TradeItemEo> optionalTradeItemEo = tradeItemEos.stream().filter(tradeItem -> (tradeItem.getSkuSerial() + "_" + tradeItem.getGift()).equals(key)).findFirst();
                            if (!optionalTradeItemEo.isPresent()) continue;
                            TradeItemEo tradeItem2 = optionalTradeItemEo.get();
                            deliveryItemEos.add(this.handleDeliveryItemEo(tradeItem2, orderDeliveryEo.getDeliveryNo(), deliveryNum.intValue()));
                            Integer deliveredNum = null != tradeItem2.getDeliveredNum() ? tradeItem2.getDeliveredNum() : 0;
                            tradeItem2.setDeliveredNum(Integer.valueOf(deliveredNum + deliveryNum.intValue()));
                            waitUpdate.add(tradeItem2);
                        }
                        orderDeliveryCreateTobBo.setDeliveryItemEoList(deliveryItemEos);
                        orderDeliveryCreateTobBo.setTradeItemEos(waitUpdate);
                    }
                }
            }
        }
        return orderDeliveryCreateTobBo;
    }

    private DeliveryItemEo handleDeliveryItemEo(TradeItemEo tradeItem, String deliveryNo, Integer itemNum) {
        DeliveryItemEo deliveryItemEo = DeliveryItemEo.newInstance();
        deliveryItemEo.setTradeNo(tradeItem.getTradeNo());
        deliveryItemEo.setDeliveryNo(deliveryNo);
        deliveryItemEo.setTrOrderItemNo(tradeItem.getTradeItemNo());
        deliveryItemEo.setCargoSerial(tradeItem.getCargoSerial());
        deliveryItemEo.setDeliveredNum(Integer.valueOf(0));
        deliveryItemEo.setItemNum(itemNum);
        deliveryItemEo.setDeliverySubType("NORMAL");
        deliveryItemEo.setDeliveryType("NORMAL");
        deliveryItemEo.setSkuSerial(tradeItem.getSkuSerial());
        deliveryItemEo.setSkuCode(tradeItem.getSkuCode());
        deliveryItemEo.setSkuDesc(tradeItem.getSkuDesc());
        deliveryItemEo.setItemCode(tradeItem.getItemCode());
        deliveryItemEo.setItemName(tradeItem.getItemName());
        deliveryItemEo.setItemPrice(tradeItem.getItemPrice());
        deliveryItemEo.setItemOrigPrice(tradeItem.getItemOrigPrice());
        deliveryItemEo.setRemark(tradeItem.getRemark());
        deliveryItemEo.setItemSerial(tradeItem.getItemSerial());
        deliveryItemEo.setUnit(tradeItem.getUnit());
        String extension = tradeItem.getExtension();
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            JSONObject extensionObj = JSON.parseObject((String)extension);
            deliveryItemEo.setItemImgPath(extensionObj.getString("imgPath"));
        }
        deliveryItemEo.setTenantId(tradeItem.getTenantId());
        deliveryItemEo.setInstanceId(tradeItem.getInstanceId());
        deliveryItemEo.setBatchNo(tradeItem.getBatchNo());
        return deliveryItemEo;
    }

    public OrderDeliveryCreateBo save(OrderDeliveryCreateBo orderDeliveryCreateBo, CreateOrderDeliveryReqDto createOrderDeliveryReqDto) {
        if (CollectionUtils.isNotEmpty((Collection)orderDeliveryCreateBo.getTradeItemEos())) {
            orderDeliveryCreateBo.getTradeItemEos().stream().forEach(bean -> this.tradeItemDas.updateSelective((BaseEo)bean));
        }
        return orderDeliveryCreateBo;
    }

    public OrderDeliveryCreateBo postProcessor(OrderDeliveryCreateBo orderDeliveryCreateBo, CreateOrderDeliveryReqDto createOrderDeliveryReqDto) {
        return orderDeliveryCreateBo;
    }
}

