/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.extptimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.enhance.extension.CubeExtImpl;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.IBalanceApi;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.ChangeTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalancePayReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalanceReturnReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ActivityConstant;
import com.dtyunxi.yundt.cube.center.trade.api.constants.B2bConstant;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderCancelTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BaseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderExtInfoDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderPreviewReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderSplitReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.activity.OrderActivityAddReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OrderBReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.GiftInfoRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.order.OrderPreviewRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.order.activity.ExchangeDisplayRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.utils.TransformUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.constants.BaseFlowDef;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.enums.OrderTradeStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.CreateOrderFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.OrderCloseProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.OrderCloseMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IHelpService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderActivityService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IExtlOrderActivityService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.tob.IOptLogService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.ContextUtil;
import com.dtyunxi.yundt.cube.center.trade.conf.ext.domain.OrderCreateTobBo;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.tob.AttachementDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderActivityEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.tob.AttachementEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.tob.OptLogEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IOrderCreateActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.CancelOrderBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.CloseOrderBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderCreateBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderRefactorBo;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.IItemActivityStockApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.IExchangeBalanceAccountApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeAccountUseReq;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceRollBackReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.InitExchangeAccountReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.enums.TurnoverChangeTypeEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@CubeExtImpl(name="B\u7aef\u4e0b\u5355\u6269\u5c55", descr="B\u7aef\u4e0b\u5355\u6269\u5c55")
public class OrderCreateActionTobExtPtImpl
implements IOrderCreateActionExtPt {
    private static final Logger logger = LoggerFactory.getLogger(OrderCreateActionTobExtPtImpl.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @CubeResource
    private IOrderCreateActionExtPt orderCreateActionExtPt;
    @Autowired
    private CreateOrderFlowAction createOrderFlowAction;
    @Resource
    private IBalanceApi iBalanceApi;
    @Resource
    private IOptLogService optLogService;
    @Resource
    private AttachementDas attachementDas;
    @Resource
    private OrderCloseProducer orderCloseProducer;
    @Resource
    private IContext context;
    @Resource
    private IOrderService orderService;
    @Resource
    private IExtlOrderActivityService extlOrderActivityService;
    @Resource
    private IOrderActivityService orderActivityService;
    @Resource
    private OrderDas orderDas;
    @Resource
    private ITradeItemService tradeItemService;
    @Resource
    private IItemActivityStockApi itemActivityStockApi;
    @Resource
    private IHelpService helpService;
    @Autowired
    private ITcbjInventoryApi tcbjInventoryApi;
    @Autowired
    private IExchangeBalanceAccountApi exchangeBalanceAccountApi;

    public String getFlowDefName() {
        return BaseFlowDef.BASE_ORDER_TOB.getFlowName();
    }

    public Long getFlowDefId() {
        return BaseFlowDef.BASE_ORDER_TOB.getFlowId();
    }

    public OrderCreateBo calcAmount(OrderCreateBo orderBo, OrderReqDto orderReq) {
        logger.info("TOB\u8ba2\u5355\u8ba1\u7b97\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)orderBo.getOrderEo()));
        boolean isChildrenOrder = StringUtils.isNotEmpty((CharSequence)orderBo.getOrderEo().getParentOrderNo()) || StringUtils.isBlank((CharSequence)orderBo.getOrderEo().getParentOrderNo()) && Integer.valueOf(0).equals(orderBo.getOrderEo().getIsSplit());
        boolean notSecondKillReq = !"SKILL_ORDER".equals(orderReq.getFlowType());
        OrderPreviewReqDto order = new OrderPreviewReqDto();
        BeanUtils.copyProperties((Object)orderReq, (Object)order);
        order.setViewType(Integer.valueOf(1));
        order.setOrderItems(order.getOrderItems());
        order.setActivity(order.getActivity());
        order.setGiftItems(order.getGiftItems());
        order.setNoExchangeException(false);
        order.setRuleId(orderReq.getRuleId());
        logger.info("ruleId8", (Object)JSON.toJSONString((Object)order));
        order.setActivityStockFlag(Boolean.valueOf(false));
        OrderPreviewRespDto previewRespDto = notSecondKillReq ? this.orderService.countAndPreviewOrderAmount(order) : this.orderService.countAndPreviewSeckillOrderAmount(order);
        logger.info("countAndPreviewOrderAmount\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)previewRespDto));
        GiftInfoRespDto giftInfoRespDto = new GiftInfoRespDto();
        HashMap<String, BigDecimal> giftDeductionMap = new HashMap<String, BigDecimal>();
        if (isChildrenOrder && Objects.nonNull(orderReq.getCustomerId())) {
            previewRespDto.setCustomerId(Long.valueOf(orderReq.getCustomerId()));
            previewRespDto.setGiftAccount(orderReq.isGiftAccount());
            previewRespDto.setOrderNo(orderBo.getOrderEo().getOrderNo());
            giftInfoRespDto = this.helpService.addOrderAction(previewRespDto);
            logger.info("\u63d0\u4ea4\u8ba2\u5355\u8ba1\u7b97\u7ed3\u679c\u4e3a" + JSON.toJSONString((Object)giftInfoRespDto));
            if (CollectionUtils.isNotEmpty((Collection)giftInfoRespDto.getList())) {
                for (Object tradeItemRespDto : giftInfoRespDto.getList()) {
                    String key = tradeItemRespDto.getShopId() + tradeItemRespDto.getSkuSerial() + tradeItemRespDto.getGift() + "#" + tradeItemRespDto.getIfExchange() + "#" + tradeItemRespDto.getExchangeActivityId() + "#" + tradeItemRespDto.getIsCombinedPackage() + "#" + tradeItemRespDto.getCombinedPackageActivityId();
                    giftDeductionMap.put(key, tradeItemRespDto.getDiscountAmount());
                }
            }
        }
        logger.info("giftDeductionMap\u5bf9\u8c61\uff1a{}", (Object)JSON.toJSONString(giftDeductionMap));
        orderReq.setTotalIntegral(previewRespDto.getTotalIntegral());
        orderReq.setStartingPric(previewRespDto.getStartingPric());
        orderReq.setPayAmount(previewRespDto.getPayAmount().subtract(giftInfoRespDto.getDeductionAmount()));
        orderReq.setTotalAmount(previewRespDto.getTotalAmount());
        orderReq.setDiscountAmount(previewRespDto.getDiscountAmount());
        orderBo.setCountPreview(previewRespDto);
        if (previewRespDto.getTotalIntegral() != null) {
            orderBo.getOrderEo().setIntegral(Integer.valueOf(previewRespDto.getTotalIntegral().intValue()));
        }
        orderBo.getOrderEo().setTotalAmount(previewRespDto.getTotalAmount());
        orderBo.getOrderEo().setPayAmount(previewRespDto.getPayAmount().subtract(giftInfoRespDto.getDeductionAmount()));
        orderBo.getOrderEo().setDiscountAmount(previewRespDto.getDiscountAmount());
        orderBo.getOrderEo().setFreightAmount(previewRespDto.getFreightAmount());
        orderBo.getOrderEo().setTotalRebateAmount(previewRespDto.getTotalRebateAmount());
        orderBo.getOrderEo().setGiftFreezeAmount(giftInfoRespDto.getUnableAmount());
        orderBo.getOrderEo().setDeductionAmount(giftInfoRespDto.getDeductionAmount().subtract(giftInfoRespDto.getAddAmount()));
        orderBo.getOrderEo().setGiftAddAmount(giftInfoRespDto.getAddAmount());
        orderBo.getOrderEo().setGiftDeductionAmount(giftInfoRespDto.getDeductionAmount());
        if (previewRespDto.isUsePointDeduct()) {
            orderBo.getOrderEo().setTotalCashOutAmount(previewRespDto.getTotalCashOutAmount());
            orderBo.getOrderEo().setTotalCashOutPoint(previewRespDto.getTotalCashOutPoint());
        }
        orderReq.setTotalCashOutAmount(previewRespDto.getTotalCashOutAmount());
        orderReq.setTotalCashOutPoint(previewRespDto.getTotalCashOutPoint());
        Map<String, TradeItemRespDto> activitySkuItemMap = previewRespDto.getOrderItems().stream().collect(Collectors.toMap(item -> item.getShopId() + item.getSkuSerial() + item.getGift() + "#" + item.getIfExchange() + "#" + item.getExchangeActivityId() + "#" + item.getIsCombinedPackage() + "#" + item.getCombinedPackageActivityId(), item -> item, (item1, item2) -> item1));
        logger.info("\u63d0\u4ea4\u8ba2\u5355\u7ec4\u88c5tradeEo\uff1a{}\uff0cBo\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(activitySkuItemMap), (Object)JSON.toJSONString((Object)orderBo.getTradeItemEoList()));
        for (Object tradeItemEo : orderBo.getTradeItemEoList()) {
            TradeItemRespDto tradeItemRespDto = activitySkuItemMap.get(tradeItemEo.getShopId() + tradeItemEo.getSkuSerial() + tradeItemEo.getGift() + "#" + tradeItemEo.getIfExchange() + "#" + tradeItemEo.getExchangeActivityId() + "#" + tradeItemEo.getIsCombinedPackage() + "#" + tradeItemEo.getCombinedPackageActivityId());
            logger.info("\u9884\u89c8\u63a5\u53e3\u8fd4\u56de\u6d3b\u52a8\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)tradeItemRespDto));
            if (tradeItemRespDto == null) continue;
            tradeItemEo.setItemPrice(tradeItemRespDto.getItemPrice());
            tradeItemEo.setItemOrigPrice(tradeItemRespDto.getItemOrigPrice());
            tradeItemEo.setItemMarketPrice(tradeItemRespDto.getItemMarketPrice());
            tradeItemEo.setPayTotalAmount(tradeItemRespDto.getPayTotalAmount());
            tradeItemEo.setPlatformDiscountPrice(tradeItemRespDto.getPlatformDiscountPrice());
            tradeItemEo.setDiscountTotalAmount(tradeItemRespDto.getDiscountTotalAmount());
            tradeItemEo.setRebateAmount(tradeItemRespDto.getRebateAmount());
            tradeItemEo.setGiftSkuIds(tradeItemRespDto.getGiftSkuIds());
            tradeItemEo.setAddAmount(giftInfoRespDto.getDeductionAmount().subtract(giftInfoRespDto.getAddAmount()));
            tradeItemEo.setRemainAmount(tradeItemEo.getAddAmount());
            if (giftInfoRespDto.isDeduction()) {
                tradeItemEo.setGiftDeduction(giftDeductionMap.getOrDefault(tradeItemEo.getShopId() + tradeItemEo.getSkuSerial() + tradeItemEo.getGift() + "#" + tradeItemEo.getIfExchange() + "#" + tradeItemEo.getExchangeActivityId() + "#" + tradeItemEo.getIsCombinedPackage() + "#" + tradeItemEo.getCombinedPackageActivityId(), BigDecimal.ZERO));
                tradeItemEo.setPayTotalAmount(tradeItemEo.getPayTotalAmount().subtract(tradeItemEo.getGiftDeduction()));
                tradeItemEo.setItemPrice(tradeItemEo.getPayTotalAmount().divide(BigDecimal.valueOf(tradeItemRespDto.getItemNum().intValue()), 2, 5));
            }
            tradeItemEo.setGiftCost(tradeItemRespDto.getGiftCost());
            if (!previewRespDto.isUsePointDeduct()) continue;
            tradeItemEo.setCashOutAmount(tradeItemRespDto.getCashOutAmount());
            tradeItemEo.setCashOutPoint(tradeItemRespDto.getCashOutPoint());
        }
        if (Objects.nonNull(orderReq.getActivity()) && CollectionUtils.isNotEmpty((Collection)orderReq.getActivity().getActivityList())) {
            if (notSecondKillReq) {
                Map activityDiscountMap = previewRespDto.getActivityDiscountMap();
                for (OrderActivityInfoReqDto orderActivityInfoReqDto : orderReq.getActivity().getActivityList()) {
                    BigDecimal discountAmount = (BigDecimal)activityDiscountMap.get(orderActivityInfoReqDto.getActivityId().toString());
                    orderActivityInfoReqDto.setDiscountAmount(discountAmount);
                }
            } else {
                OrderActivityInfoReqDto orderActivityInfoReqDto = (OrderActivityInfoReqDto)orderReq.getActivity().getActivityList().get(0);
                orderActivityInfoReqDto.setDiscountAmount(previewRespDto.getTotalDiscountAmount());
            }
        }
        this.checkStartPric(orderReq);
        if (isChildrenOrder && Objects.nonNull(orderReq.getCustomerId()) && CollectionUtils.isNotEmpty((Collection)previewRespDto.getExchangeDisplayRespDto())) {
            for (ExchangeDisplayRespDto exchangeDisplayRespDto : previewRespDto.getExchangeDisplayRespDto()) {
                if (!Integer.valueOf(1).equals(exchangeDisplayRespDto.getIfBalanceAccount())) continue;
                if (!exchangeDisplayRespDto.isInited()) {
                    InitExchangeAccountReqDto initAccountReqDto = new InitExchangeAccountReqDto();
                    initAccountReqDto.setActivityId(exchangeDisplayRespDto.getActivityId());
                    initAccountReqDto.setCustomerId(Long.valueOf(orderReq.getCustomerId()));
                    logger.info("\u521d\u59cb\u5316\u6362\u8d2d\u989d\u5ea6\u8d26\u6237\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)initAccountReqDto));
                    RestResponseHelper.extractData((RestResponse)this.exchangeBalanceAccountApi.initExchangeAccount(initAccountReqDto));
                }
                ExchangeAccountUseReq accountUseReq = new ExchangeAccountUseReq();
                accountUseReq.setOrderNo(orderBo.getOrderEo().getOrderNo());
                accountUseReq.setActivityId(exchangeDisplayRespDto.getActivityId());
                accountUseReq.setCustomerId(Long.valueOf(orderReq.getCustomerId()));
                accountUseReq.setChangeAvaBalance(Optional.ofNullable(exchangeDisplayRespDto.getDiscount()).orElse(BigDecimal.ZERO));
                accountUseReq.setChangeUsedBalance(Optional.ofNullable(exchangeDisplayRespDto.getUsedDiscount()).orElse(BigDecimal.ZERO));
                accountUseReq.setTurnoverChangeTypeEnum(TurnoverChangeTypeEnum.SUBMIT_ORDER);
                logger.info("\u4e0b\u5355\u4f7f\u7528\u6362\u8d2d\u989d\u5ea6\u8d26\u6237\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)accountUseReq));
                RestResponseHelper.extractData((RestResponse)this.exchangeBalanceAccountApi.useExchangeBalanceAccount(accountUseReq));
            }
        }
        return orderBo;
    }

    private void checkStartPric(OrderReqDto orderReqDto) {
        if (orderReqDto.getFreightAmount() == null) {
            orderReqDto.setFreightAmount(BigDecimal.ZERO);
        }
        if (orderReqDto.getStartingPric() == null) {
            orderReqDto.setStartingPric(BigDecimal.ZERO);
        }
        if (orderReqDto.getStartingPric().compareTo(orderReqDto.getPayAmount().subtract(orderReqDto.getFreightAmount())) > 0) {
            throw new BizException("\u4e0d\u6ee1\u8db3\u8d77\u9001\u4ef7");
        }
    }

    public OrderCreateBo preJoinActivity(OrderCreateBo orderBo, OrderReqDto orderReq) {
        boolean isChildrenOrder = StringUtils.isNotEmpty((CharSequence)orderBo.getOrderEo().getParentOrderNo());
        if (orderReq.getActivity() != null && CollectionUtils.isNotEmpty((Collection)orderReq.getActivity().getActivityList())) {
            this.preJoinActivity(orderReq);
        }
        return orderBo;
    }

    public void preJoinActivity(OrderReqDto orderReq) {
        if (orderReq.getActivity() != null && CollectionUtils.isNotEmpty((Collection)orderReq.getActivity().getActivityList())) {
            this.extlOrderActivityService.preJoinActivity(orderReq);
            List activityList = orderReq.getActivity().getActivityList();
            activityList.stream().forEach(activity -> {
                OrderActivityAddReqDto activityAddReqDto = new OrderActivityAddReqDto();
                activityAddReqDto.setTradeNo(orderReq.getTradeNo());
                activityAddReqDto.setOrderNo(orderReq.getTradeNo());
                activityAddReqDto.setUserId(orderReq.getUserId());
                activityAddReqDto.setUserSrc(orderReq.getUserSrc());
                activityAddReqDto.setStatus(Integer.valueOf(0));
                activityAddReqDto.setParentType(activity.getType());
                activityAddReqDto.setType(activity.getType());
                activityAddReqDto.setParentActivityId("0L");
                activityAddReqDto.setActivityId(activity.getActivityId().toString());
                activityAddReqDto.setActivityName(activity.getActivityName());
                activityAddReqDto.setDiscountAmount(activity.getDiscountAmount());
                activityAddReqDto.setExtension(JSON.toJSONString((Object)activity));
                this.orderActivityService.add(activityAddReqDto);
            });
        }
    }

    public OrderCreateBo splitOrder(OrderCreateBo orderCreateBo, OrderReqDto orderReq) {
        boolean isChildrenOrder = StringUtils.isNotEmpty((CharSequence)orderCreateBo.getOrderEo().getParentOrderNo());
        if (isChildrenOrder) {
            return orderCreateBo;
        }
        if (orderCreateBo.getCountPreview() == null) {
            return orderCreateBo;
        }
        OrderSplitReqDto orderSplit = orderCreateBo.getCountPreview().getOrderSplit();
        if (orderSplit == null || CollectionUtils.isEmpty((Collection)orderSplit.getChildrenOrderList())) {
            return orderCreateBo;
        }
        orderCreateBo.getOrderEo().setIsSplit(Integer.valueOf(1));
        ArrayList<OrderCreateBo> orderChildList = new ArrayList<OrderCreateBo>();
        for (OrderReqDto childrenOrder : orderSplit.getChildrenOrderList()) {
            childrenOrder.setTradeNo(TradeUtil.generateTradeNo((String)orderReq.getTradeNo()));
            childrenOrder.setParentOrderNo(orderCreateBo.getOrderEo().getOrderNo());
            childrenOrder.setActivity(null);
            childrenOrder.setIsSplit(Integer.valueOf(0));
            OrderCreateBo orderCreate = new OrderCreateBo();
            orderCreate.setOrderReqDto(childrenOrder);
            orderCreate.setStartFlowParam(this.orderCreateActionExtPt.getFlowDefId(), this.orderCreateActionExtPt.getFlowDefName());
            orderChildList.add(orderCreate);
        }
        for (OrderCreateBo orderCreate : orderChildList) {
            this.createOrderFlowAction.createOrder(orderCreate);
        }
        return orderCreateBo;
    }

    public Class getDtoClass() {
        return OrderBReqDto.class;
    }

    public OrderReqDto validate(OrderReqDto orderReq) {
        return orderReq;
    }

    public OrderCreateBo packBo(OrderCreateBo orderBo, OrderReqDto orderReq) {
        OrderCreateTobBo orderCreateTobBo = (OrderCreateTobBo)TransformUtil.transformParentToChild((BaseReqDto)orderBo, OrderCreateTobBo.class);
        OrderBReqDto bOrderReq = (OrderBReqDto)orderReq;
        if (CollectionUtils.isNotEmpty((Collection)bOrderReq.getAttachements())) {
            List attachementEos = bOrderReq.getAttachements().stream().map(bean -> {
                AttachementEo attachementEo = AttachementEo.newInstance();
                CubeBeanUtils.copyProperties((Object)attachementEo, (Object)bean, (String[])new String[0]);
                attachementEo.setBizNo(orderBo.getOrderEo().getOrderNo());
                attachementEo.setBizType(OptBizTypeEnum.ORDER.getType());
                return attachementEo;
            }).collect(Collectors.toList());
            orderCreateTobBo.setAttachementEos(attachementEos);
        }
        orderCreateTobBo.getOrderEo().setDeliveryDate(bOrderReq.getDeliveryDate());
        String orderExt = this.getOrderExt(bOrderReq);
        orderCreateTobBo.getOrderEo().setExtension(orderExt);
        return orderCreateTobBo;
    }

    public OrderCreateBo save(OrderCreateBo orderBo, OrderReqDto orderReq) {
        OrderEo orderEo;
        OrderCreateTobBo orderCreateTobBo = (OrderCreateTobBo)TransformUtil.transformParentToChild((BaseReqDto)orderBo, OrderCreateTobBo.class);
        if (CollectionUtils.isNotEmpty((Collection)orderCreateTobBo.getAttachementEos())) {
            this.attachementDas.insertBatch(orderCreateTobBo.getAttachementEos());
        }
        boolean isChildrenOrder = StringUtils.isNotBlank((CharSequence)(orderEo = orderBo.getOrderEo()).getParentOrderNo()) || StringUtils.isBlank((CharSequence)orderEo.getParentOrderNo()) && Integer.valueOf(0).equals(orderEo.getIsSplit());
        logger.info("\u662f\u5426\u4f7f\u7528\u8fd4\u5229\u62b5\u6263,\u8fd4\u5229\u4f7f\u7528\u91d1\u989d[{}],\u662f\u5426\u5b50\u8ba2\u5355:{}", (Object)JSON.toJSONString((Object)orderEo.getTotalRebateAmount()), (Object)isChildrenOrder);
        if (isChildrenOrder && !orderEo.getOrderTradeStatus().equals(OrderTradeStatusEnum.DRAFT.getCode()) && orderEo.getTotalRebateAmount() != null && orderEo.getTotalRebateAmount().compareTo(BigDecimal.ZERO) > 0) {
            BalancePayReqDto balanceAddReqDto = new BalancePayReqDto();
            balanceAddReqDto.setOrderNo(orderEo.getOrderNo());
            balanceAddReqDto.setPayAmount(orderEo.getTotalRebateAmount());
            balanceAddReqDto.setUserId(Long.valueOf(orderEo.getCustomerId()));
            logger.info("\u4f7f\u7528\u6298\u6263\u8d26\u6237\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)balanceAddReqDto));
            RestResponse balancePayRespDtoRestResponse = this.iBalanceApi.useBalance(balanceAddReqDto);
            logger.info("\u4f7f\u7528\u6298\u6263\u8d26\u6237\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)balancePayRespDtoRestResponse));
            RestResponseHelper.extractData((RestResponse)balancePayRespDtoRestResponse);
        }
        return orderCreateTobBo;
    }

    public OrderCreateBo postProcessor(OrderCreateBo orderBo, OrderReqDto orderReq) {
        boolean isChildrenOrder;
        OrderBReqDto bOrderReq = (OrderBReqDto)orderReq;
        this.saveOptLog(orderBo.getOrderEo().getOrderNo(), orderReq.getSubmitType(), bOrderReq.getPayType(), bOrderReq.getCreditAccountNo());
        boolean bl = isChildrenOrder = StringUtils.isNotEmpty((CharSequence)orderBo.getOrderEo().getParentOrderNo()) || StringUtils.isBlank((CharSequence)orderBo.getOrderEo().getParentOrderNo()) && Integer.valueOf(0).equals(orderBo.getOrderEo().getIsSplit());
        if (isChildrenOrder) {
            OrderCloseMessageVo messageVo = new OrderCloseMessageVo(orderBo.getOrderEo().getOrderNo(), null, orderReq.getCloseTime(), orderReq.getTenantId(), orderReq.getInstanceId());
            this.sendOrderCloseMsg(messageVo);
        }
        return orderBo;
    }

    public void sendOrderCloseMsg(OrderCloseMessageVo messageVo) {
        messageVo.setAppKey(ContextUtil.getInstanceId());
        logger.info("[toB\u53d1\u9001\u5173\u95ed\u8ba2\u5355\u6d88\u606f]: {}", (Object)JSON.toJSONString((Object)messageVo));
        long now = System.currentTimeMillis();
        if (messageVo.getCloseTime() != null) {
            long delay = (messageVo.getCloseTime().getTime() - now) / 1000L;
            if (delay < 0L) {
                delay = 0L;
            }
            this.commonsMqService.sendDelaySingleMessage("b2b_order_close", (Object)messageVo, Long.valueOf(delay));
        }
    }

    public OrderCreateBo packBo_update(OrderCreateBo orderBo, OrderReqDto orderReq) {
        OrderCreateTobBo orderCreateTobBo = (OrderCreateTobBo)TransformUtil.transformParentToChild((BaseReqDto)orderBo, OrderCreateTobBo.class);
        OrderBReqDto bOrderReq = new OrderBReqDto();
        BeanUtils.copyProperties((Object)orderReq, (Object)bOrderReq);
        if (CollectionUtils.isNotEmpty((Collection)bOrderReq.getAttachements())) {
            AttachementEo attachementEo_query = AttachementEo.newInstance();
            attachementEo_query.setBizNo(orderCreateTobBo.getOrderEo().getOrderNo());
            List select = this.attachementDas.select((BaseEo)attachementEo_query);
            List attachementEos = bOrderReq.getAttachements().stream().map(bean -> {
                AttachementEo attachementEo = null;
                Optional<AttachementEo> first = select.stream().filter(o -> o.getId() == bean.getId() || o.getPath() == bean.getPath()).findFirst();
                attachementEo = first.isPresent() ? first.get() : AttachementEo.newInstance();
                CubeBeanUtils.copyProperties((Object)attachementEo, (Object)bean, (String[])new String[0]);
                attachementEo.setBizNo(orderBo.getOrderEo().getOrderNo());
                attachementEo.setBizType(OptBizTypeEnum.ORDER.getType());
                return attachementEo;
            }).collect(Collectors.toList());
            orderCreateTobBo.setAttachementEos(attachementEos);
        }
        orderCreateTobBo.getOrderEo().setDeliveryDate(bOrderReq.getDeliveryDate());
        return orderCreateTobBo;
    }

    public OrderCreateBo save_update(OrderCreateBo orderBo, OrderReqDto orderReq) {
        OrderCreateTobBo orderCreateTobBo = (OrderCreateTobBo)TransformUtil.transformParentToChild((BaseReqDto)orderBo, OrderCreateTobBo.class);
        AttachementEo attachementEo_query = AttachementEo.newInstance();
        attachementEo_query.setBizNo(orderCreateTobBo.getOrderEo().getOrderNo());
        this.attachementDas.delete((BaseEo)attachementEo_query);
        if (CollectionUtils.isNotEmpty((Collection)orderCreateTobBo.getAttachementEos())) {
            this.attachementDas.insertBatch(orderCreateTobBo.getAttachementEos());
        }
        return orderCreateTobBo;
    }

    private void saveOptLog(String bizNo, String submitType, String payType, String creditAccountNo) {
        OptLogEo optLogEo = new OptLogEo();
        optLogEo.setBizType(OptBizTypeEnum.ORDER.getType());
        optLogEo.setBizNo(bizNo);
        optLogEo.setOptTime(new Date());
        optLogEo.setOptPerson(this.context.userName());
        if ("2".equals(submitType)) {
            optLogEo.setOptType(OptTypeEnum.ORDER_SUBMIT.getType());
            if ("CREDIT_PAY".equals(payType) && StringUtils.isNotEmpty((CharSequence)creditAccountNo)) {
                optLogEo.setDescription(String.format("\u3010\u5f85\u4e1a\u52a1\u5ba1\u6838\u3011\u5df2\u63d0\u4ea4\u8ba2\u8d27\u5355\uff0c\u5f85\u8ba2\u8d27\u5355\u5ba1\u6838\uff0c\u5df2\u7ed1\u5b9a\u652f\u4ed8\u65b9\u5f0f\uff1a\u4fe1\u7528\u652f\u4ed8%s", creditAccountNo));
            } else if ("STORED_AMOUNT_PAY".equals(payType) && StringUtils.isNotEmpty((CharSequence)creditAccountNo)) {
                optLogEo.setDescription("\u3010\u5f85\u4e1a\u52a1\u5ba1\u6838\u3011\u5df2\u63d0\u4ea4\u8ba2\u8d27\u5355\uff0c\u5f85\u8ba2\u8d27\u5355\u5ba1\u6838\uff0c\u5df2\u7ed1\u5b9a\u652f\u4ed8\u65b9\u5f0f\uff1a\u8d26\u53f7\u652f\u4ed8");
            } else {
                optLogEo.setDescription("\u3010\u5f85\u652f\u4ed8\u3011\u5df2\u63d0\u4ea4\u8ba2\u5355\uff0c\u5f85\u652f\u4ed8");
            }
        } else {
            optLogEo.setOptType(OptTypeEnum.ORDER_CREATE.getType());
            optLogEo.setDescription("\u3010\u5df2\u521b\u5efa\u3011\u521b\u5efa\u8ba2\u8d27\u5355\uff0c\u5df2\u521b\u5efa\u8349\u7a3f");
        }
        this.optLogService.addBoOptLog(optLogEo);
    }

    private String getOrderExt(OrderBReqDto orderBo) {
        if (CollectionUtils.isNotEmpty((Collection)orderBo.getExtInfos())) {
            OrderExtInfoDto orderExtInfoDto = (OrderExtInfoDto)orderBo.getExtInfos().get(0);
            JSONObject extenJson = null;
            extenJson = StringUtils.isEmpty((CharSequence)orderBo.getExtension()) ? new JSONObject() : JSONObject.parseObject((String)orderBo.getExtension());
            if (StringUtils.isNotBlank((CharSequence)orderExtInfoDto.getInvoice())) {
                extenJson.put("invoice", (Object)orderExtInfoDto.getInvoice());
            }
            return extenJson.toJSONString();
        }
        return null;
    }

    public OrderRefactorBo completeOrder(OrderRefactorBo orderBo) {
        orderBo.getOrderEo().setEndTime(new Date());
        OptLogEo optLogEo = new OptLogEo();
        optLogEo.setBizType(OptBizTypeEnum.ORDER.getType());
        optLogEo.setBizNo(orderBo.getOrderEo().getOrderNo());
        optLogEo.setOptType(OptTypeEnum.ORDER_FINISH.getType());
        optLogEo.setOptTime(new Date());
        optLogEo.setOptPerson("");
        optLogEo.setDescription(String.format("\u3010\u8ba2\u8d27\u5355\u5df2\u5b8c\u6210\u3011\u8ba2\u8d27\u5355\u53f7\uff1a%s\u5df2\u5b8c\u6210\u4ea4\u6613\u3002", orderBo.getOrderEo().getOrderNo()));
        this.optLogService.addBoOptLog(optLogEo);
        return orderBo;
    }

    public CancelOrderBo cancelOrder(CancelOrderBo cancelOrderBo) {
        OrderEo orderEo = cancelOrderBo.getOrderEo();
        CancelReqDto cancelReqDto = cancelOrderBo.getCancelReqDto();
        if (cancelReqDto == null) {
            cancelReqDto = new CancelReqDto();
        }
        if (cancelOrderBo.getOrderEo() == null) {
            orderEo = this.orderDas.lockByOrderNo(cancelOrderBo.getCancelReqDto().getTradeNo());
            cancelOrderBo.setOrderEo(orderEo);
        }
        this.checkIfActivityAndRollbackStock(orderEo);
        if (cancelReqDto.getCancelType() == null || cancelReqDto.getCancelDesc() == null) {
            cancelReqDto.setCancelType(OrderCancelTypeEnum.SYSTEM_CANCLE.getName());
            cancelReqDto.setCancelDesc(OrderCancelTypeEnum.SYSTEM_CANCLE.getDesc());
        }
        cancelOrderBo.getOrderEo().setCancelDesc(cancelReqDto.getCancelDesc());
        orderEo.setCancelTime(new Date());
        orderEo.setCancelType(cancelReqDto.getCancelType());
        if (cancelOrderBo.ifNoUseFlow()) {
            this.orderDas.updateSelective((BaseEo)orderEo);
        }
        if (orderEo.getTotalRebateAmount() != null && orderEo.getTotalRebateAmount().compareTo(BigDecimal.ZERO) > 0) {
            BalanceReturnReqDto balanceReturnReqDto = new BalanceReturnReqDto();
            balanceReturnReqDto.setChangeType(ChangeTypeEnum.CANCEL_ORDER.toCode());
            balanceReturnReqDto.setOrderNo(orderEo.getOrderNo());
            balanceReturnReqDto.setReturnAmount(orderEo.getTotalRebateAmount());
            balanceReturnReqDto.setUserId(Long.valueOf(orderEo.getCustomerId()));
            this.iBalanceApi.returnBalance(balanceReturnReqDto);
        }
        this.helpService.cancelOrder(orderEo);
        ExchangeBalanceRollBackReqDto rollBackReqDto = new ExchangeBalanceRollBackReqDto();
        rollBackReqDto.setOrderNo(orderEo.getOrderNo());
        rollBackReqDto.setTurnoverChangeTypeEnum(TurnoverChangeTypeEnum.CANCEL_ORDER);
        RestResponseHelper.extractData((RestResponse)this.exchangeBalanceAccountApi.rollbackExchangeAccount(rollBackReqDto));
        logger.info("\u53d6\u6d88\u8ba2\u5355\uff0c\u4fee\u6539\u901a\u77e5\u5355\u72b6\u6001\u5165\u53c2\uff0c\u524d\u7f6e\u4e1a\u52a1\u5355\u53f7\uff1a{}\uff0c\u72b6\u6001\uff1a{}", (Object)orderEo.getOrderNo(), (Object)1015);
        return cancelOrderBo;
    }

    public CloseOrderBo closeOrder(CloseOrderBo closeOrderBo) {
        OrderEo orderEo = closeOrderBo.getOrderEo();
        CancelReqDto cancelReqDto = closeOrderBo.getCancelReqDto();
        if (cancelReqDto == null) {
            cancelReqDto = new CancelReqDto();
        }
        if (closeOrderBo.getOrderEo() == null) {
            orderEo = this.orderDas.lockByOrderNo(closeOrderBo.getCancelReqDto().getTradeNo());
            closeOrderBo.setOrderEo(orderEo);
        }
        this.checkIfActivityAndRollbackStock(orderEo);
        if (cancelReqDto.getCancelType() == null || cancelReqDto.getCancelDesc() == null) {
            cancelReqDto.setCancelType(OrderCancelTypeEnum.SYSTEM_CANCLE.getName());
            cancelReqDto.setCancelDesc(OrderCancelTypeEnum.SYSTEM_CANCLE.getDesc());
        }
        closeOrderBo.getOrderEo().setCancelDesc(cancelReqDto.getCancelDesc());
        orderEo.setCancelTime(new Date());
        orderEo.setCancelType(cancelReqDto.getCancelType());
        if (closeOrderBo.ifNoUseFlow()) {
            this.orderDas.updateSelective((BaseEo)orderEo);
        }
        if (orderEo.getTotalRebateAmount() != null && orderEo.getTotalRebateAmount().compareTo(BigDecimal.ZERO) > 0) {
            BalanceReturnReqDto balanceReturnReqDto = new BalanceReturnReqDto();
            balanceReturnReqDto.setChangeType(ChangeTypeEnum.CLOSE_ORDER.toCode());
            balanceReturnReqDto.setOrderNo(orderEo.getOrderNo());
            balanceReturnReqDto.setReturnAmount(orderEo.getTotalRebateAmount());
            balanceReturnReqDto.setUserId(Long.valueOf(orderEo.getCustomerId()));
            this.iBalanceApi.returnBalance(balanceReturnReqDto);
        }
        this.helpService.closeOrder(orderEo);
        ExchangeBalanceRollBackReqDto rollBackReqDto = new ExchangeBalanceRollBackReqDto();
        rollBackReqDto.setOrderNo(orderEo.getOrderNo());
        rollBackReqDto.setTurnoverChangeTypeEnum(TurnoverChangeTypeEnum.CLOSE_ORDER);
        RestResponseHelper.extractData((RestResponse)this.exchangeBalanceAccountApi.rollbackExchangeAccount(rollBackReqDto));
        logger.info("\u5173\u95ed\u8ba2\u5355\uff0c\u4fee\u6539\u901a\u77e5\u5355\u72b6\u6001\u5165\u53c2\uff0c\u524d\u7f6e\u4e1a\u52a1\u5355\u53f7\uff1a{}\uff0c\u72b6\u6001\uff1a{}", (Object)orderEo.getOrderNo(), (Object)3013);
        return closeOrderBo;
    }

    private void checkIfActivityAndRollbackStock(OrderEo orderEo) {
        RestResponse restResponse = this.itemActivityStockApi.queryActivityStockType(orderEo.getInstanceId());
        Integer stockType = (Integer)RestResponseHelper.extractData((RestResponse)restResponse);
        if (B2bConstant.SHARE.equals(stockType)) {
            this.orderService.rollbackOrderStock(orderEo);
            return;
        }
        Boolean flag = false;
        List orderActivityEos = this.orderActivityService.queryActivityByOrderNo(orderEo.getOrderNo());
        for (OrderActivityEo orderActivityEo : orderActivityEos) {
            if (!ActivityConstant.SECKILL_ACTIVITY.equals(orderActivityEo.getType()) && !ActivityConstant.PROMOTION.equals(orderActivityEo.getType()) && !ActivityConstant.TIME_DISCOUNT.equals(orderActivityEo.getType())) continue;
            flag = true;
            break;
        }
        if (flag.booleanValue()) {
            this.orderService.rollbackOrderStockByActivity(orderEo);
        }
    }
}

