/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.extptimpl;

import com.dtyunxi.cube.enhance.extension.CubeExtImpl;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderDeviceType;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.AuditStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.PayMethodTobEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BaseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayMethodReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.PayMethodTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.utils.TransformUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.constants.BaseFlowDef;
import com.dtyunxi.yundt.cube.center.trade.biz.service.tob.IOptLogService;
import com.dtyunxi.yundt.cube.center.trade.conf.ext.domain.PayMethodTobBo;
import com.dtyunxi.yundt.cube.center.trade.dao.das.tob.AttachementDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.tob.AttachementEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.tob.OptLogEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IPayRecordActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.PayMethodBo;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
@CubeExtImpl(name="B\u7aef\u521b\u5efa\u652f\u4ed8\u5355\u6269\u5c55", descr="B\u7aef\u521b\u5efa\u652f\u4ed8\u5355\u6269\u5c55")
public class PayRecordActionTobExtPtImpl
implements IPayRecordActionExtPt {
    @Resource
    private IOptLogService optLogService;
    @Resource
    private IContext context;
    @Resource
    private AttachementDas attachementDas;

    public String getFlowType() {
        return "PAY";
    }

    public Long getFlowDefId() {
        return BaseFlowDef.BASE_PAY_TOB.getFlowId();
    }

    public String getFlowName() {
        return BaseFlowDef.BASE_PAY_TOB.getFlowName();
    }

    public Class getDtoClass() {
        return PayMethodTobReqDto.class;
    }

    public PayMethodReqDto validate(PayMethodReqDto payMethodReqDto) {
        return payMethodReqDto;
    }

    public PayMethodBo packBo(PayMethodBo payMethodBo, PayMethodReqDto payMethodReqDto) {
        PayMethodTobBo payMethodTobBo = (PayMethodTobBo)TransformUtil.transformParentToChild((BaseReqDto)payMethodBo, PayMethodTobBo.class);
        PayMethodTobReqDto bPayMethodReqDto = (PayMethodTobReqDto)payMethodReqDto;
        if (CollectionUtils.isNotEmpty((Collection)bPayMethodReqDto.getAttachements())) {
            List attachementEos = bPayMethodReqDto.getAttachements().stream().map(bean -> {
                AttachementEo attachementEo = AttachementEo.newInstance();
                CubeBeanUtils.copyProperties((Object)attachementEo, (Object)bean, (String[])new String[0]);
                attachementEo.setBizNo(payMethodBo.getPayRecordEo().getPayNo());
                attachementEo.setBizType(OptBizTypeEnum.PAY.getType());
                return attachementEo;
            }).collect(Collectors.toList());
            payMethodTobBo.setAttachementEos(attachementEos);
        }
        payMethodTobBo.getPayRecordEo().setStoreAmount(bPayMethodReqDto.getStoreAmount());
        payMethodTobBo.getPayRecordEo().setCreditAmount(bPayMethodReqDto.getCreditAmount());
        payMethodTobBo.getPayRecordEo().setPayTime(bPayMethodReqDto.getPayTime());
        payMethodTobBo.getPayRecordEo().setConfirmTime(bPayMethodReqDto.getConfirmTime());
        payMethodTobBo.getPayRecordEo().setRemark(bPayMethodReqDto.getRemark());
        payMethodTobBo.getPayRecordEo().setAccount(bPayMethodReqDto.getAccount());
        if (null != bPayMethodReqDto.getPayAmount() && bPayMethodReqDto.getPayAmount().compareTo(new BigDecimal(0)) > 0) {
            payMethodTobBo.getPayRecordEo().setPayAmount(bPayMethodReqDto.getPayAmount());
        }
        if (OrderDeviceType.PC.getCode().equals(bPayMethodReqDto.getDeviceType())) {
            payMethodTobBo.getPayRecordEo().setAuditStatus(AuditStatusEnum.PASS.getType());
        } else {
            payMethodTobBo.getPayRecordEo().setAuditStatus(AuditStatusEnum.WAIT.getType());
        }
        if (!StringUtils.isBlank((String)bPayMethodReqDto.getAuditStatus())) {
            payMethodTobBo.getPayRecordEo().setAuditStatus(bPayMethodReqDto.getAuditStatus());
            if (!AuditStatusEnum.WAIT.getType().equals(bPayMethodReqDto.getAuditStatus())) {
                payMethodTobBo.getPayRecordEo().setPayTime(new Date());
            }
        }
        return payMethodTobBo;
    }

    public PayMethodBo save(PayMethodBo payMethodBo, PayMethodReqDto payMethodReqDto) {
        PayMethodTobBo payMethodTobBo = (PayMethodTobBo)TransformUtil.transformParentToChild((BaseReqDto)payMethodBo, PayMethodTobBo.class);
        if (CollectionUtils.isNotEmpty((Collection)payMethodTobBo.getAttachementEos())) {
            this.attachementDas.insertBatch(payMethodTobBo.getAttachementEos());
        }
        return payMethodTobBo;
    }

    public PayMethodBo postProcessor(PayMethodBo payMethodBo, PayMethodReqDto payMethodReqDto) {
        this.saveOptLog(payMethodReqDto.getOrderNo(), payMethodReqDto.getPayMethod(), payMethodReqDto.getPayAmount());
        return payMethodBo;
    }

    private void saveOptLog(String bizNo, String payMethod, BigDecimal payAmount) {
        OptLogEo optLogEo = new OptLogEo();
        optLogEo.setBizType(OptBizTypeEnum.ORDER.getType());
        optLogEo.setBizNo(bizNo);
        optLogEo.setOptType(OptTypeEnum.ORDER_PAY_RECORD.getType());
        optLogEo.setOptTime(new Date());
        optLogEo.setOptPerson(this.context.userName());
        optLogEo.setDescription(String.format("\u3010\u65b0\u589e\u6536\u6b3e\u3011\u65b0\u589e\u6536\u6b3e\uff0c\u652f\u4ed8\u65b9\u5f0f\uff1a%s\uff0c\u91d1\u989d\uff1a%s", PayMethodTobEnum.toName((String)payMethod), payAmount));
        this.optLogService.addBoOptLog(optLogEo);
    }
}

