/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.extptimpl;

import com.dtyunxi.cube.enhance.extension.CubeExtImpl;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BaseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.RefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.RefundTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.utils.TransformUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.constants.BaseFlowDef;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.service.tob.IOptLogService;
import com.dtyunxi.yundt.cube.center.trade.conf.ext.domain.RefundCreateTobBo;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefundDetailDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.tob.AttachementDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundDetailEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.tob.AttachementEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.tob.OptLogEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IRefundActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.RefundCreateBo;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
@CubeExtImpl(name="B\u7aef\u521b\u5efa\u9000\u6b3e\u5355\u6269\u5c55", descr="B\u7aef\u521b\u5efa\u9000\u6b3e\u5355\u6269\u5c55")
public class RefundActionTobExtPtImpl
implements IRefundActionExtPt {
    @Resource
    private AttachementDas attachementDas;
    @Resource
    private IOptLogService optLogService;
    @Resource
    private RefundDetailDas refundDetailDas;
    @Resource
    private IContext context;

    public Long getFlowDefId() {
        return BaseFlowDef.BASE_RETURN_TOB.getFlowId();
    }

    public String getFlowDefName() {
        return BaseFlowDef.BASE_RETURN_TOB.getFlowName();
    }

    public Class getDtoClass() {
        return RefundTobReqDto.class;
    }

    public RefundCreateBo validate(RefundCreateBo refundCreateBo) {
        return refundCreateBo;
    }

    public RefundCreateBo packBo(RefundCreateBo refundCreateBo, RefundReqDto refundReqDto) {
        RefundCreateTobBo refundCreateTobBo = (RefundCreateTobBo)TransformUtil.transformParentToChild((BaseReqDto)refundCreateBo, RefundCreateTobBo.class);
        RefundTobReqDto refundTobReqDto = (RefundTobReqDto)refundReqDto;
        if (CollectionUtils.isNotEmpty((Collection)refundTobReqDto.getAttachements())) {
            List attachementEos = refundTobReqDto.getAttachements().stream().map(bean -> {
                AttachementEo attachementEo = AttachementEo.newInstance();
                CubeBeanUtils.copyProperties((Object)attachementEo, (Object)bean, (String[])new String[0]);
                attachementEo.setBizNo(refundReqDto.getReturnNo());
                attachementEo.setBizType(OptBizTypeEnum.RETURN.getType());
                return attachementEo;
            }).collect(Collectors.toList());
            refundCreateTobBo.setAttachementEos(attachementEos);
        }
        RefundEo refundEo = refundCreateBo.getRefundEo();
        if (CollectionUtils.isNotEmpty((Collection)refundTobReqDto.getRefundDetails())) {
            List refundDetailEos = refundTobReqDto.getRefundDetails().stream().map(bean -> {
                RefundDetailEo refundDetailEo = RefundDetailEo.newInstance();
                CubeBeanUtils.copyProperties((Object)refundDetailEo, (Object)bean, (String[])new String[0]);
                refundDetailEo.setRefundNo(refundEo.getRefundNo());
                refundDetailEo.setPayNo(refundEo.getPayNo());
                return refundDetailEo;
            }).collect(Collectors.toList());
            refundCreateTobBo.setRefundDetailEos(refundDetailEos);
        }
        refundCreateTobBo.getRefundEo().setRefundPerson(refundTobReqDto.getRefundPerson());
        refundCreateTobBo.getRefundEo().setRemark(refundTobReqDto.getRemark());
        if (StringUtils.isNotEmpty((String)refundTobReqDto.getRefundStatus())) {
            refundCreateTobBo.getRefundEo().setRefundStatus(refundTobReqDto.getRefundStatus());
        }
        refundCreateTobBo.setRefundRequest(null);
        return refundCreateTobBo;
    }

    public RefundCreateBo save(RefundCreateBo refundCreateBo, RefundReqDto refundReqDto) {
        RefundCreateTobBo refundCreateTobBo = (RefundCreateTobBo)TransformUtil.transformParentToChild((BaseReqDto)refundCreateBo, RefundCreateTobBo.class);
        if (CollectionUtils.isNotEmpty((Collection)refundCreateTobBo.getAttachementEos())) {
            this.attachementDas.insertBatch(refundCreateTobBo.getAttachementEos());
        }
        if (CollectionUtils.isNotEmpty((Collection)refundCreateTobBo.getRefundDetailEos())) {
            this.refundDetailDas.insertBatch(refundCreateTobBo.getRefundDetailEos());
        }
        return refundCreateTobBo;
    }

    public RefundCreateBo postProcessor(RefundCreateBo refundCreateBo, RefundReqDto refundReqDto) {
        this.saveOptLog(refundReqDto.getReturnNo());
        return refundCreateBo;
    }

    private void saveOptLog(String bizNo) {
        OptLogEo optLogEo = new OptLogEo();
        optLogEo.setBizType(OptBizTypeEnum.RETURN.getType());
        optLogEo.setBizNo(bizNo);
        optLogEo.setOptType(OptTypeEnum.REFUND_CREATE.getType());
        optLogEo.setOptTime(new Date());
        optLogEo.setOptPerson(this.context.userName());
        optLogEo.setDescription("\u6dfb\u52a0\u9000\u6b3e\u8bb0\u5f55\u6210\u529f");
        this.optLogService.addBoOptLog(optLogEo);
    }

    public String generateRefundNo(RefundCreateBo refundCreateBo) {
        return TradeUtil.generateTradeNo();
    }
}

