/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.extptimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.enhance.extension.CubeExtImpl;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsReceiveNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.order.recipt.ITcbjReciptApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjNotiGenItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjNotiGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReturnStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReturnTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.SaleChannelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.ReturnOrderCreateModeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.AfterSalesItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BaseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.AfterSalesItemTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.trade.api.utils.TransformUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.constants.BaseFlowDef;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.tob.IOptLogService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.ResponseUtil;
import com.dtyunxi.yundt.cube.center.trade.conf.ext.domain.ReturnCreateTobBo;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ApplyReturnItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.tob.AttachementDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ApplyReturnItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdDeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdReturnEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdTradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.tob.AttachementEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.tob.OptLogEo;
import com.dtyunxi.yundt.cube.center.trade.ext.api.constants.OrderBizStatusTobEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IReturnRefundActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.CancelReturnBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.ReturnCreateBo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@CubeExtImpl(name="B\u7aef\u521b\u5efa\u552e\u540e\u5355\u6269\u5c55", descr="B\u7aef\u521b\u5efa\u552e\u540e\u5355\u6269\u5c55")
public class ReturnRefundActionTobExtPtImpl
implements IReturnRefundActionExtPt {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @CubeResource
    private IReturnRefundActionExtPt returnRefundActionExtPt;
    @Resource
    private AttachementDas attachementDas;
    @Resource
    private IOptLogService optLogService;
    @Resource
    private IContext context;
    @Resource
    private IOrderService orderService;
    @Resource
    private IWarehouseQueryApi warehouseQueryApi;
    @Resource
    private IAreaQueryApi areaQueryApi;
    @Resource
    private OrderDeliveryDas orderDeliveryDas;
    @Resource
    private DeliveryItemDas deliveryItemDas;
    @Resource
    private ReturnDas returnDas;
    @Resource
    private ReturnItemDas returnItemDas;
    @Resource
    private ApplyReturnItemDas applyReturnItemDas;
    @Resource
    private ITradeItemService tradeItemService;
    @Resource
    private TradeItemDas tradeItemDas;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private ITcbjReciptApi tcbjReciptApi;
    @Autowired
    private ITcbjInventoryApi tcbjInventoryApi;
    @Resource
    private ICsReceiveNoticeOrderApi receiveNoticeOrderApi;

    public Long getFlowDefId() {
        return BaseFlowDef.BASE_RETURN_TOB.getFlowId();
    }

    public String getFlowDefName() {
        return BaseFlowDef.BASE_RETURN_TOB.getFlowName();
    }

    public Class getDtoClass() {
        return ReturnTobReqDto.class;
    }

    public Class getDetailDtoClass() {
        return AfterSalesItemTobReqDto.class;
    }

    public ReturnCreateBo validate(ReturnCreateBo returnBo) {
        OrderEo orderEo = this.orderService.getByOrderNo(returnBo.getReturnReqDto().getOrderTradeNo());
        if (!(null == orderEo || OrderBizStatusTobEnum.PART_CONFIRM.getCode().equals(orderEo.getOrderTradeStatus()) || OrderBizStatusTobEnum.CONFIRM.getCode().equals(orderEo.getOrderTradeStatus()) || OrderBizStatusTobEnum.FINISH.getCode().equals(orderEo.getOrderTradeStatus()))) {
            throw new com.dtyunxi.exceptions.BizException("\u8ba2\u5355\uff1a" + returnBo.getReturnReqDto().getOrderTradeNo() + "\u7684\u72b6\u6001\u4e3a\uff1a" + OrderBizStatusTobEnum.toName((String)orderEo.getOrderTradeStatus()) + "\uff0c\u4e0d\u80fd\u552e\u540e");
        }
        return returnBo;
    }

    public ReturnCreateBo packBo(ReturnCreateBo returnBo, ReturnReqDto returnReqDto) {
        ReturnCreateTobBo returnCreateTobBo = (ReturnCreateTobBo)TransformUtil.transformParentToChild((BaseReqDto)returnBo, ReturnCreateTobBo.class);
        ReturnTobReqDto returnTobReqDto = (ReturnTobReqDto)returnReqDto;
        if (CollectionUtils.isNotEmpty((Collection)returnTobReqDto.getAttachements())) {
            List attachementEos = returnTobReqDto.getAttachements().stream().map(bean -> {
                AttachementEo attachementEo = AttachementEo.newInstance();
                CubeBeanUtils.copyProperties((Object)attachementEo, (Object)bean, (String[])new String[0]);
                attachementEo.setBizNo(returnBo.getReturnEo().getReturnNo());
                attachementEo.setBizType(OptBizTypeEnum.RETURN.getType());
                return attachementEo;
            }).collect(Collectors.toList());
            returnCreateTobBo.setAttachementEos(attachementEos);
        }
        returnCreateTobBo.getReturnEo().setRefundStatus(returnTobReqDto.getRefundStatus());
        returnCreateTobBo.getReturnEo().setRemark(returnTobReqDto.getRemark());
        returnCreateTobBo.getReturnEo().setTotalAmount(returnTobReqDto.getTotalAmount());
        returnCreateTobBo.getReturnEo().setPlaceTime(returnTobReqDto.getPlaceTime());
        returnCreateTobBo.getReturnEo().setPlaceUserId(returnTobReqDto.getPlaceUserId());
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)returnBo.getReturnEo().getReturnDesc())) {
            returnCreateTobBo.getReturnEo().setReturnDesc(returnTobReqDto.getReturnDesc());
        }
        returnCreateTobBo.getReturnEo().setCustomerId(returnTobReqDto.getCustomerId());
        if (null == returnBo.getFlag() || !returnBo.getFlag().booleanValue()) {
            returnCreateTobBo.getReturnItemEos().stream().forEach(bean -> {
                AfterSalesItemReqDto afterSalesItemReqDto = (AfterSalesItemReqDto)returnBo.getSalesItemReqDtoMap().get(bean.getSkuSerial() + "_" + bean.getGift());
                if (null != afterSalesItemReqDto) {
                    AfterSalesItemTobReqDto afterSalesItemTobReqDto = (AfterSalesItemTobReqDto)afterSalesItemReqDto;
                    bean.setReturnedNum(afterSalesItemTobReqDto.getReturnedNum());
                    bean.setReturnNum(afterSalesItemTobReqDto.getReturnNum());
                    bean.setUnit(afterSalesItemTobReqDto.getUnit());
                    bean.setItemAmount(afterSalesItemTobReqDto.getItemAmount());
                    bean.setRefundAmount(afterSalesItemTobReqDto.getRefundAmount());
                }
            });
        }
        return returnCreateTobBo;
    }

    public ReturnCreateBo save(ReturnCreateBo returnBo, ReturnReqDto returnReqDto) {
        ReturnCreateTobBo returnCreateTobBo = (ReturnCreateTobBo)TransformUtil.transformParentToChild((BaseReqDto)returnBo, ReturnCreateTobBo.class);
        if (CollectionUtils.isNotEmpty((Collection)returnCreateTobBo.getAttachementEos())) {
            this.attachementDas.insertBatch(returnCreateTobBo.getAttachementEos());
        }
        return returnCreateTobBo;
    }

    public ReturnCreateBo postProcessor(ReturnCreateBo returnBo, ReturnReqDto returnReqDto) {
        this.saveOptLog(returnBo.getReturnEo().getReturnNo(), returnBo.getReturnEo().getReturnType());
        return returnBo;
    }

    private void createReciptInform(ReturnCreateBo returnBo, ReturnReqDto returnReqDto) {
        JSONObject jsonObject;
        ReturnCreateTobBo returnCreateTobBo = (ReturnCreateTobBo)TransformUtil.transformParentToChild((BaseReqDto)returnBo, ReturnCreateTobBo.class);
        ReturnEo returnEo = returnBo.getReturnEo();
        TcbjNotiGenReqDto tcbjNotiGenReqDto = new TcbjNotiGenReqDto();
        tcbjNotiGenReqDto.setPreNo(returnEo.getReturnNo());
        tcbjNotiGenReqDto.setOrganizationId(returnEo.getOrganizationId());
        String planTime = DateFormatUtils.format((Date)returnEo.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss");
        tcbjNotiGenReqDto.setPlanTime(planTime);
        this.logger.info("getBuyerAddrInfo={}", (Object)returnEo.getBuyerAddrInfo());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)returnEo.getBuyerAddrInfo()) && (jsonObject = JSONObject.parseObject((String)returnEo.getBuyerAddrInfo())) != null) {
            tcbjNotiGenReqDto.setReciveName(jsonObject.getString("contact"));
            tcbjNotiGenReqDto.setRecivePhone(jsonObject.getString("phone"));
            tcbjNotiGenReqDto.setAddress(jsonObject.getString("address"));
            this.logger.info("\u4e0a\u95e8\u53d6\u8d27\u5730\u5740id{}", (Object)jsonObject.getString("id"));
        }
        tcbjNotiGenReqDto.setWarehouseCode(returnEo.getWarehouseCode());
        ArrayList<TcbjNotiGenItemReqDto> notiGenItemReqDtos = new ArrayList<TcbjNotiGenItemReqDto>();
        for (ApplyReturnItemEo item : returnCreateTobBo.getApplyReturnItemEos()) {
            TcbjNotiGenItemReqDto dto = new TcbjNotiGenItemReqDto();
            dto.setBatch(null);
            dto.setCargoCode(item.getCargoSerial());
            dto.setTradeOrderItemId(item.getTradeItemId());
            dto.setNum(item.getReturnNum());
            dto.setPlanNum(item.getReturnNum());
            notiGenItemReqDtos.add(dto);
        }
        tcbjNotiGenReqDto.setNotiGenItemReqDtos(notiGenItemReqDtos);
        tcbjNotiGenReqDto.setType(Integer.valueOf(204));
        this.tcbjReciptApi.send(tcbjNotiGenReqDto);
    }

    public ReturnCreateBo dealWithoutOrderNo(ReturnCreateBo returnCreateBo) {
        ReturnReqDto returnReqDto = returnCreateBo.getReturnReqDto();
        if (null != returnReqDto) {
            String deliveryNo = returnReqDto.getDeliveryNo();
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)deliveryNo)) {
                OrderDeliveryEo orderDeliveryEo = this.orderDeliveryDas.selectByDeliveryNo(deliveryNo);
                List deliveryItemEos = this.deliveryItemDas.queryByDeliveryNo(deliveryNo);
                String orderNo = orderDeliveryEo.getOrderNo();
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)orderNo)) {
                    OrderEo orderEo = this.orderService.getByOrderNo(orderNo);
                    ReturnEo returnEo = ReturnEo.newInstance();
                    returnReqDto.setTradeNo(TradeUtil.generateTradeNo((String)orderEo.getOrderNo()));
                    CubeBeanUtils.copyProperties((Object)returnEo, (Object)returnReqDto, (String[])new String[0]);
                    returnEo.setTradeNo(returnReqDto.getTradeNo());
                    returnEo.setReturnNo(returnReqDto.getTradeNo());
                    this.copyRedundancyAttribute(returnEo, orderEo);
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)returnReqDto.getWarehouseCode())) {
                        returnEo.setWarehouseCode(returnReqDto.getWarehouseCode());
                    } else {
                        returnEo.setWarehouseCode(orderEo.getWarehouseCode());
                    }
                    this.setReturnDescTob(returnEo);
                    returnEo.setDeliveryNo(deliveryNo);
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)returnReqDto.getDeviceType())) {
                        returnEo.setDeviceType(returnReqDto.getDeviceType());
                    }
                    returnCreateBo.setReturnEo(returnEo);
                    returnCreateBo.setOrderEo(orderEo);
                    HashMap map = new HashMap();
                    ArrayList<DeliveryItemEo> waitUpdate = new ArrayList<DeliveryItemEo>();
                    ArrayList<TradeItemEo> giftWaitUpdate = new ArrayList<TradeItemEo>();
                    ArrayList<AfterSalesItemReqDto> itemList = new ArrayList<AfterSalesItemReqDto>(returnReqDto.getAfterSalesItems().size());
                    ArrayList<AfterSalesItemReqDto> giftList = new ArrayList<AfterSalesItemReqDto>(returnReqDto.getAfterSalesItems().size());
                    for (AfterSalesItemReqDto afterSalesItem : returnReqDto.getAfterSalesItems()) {
                        if (YesNoEnum.YES.getValue().equals(afterSalesItem.getGift())) {
                            giftList.add(afterSalesItem);
                            continue;
                        }
                        itemList.add(afterSalesItem);
                    }
                    List tradeItemEos = this.tradeItemService.queryByTradeNo(orderNo);
                    Map<String, TradeItemEo> tradeItemMap = tradeItemEos.stream().collect(Collectors.toMap(StdTradeItemEo::getTradeItemNo, item -> item, (v1, v2) -> v2));
                    Map<String, DeliveryItemEo> deliveryItemMap = deliveryItemEos.stream().collect(Collectors.toMap(StdDeliveryItemEo::getTrOrderItemNo, item -> item, (v1, v2) -> v2));
                    HashMap itemRefundNumMap = orderEo.getTotalRebateAmount() == null || orderEo.getTotalRebateAmount().compareTo(BigDecimal.ZERO) == 0 ? Maps.newHashMap() : this.getStringBigDecimalMap(orderNo);
                    List returnItemEos = returnReqDto.getAfterSalesItems().stream().map(bean -> {
                        BigDecimal rebateAmount;
                        AfterSalesItemReqDto afterSalesItemReqDto = (AfterSalesItemReqDto)EoUtil.transformExtFieldsToDto((BaseVo)bean, (Class)this.returnRefundActionExtPt.getDetailDtoClass());
                        AfterSalesItemTobReqDto afterSalesItemTobReqDto = (AfterSalesItemTobReqDto)afterSalesItemReqDto;
                        TradeItemEo tradeItemEo = (TradeItemEo)tradeItemMap.get(bean.getTradeItemNo());
                        ReturnItemEo returnItemEo = new ReturnItemEo();
                        if (YesNoEnum.YES.getValue().equals(tradeItemEo.getGift())) {
                            CubeBeanUtils.copyProperties((Object)returnItemEo, (Object)tradeItemEo, (String[])new String[0]);
                            Integer returnedNum = null != tradeItemEo.getReturnedNum() ? tradeItemEo.getReturnedNum() : 0;
                            Integer refundItemNum = null != bean.getItemNum() ? bean.getItemNum() : afterSalesItemTobReqDto.getReturnNum();
                            tradeItemEo.setReturnedNum(Integer.valueOf(returnedNum + refundItemNum));
                            giftWaitUpdate.add(tradeItemEo);
                        } else {
                            DeliveryItemEo deliveryItemEo = (DeliveryItemEo)deliveryItemMap.get(bean.getTradeItemNo());
                            CubeBeanUtils.copyProperties((Object)returnItemEo, (Object)deliveryItemEo, (String[])new String[0]);
                            Integer returnedNum = null != deliveryItemEo.getReturnedNum() ? deliveryItemEo.getReturnedNum() : 0;
                            Integer refundItemNum = null != bean.getItemNum() ? bean.getItemNum() : afterSalesItemTobReqDto.getReturnNum();
                            deliveryItemEo.setReturnedNum(Integer.valueOf(returnedNum + refundItemNum));
                            waitUpdate.add(deliveryItemEo);
                        }
                        returnItemEo.setId(null);
                        returnItemEo.setSkuSerial(bean.getSkuSerial());
                        returnItemEo.setReturnNo(returnEo.getReturnNo());
                        returnItemEo.setDeliveryNo(deliveryNo);
                        returnItemEo.setReturnedNum(afterSalesItemTobReqDto.getReturnedNum());
                        returnItemEo.setReturnNum(afterSalesItemTobReqDto.getReturnNum());
                        returnItemEo.setUnit(afterSalesItemTobReqDto.getUnit());
                        returnItemEo.setRemark(afterSalesItemTobReqDto.getRemark());
                        returnItemEo.setExtension(afterSalesItemTobReqDto.getExtension());
                        returnItemEo.setItemId(afterSalesItemTobReqDto.getItemSerial());
                        returnItemEo.setItemAmount(afterSalesItemTobReqDto.getItemAmount());
                        returnItemEo.setRefundAmount(afterSalesItemTobReqDto.getRefundAmount());
                        returnItemEo.setGift(bean.getGift());
                        if (returnItemEo.getReturnedNum() < returnItemEo.getItemNum()) {
                            rebateAmount = tradeItemEo.getRebateAmount() == null ? BigDecimal.ZERO : tradeItemEo.getRebateAmount();
                            BigDecimal divide = rebateAmount.divide(BigDecimal.valueOf(tradeItemEo.getItemNum().intValue()), 1);
                            returnItemEo.setReturnRebate(divide.multiply(BigDecimal.valueOf(returnItemEo.getReturnNum().intValue())).setScale(2, 1));
                        } else {
                            rebateAmount = tradeItemEo.getRebateAmount() == null ? BigDecimal.ZERO : tradeItemEo.getRebateAmount();
                            BigDecimal returnedRebate = itemRefundNumMap.get(bean.getSkuSerial()) == null ? BigDecimal.ZERO : (BigDecimal)itemRefundNumMap.get(bean.getSkuSerial());
                            BigDecimal subtract = rebateAmount.subtract(returnedRebate);
                            returnItemEo.setReturnRebate(subtract);
                        }
                        map.put(bean.getSkuSerial() + "_" + bean.getGift(), afterSalesItemReqDto);
                        return returnItemEo;
                    }).collect(Collectors.toList());
                    BigDecimal totalRebate = returnItemEos.stream().map(item -> item.getReturnRebate() == null ? BigDecimal.ZERO : item.getReturnRebate()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    returnEo.setReturnRebate(totalRebate);
                    returnCreateBo.setSalesItemReqDtoMap(map);
                    returnCreateBo.setReturnItemEos(returnItemEos);
                    returnCreateBo = this.returnRefundActionExtPt.packBo(returnCreateBo, returnReqDto);
                    returnCreateBo = this.savePre(returnCreateBo, returnReqDto);
                    if (CollectionUtils.isNotEmpty(waitUpdate)) {
                        this.updateDeliveryItem(waitUpdate);
                    }
                    if (CollectionUtils.isNotEmpty(giftWaitUpdate)) {
                        this.updateTradeItem(giftWaitUpdate);
                    }
                    return this.postProcessor(returnCreateBo, returnReqDto);
                }
            } else {
                String customerId = returnReqDto.getCustomerId();
                List afterSalesItemReqDtos = returnReqDto.getAfterSalesItems();
                List<String> skuIds = afterSalesItemReqDtos.stream().map(AfterSalesItemReqDto::getSkuSerial).collect(Collectors.toList());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)customerId)) {
                    OrderEo queryorderEo = OrderEo.newInstance();
                    queryorderEo.setCustomerId(customerId);
                    List orderEos = this.orderService.queryList(queryorderEo);
                    if (CollectionUtils.isEmpty((Collection)orderEos)) {
                        throw new com.dtyunxi.exceptions.BizException(TradeExceptionCode.ORDER_NO_EXIT.getCode(), TradeExceptionCode.ORDER_NO_EXIT.getMsg());
                    }
                    OrderEo orderEo = (OrderEo)orderEos.get(0);
                    OrderDeliveryEo queryEo = OrderDeliveryEo.newInstance();
                    queryEo.setCustomerId(customerId);
                    queryEo.setDeliveryStatus(DeliveryStatusEnum.SIGNED.getStatus());
                    List orderDeliveryEos = this.orderDeliveryDas.select((BaseEo)queryEo);
                    if (CollectionUtils.isNotEmpty((Collection)orderDeliveryEos)) {
                        List<OrderDeliveryDetailRespDto> targetOrderDelivery = this.getTargetOrderDelivery(skuIds, orderDeliveryEos);
                        ReturnEo returnEo = ReturnEo.newInstance();
                        returnReqDto.setTradeNo(TradeUtil.generateTradeNo((String)orderEo.getOrderNo()));
                        CubeBeanUtils.copyProperties((Object)returnEo, (Object)returnReqDto, (String[])new String[0]);
                        returnEo.setTradeNo(returnReqDto.getTradeNo());
                        returnEo.setReturnNo(returnReqDto.getTradeNo());
                        this.copyRedundancyAttribute(returnEo, orderEo);
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)returnReqDto.getWarehouseCode())) {
                            returnEo.setWarehouseCode(returnReqDto.getWarehouseCode());
                        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((OrderDeliveryEo)orderDeliveryEos.get(0)).getWarehouseCode())) {
                            returnEo.setWarehouseCode(((OrderDeliveryEo)orderDeliveryEos.get(0)).getWarehouseCode());
                        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderEo.getWarehouseCode())) {
                            returnEo.setWarehouseCode(orderEo.getWarehouseCode());
                        }
                        this.setReturnDescTob(returnEo);
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)returnReqDto.getDeviceType())) {
                            returnEo.setDeviceType(returnReqDto.getDeviceType());
                        }
                        returnCreateBo.setReturnEo(returnEo);
                        returnCreateBo.setOrderEo(orderEo);
                        HashMap<String, AfterSalesItemReqDto> map = new HashMap<String, AfterSalesItemReqDto>();
                        ArrayList<ReturnItemEo> returnItemEos = new ArrayList<ReturnItemEo>();
                        ArrayList<DeliveryItemRespDto> waitUpdate = new ArrayList<DeliveryItemRespDto>();
                        for (AfterSalesItemReqDto bean2 : returnReqDto.getAfterSalesItems()) {
                            AfterSalesItemReqDto afterSalesItemReqDto = (AfterSalesItemReqDto)EoUtil.transformExtFieldsToDto((BaseVo)bean2, (Class)this.returnRefundActionExtPt.getDetailDtoClass());
                            AfterSalesItemTobReqDto afterSalesItemTobReqDto = (AfterSalesItemTobReqDto)afterSalesItemReqDto;
                            String skuSerial = bean2.getSkuSerial();
                            List deepOrderDelivery = targetOrderDelivery.stream().filter(delivery -> {
                                List deliveryItems = delivery.getDeliveryItems();
                                List skuIdList = deliveryItems.stream().map(DeliveryItemRespDto::getSkuSerial).collect(Collectors.toList());
                                if (skuIdList.contains(skuSerial)) {
                                    Optional<DeliveryItemRespDto> optionalDeliveryItemRespDto = deliveryItems.stream().filter(item -> skuSerial.equals(item.getSkuSerial())).findFirst();
                                    return optionalDeliveryItemRespDto.isPresent() && optionalDeliveryItemRespDto.get().getItemNum() > 0 && (Objects.isNull(optionalDeliveryItemRespDto.get().getReturnedNum()) || optionalDeliveryItemRespDto.get().getItemNum() > optionalDeliveryItemRespDto.get().getReturnedNum());
                                }
                                return false;
                            }).collect(Collectors.toList());
                            Integer refundItemNum = null != bean2.getItemNum() ? bean2.getItemNum() : afterSalesItemTobReqDto.getReturnNum();
                            for (OrderDeliveryDetailRespDto deepBean : deepOrderDelivery) {
                                Optional<DeliveryItemRespDto> first = deepBean.getDeliveryItems().stream().filter(b -> b.getSkuSerial().equals(skuSerial)).findFirst();
                                if (!first.isPresent()) continue;
                                DeliveryItemRespDto deliveryItemRespDto = first.get();
                                waitUpdate.add(deliveryItemRespDto);
                                ReturnItemEo returnItemEo = ReturnItemEo.newInstance();
                                returnItemEo.setDeliveryNo(deepBean.getDeliveryNo());
                                CubeBeanUtils.copyProperties((Object)returnItemEo, (Object)deliveryItemRespDto, (String[])new String[0]);
                                returnItemEo.setId(null);
                                returnItemEo.setSkuSerial(deliveryItemRespDto.getSkuSerial());
                                returnItemEo.setReturnNo(returnEo.getReturnNo());
                                returnItemEo.setUnit(returnItemEo.getUnit());
                                returnItemEo.setRemark(afterSalesItemTobReqDto.getRemark());
                                returnItemEo.setExtension(afterSalesItemTobReqDto.getExtension());
                                returnItemEo.setItemId(afterSalesItemTobReqDto.getItemSerial());
                                returnItemEos.add(returnItemEo);
                                Integer itemNum = null != deliveryItemRespDto.getItemNum() ? deliveryItemRespDto.getItemNum() : 0;
                                Integer returnedNum = null != deliveryItemRespDto.getReturnedNum() ? deliveryItemRespDto.getReturnedNum() : 0;
                                if (refundItemNum <= itemNum - returnedNum) {
                                    returnItemEo.setReturnNum(refundItemNum);
                                    returnItemEo.setItemAmount(new BigDecimal(refundItemNum).multiply(Optional.ofNullable(deliveryItemRespDto.getItemPrice()).orElse(BigDecimal.ZERO)));
                                    returnItemEo.setRefundAmount(new BigDecimal(refundItemNum).multiply(Optional.ofNullable(deliveryItemRespDto.getItemPrice()).orElse(BigDecimal.ZERO)));
                                    deliveryItemRespDto.setReturnedNum(Integer.valueOf(returnedNum + refundItemNum));
                                    deliveryItemRespDto.setExtFields(null);
                                    break;
                                }
                                Integer remainNum = Optional.ofNullable(itemNum - returnedNum).orElse(0);
                                returnItemEo.setReturnNum(remainNum);
                                returnItemEo.setItemAmount(new BigDecimal(remainNum).multiply(Optional.ofNullable(deliveryItemRespDto.getItemPrice()).orElse(BigDecimal.ZERO)));
                                returnItemEo.setRefundAmount(new BigDecimal(remainNum).multiply(Optional.ofNullable(deliveryItemRespDto.getItemPrice()).orElse(BigDecimal.ZERO)));
                                refundItemNum = refundItemNum - (itemNum - returnedNum);
                                deliveryItemRespDto.setReturnedNum(itemNum);
                                deliveryItemRespDto.setExtFields(null);
                            }
                            map.put(skuSerial, afterSalesItemReqDto);
                        }
                        returnCreateBo.setSalesItemReqDtoMap(map);
                        returnCreateBo.setReturnItemEos(returnItemEos);
                        returnCreateBo = this.returnRefundActionExtPt.packBo(returnCreateBo, returnReqDto);
                        returnCreateBo = this.savePre(returnCreateBo, returnReqDto);
                        if (CollectionUtils.isNotEmpty(waitUpdate)) {
                            List deliveryItemEos = EoUtil.dtoListToEoList(waitUpdate, DeliveryItemEo.class);
                            this.updateDeliveryItem(deliveryItemEos);
                        }
                        return this.postProcessor(returnCreateBo, returnReqDto);
                    }
                }
            }
        }
        return returnCreateBo;
    }

    private Map<String, BigDecimal> getStringBigDecimalMap(String orderNo) {
        HashMap itemRefundNumMap = Maps.newHashMap();
        List returnEos = this.returnDas.getReturnEos(orderNo);
        List returnNoList = returnEos.stream().filter(afterSalesRespDto -> !ReturnStatusEnum.CANCEL.getName().equals(afterSalesRespDto.getReturnStatus()) && !ReturnStatusEnum.REJECT.getName().equals(afterSalesRespDto.getReturnStatus())).collect(Collectors.toList()).stream().map(StdReturnEo::getReturnNo).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(returnNoList)) {
            this.logger.info("\u9000\u8ba2\u5355:\u83b7\u53d6\u8ba2\u5355\u5df2\u9000\u8bb0\u5f55\u4e3a\u7a7a\u65e5\u5fd7\u8f93\u51fa[{}]", (Object)JSON.toJSONString((Object)orderNo));
            return itemRefundNumMap;
        }
        List returnItems = this.returnItemDas.getReturnItemEos(returnNoList);
        returnItems.forEach(returnItemEo -> {
            BigDecimal returnedRebate = returnItemEo.getReturnRebate() == null ? BigDecimal.ZERO : returnItemEo.getReturnRebate();
            BigDecimal itemRefundRebate = (BigDecimal)itemRefundNumMap.get(returnItemEo.getSkuSerial());
            itemRefundRebate = null == itemRefundRebate ? returnedRebate : itemRefundRebate.add(returnedRebate);
            itemRefundNumMap.put(returnItemEo.getSkuSerial(), itemRefundRebate);
        });
        return itemRefundNumMap;
    }

    public CancelReturnBo cancelReturnFinishAction(CancelReturnBo cancelReturnBo) {
        ReturnEo returnEo = cancelReturnBo.getReturnEo();
        this.logger.info("returnEo is null={}", (Object)(returnEo == null ? 1 : 0));
        if (cancelReturnBo.getCancelReqDto() != null) {
            CancelReqDto cancelReqDto = cancelReturnBo.getCancelReqDto();
            returnEo.setCancelType(cancelReqDto.getCancelType());
            returnEo.setCancelDesc(cancelReqDto.getCancelDesc());
        }
        this.returnAfterSaleNum(returnEo.getReturnNo());
        returnEo.setCancelTime(new Date());
        OptLogEo optLogEo = new OptLogEo();
        optLogEo.setBizType(OptBizTypeEnum.RETURN.getType());
        optLogEo.setBizNo(returnEo.getReturnNo());
        optLogEo.setOptType(OptTypeEnum.RETURN_CANCEL.getType());
        optLogEo.setOptTime(new Date());
        optLogEo.setOptPerson(this.context.userName());
        String desc = String.format("\u5df2\u53d6\u6d88\u9000\u8ba2\u5355\u3002%s", cancelReturnBo.getCancelReqDto().getCancelDesc());
        optLogEo.setDescription(desc);
        this.optLogService.addBoOptLog(optLogEo);
        this.logger.info("\u53d6\u6d88\u9000\u8d27\u5355\uff0c\u4fee\u6539\u901a\u77e5\u5355\u72b6\u6001\u5165\u53c2\uff0c\u524d\u7f6e\u4e1a\u52a1\u5355\u53f7\uff1a{}\uff0c\u72b6\u6001\uff1a{}", (Object)returnEo.getReturnNo(), (Object)2016);
        RestResponseHelper.extractData((RestResponse)this.receiveNoticeOrderApi.updateOrderStatus(returnEo.getReturnNo(), CsOrderStatusEnum.RECEIVE_CANCEL.getCode()));
        return cancelReturnBo;
    }

    private void returnAfterSaleNum(String returnNo) {
        ReturnItemEo queryReturnItemEo = ReturnItemEo.newInstance();
        queryReturnItemEo.setReturnNo(returnNo);
        List returnItemEos = this.returnItemDas.select((BaseEo)queryReturnItemEo);
        List targetReturnItemEos = returnItemEos.stream().filter(bean -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)bean.getDeliveryNo())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(targetReturnItemEos)) {
            this.logger.info("returnAfterSaleNum targetReturnItemEos\uff1asize={}", targetReturnItemEos);
            List deliveryNos = targetReturnItemEos.stream().map(ReturnItemEo::getDeliveryNo).collect(Collectors.toList());
            DeliveryItemEo queryDeliveryItemEo = DeliveryItemEo.newInstance();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"delivery_no", deliveryNos));
            queryDeliveryItemEo.setSqlFilters(sqlFilters);
            List deliveryItemEos = this.deliveryItemDas.select((BaseEo)queryDeliveryItemEo);
            if (CollectionUtils.isNotEmpty((Collection)deliveryItemEos)) {
                targetReturnItemEos.stream().forEach(bean -> {
                    DeliveryItemEo deliveryItemEo2;
                    Optional<DeliveryItemEo> deliveryItemEoOptional = deliveryItemEos.stream().filter(deliveryItemEo -> null != deliveryItemEo.getSkuSerial() && null != bean.getSkuSerial() && deliveryItemEo.getSkuSerial().equals(bean.getSkuSerial())).findFirst();
                    if (deliveryItemEoOptional.isPresent() && null != (deliveryItemEo2 = deliveryItemEoOptional.get()).getReturnedNum() && deliveryItemEo2.getReturnedNum() >= bean.getReturnNum()) {
                        deliveryItemEo2.setReturnedNum(Integer.valueOf(deliveryItemEo2.getReturnedNum() - bean.getReturnNum()));
                        this.deliveryItemDas.updateSelective((BaseEo)deliveryItemEo2);
                    }
                });
            }
        }
    }

    private ReturnCreateBo savePre(ReturnCreateBo returnBo, ReturnReqDto returnReqDto) {
        if (null != returnBo.getReturnEo()) {
            this.returnDas.insert((BaseEo)returnBo.getReturnEo());
        }
        if (CollectionUtils.isNotEmpty((Collection)returnBo.getReturnItemEos())) {
            this.returnItemDas.insertBatch(returnBo.getReturnItemEos());
        }
        return this.returnRefundActionExtPt.save(returnBo, returnReqDto);
    }

    private WarehouseRespDto buildWarehouse(Long orgId) {
        try {
            WarehouseQueryReqDto warehouseQueryReqDto = new WarehouseQueryReqDto();
            warehouseQueryReqDto.setOrganizationIds((List)Lists.newArrayList((Object[])new Long[]{orgId}));
            warehouseQueryReqDto.setType("1");
            warehouseQueryReqDto.setMainWarehouse(Integer.valueOf(1));
            RestResponse pageInfoRestResp = this.warehouseQueryApi.queryWarehousePage(warehouseQueryReqDto, Integer.valueOf(1), Integer.valueOf(1));
            PageInfo warehousePageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResp);
            return (WarehouseRespDto)warehousePageInfo.getList().get(0);
        }
        catch (Exception e) {
            throw new BizException("\u5546\u5bb6\u672a\u914d\u7f6e\u9ed8\u8ba4\u9000\u8d27\u4ed3\u5e93,\u8bf7\u8054\u7cfb\u5ba2\u670d\u5904\u7406");
        }
    }

    private void setReturnDescTob(ReturnEo returnEo) {
        String returnDesc = returnEo.getReturnDesc();
        if (!StringUtils.isNotEmpty((String)returnDesc)) {
            WarehouseRespDto warehouseRespDto = (WarehouseRespDto)ResponseUtil.getSuccessResult((RestResponse)this.warehouseQueryApi.queryWarehouseByCode(returnEo.getWarehouseCode(), "{}"));
            StringBuilder sb = new StringBuilder();
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)warehouseRespDto.getProvCode())) {
                RestResponse provRestResponse = this.areaQueryApi.queryByCode(warehouseRespDto.getProvCode());
                AreaDto provDto = (AreaDto)ResponseUtil.getSuccessResult((RestResponse)provRestResponse);
                sb.append(provDto.getName());
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)warehouseRespDto.getCityCode())) {
                RestResponse cityRestResponse = this.areaQueryApi.queryByCode(warehouseRespDto.getCityCode());
                AreaDto cityDto = (AreaDto)ResponseUtil.getSuccessResult((RestResponse)cityRestResponse);
                sb.append(cityDto.getName());
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)warehouseRespDto.getAreaCode())) {
                RestResponse areaRestResponse = this.areaQueryApi.queryByCode(warehouseRespDto.getAreaCode());
                AreaDto areaDto = (AreaDto)ResponseUtil.getSuccessResult((RestResponse)areaRestResponse);
                sb.append(areaDto.getName());
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)warehouseRespDto.getAddr())) {
                sb.append(warehouseRespDto.getAddr());
            }
            sb.append(warehouseRespDto.getAddr());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("deliveryName", (Object)warehouseRespDto.getContactPerson());
            jsonObject.put("deliveryMobile", (Object)warehouseRespDto.getContactPhone());
            jsonObject.put("deliveryAddress", (Object)sb.toString());
            returnEo.setReturnDesc(jsonObject.toJSONString());
        }
    }

    private void copyRedundancyAttribute(ReturnEo returnEo, OrderEo orderEo) {
        returnEo.setOrderTradeNo(orderEo.getTradeNo());
        returnEo.setBizStatus(ReturnStatusEnum.INIT.getName());
        returnEo.setDeviceType(orderEo.getDeviceType());
        returnEo.setSellerSrc(orderEo.getSellerSrc());
        returnEo.setSellerId(orderEo.getSellerId());
        returnEo.setShopType(orderEo.getShopType());
        returnEo.setShopId(orderEo.getShopId());
        returnEo.setUserSrc(orderEo.getUserSrc());
        returnEo.setUserId(orderEo.getUserId());
        returnEo.setSaleChannel(orderEo.getSaleChannel());
        returnEo.setMktChannel(orderEo.getMktChannel());
        returnEo.setOrganizationId(orderEo.getOrganizationId());
        returnEo.setOrganizationName(orderEo.getOrganizationName());
    }

    private List<OrderDeliveryDetailRespDto> getTargetOrderDelivery(List<String> skuIds, List<OrderDeliveryEo> orderDeliveryEos) {
        ArrayList orderDeliveryDetailRespDtos = new ArrayList(orderDeliveryEos.size());
        DtoHelper.eoList2DtoList(orderDeliveryEos, orderDeliveryDetailRespDtos, OrderDeliveryDetailRespDto.class);
        orderDeliveryDetailRespDtos.stream().forEach(bean -> {
            DeliveryItemEo deliveryItemEo = DeliveryItemEo.newInstance();
            deliveryItemEo.setDeliveryNo(bean.getDeliveryNo());
            List deliveryItemEoList = this.deliveryItemDas.select((BaseEo)deliveryItemEo);
            ArrayList deliveryItemRespDtoList = new ArrayList(deliveryItemEoList.size());
            DtoHelper.eoList2DtoList((Collection)deliveryItemEoList, deliveryItemRespDtoList, DeliveryItemRespDto.class);
            bean.setDeliveryItems(deliveryItemRespDtoList);
        });
        List<OrderDeliveryDetailRespDto> targetOrderDelivery = orderDeliveryDetailRespDtos.stream().filter(bean -> {
            List deliveryItems = bean.getDeliveryItems();
            List skuIdList = deliveryItems.stream().map(DeliveryItemRespDto::getSkuSerial).collect(Collectors.toList());
            return !Collections.disjoint(skuIdList, skuIds);
        }).collect(Collectors.toList());
        return targetOrderDelivery;
    }

    private void updateDeliveryItem(List<DeliveryItemEo> deliveryItemEos) {
        deliveryItemEos.stream().forEach(bean -> this.deliveryItemDas.updateSelective((BaseEo)bean));
    }

    private void updateTradeItem(List<TradeItemEo> tradeItemEos) {
        tradeItemEos.stream().forEach(bean -> this.tradeItemDas.updateSelective((BaseEo)bean));
    }

    private void saveOptLog(String bizNo, String returnType) {
        OptLogEo optLogEo = new OptLogEo();
        optLogEo.setBizType(OptBizTypeEnum.RETURN.getType());
        optLogEo.setBizNo(bizNo);
        optLogEo.setOptType(OptTypeEnum.RETURN_CREATE.getType());
        optLogEo.setOptTime(new Date());
        optLogEo.setOptPerson(this.context.userName());
        optLogEo.setDescription(String.format("\u5df2\u63d0\u4ea4\u9000\u8ba2\u5355\uff0c\u5f85\u540e\u53f0\u5ba1\u6838\uff0c\u4e1a\u52a1\u7c7b\u578b%s", ReturnTypeEnum.toName((String)returnType)));
        this.optLogService.addBoOptLog(optLogEo);
    }

    public ReturnCreateBo dealWithUncertaintyItem(ReturnCreateBo returnCreateBo) {
        ReturnReqDto returnReqDto = returnCreateBo.getReturnReqDto();
        ReturnTobReqDto returnTobReqDto = (ReturnTobReqDto)returnReqDto;
        List afterSalesItemReqDtos = returnReqDto.getAfterSalesItems();
        List attachements = returnTobReqDto.getAttachements();
        if (CollectionUtils.isEmpty((Collection)attachements) && CollectionUtils.isEmpty((Collection)afterSalesItemReqDtos)) {
            throw new com.dtyunxi.exceptions.BizException(TradeExceptionCode.MISSING_PARAMETER.getCode(), "\u53c2\u6570\u5f02\u5e38:\u552e\u540e\u5546\u54c1\u548c\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        String customerId = returnTobReqDto.getCustomerId();
        String createMode = returnTobReqDto.getCreateMode();
        Long shopId = returnTobReqDto.getShopId();
        Long sellerId = returnTobReqDto.getSellerId();
        OrderEo orderEo = null;
        ReturnEo returnEo = ReturnEo.newInstance();
        HashMap<String, AfterSalesItemReqDto> map = new HashMap<String, AfterSalesItemReqDto>();
        ArrayList<ApplyReturnItemEo> applyReturnItemEos = new ArrayList<ApplyReturnItemEo>();
        ReturnOrderCreateModeEnum createModeEnum = ReturnOrderCreateModeEnum.fromType((String)createMode);
        switch (createModeEnum) {
            case FROM_ORDER: {
                String tradeItemNo = ((AfterSalesItemReqDto)afterSalesItemReqDtos.get(0)).getTradeItemNo();
                TradeItemEo tradeItemEo = this.tradeItemService.queryByTradeItemNo(tradeItemNo);
                orderEo = this.orderService.queryByOrderNo(returnTobReqDto.getOrderTradeNo());
                returnTobReqDto.setTradeNo(TradeUtil.generateTradeNo((String)orderEo.getOrderNo()));
                CubeBeanUtils.copyProperties((Object)returnEo, (Object)returnTobReqDto, (String[])new String[0]);
                returnEo.setTradeNo(returnTobReqDto.getTradeNo());
                returnEo.setReturnNo(returnTobReqDto.getTradeNo());
                this.copyRedundancyAttribute(returnEo, orderEo);
                returnEo.setWarehouseCode(orderEo.getWarehouseCode());
                returnEo.setDeviceType(returnTobReqDto.getDeviceType());
                List<AfterSalesItemReqDto> afterSalesItemFromOrder = returnReqDto.getAfterSalesItems().stream().filter(e -> e.getTradeItemNo() != null).collect(Collectors.toList());
                List<ApplyReturnItemEo> applyReturnItemEoFromOrder = this.convertAfterSalesItemFromOrder(map, returnEo, afterSalesItemFromOrder);
                applyReturnItemEos.addAll(applyReturnItemEoFromOrder);
                WarehouseRespDto warehouseRespDto = this.buildWarehouse(orderEo.getOrganizationId());
                returnEo.setWarehouseCode(warehouseRespDto.getCode());
                this.setReturnDescTob(returnEo);
                break;
            }
            case FROM_MANUAL_SKU: {
                CubeBeanUtils.copyProperties((Object)returnEo, (Object)returnTobReqDto, (String[])new String[0]);
                returnTobReqDto.setTradeNo(TradeUtil.generateTradeNo());
                returnEo.setTradeNo(returnTobReqDto.getTradeNo());
                returnEo.setReturnNo(returnTobReqDto.getTradeNo());
                SellerRespDto sellerRespDto = (SellerRespDto)this.sellerQueryApi.queryById(sellerId).getData();
                returnEo.setSellerId(String.valueOf(sellerId));
                returnEo.setSellerSrc(null);
                returnEo.setShopId(String.valueOf(shopId));
                returnEo.setShopType(null);
                returnEo.setBizStatus(ReturnStatusEnum.INIT.getName());
                returnEo.setUserSrc(null);
                returnEo.setUserId(String.valueOf(this.context.userId()));
                returnEo.setSaleChannel(SaleChannelEnum.SALECHANNEL_ZYSC.getCode());
                returnEo.setMktChannel(null);
                returnEo.setOrganizationId(sellerRespDto.getOrganizationId());
                returnEo.setOrganizationName(sellerRespDto.getOrganizationName());
                WarehouseRespDto defaultWarehouse = this.buildWarehouse(sellerRespDto.getOrganizationId());
                returnEo.setWarehouseCode(defaultWarehouse.getCode());
                this.setReturnDescTob(returnEo);
                List<ApplyReturnItemEo> applyReturnItemEoFromManual = this.convertAfterSalesItemFromItemSku(map, returnEo, returnReqDto.getAfterSalesItems());
                applyReturnItemEos.addAll(applyReturnItemEoFromManual);
                break;
            }
            default: {
                throw new com.dtyunxi.exceptions.BizException(TradeExceptionCode.MISSING_PARAMETER.getCode(), "\u521b\u5efa\u552e\u540e\u65b9\u5f0f\u672a\u77e5\u3002");
            }
        }
        BigDecimal totalRebate = applyReturnItemEos.stream().map(item -> item.getReturnRebate() == null ? BigDecimal.ZERO : item.getReturnRebate()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal refundAmount = applyReturnItemEos.stream().map(item -> item.getRefundAmount() == null ? BigDecimal.ZERO : item.getRefundAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        returnEo.setRefundAmount(refundAmount);
        returnEo.setReturnRebate(totalRebate);
        returnEo.setReturnReason(returnTobReqDto.getReqReason());
        returnTobReqDto.setTotalAmount(refundAmount);
        returnCreateBo.setSalesItemReqDtoMap(map);
        returnCreateBo.setReturnEo(returnEo);
        returnCreateBo.setOrderEo(orderEo);
        returnCreateBo.setReturnItemEos(new ArrayList());
        ReturnCreateTobBo returnCreateTobBo = (ReturnCreateTobBo)TransformUtil.transformParentToChild((BaseReqDto)returnCreateBo, ReturnCreateTobBo.class);
        returnCreateTobBo.setApplyReturnItemEos(applyReturnItemEos);
        returnCreateBo = this.packBo((ReturnCreateBo)returnCreateTobBo, (ReturnReqDto)returnTobReqDto);
        returnCreateBo = this.saveApplyItem(returnCreateBo, returnReqDto);
        return this.postProcessor(returnCreateBo, returnReqDto);
    }

    private List<ApplyReturnItemEo> convertAfterSalesItemFromItemSku(Map<String, AfterSalesItemReqDto> map, ReturnEo returnEo, List<AfterSalesItemReqDto> afterSalesItemFromManual) {
        List<ApplyReturnItemEo> ressult = afterSalesItemFromManual.stream().map(bean -> {
            AfterSalesItemReqDto afterSalesItemReqDto = (AfterSalesItemReqDto)EoUtil.transformExtFieldsToDto((BaseVo)bean, (Class)this.returnRefundActionExtPt.getDetailDtoClass());
            AfterSalesItemTobReqDto afterSalesItemTobReqDto = (AfterSalesItemTobReqDto)afterSalesItemReqDto;
            ApplyReturnItemEo applyReturnItemEo = new ApplyReturnItemEo();
            applyReturnItemEo.setId(null);
            applyReturnItemEo.setBrandId(afterSalesItemTobReqDto.getBrandId());
            applyReturnItemEo.setBrandCode(afterSalesItemTobReqDto.getBrandCode());
            applyReturnItemEo.setSkuSerial(bean.getSkuSerial());
            applyReturnItemEo.setSkuCode(afterSalesItemTobReqDto.getSkuCode());
            applyReturnItemEo.setSkuDesc(afterSalesItemTobReqDto.getSkuDesc());
            applyReturnItemEo.setCargoSerial(afterSalesItemTobReqDto.getCargoSerial());
            applyReturnItemEo.setShopId(returnEo.getShopId());
            applyReturnItemEo.setReturnNo(returnEo.getReturnNo());
            applyReturnItemEo.setDeliveryNo(null);
            applyReturnItemEo.setReturnedNum(afterSalesItemTobReqDto.getReturnedNum());
            applyReturnItemEo.setReturnNum(afterSalesItemTobReqDto.getReturnNum());
            applyReturnItemEo.setUnit(afterSalesItemTobReqDto.getUnit());
            applyReturnItemEo.setRemark(afterSalesItemTobReqDto.getRemark());
            applyReturnItemEo.setExtension(afterSalesItemTobReqDto.getExtension());
            applyReturnItemEo.setItemId(afterSalesItemTobReqDto.getItemSerial());
            applyReturnItemEo.setItemCode(afterSalesItemTobReqDto.getItemCode());
            applyReturnItemEo.setItemName(afterSalesItemTobReqDto.getItemName());
            applyReturnItemEo.setItemPrice(afterSalesItemTobReqDto.getItemPrice());
            applyReturnItemEo.setItemAmount(afterSalesItemTobReqDto.getItemAmount());
            applyReturnItemEo.setRefundAmount(afterSalesItemTobReqDto.getRefundAmount());
            applyReturnItemEo.setGift(bean.getGift());
            applyReturnItemEo.setItemNum(afterSalesItemTobReqDto.getReturnNum());
            applyReturnItemEo.setReturnRebate(BigDecimal.ZERO);
            applyReturnItemEo.setBatchNo(bean.getBatchNo());
            map.put(bean.getSkuSerial() + "_" + bean.getGift(), afterSalesItemReqDto);
            return applyReturnItemEo;
        }).collect(Collectors.toList());
        return ressult;
    }

    private List<ApplyReturnItemEo> convertAfterSalesItemFromOrder(Map<String, AfterSalesItemReqDto> map, ReturnEo returnEo, List<AfterSalesItemReqDto> afterSalesItemFromOrder) {
        List<ApplyReturnItemEo> ressult = afterSalesItemFromOrder.stream().map(bean -> {
            TradeItemEo tradeItemEo = this.tradeItemService.queryByTradeItemNo(bean.getTradeItemNo());
            AfterSalesItemReqDto afterSalesItemReqDto = (AfterSalesItemReqDto)EoUtil.transformExtFieldsToDto((BaseVo)bean, (Class)this.returnRefundActionExtPt.getDetailDtoClass());
            AfterSalesItemTobReqDto afterSalesItemTobReqDto = (AfterSalesItemTobReqDto)afterSalesItemReqDto;
            Integer returnedNum = tradeItemEo.getReturnedNum() == null ? 0 : tradeItemEo.getReturnedNum();
            Integer curCanReturnNum = tradeItemEo.getItemNum() - returnedNum;
            if (afterSalesItemTobReqDto.getReturnNum() > curCanReturnNum) {
                String errMsg = String.format("\u53c2\u6570\u5f02\u5e38:\u5546\u54c1%s \u7533\u8bf7\u9000\u8d27\u6570%s\u5927\u4e8e\u5269\u4f59\u53ef\u9000%s", afterSalesItemTobReqDto.getItemCode(), afterSalesItemTobReqDto.getReturnNum(), curCanReturnNum);
                throw new com.dtyunxi.exceptions.BizException(TradeExceptionCode.MISSING_PARAMETER.getCode(), errMsg);
            }
            ApplyReturnItemEo applyReturnItemEo = new ApplyReturnItemEo();
            CubeBeanUtils.copyProperties((Object)applyReturnItemEo, (Object)tradeItemEo, (String[])new String[0]);
            applyReturnItemEo.setId(null);
            applyReturnItemEo.setTradeItemId(tradeItemEo.getId());
            applyReturnItemEo.setSkuSerial(bean.getSkuSerial());
            applyReturnItemEo.setReturnNo(returnEo.getReturnNo());
            applyReturnItemEo.setReturnedNum(afterSalesItemTobReqDto.getReturnedNum());
            applyReturnItemEo.setReturnNum(afterSalesItemTobReqDto.getReturnNum());
            applyReturnItemEo.setUnit(afterSalesItemTobReqDto.getUnit());
            applyReturnItemEo.setRemark(afterSalesItemTobReqDto.getRemark());
            applyReturnItemEo.setExtension(afterSalesItemTobReqDto.getExtension());
            applyReturnItemEo.setItemId(afterSalesItemTobReqDto.getItemSerial());
            applyReturnItemEo.setItemCode(afterSalesItemTobReqDto.getItemCode());
            applyReturnItemEo.setItemAmount(afterSalesItemTobReqDto.getItemAmount());
            applyReturnItemEo.setItemPrice(afterSalesItemTobReqDto.getItemPrice());
            applyReturnItemEo.setRefundAmount(afterSalesItemTobReqDto.getRefundAmount());
            applyReturnItemEo.setGift(bean.getGift());
            applyReturnItemEo.setItemNum(tradeItemEo.getItemNum());
            BigDecimal rebateAmount = tradeItemEo.getRebateAmount() == null ? BigDecimal.ZERO : tradeItemEo.getRebateAmount();
            BigDecimal divide = rebateAmount.divide(BigDecimal.valueOf(tradeItemEo.getItemNum().intValue()), 1);
            applyReturnItemEo.setReturnRebate(divide.multiply(BigDecimal.valueOf(applyReturnItemEo.getReturnNum().intValue())).setScale(2, 1));
            applyReturnItemEo.setBatchNo(bean.getBatchNo());
            map.put(bean.getSkuSerial() + "_" + bean.getGift(), afterSalesItemReqDto);
            return applyReturnItemEo;
        }).collect(Collectors.toList());
        return ressult;
    }

    private ReturnCreateBo saveApplyItem(ReturnCreateBo returnBo, ReturnReqDto returnReqDto) {
        ReturnCreateTobBo returnCreateTobBo = (ReturnCreateTobBo)TransformUtil.transformParentToChild((BaseReqDto)returnBo, ReturnCreateTobBo.class);
        if (null != returnBo.getReturnEo()) {
            this.returnDas.insert((BaseEo)returnBo.getReturnEo());
        }
        if (CollectionUtils.isNotEmpty((Collection)returnCreateTobBo.getApplyReturnItemEos())) {
            this.applyReturnItemDas.insertBatch(returnCreateTobBo.getApplyReturnItemEos());
        }
        return this.returnRefundActionExtPt.save(returnBo, returnReqDto);
    }
}

