/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.mq.process;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.settlement.api.constant.PaymentWayEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.MessageInformDto;
import com.dtyunxi.yundt.cube.center.trade.api.IPayApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayMethodReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@MQDesc(tag="SETTLEMENT_ORDER_PAY_INFORM", msgType="single")
public class OrderPayInformProcess
implements IMessageProcessor<MessageVo> {
    private Logger logger = LoggerFactory.getLogger(OrderPayInformProcess.class);
    @Resource
    private ILockService lockService;
    @Resource(name="payApiImpl")
    private IPayApi payApi;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IUserQueryApi userQueryApi;

    private void befor() {
        ServiceContext.getContext().set("yes.req.requestId", (Object)UUID.randomUUID().toString().replace("-", ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(MessageVo messageVo) {
        this.befor();
        long start = System.currentTimeMillis();
        this.logger.info("\u7ed3\u7b97\u652f\u4ed8\u6210\u529fMQ\u901a\u77e5:{}", (Object)JSON.toJSONString((Object)messageVo));
        MessageInformDto messageInformDto = (MessageInformDto)JSON.parseObject((String)messageVo.getData().toString(), MessageInformDto.class);
        Mutex lock = this.lockService.lock(this.getClass().getSimpleName(), messageInformDto.getOrderNo(), 1500, 1500, TimeUnit.MILLISECONDS);
        try {
            UserDto userDto;
            if (StringUtils.isNumber((String)messageInformDto.getUserId()) && (userDto = (UserDto)RestResponseHelper.extractData((RestResponse)this.userQueryApi.queryById(Long.valueOf(messageInformDto.getUserId()), null))) != null) {
                ServiceContext.getContext().set("yes.req.userId", (Object)messageInformDto.getUserId());
                ServiceContext.getContext().set("yes.req.userCode", (Object)userDto.getUserName());
            }
            OrderDetailRespDto orderRespDto = this.orderService.getDetail(messageInformDto.getOrderNo(), null);
            this.logger.info("\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)orderRespDto));
            if (orderRespDto == null || "PAYED".equals(orderRespDto.getPayStatus())) {
                this.logger.info("\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\u6216\u8005\u5df2\u652f\u4ed8");
                MessageResponse messageResponse = MessageResponse.SUCCESS;
                return messageResponse;
            }
            PayMethodReqDto payMethodReqDto = new PayMethodReqDto();
            payMethodReqDto.setFlowDefId(Long.valueOf(0L));
            payMethodReqDto.setOrderNo(messageInformDto.getOrderNo());
            payMethodReqDto.setPayFlowName("PAY_TOB");
            payMethodReqDto.setTradeNo(messageInformDto.getOrderNo());
            HashMap<String, Object> addrExtFields = new HashMap<String, Object>();
            addrExtFields.put("attachements", new ArrayList());
            addrExtFields.put("confirmTime", new Date());
            addrExtFields.put("payAmount", messageInformDto.getPayAmount());
            addrExtFields.put("payTime", messageInformDto.getPayTime());
            payMethodReqDto.setPayMethod(PaymentWayEnum.fromCode((String)messageInformDto.getPayTypeCode()).getTypeStr());
            payMethodReqDto.setExtFields(addrExtFields);
            payMethodReqDto.setDeviceType("H5");
            this.logger.info("\u5728\u7ebf\u652f\u4ed8\u53d1\u8d77modifyPayMethod\u8bf7\u6c42\u8c03\u7528\u8ba2\u5355\u652f\u4ed8\u63a5\u53e3,\u5165\u53c2\u4fe1\u606f\u4e3a{}", (Object)JSON.toJSONString((Object)payMethodReqDto));
            RestResponseHelper.extractData((RestResponse)this.payApi.modifyPayMethod(messageInformDto.getTradeNo(), payMethodReqDto));
        }
        catch (Exception e) {
            this.logger.info("\u7ed3\u7b97\u652f\u4ed8\u6210\u529fMQ\u901a\u77e5\u6d88\u8d39\u5931\u8d25", (Object)JSON.toJSONString((Object)e));
            e.printStackTrace();
        }
        finally {
            this.lockService.unlock(lock);
        }
        this.logger.info("\u7ed3\u7b97\u652f\u4ed8\u6210\u529fMQ\u901a\u77e5\u6d88\u8d39\u8017\u65f6:{}ms", (Object)(start - System.currentTimeMillis()));
        return MessageResponse.SUCCESS;
    }
}

