/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuExtRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DefaultValue;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReturnStatusToBEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.ReturnOrderCreateModeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.AfterSalesItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.AfterSalesItemTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.GiftAccountReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnConfirmRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnItemConfirmDetailReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnItemConfirmReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnItemDataReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnModTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.tob.ReturnCountTobRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.trade.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IAfterSalesTobService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.ResponseUtil;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ApplyReturnItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefundDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnOmniDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.tob.AttachementDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ApplyReturnItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnOmniEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdDeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdTradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.tob.AttachementEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.api.dto.request.SellerSkuPriceReqDto;
import com.yx.tcbj.center.api.dto.response.SellerSkuPriceRespDto;
import com.yx.tcbj.center.api.query.ISellerSkuPriceQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AfterSalesTobServiceImpl
implements IAfterSalesTobService {
    private Logger logger = LoggerFactory.getLogger(AfterSalesTobServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    IOrderService orderService;
    @Autowired
    ReturnDas returnDas;
    @Autowired
    private ReturnItemDas returnItemDas;
    @Resource
    private DeliveryItemDas deliveryItemDas;
    @Resource
    private OrderDeliveryDas orderDeliveryDas;
    @Resource
    private AttachementDas attachementDas;
    @Resource
    private RefundDas refundDas;
    @Resource
    private ReturnOmniDas returnOmniDas;
    @Resource
    private ITradeItemService tradeItemService;
    @Resource
    private TradeItemDas tradeItemDas;
    @Resource
    private ApplyReturnItemDas applyReturnItemDas;
    @Resource
    private IWarehouseQueryApi warehouseQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IAreaQueryApi areaQueryApi;
    @Autowired
    private IItemSkuQueryApi itemSkuQueryApi;
    @Autowired
    private IItemQueryApi itemQueryApi;
    @Autowired
    private ISellerSkuPriceQueryApi sellerSkuPriceQueryApi;

    @Override
    public void modifyReturnInfo(ReturnModTobReqDto returnModTobReqDto) {
        ReturnEo selectEo = new ReturnEo();
        selectEo.setReturnNo(returnModTobReqDto.getReturnNo());
        ReturnEo returnEo = (ReturnEo)this.returnDas.selectOne((BaseEo)selectEo);
        ReturnEo updateEo = ReturnEo.newInstance();
        updateEo.setId(returnEo.getId());
        DtoHelper.dto2Eo((BaseVo)returnModTobReqDto, (BaseEo)updateEo);
        this.returnDas.updateSelective((BaseEo)updateEo);
        if (DefaultValue.YES.equals(returnModTobReqDto.getUpdateFlag())) {
            if (StringUtils.isNotEmpty((CharSequence)returnEo.getDeliveryNo())) {
                returnModTobReqDto.getAfterSalesItems().stream().forEach(bean -> {
                    ReturnItemEo returnItemEo = ReturnItemEo.newInstance();
                    DtoHelper.dto2Eo((BaseVo)bean, (BaseEo)returnItemEo);
                    this.returnItemDas.updateSelective((BaseEo)returnItemEo);
                });
                List deliveryItemEos = this.deliveryItemDas.queryByDeliveryNo(returnEo.getDeliveryNo());
                ArrayList waitUpdate = Lists.newArrayList();
                ArrayList giftWaitUpdate = new ArrayList();
                if (CollectionUtils.isNotEmpty((Collection)deliveryItemEos)) {
                    List tradeItemEos = this.tradeItemService.queryByTradeNo(returnEo.getOrderTradeNo());
                    Map<String, TradeItemEo> tradeItemMap = tradeItemEos.stream().collect(Collectors.toMap(StdTradeItemEo::getTradeItemNo, item -> item, (v1, v2) -> v2));
                    Map<String, DeliveryItemEo> deliveryItemMap = deliveryItemEos.stream().collect(Collectors.toMap(StdDeliveryItemEo::getTrOrderItemNo, item -> item, (v1, v2) -> v2));
                    returnModTobReqDto.getAfterSalesItems().stream().forEach(bean -> {
                        AfterSalesItemReqDto afterSalesItemReqDto = (AfterSalesItemReqDto)EoUtil.transformExtFieldsToDto((BaseVo)bean, AfterSalesItemTobReqDto.class);
                        TradeItemEo tradeItemEo = (TradeItemEo)tradeItemMap.get(bean.getTradeItemNo());
                        if (YesNoEnum.YES.getValue().equals(tradeItemEo.getGift())) {
                            Integer returnedNum = null != tradeItemEo.getReturnedNum() ? tradeItemEo.getReturnedNum() : 0;
                            Integer revertNum = ((AfterSalesItemTobReqDto)afterSalesItemReqDto).getReturnNum() - ((AfterSalesItemTobReqDto)afterSalesItemReqDto).getOriginNum();
                            tradeItemEo.setReturnedNum(Integer.valueOf(returnedNum + revertNum));
                            giftWaitUpdate.add(tradeItemEo);
                        } else {
                            DeliveryItemEo deliveryItemEo = (DeliveryItemEo)deliveryItemMap.get(bean.getTradeItemNo());
                            Integer returnedNum = null != deliveryItemEo.getReturnedNum() ? deliveryItemEo.getReturnedNum() : 0;
                            Integer revertNum = ((AfterSalesItemTobReqDto)afterSalesItemReqDto).getReturnNum() - ((AfterSalesItemTobReqDto)afterSalesItemReqDto).getOriginNum();
                            deliveryItemEo.setReturnedNum(Integer.valueOf(returnedNum + revertNum));
                            waitUpdate.add(deliveryItemEo);
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty((Collection)waitUpdate)) {
                    waitUpdate.stream().forEach(bean -> this.deliveryItemDas.updateSelective((BaseEo)bean));
                }
                if (CollectionUtils.isNotEmpty(giftWaitUpdate)) {
                    giftWaitUpdate.stream().forEach(bean -> this.tradeItemDas.updateSelective((BaseEo)bean));
                }
            } else {
                ReturnItemEo selectItemEo = ReturnItemEo.newInstance();
                selectItemEo.setReturnNo(returnModTobReqDto.getReturnNo());
                List returnItemList = this.returnItemDas.select((BaseEo)selectItemEo);
                Map<String, ReturnItemEo> returnItemMap = returnItemList.stream().collect(Collectors.toMap(returnItem -> returnItem.getSkuSerial() + "_" + returnItem.getDeliveryNo(), o -> o));
                Set deliveryNos = returnItemList.stream().map(ReturnItemEo::getDeliveryNo).collect(Collectors.toSet());
                DeliveryItemEo queryItemEo = DeliveryItemEo.newInstance();
                ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
                sqlFilters.add(SqlFilter.in((String)"delivery_no", (Object)Lists.newArrayList(deliveryNos)));
                queryItemEo.setSqlFilters(sqlFilters);
                List deliveryItemEos = this.deliveryItemDas.select((BaseEo)queryItemEo);
                ArrayList revertDeliveryItem = Lists.newArrayList();
                for (DeliveryItemEo deliveryItemEo : deliveryItemEos) {
                    ReturnItemEo returnItemEo = returnItemMap.get(deliveryItemEo.getSkuSerial() + "_" + deliveryItemEo.getDeliveryNo());
                    if (!Objects.nonNull(returnItemEo)) continue;
                    deliveryItemEo.setReturnedNum(Integer.valueOf(deliveryItemEo.getReturnedNum() - returnItemEo.getReturnNum()));
                    revertDeliveryItem.add(deliveryItemEo);
                }
                if (CollectionUtils.isNotEmpty((Collection)revertDeliveryItem)) {
                    revertDeliveryItem.stream().forEach(bean -> this.deliveryItemDas.updateSelective((BaseEo)bean));
                }
                ReturnItemEo deleteEo = ReturnItemEo.newInstance();
                deleteEo.setReturnNo(returnModTobReqDto.getReturnNo());
                this.returnItemDas.delete((BaseEo)deleteEo);
                String customerId = returnEo.getCustomerId();
                List afterSalesItemReqDtos = returnModTobReqDto.getAfterSalesItems();
                List<String> skuIds = afterSalesItemReqDtos.stream().map(AfterSalesItemReqDto::getSkuSerial).collect(Collectors.toList());
                if (StringUtils.isNotBlank((CharSequence)customerId)) {
                    OrderEo queryorderEo = OrderEo.newInstance();
                    queryorderEo.setCustomerId(customerId);
                    List orderEos = this.orderService.queryList(queryorderEo);
                    if (CollectionUtils.isEmpty((Collection)orderEos)) {
                        throw new BizException(TradeExceptionCode.ORDER_NO_EXIT.getCode(), TradeExceptionCode.ORDER_NO_EXIT.getMsg());
                    }
                    OrderDeliveryEo queryEo = OrderDeliveryEo.newInstance();
                    queryEo.setCustomerId(customerId);
                    queryEo.setDeliveryStatus(DeliveryStatusEnum.SIGNED.getStatus());
                    List orderDeliveryEos = this.orderDeliveryDas.select((BaseEo)queryEo);
                    if (CollectionUtils.isNotEmpty((Collection)orderDeliveryEos)) {
                        List updateDeliveryItems;
                        List<OrderDeliveryDetailRespDto> targetOrderDelivery = this.getTargetOrderDelivery(skuIds, orderDeliveryEos);
                        ArrayList<ReturnItemEo> returnItemEos = new ArrayList<ReturnItemEo>();
                        ArrayList waitUpdate = Lists.newArrayList();
                        block1: for (AfterSalesItemReqDto bean2 : returnModTobReqDto.getAfterSalesItems()) {
                            AfterSalesItemReqDto afterSalesItemReqDto = (AfterSalesItemReqDto)EoUtil.transformExtFieldsToDto((BaseVo)bean2, AfterSalesItemTobReqDto.class);
                            AfterSalesItemTobReqDto afterSalesItemTobReqDto = (AfterSalesItemTobReqDto)afterSalesItemReqDto;
                            String skuSerial = bean2.getSkuSerial();
                            List deepOrderDelivery = targetOrderDelivery.stream().filter(delivery -> {
                                List deliveryItems = delivery.getDeliveryItems();
                                List skuIdList = deliveryItems.stream().map(DeliveryItemRespDto::getSkuSerial).collect(Collectors.toList());
                                if (skuIdList.contains(skuSerial)) {
                                    Optional<DeliveryItemRespDto> optionalDeliveryItemRespDto = deliveryItems.stream().filter(item -> skuSerial.equals(item.getSkuSerial())).findFirst();
                                    return optionalDeliveryItemRespDto.isPresent() && optionalDeliveryItemRespDto.get().getItemNum() > 0 && (Objects.isNull(optionalDeliveryItemRespDto.get().getReturnedNum()) || optionalDeliveryItemRespDto.get().getItemNum() > optionalDeliveryItemRespDto.get().getReturnedNum());
                                }
                                return false;
                            }).collect(Collectors.toList());
                            Integer refundItemNum = afterSalesItemTobReqDto.getReturnNum();
                            for (OrderDeliveryDetailRespDto deepBean : deepOrderDelivery) {
                                Optional<DeliveryItemRespDto> first = deepBean.getDeliveryItems().stream().filter(b -> b.getSkuSerial().equals(skuSerial)).findFirst();
                                if (!first.isPresent()) continue;
                                DeliveryItemRespDto deliveryItemRespDto = first.get();
                                waitUpdate.add(deliveryItemRespDto);
                                ReturnItemEo returnItemEo = ReturnItemEo.newInstance();
                                returnItemEo.setDeliveryNo(deepBean.getDeliveryNo());
                                CubeBeanUtils.copyProperties((Object)returnItemEo, (Object)deliveryItemRespDto, (String[])new String[0]);
                                returnItemEo.setId(null);
                                returnItemEo.setSkuSerial(deliveryItemRespDto.getSkuSerial());
                                returnItemEo.setReturnNo(returnEo.getReturnNo());
                                returnItemEo.setUnit(returnItemEo.getUnit());
                                returnItemEo.setRemark(afterSalesItemTobReqDto.getRemark());
                                returnItemEo.setItemId(afterSalesItemTobReqDto.getItemSerial());
                                returnItemEo.setExtension(afterSalesItemTobReqDto.getExtension());
                                returnItemEos.add(returnItemEo);
                                Integer itemNum = null != deliveryItemRespDto.getItemNum() ? deliveryItemRespDto.getItemNum() : 0;
                                Integer returnedNum = null != deliveryItemRespDto.getReturnedNum() ? deliveryItemRespDto.getReturnedNum() : 0;
                                if (refundItemNum <= itemNum - returnedNum) {
                                    returnItemEo.setReturnNum(refundItemNum);
                                    returnItemEo.setItemAmount(new BigDecimal(refundItemNum).multiply(Optional.ofNullable(deliveryItemRespDto.getItemPrice()).orElse(BigDecimal.ZERO)));
                                    returnItemEo.setRefundAmount(new BigDecimal(refundItemNum).multiply(Optional.ofNullable(deliveryItemRespDto.getItemPrice()).orElse(BigDecimal.ZERO)));
                                    deliveryItemRespDto.setReturnedNum(Integer.valueOf(returnedNum + refundItemNum));
                                    deliveryItemRespDto.setExtFields(null);
                                    continue block1;
                                }
                                Integer remainNum = Optional.ofNullable(itemNum - returnedNum).orElse(0);
                                returnItemEo.setReturnNum(remainNum);
                                returnItemEo.setItemAmount(new BigDecimal(remainNum).multiply(Optional.ofNullable(deliveryItemRespDto.getItemPrice()).orElse(BigDecimal.ZERO)));
                                returnItemEo.setRefundAmount(new BigDecimal(remainNum).multiply(Optional.ofNullable(deliveryItemRespDto.getItemPrice()).orElse(BigDecimal.ZERO)));
                                refundItemNum = refundItemNum - (itemNum - returnedNum);
                                deliveryItemRespDto.setReturnedNum(itemNum);
                                deliveryItemRespDto.setExtFields(null);
                            }
                        }
                        if (CollectionUtils.isNotEmpty(returnItemEos)) {
                            this.returnItemDas.insertBatch(returnItemEos);
                        }
                        if (CollectionUtils.isNotEmpty((Collection)waitUpdate) && CollectionUtils.isNotEmpty((Collection)(updateDeliveryItems = EoUtil.dtoListToEoList((Collection)waitUpdate, DeliveryItemEo.class)))) {
                            updateDeliveryItems.stream().forEach(bean -> this.deliveryItemDas.updateSelective((BaseEo)bean));
                        }
                    }
                }
            }
            AttachementEo delAttachmentEo = new AttachementEo();
            delAttachmentEo.setBizNo(returnModTobReqDto.getReturnNo());
            delAttachmentEo.setBizType(OptBizTypeEnum.RETURN.getType());
            this.attachementDas.delete((BaseEo)delAttachmentEo);
            if (CollectionUtils.isNotEmpty((Collection)returnModTobReqDto.getAttachements())) {
                List attachmentEoList = returnModTobReqDto.getAttachements().stream().map(bean -> {
                    AttachementEo attachementEo = AttachementEo.newInstance();
                    CubeBeanUtils.copyProperties((Object)attachementEo, (Object)bean, (String[])new String[0]);
                    attachementEo.setBizNo(returnModTobReqDto.getReturnNo());
                    attachementEo.setBizType(OptBizTypeEnum.RETURN.getType());
                    return attachementEo;
                }).collect(Collectors.toList());
                this.attachementDas.insertBatch(attachmentEoList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRefund(ReturnConfirmRefundReqDto returnConfirmRefundReqDto) {
        List refundNos = returnConfirmRefundReqDto.getRefundNos();
        RefundEo queryRefundEo = RefundEo.newInstance();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"refund_no", (Object)refundNos));
        queryRefundEo.setSqlFilters(sqlFilterList);
        List select = this.refundDas.select((BaseEo)queryRefundEo);
        if (CollectionUtils.isNotEmpty((Collection)select)) {
            Optional<RefundEo> optionalRefundEo = select.stream().filter(bean -> RefundStatusEnum.SUCCESS.getName().equals(bean.getStatus("refundStatus"))).findFirst();
            if (optionalRefundEo.isPresent()) {
                throw new BizException("\u4e0d\u80fd\u5220\u9664\u5df2\u9000\u6b3e\u7684\u9000\u6b3e\u5355");
            }
            refundNos.stream().forEach(bean -> {
                RefundEo deleteRefundEo = RefundEo.newInstance();
                deleteRefundEo.setRefundNo(bean);
                this.refundDas.logicDelete((BaseEo)deleteRefundEo);
            });
        }
    }

    @Override
    public ReturnCountTobRespDto queryReturnCountTob(String filter) {
        ReturnCountTobRespDto returnCountTobRespDto = new ReturnCountTobRespDto();
        ReturnQueryReqDto returnQueryReqDto = (ReturnQueryReqDto)JSON.parseObject((String)filter, ReturnQueryReqDto.class);
        ReturnOmniEo returnOmniEo = new ReturnOmniEo();
        DtoHelper.dto2Eo((BaseVo)returnQueryReqDto, (BaseEo)returnOmniEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotEmpty((CharSequence)returnQueryReqDto.getCustomerIds())) {
            sqlFilters.add(SqlFilter.in((String)"customer_id", (Object)returnQueryReqDto.getCustomerIds()));
        }
        returnOmniEo.setSqlFilters(sqlFilters);
        returnOmniEo.setReturnStatus(ReturnStatusToBEnum.WAIT_AUDIT.getCode());
        int waitAuditCount = this.returnOmniDas.count((BaseEo)returnOmniEo);
        returnCountTobRespDto.setWaitAuditCount(Integer.valueOf(waitAuditCount));
        returnOmniEo.setReturnStatus(ReturnStatusToBEnum.COMPLETE.getCode());
        int completeCount = this.returnOmniDas.count((BaseEo)returnOmniEo);
        returnCountTobRespDto.setCompleteCount(Integer.valueOf(completeCount));
        returnOmniEo.setReturnStatus(null);
        StringBuilder statusSb = new StringBuilder();
        statusSb.append(ReturnStatusToBEnum.WAIT_IN_STORAGE.getCode()).append(",");
        statusSb.append(ReturnStatusToBEnum.PART_IN_STORAGE.getCode()).append(",");
        statusSb.append(ReturnStatusToBEnum.ALL_IN_STORAGE.getCode()).append(",");
        statusSb.append(ReturnStatusToBEnum.WAIT_REFUND.getCode()).append(",");
        statusSb.append(ReturnStatusToBEnum.PART_REFUND.getCode()).append(",");
        statusSb.deleteCharAt(statusSb.length() - 1);
        sqlFilters.add(SqlFilter.in((String)"return_status", (Object)statusSb.toString()));
        int processingCount = this.returnOmniDas.count((BaseEo)returnOmniEo);
        returnCountTobRespDto.setProcessingCount(Integer.valueOf(processingCount));
        return returnCountTobRespDto;
    }

    private List<OrderDeliveryDetailRespDto> getTargetOrderDelivery(List<String> skuIds, List<OrderDeliveryEo> orderDeliveryEos) {
        ArrayList orderDeliveryDetailRespDtos = new ArrayList(orderDeliveryEos.size());
        DtoHelper.eoList2DtoList(orderDeliveryEos, orderDeliveryDetailRespDtos, OrderDeliveryDetailRespDto.class);
        orderDeliveryDetailRespDtos.stream().forEach(bean -> {
            DeliveryItemEo deliveryItemEo = DeliveryItemEo.newInstance();
            deliveryItemEo.setDeliveryNo(bean.getDeliveryNo());
            List deliveryItemEoList = this.deliveryItemDas.select((BaseEo)deliveryItemEo);
            ArrayList deliveryItemRespDtoList = new ArrayList(deliveryItemEoList.size());
            DtoHelper.eoList2DtoList((Collection)deliveryItemEoList, deliveryItemRespDtoList, DeliveryItemRespDto.class);
            bean.setDeliveryItems(deliveryItemRespDtoList);
        });
        List<OrderDeliveryDetailRespDto> targetOrderDelivery = orderDeliveryDetailRespDtos.stream().filter(bean -> {
            List deliveryItems = bean.getDeliveryItems();
            List skuIdList = deliveryItems.stream().map(DeliveryItemRespDto::getSkuSerial).collect(Collectors.toList());
            return !Collections.disjoint(skuIdList, skuIds);
        }).collect(Collectors.toList());
        return targetOrderDelivery;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyUncertainItemReturnInfo(ReturnModTobReqDto returnModTobReqDto) {
        ReturnEo selectEo = new ReturnEo();
        selectEo.setReturnNo(returnModTobReqDto.getReturnNo());
        ReturnEo returnEo = (ReturnEo)this.returnDas.selectOne((BaseEo)selectEo);
        if (returnEo == null) {
            throw new BizException(TradeExceptionCode.RETURN_NOT_EXIST.getCode(), "\u9000\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (!ReturnStatusToBEnum.WAIT_AUDIT.getCode().equals(returnEo.getReturnStatus())) {
            BizExceptionHelper.throwBizException((String)TradeExceptionCode.RETURN_STATUS_ERROR.getCode(), (String)TradeExceptionCode.RETURN_STATUS_ERROR.getMsg());
        }
        String customerId = returnModTobReqDto.getCustomerId();
        Long shopId = returnModTobReqDto.getShopId();
        Long sellerId = returnModTobReqDto.getSellerId();
        String createMode = returnModTobReqDto.getCreateMode();
        List afterSalesItemReqDtos = returnModTobReqDto.getAfterSalesItems();
        List attachements = returnModTobReqDto.getAttachements();
        if (CollectionUtils.isEmpty((Collection)attachements) && CollectionUtils.isEmpty((Collection)afterSalesItemReqDtos)) {
            throw new com.dtyunxi.exceptions.BizException(TradeExceptionCode.MISSING_PARAMETER.getCode(), "\u53c2\u6570\u5f02\u5e38:\u552e\u540e\u5546\u54c1\u548c\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (DefaultValue.YES.equals(returnModTobReqDto.getUpdateFlag())) {
            ArrayList<ApplyReturnItemEo> applyReturnItemEos = new ArrayList<ApplyReturnItemEo>();
            ReturnOrderCreateModeEnum createModeEnum = ReturnOrderCreateModeEnum.fromType((String)createMode);
            switch (createModeEnum) {
                case FROM_ORDER: {
                    List<ApplyReturnItemEo> applyReturnItemEosFromOrder = this.convertAfterSalesItemFromOrder(returnModTobReqDto.getAfterSalesItems(), returnEo);
                    applyReturnItemEos.addAll(applyReturnItemEosFromOrder);
                    break;
                }
                case FROM_MANUAL_SKU: {
                    if (!returnEo.getShopId().equals(shopId)) {
                        returnEo.setShopId(String.valueOf(shopId));
                        returnEo.setSellerId(String.valueOf(sellerId));
                        returnEo.setCustomerId(customerId);
                        SellerRespDto sellerRespDto = (SellerRespDto)this.sellerQueryApi.queryById(sellerId).getData();
                        returnEo.setOrganizationId(sellerRespDto.getOrganizationId());
                        returnEo.setOrganizationName(sellerRespDto.getOrganizationName());
                        WarehouseRespDto defaultWarehouse = this.buildWarehouse(sellerRespDto.getOrganizationId());
                        returnEo.setWarehouseCode(defaultWarehouse.getCode());
                        returnEo.setUpdatePerson(String.valueOf(this.context.userId()));
                        returnEo.setUpdateTime(new Date());
                        this.setReturnDescTob(returnEo, defaultWarehouse);
                    }
                    List<ApplyReturnItemEo> applyReturnItemEosFromSku = this.convertAfterSalesItemFromSku(returnModTobReqDto.getAfterSalesItems(), returnEo);
                    applyReturnItemEos.addAll(applyReturnItemEosFromSku);
                    break;
                }
                default: {
                    throw new com.dtyunxi.exceptions.BizException(TradeExceptionCode.MISSING_PARAMETER.getCode(), "\u521b\u5efa\u552e\u540e\u65b9\u5f0f\u672a\u77e5\u3002");
                }
            }
            BigDecimal totalRebate = applyReturnItemEos.stream().map(item -> item.getReturnRebate() == null ? BigDecimal.ZERO : item.getReturnRebate()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalRefundmAmount = applyReturnItemEos.stream().map(item -> item.getRefundAmount() == null ? BigDecimal.ZERO : item.getRefundAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
            returnEo.setReturnRebate(totalRebate);
            returnEo.setRefundAmount(totalRefundmAmount);
            returnEo.setBuyerAddrInfo(returnModTobReqDto.getBuyerAddrInfo());
            returnEo.setRemark(returnModTobReqDto.getRemark());
            returnEo.setReturnReason(returnModTobReqDto.getReqReason());
            CubeBeanUtils.copyProperties((Object)returnEo, (Object)returnModTobReqDto, (String[])new String[0]);
            ApplyReturnItemEo deleteEo = new ApplyReturnItemEo();
            deleteEo.setReturnNo(returnModTobReqDto.getReturnNo());
            this.applyReturnItemDas.delete((BaseEo)deleteEo);
            if (CollectionUtils.isNotEmpty(applyReturnItemEos)) {
                this.applyReturnItemDas.insertBatch(applyReturnItemEos);
            }
            this.returnDas.updateSelective((BaseEo)returnEo);
        }
        AttachementEo delAttachmentEo = new AttachementEo();
        delAttachmentEo.setBizNo(returnModTobReqDto.getReturnNo());
        delAttachmentEo.setBizType(OptBizTypeEnum.RETURN.getType());
        this.attachementDas.delete((BaseEo)delAttachmentEo);
        if (CollectionUtils.isNotEmpty((Collection)returnModTobReqDto.getAttachements())) {
            List attachmentEoList = returnModTobReqDto.getAttachements().stream().map(bean -> {
                AttachementEo attachementEo = AttachementEo.newInstance();
                CubeBeanUtils.copyProperties((Object)attachementEo, (Object)bean, (String[])new String[0]);
                attachementEo.setId(null);
                attachementEo.setBizNo(returnModTobReqDto.getReturnNo());
                attachementEo.setBizType(OptBizTypeEnum.RETURN.getType());
                return attachementEo;
            }).collect(Collectors.toList());
            this.attachementDas.insertBatch(attachmentEoList);
        }
    }

    private void setReturnDescTob(ReturnEo returnEo, WarehouseRespDto defaultWarehouse) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)defaultWarehouse.getProvCode())) {
            RestResponse provRestResponse = this.areaQueryApi.queryByCode(defaultWarehouse.getProvCode());
            AreaDto provDto = (AreaDto)ResponseUtil.getSuccessResult((RestResponse)provRestResponse);
            sb.append(provDto.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)defaultWarehouse.getCityCode())) {
            RestResponse cityRestResponse = this.areaQueryApi.queryByCode(defaultWarehouse.getCityCode());
            AreaDto cityDto = (AreaDto)ResponseUtil.getSuccessResult((RestResponse)cityRestResponse);
            sb.append(cityDto.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)defaultWarehouse.getAreaCode())) {
            RestResponse areaRestResponse = this.areaQueryApi.queryByCode(defaultWarehouse.getAreaCode());
            AreaDto areaDto = (AreaDto)ResponseUtil.getSuccessResult((RestResponse)areaRestResponse);
            sb.append(areaDto.getName());
        }
        sb.append(defaultWarehouse.getAddr());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("deliveryName", (Object)defaultWarehouse.getContactPerson());
        jsonObject.put("deliveryMobile", (Object)defaultWarehouse.getContactPhone());
        jsonObject.put("deliveryAddress", (Object)sb.toString());
        returnEo.setReturnDesc(jsonObject.toJSONString());
    }

    private WarehouseRespDto buildWarehouse(Long orgId) {
        try {
            WarehouseQueryReqDto warehouseQueryReqDto = new WarehouseQueryReqDto();
            warehouseQueryReqDto.setOrganizationIds((List)Lists.newArrayList((Object[])new Long[]{orgId}));
            warehouseQueryReqDto.setType("1");
            warehouseQueryReqDto.setMainWarehouse(Integer.valueOf(1));
            RestResponse pageInfoRestResp = this.warehouseQueryApi.queryWarehousePage(warehouseQueryReqDto, Integer.valueOf(1), Integer.valueOf(1));
            PageInfo warehousePageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResp);
            return (WarehouseRespDto)warehousePageInfo.getList().get(0);
        }
        catch (Exception e) {
            throw new BizException("\u5546\u5bb6\u672a\u914d\u7f6e\u9ed8\u8ba4\u9000\u8d27\u4ed3\u5e93,\u8bf7\u8054\u7cfb\u5ba2\u670d\u5904\u7406");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyReturn(ReturnTobReqDto returnTobReqDto) {
        if (StringUtils.isBlank((CharSequence)returnTobReqDto.getReturnNo())) {
            throw new BizException("\u9000\u8d27\u6d41\u6c34\u53f7\u9000\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ReturnOmniEo returnOmniEo = new ReturnOmniEo();
        returnOmniEo.setReturnExpressCompany(returnTobReqDto.getReturnExpressCompany());
        returnOmniEo.setReturnExpressSerial(returnTobReqDto.getReturnExpressSerial());
        returnOmniEo.setReturnExpressDetail(returnTobReqDto.getReturnExpressDetail());
        returnOmniEo.setReturnExpressCompanyName(returnTobReqDto.getReturnExpressCompanyName());
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.eq((String)"return_no", (Object)returnTobReqDto.getReturnNo()));
        returnOmniEo.setSqlFilters((List)sqlFilters);
        this.returnOmniDas.updateSelectiveSqlFilter((BaseEo)returnOmniEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchInsertReturnItems(List<ReturnItemEo> returnItemEos) {
        this.returnItemDas.insertBatch(returnItemEos);
    }

    private List<ApplyReturnItemEo> convertAfterSalesItemFromSku(List<AfterSalesItemReqDto> afterSalesItems, ReturnEo returnEo) {
        return afterSalesItems.stream().map(bean -> {
            AfterSalesItemReqDto afterSalesItemReqDto = (AfterSalesItemReqDto)EoUtil.transformExtFieldsToDto((BaseVo)bean, AfterSalesItemTobReqDto.class);
            AfterSalesItemTobReqDto afterSalesItemTobReqDto = (AfterSalesItemTobReqDto)afterSalesItemReqDto;
            ApplyReturnItemEo applyReturnItemEo = new ApplyReturnItemEo();
            applyReturnItemEo.setId(null);
            applyReturnItemEo.setShopId(returnEo.getShopId());
            applyReturnItemEo.setBrandId(afterSalesItemTobReqDto.getBrandId());
            applyReturnItemEo.setBrandCode(afterSalesItemTobReqDto.getBrandCode());
            applyReturnItemEo.setSkuSerial(bean.getSkuSerial());
            applyReturnItemEo.setReturnNo(returnEo.getReturnNo());
            applyReturnItemEo.setDeliveryNo(null);
            applyReturnItemEo.setReturnedNum(afterSalesItemTobReqDto.getReturnedNum());
            applyReturnItemEo.setReturnNum(afterSalesItemTobReqDto.getReturnNum());
            applyReturnItemEo.setUnit(afterSalesItemTobReqDto.getUnit());
            applyReturnItemEo.setRemark(afterSalesItemTobReqDto.getRemark());
            applyReturnItemEo.setExtension(afterSalesItemTobReqDto.getExtension());
            applyReturnItemEo.setItemId(afterSalesItemTobReqDto.getItemSerial());
            applyReturnItemEo.setItemCode(afterSalesItemTobReqDto.getItemCode());
            applyReturnItemEo.setItemName(afterSalesItemTobReqDto.getItemName());
            applyReturnItemEo.setItemPrice(afterSalesItemTobReqDto.getItemPrice());
            applyReturnItemEo.setSkuCode(afterSalesItemTobReqDto.getSkuCode());
            applyReturnItemEo.setSkuDesc(afterSalesItemTobReqDto.getSkuDesc());
            applyReturnItemEo.setCargoSerial(afterSalesItemTobReqDto.getCargoSerial());
            applyReturnItemEo.setItemAmount(afterSalesItemTobReqDto.getItemAmount());
            applyReturnItemEo.setRefundAmount(afterSalesItemTobReqDto.getRefundAmount());
            applyReturnItemEo.setGift(bean.getGift());
            applyReturnItemEo.setReturnRebate(null);
            applyReturnItemEo.setBatchNo(bean.getBatchNo());
            applyReturnItemEo.setItemNum(afterSalesItemTobReqDto.getReturnNum());
            return applyReturnItemEo;
        }).collect(Collectors.toList());
    }

    private List<ApplyReturnItemEo> convertAfterSalesItemFromOrder(List<AfterSalesItemReqDto> afterSalesItems, ReturnEo returnEo) {
        List tradeItemEoList = this.tradeItemService.queryByTradeNo(returnEo.getOrderTradeNo());
        Map<String, TradeItemEo> tradeItemEoMap = tradeItemEoList.stream().collect(Collectors.toMap(tradeItemEo -> tradeItemEo.getSkuSerial() + "_" + tradeItemEo.getGift(), o -> o, (o1, o2) -> o1));
        return afterSalesItems.stream().map(bean -> {
            AfterSalesItemReqDto afterSalesItemReqDto = (AfterSalesItemReqDto)EoUtil.transformExtFieldsToDto((BaseVo)bean, AfterSalesItemTobReqDto.class);
            AfterSalesItemTobReqDto afterSalesItemTobReqDto = (AfterSalesItemTobReqDto)afterSalesItemReqDto;
            String skuId = afterSalesItemTobReqDto.getSkuSerial();
            TradeItemEo tradeItemEo = (TradeItemEo)tradeItemEoMap.get(skuId + "_" + afterSalesItemTobReqDto.getGift());
            ApplyReturnItemEo applyReturnItemEo = new ApplyReturnItemEo();
            CubeBeanUtils.copyProperties((Object)applyReturnItemEo, (Object)tradeItemEo, (String[])new String[0]);
            Integer returnedNum = tradeItemEo.getReturnedNum() == null ? 0 : tradeItemEo.getReturnedNum();
            Integer curCanReturnNum = tradeItemEo.getItemNum() - returnedNum;
            if (afterSalesItemTobReqDto.getReturnNum() > curCanReturnNum) {
                String errMsg = String.format("\u53c2\u6570\u5f02\u5e38:\u5546\u54c1%s \u7533\u8bf7\u9000\u8d27\u6570%s\u5927\u4e8e\u5269\u4f59\u53ef\u9000%s", afterSalesItemTobReqDto.getItemCode(), afterSalesItemTobReqDto.getReturnNum(), curCanReturnNum);
                throw new com.dtyunxi.exceptions.BizException(TradeExceptionCode.MISSING_PARAMETER.getCode(), errMsg);
            }
            applyReturnItemEo.setId(null);
            applyReturnItemEo.setShopId(returnEo.getShopId());
            applyReturnItemEo.setSkuSerial(bean.getSkuSerial());
            applyReturnItemEo.setReturnNo(returnEo.getReturnNo());
            applyReturnItemEo.setDeliveryNo(null);
            applyReturnItemEo.setReturnedNum(afterSalesItemTobReqDto.getReturnedNum());
            applyReturnItemEo.setReturnNum(afterSalesItemTobReqDto.getReturnNum());
            applyReturnItemEo.setUnit(afterSalesItemTobReqDto.getUnit());
            applyReturnItemEo.setRemark(afterSalesItemTobReqDto.getRemark());
            applyReturnItemEo.setExtension(afterSalesItemTobReqDto.getExtension());
            applyReturnItemEo.setItemId(afterSalesItemTobReqDto.getItemSerial());
            applyReturnItemEo.setItemAmount(afterSalesItemTobReqDto.getItemAmount());
            applyReturnItemEo.setRefundAmount(afterSalesItemTobReqDto.getRefundAmount());
            applyReturnItemEo.setGift(bean.getGift());
            applyReturnItemEo.setItemNum(tradeItemEo.getItemNum());
            applyReturnItemEo.setBatchNo(afterSalesItemTobReqDto.getBatchNo());
            BigDecimal rebateAmount = tradeItemEo.getRebateAmount() == null ? BigDecimal.ZERO : tradeItemEo.getRebateAmount();
            BigDecimal divide = rebateAmount.divide(BigDecimal.valueOf(tradeItemEo.getItemNum().intValue()), 1);
            applyReturnItemEo.setReturnRebate(divide.multiply(BigDecimal.valueOf(applyReturnItemEo.getReturnNum().intValue())).setScale(2, 1));
            return applyReturnItemEo;
        }).collect(Collectors.toList());
    }

    @Override
    public BigDecimal giftRefund(GiftAccountReqDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getOrderNo())) {
            throw new BizException("\u672a\u6307\u5b9a\u8ba2\u5355\u53f7");
        }
        if (CollectionUtils.isEmpty((Collection)dto.getList())) {
            throw new BizException("\u9000\u8d27\u5546\u54c1\u4e3a\u7a7a");
        }
        List items = this.tradeItemDas.select(SqlFilterBuilder.create(TradeItemEo.class).eq("tradeNo", (Object)dto.getOrderNo()).eo());
        if (CollectionUtils.isEmpty((Collection)items)) {
            throw new BizException("\u8ba2\u5355\u53f7" + dto.getOrderNo() + "\u672a\u627e\u5230\u5546\u54c1");
        }
        Map<Long, Integer> collect = dto.getList().stream().collect(Collectors.toMap(GiftAccountReqDto.Item::getSkuId, GiftAccountReqDto.Item::getItemNum));
        BigDecimal total = BigDecimal.ZERO;
        for (TradeItemEo x : items) {
            Integer integer = collect.get(Long.valueOf(x.getSkuSerial()));
            if (x.getReturnedNum() == 0) {
                x.setReturnedNum(Integer.valueOf(0));
            }
            if (Objects.nonNull(integer)) {
                if (Objects.equals(integer, x.getItemNum())) {
                    total = total.add(Optional.ofNullable(x.getAddAmount()).orElse(BigDecimal.ZERO));
                    x.setRemainAmount(BigDecimal.ZERO);
                } else if (Objects.equals(integer, x.getItemNum() - x.getReturnedNum())) {
                    total = total.add(Optional.ofNullable(x.getRemainAmount()).orElse(BigDecimal.ZERO));
                    x.setRemainAmount(BigDecimal.ZERO);
                } else {
                    int i = x.getItemNum() - x.getReturnedNum();
                    BigDecimal divide = BigDecimal.valueOf(integer.intValue()).divide(BigDecimal.valueOf(i), 4, 5);
                    BigDecimal bigDecimal = Optional.ofNullable(x.getRemainAmount()).orElse(BigDecimal.ZERO).multiply(divide).setScale(2, 5);
                    total = total.add(bigDecimal);
                    x.setRemainAmount(Optional.ofNullable(x.getRemainAmount()).orElse(BigDecimal.ZERO).add(bigDecimal));
                }
            }
            this.tradeItemDas.updateSelective((BaseEo)x);
        }
        return total;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOuterReturnItem(ReturnEo returnEo, ReturnItemConfirmReqDto returnItemConfirmReqDto) {
        this.logger.info("saveOuterReturnItem-param={}", (Object)returnItemConfirmReqDto);
        String sellerId = returnEo.getSellerId();
        String customerId = returnEo.getCustomerId();
        Date curDate = new Date();
        ArrayList<String> returnNoList = new ArrayList<String>();
        returnNoList.add(returnEo.getReturnNo());
        List returnItemEoDbEntitys = this.returnItemDas.getReturnItemEos(returnNoList);
        if (CollectionUtils.isNotEmpty((Collection)returnItemEoDbEntitys)) {
            this.logger.warn("returnNo={} item aready exists", (Object)returnEo.getReturnNo());
        }
        List cargoCodes = returnItemConfirmReqDto.getReturnItemConfirmDetailReqDtos().stream().map(ReturnItemConfirmDetailReqDto::getCargoCode).filter(e -> StringUtils.isNotEmpty((CharSequence)e)).collect(Collectors.toList());
        cargoCodes = cargoCodes.stream().distinct().collect(Collectors.toList());
        List itemSkuRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuQueryApi.queryByCargoCode(cargoCodes));
        Map<String, ItemSkuExtRespDto> itemSkuRespDtoMap = itemSkuRespDtos.stream().collect(Collectors.toMap(ItemSkuRespDto::getCargoCode, e -> e, (e1, e2) -> e1));
        List skuIdList = itemSkuRespDtos.stream().map(e -> e.getId()).collect(Collectors.toList());
        SellerSkuPriceReqDto sellerSkuPriceReqDto = new SellerSkuPriceReqDto();
        sellerSkuPriceReqDto.setCustomerId(Long.valueOf(customerId));
        sellerSkuPriceReqDto.setSkuIdList(skuIdList.stream().distinct().collect(Collectors.toList()));
        List custSkuPriceList = (List)RestResponseHelper.extractData((RestResponse)this.sellerSkuPriceQueryApi.queryList(sellerSkuPriceReqDto));
        Map<String, SellerSkuPriceRespDto> custSkuPriceMap = custSkuPriceList.stream().collect(Collectors.toMap(e -> String.valueOf(e.getSkuId()), e -> e, (e1, e2) -> e1));
        ArrayList returnItemEos = Lists.newArrayList();
        ArrayList waitUpdTradeItemList = Lists.newArrayList();
        ReturnOrderCreateModeEnum createModeEnum = ReturnOrderCreateModeEnum.fromType((String)returnEo.getCreateMode());
        HashMap collect = Maps.newHashMap();
        for (ReturnItemConfirmDetailReqDto returnItemConfirmDetailReqDto : returnItemConfirmReqDto.getReturnItemConfirmDetailReqDtos()) {
            String orderNo = returnItemConfirmDetailReqDto.getOrderNo();
            if (collect.containsKey(orderNo)) {
                ((List)collect.get(orderNo)).add(returnItemConfirmDetailReqDto);
                continue;
            }
            collect.put(orderNo, Lists.newArrayList((Object[])new ReturnItemConfirmDetailReqDto[]{returnItemConfirmDetailReqDto}));
        }
        for (Map.Entry entry : collect.entrySet()) {
            List<ReturnItemConfirmDetailReqDto> mergeReturnItemForSku = AfterSalesTobServiceImpl.mergeReturnItemList((List)entry.getValue());
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)entry.getKey()))) {
                List manualTradeItemEoList = this.tradeItemService.queryByTradeNo((String)entry.getKey());
                ApplyReturnItemEo applyReturnItemEo = new ApplyReturnItemEo();
                applyReturnItemEo.setReturnNo(returnEo.getReturnNo());
                List applyReturnItemEos = this.applyReturnItemDas.select((BaseEo)applyReturnItemEo);
                if (CollectionUtils.isEmpty((Collection)applyReturnItemEos)) {
                    this.logger.info("\u539f\u5355\u9000\u8d27\u5355\uff0c\u7533\u8bf7\u6e05\u5355\u4e3a\u7a7a\uff1a{}", (Object)JSON.toJSONString((Object)applyReturnItemEo));
                    continue;
                }
                Map<Long, TradeItemEo> tradeItemEoMap = manualTradeItemEoList.stream().filter(e -> e.getGift() == 0).collect(Collectors.toMap(BaseEo::getId, e -> e, (e1, e2) -> e1));
                Map<String, List<ApplyReturnItemEo>> applyRrturnItemGroupMap = applyReturnItemEos.stream().collect(Collectors.groupingBy(ApplyReturnItemEo::getCargoSerial));
                Comparator<ApplyReturnItemEo> comparator = new Comparator<ApplyReturnItemEo>(){

                    @Override
                    public int compare(ApplyReturnItemEo o1, ApplyReturnItemEo o2) {
                        return o1.getItemPrice().compareTo(o2.getItemPrice());
                    }
                };
                for (Map.Entry<String, List<ApplyReturnItemEo>> cargoSerialPriceEntry : applyRrturnItemGroupMap.entrySet()) {
                    Collections.sort(cargoSerialPriceEntry.getValue(), comparator);
                }
                returnItemEos.addAll(this.packReturnItemEoFromOrder(returnEo, tradeItemEoMap, mergeReturnItemForSku, itemSkuRespDtoMap, custSkuPriceMap, waitUpdTradeItemList, applyRrturnItemGroupMap));
                continue;
            }
            returnItemEos.addAll(this.packReturnItemEoFromSku(returnEo, mergeReturnItemForSku, itemSkuRespDtoMap, custSkuPriceMap));
        }
        this.logger.info("saveOuterReturnItem-param-returnItemEos ={}", (Object)returnItemEos);
        if (CollectionUtils.isNotEmpty((Collection)returnItemEos)) {
            this.returnItemDas.insertBatch((List)returnItemEos);
            if (CollectionUtils.isNotEmpty((Collection)waitUpdTradeItemList)) {
                for (TradeItemEo tradeItemEo : waitUpdTradeItemList) {
                    this.tradeItemDas.update((BaseEo)tradeItemEo);
                }
            }
            BigDecimal totalRebate = returnItemEos.stream().map(item -> item.getReturnRebate() == null ? BigDecimal.ZERO : item.getReturnRebate()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal bigDecimal = returnItemEos.stream().map(item -> item.getRefundAmount() == null ? BigDecimal.ZERO : item.getRefundAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
            ReturnEo tmpUpdReturnEo = new ReturnEo();
            tmpUpdReturnEo.setRefundAmount(bigDecimal);
            tmpUpdReturnEo.setTotalAmount(bigDecimal);
            tmpUpdReturnEo.setReturnRebate(totalRebate);
            tmpUpdReturnEo.setUpdateTime(curDate);
            tmpUpdReturnEo.setId(returnEo.getId());
            this.returnDas.updateSelective((BaseEo)tmpUpdReturnEo);
        }
    }

    @Override
    @Transactional
    public void changeReturnItem(ReturnItemDataReqDto returnConfirmRefundReqDto) {
        ReturnItemEo returnItemEo = new ReturnItemEo();
        BeanUtils.copyProperties((Object)returnConfirmRefundReqDto, (Object)returnItemEo);
        this.returnItemDas.updateSelective((BaseEo)returnItemEo);
    }

    private List<ReturnItemEo> packReturnItemEoFromSku(ReturnEo returnEo, List<ReturnItemConfirmDetailReqDto> mergeReturnItemForSku, Map<String, ItemSkuExtRespDto> itemSkuRespDtoMap, Map<String, SellerSkuPriceRespDto> custSkuPriceMap) {
        Date curDate = new Date();
        return mergeReturnItemForSku.stream().map(bean -> {
            ReturnItemEo returnItemEo = new ReturnItemEo();
            ItemSkuExtRespDto itemSkuExtRespDto = (ItemSkuExtRespDto)itemSkuRespDtoMap.get(bean.getCargoCode());
            if (itemSkuExtRespDto == null) {
                this.logger.warn("\u8d27\u54c1\u7f16\u7801={}\u4e0d\u5b58\u5728,\u5546\u54c1\u65e0\u6cd5\u5165\u5e93", (Object)bean.getCargoCode());
                return null;
            }
            Long skuId = itemSkuExtRespDto.getId();
            SellerSkuPriceRespDto skuPrice = (SellerSkuPriceRespDto)custSkuPriceMap.get(String.valueOf(skuId));
            returnItemEo.setId(null);
            returnItemEo.setCreateTime(curDate);
            returnItemEo.setUpdateTime(curDate);
            returnItemEo.setItemId(String.valueOf(itemSkuExtRespDto.getItemId()));
            returnItemEo.setItemCode(itemSkuExtRespDto.getItemCode());
            returnItemEo.setItemName(itemSkuExtRespDto.getItemName());
            returnItemEo.setSkuSerial(String.valueOf(skuId));
            returnItemEo.setSkuCode(itemSkuExtRespDto.getSkuCode());
            returnItemEo.setSkuDesc(itemSkuExtRespDto.getAttr());
            returnItemEo.setCargoSerial(itemSkuExtRespDto.getCargoCode());
            returnItemEo.setReturnNo(returnEo.getReturnNo());
            returnItemEo.setGift(Integer.valueOf(0));
            returnItemEo.setItemNum(Integer.valueOf(0));
            returnItemEo.setShopId(returnEo.getShopId());
            returnItemEo.setReturnedNum(Integer.valueOf(0));
            returnItemEo.setReturnNum(Integer.valueOf(bean.getCurrentNum().intValue()));
            returnItemEo.setUnit(itemSkuExtRespDto.getUnit());
            returnItemEo.setBrandId(String.valueOf(itemSkuExtRespDto.getBrandId()));
            returnItemEo.setInstanceId(returnEo.getInstanceId());
            returnItemEo.setTenantId(returnEo.getTenantId());
            returnItemEo.setBatchNo(bean.getBatchNo());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("imgPath", (Object)itemSkuExtRespDto.getImgPath());
            jsonObject.put("subType", (Object)itemSkuExtRespDto.getSubType());
            returnItemEo.setExtension(jsonObject.toJSONString());
            returnItemEo.setReturnRebate(BigDecimal.ZERO);
            returnItemEo.setItemOrigPrice(Objects.nonNull(bean.getItemOrigPrice()) ? bean.getItemOrigPrice() : (skuPrice == null ? BigDecimal.ZERO : skuPrice.getSupplyPrice()));
            returnItemEo.setItemPrice(Objects.nonNull(bean.getItemPrice()) ? bean.getItemPrice() : (skuPrice == null ? BigDecimal.ZERO : skuPrice.getSupplyPrice()));
            returnItemEo.setRefundAmount(BigDecimal.valueOf(bean.getCurrentNum()).multiply(returnItemEo.getItemPrice()));
            return returnItemEo;
        }).filter(e -> e != null).collect(Collectors.toList());
    }

    private List<ReturnItemEo> packReturnItemEoFromOrder(ReturnEo returnEo, Map<Long, TradeItemEo> tradeItemEoMap, List<ReturnItemConfirmDetailReqDto> mergeReturnItemList, Map<String, ItemSkuExtRespDto> itemSkuRespDtoMap, Map<String, SellerSkuPriceRespDto> custSkuPriceMap, List<TradeItemEo> waitUpdTradeItemList, Map<String, List<ApplyReturnItemEo>> applyRrturnItemGroupMap) {
        ArrayList returnItems = Lists.newArrayList();
        for (ReturnItemConfirmDetailReqDto reqDto : mergeReturnItemList) {
            this.matchTradeItemEo(returnItems, reqDto, applyRrturnItemGroupMap);
        }
        this.logger.info("\u5b9e\u9000\u5546\u54c1\u884c\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)returnItems));
        Date curDate = new Date();
        return returnItems.stream().map(bean -> {
            ReturnItemEo returnItemEo = new ReturnItemEo();
            returnItemEo.setInstanceId(returnEo.getInstanceId());
            returnItemEo.setTenantId(returnEo.getTenantId());
            TradeItemEo tradeItemEo = (TradeItemEo)tradeItemEoMap.get(bean.getTradeOrderItemId());
            ItemSkuExtRespDto itemSkuExtRespDto = (ItemSkuExtRespDto)itemSkuRespDtoMap.get(bean.getCargoCode());
            if (itemSkuExtRespDto == null) {
                this.logger.warn("\u8d27\u54c1\u7f16\u7801={}\u4e0d\u5b58\u5728,\u5546\u54c1\u65e0\u6cd5\u5165\u5e93", (Object)bean.getCargoCode());
                return null;
            }
            if (tradeItemEo != null) {
                Integer returnedNum = Optional.ofNullable(tradeItemEo.getReturnedNum()).orElse(0);
                int canReturnNum = tradeItemEo.getItemNum() - returnedNum;
                BigDecimal rebateAmount = tradeItemEo.getRebateAmount() == null ? BigDecimal.ZERO : tradeItemEo.getRebateAmount();
                BigDecimal divide = rebateAmount.divide(BigDecimal.valueOf(tradeItemEo.getItemNum().intValue()), 2, 1);
                BeanUtils.copyProperties((Object)tradeItemEo, (Object)returnItemEo);
                returnedNum = returnedNum + bean.getCurrentNum().intValue();
                returnItemEo.setId(null);
                returnItemEo.setTradeItemId(tradeItemEo.getId());
                returnItemEo.setCreateTime(curDate);
                returnItemEo.setUpdateTime(curDate);
                returnItemEo.setItemId(tradeItemEo.getItemSerial());
                returnItemEo.setBrandId(tradeItemEo.getBrandSerial());
                returnItemEo.setSkuSerial(tradeItemEo.getSkuSerial());
                returnItemEo.setCargoSerial(itemSkuExtRespDto.getCargoCode());
                returnItemEo.setReturnNo(returnEo.getReturnNo());
                returnItemEo.setGift(tradeItemEo.getGift());
                returnItemEo.setItemNum(tradeItemEo.getItemNum());
                returnItemEo.setReturnedNum(returnedNum);
                returnItemEo.setReturnNum(Integer.valueOf(bean.getCurrentNum().intValue()));
                returnItemEo.setBatchNo(bean.getBatchNo());
                BigDecimal itemPayTotalAmount = this.getPostiveOrZore(tradeItemEo.getPayTotalAmount());
                BigDecimal itemSellPrice = this.getPostiveOrZore(tradeItemEo.getItemPrice());
                if (returnedNum >= tradeItemEo.getItemNum()) {
                    BigDecimal leftRebateAmount = rebateAmount.subtract(divide.multiply(BigDecimal.valueOf(canReturnNum)));
                    returnItemEo.setReturnRebate(leftRebateAmount);
                    BigDecimal leftRefundAmount = itemPayTotalAmount.subtract(itemSellPrice.multiply(BigDecimal.valueOf(canReturnNum)));
                    returnItemEo.setRefundAmount(leftRefundAmount);
                } else {
                    returnItemEo.setReturnRebate(divide.multiply(BigDecimal.valueOf(bean.getCurrentNum())));
                    returnItemEo.setRefundAmount(BigDecimal.valueOf(bean.getCurrentNum()).multiply(itemSellPrice));
                }
                returnItemEo.setItemOrigPrice(tradeItemEo.getItemMarketPrice());
                returnItemEo.setIfExchange(tradeItemEo.getIfExchange());
                tradeItemEo.setReturnedNum(returnedNum);
                tradeItemEo.setUpdateTime(curDate);
                waitUpdTradeItemList.add(tradeItemEo);
            } else {
                Long skuId = itemSkuExtRespDto.getId();
                SellerSkuPriceRespDto skuPrice = (SellerSkuPriceRespDto)custSkuPriceMap.get(String.valueOf(skuId));
                returnItemEo.setId(null);
                returnItemEo.setCreateTime(curDate);
                returnItemEo.setUpdateTime(curDate);
                returnItemEo.setItemId(String.valueOf(itemSkuExtRespDto.getItemId()));
                returnItemEo.setItemCode(itemSkuExtRespDto.getItemCode());
                returnItemEo.setItemName(itemSkuExtRespDto.getItemName());
                returnItemEo.setSkuCode(itemSkuExtRespDto.getSkuCode());
                returnItemEo.setSkuSerial(String.valueOf(skuId));
                returnItemEo.setSkuDesc(itemSkuExtRespDto.getAttr());
                returnItemEo.setCargoSerial(itemSkuExtRespDto.getCargoCode());
                returnItemEo.setReturnNo(returnEo.getReturnNo());
                returnItemEo.setGift(Integer.valueOf(0));
                returnItemEo.setItemNum(Integer.valueOf(0));
                returnItemEo.setReturnedNum(Integer.valueOf(0));
                returnItemEo.setReturnNum(Integer.valueOf(bean.getCurrentNum().intValue()));
                returnItemEo.setUnit(itemSkuExtRespDto.getUnit());
                returnItemEo.setBrandId(String.valueOf(itemSkuExtRespDto.getBrandId()));
                returnItemEo.setShopId(returnEo.getShopId());
                returnItemEo.setBatchNo(bean.getBatchNo());
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("imgPath", (Object)itemSkuExtRespDto.getImgPath());
                jsonObject.put("subType", (Object)itemSkuExtRespDto.getSubType());
                returnItemEo.setExtension(jsonObject.toJSONString());
                returnItemEo.setReturnRebate(BigDecimal.ZERO);
                returnItemEo.setItemOrigPrice(Objects.nonNull(bean.getItemOrigPrice()) ? bean.getItemOrigPrice() : (skuPrice == null ? BigDecimal.ZERO : skuPrice.getSupplyPrice()));
                returnItemEo.setItemPrice(Objects.nonNull(bean.getItemPrice()) ? bean.getItemPrice() : (skuPrice == null ? BigDecimal.ZERO : skuPrice.getSupplyPrice()));
                returnItemEo.setRefundAmount(BigDecimal.valueOf(bean.getCurrentNum()).multiply(returnItemEo.getItemPrice()));
            }
            return returnItemEo;
        }).filter(e -> e != null).collect(Collectors.toList());
    }

    public static void main(String[] args) {
        TradeItemEo tradeItemEo = new TradeItemEo();
        tradeItemEo.setReturnedNum(Integer.valueOf(1));
        System.out.println(Optional.ofNullable(tradeItemEo.getReturnedNum()).orElse(0));
    }

    private void matchTradeItemEo(List<ReturnItemConfirmDetailReqDto> returnItems, ReturnItemConfirmDetailReqDto returnItemDetail, Map<String, List<ApplyReturnItemEo>> applyRrturnItemGroupMap) {
        String cargoSerial = returnItemDetail.getCargoCode();
        if (applyRrturnItemGroupMap.containsKey(cargoSerial)) {
            List<ApplyReturnItemEo> applyReturnItemEos = applyRrturnItemGroupMap.get(cargoSerial);
            if (CollectionUtils.isNotEmpty(applyReturnItemEos)) {
                if (applyReturnItemEos.size() == 1) {
                    ApplyReturnItemEo applyReturnItemEo = applyReturnItemEos.get(0);
                    returnItemDetail.setMatchedNum(returnItemDetail.getCurrentNum());
                    ReturnItemConfirmDetailReqDto reqDto = new ReturnItemConfirmDetailReqDto();
                    CubeBeanUtils.copyProperties((Object)reqDto, (Object)returnItemDetail, (String[])new String[]{"tradeOrderItemId", "currentNum"});
                    reqDto.setTradeOrderItemId(applyReturnItemEo.getTradeItemId());
                    reqDto.setCurrentNum(returnItemDetail.getCurrentNum());
                    returnItems.add(reqDto);
                } else {
                    this.matchSortPriceTradeItemEo(returnItems, applyReturnItemEos, returnItemDetail);
                }
            }
        } else {
            returnItems.add(returnItemDetail);
        }
    }

    private void matchSortPriceTradeItemEo(List<ReturnItemConfirmDetailReqDto> returnItems, List<ApplyReturnItemEo> applyReturnItemEos, ReturnItemConfirmDetailReqDto returnItemDetail) {
        for (ApplyReturnItemEo applyReturnItemEo : applyReturnItemEos) {
            Integer itemNum = applyReturnItemEo.getItemNum();
            Long currentNum = returnItemDetail.getCurrentNum();
            Long matchedNum = returnItemDetail.getMatchedNum();
            long avaNum = currentNum - matchedNum;
            long retrunNum = avaNum > (long)itemNum.intValue() ? (long)itemNum.intValue() : avaNum;
            returnItemDetail.setMatchedNum(Long.valueOf(matchedNum + retrunNum));
            ReturnItemConfirmDetailReqDto reqDto = new ReturnItemConfirmDetailReqDto();
            CubeBeanUtils.copyProperties((Object)reqDto, (Object)returnItemDetail, (String[])new String[]{"tradeOrderItemId", "currentNum", "batchNo"});
            reqDto.setTradeOrderItemId(applyReturnItemEo.getTradeItemId());
            reqDto.setCurrentNum(Long.valueOf(retrunNum));
            if (StringUtils.isNotBlank((CharSequence)returnItemDetail.getBatchNo())) {
                String[] split = returnItemDetail.getBatchNo().split(",");
                String arr = split[0];
                String[] batch = arr.split("#");
                reqDto.setBatchNo(batch[0] + "#" + retrunNum);
            }
            returnItems.add(reqDto);
            if (currentNum - returnItemDetail.getMatchedNum() > 0L) continue;
            return;
        }
    }

    private BigDecimal getPostiveOrZore(BigDecimal num) {
        if (num == null || num.compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimal.ZERO;
        }
        return num;
    }

    public static List<ReturnItemConfirmDetailReqDto> mergeReturnItemList(List<ReturnItemConfirmDetailReqDto> returnItemConfirmDetailReqDtos) {
        ArrayList returnItemConfirmDetailReqDtoList = Lists.newArrayList();
        Map<String, List<ReturnItemConfirmDetailReqDto>> collectMap = returnItemConfirmDetailReqDtos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getCargoCode()) && e.getCurrentNum() > 0L).collect(Collectors.groupingBy(e -> e.getTradeOrderItemId() + "_" + e.getCargoCode()));
        collectMap.keySet().forEach(re -> {
            ReturnItemConfirmDetailReqDto returnItemConfirmDetailReqDto = new ReturnItemConfirmDetailReqDto();
            AtomicReference<Long> num = new AtomicReference<Long>(0L);
            StringBuffer batchNStr = new StringBuffer();
            ((List)collectMap.get(re)).forEach(item -> {
                BeanUtils.copyProperties((Object)item, (Object)returnItemConfirmDetailReqDto);
                batchNStr.append(item.getBatchNo()).append("#").append(item.getCurrentNum()).append(",");
                num.set((Long)num.get() + item.getCurrentNum());
            });
            returnItemConfirmDetailReqDto.setBatchNo(batchNStr.substring(0, batchNStr.lastIndexOf(",")));
            returnItemConfirmDetailReqDto.setCurrentNum(num.get());
            returnItemConfirmDetailReqDtoList.add(returnItemConfirmDetailReqDto);
        });
        return returnItemConfirmDetailReqDtoList;
    }
}

