/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BasicConfigReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BasicConfigRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IBasicConfigService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.tob.BasicConfigDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.tob.BasicConfigEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BasicConfigServiceImpl
implements IBasicConfigService {
    @Resource
    private BasicConfigDas basicConfigDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addBasicConfig(BasicConfigReqDto addReqDto) {
        BasicConfigEo queryEo = new BasicConfigEo();
        queryEo.setConfigCode(addReqDto.getConfigCode());
        queryEo.setType(addReqDto.getType());
        queryEo.setOrganizationId(addReqDto.getOrganizationId());
        queryEo = (BasicConfigEo)this.basicConfigDas.selectOne((BaseEo)queryEo);
        if (queryEo != null) {
            return queryEo.getId();
        }
        BasicConfigEo basicConfigEo = new BasicConfigEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)basicConfigEo);
        this.basicConfigDas.insert((BaseEo)basicConfigEo);
        return basicConfigEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchModifyBasicConfig(List<BasicConfigReqDto> modifyReqDtos) {
        for (BasicConfigReqDto modifyReqDto : modifyReqDtos) {
            if (modifyReqDto.getId() != null) {
                BasicConfigEo basicConfigEo = new BasicConfigEo();
                basicConfigEo.setId(modifyReqDto.getId());
                basicConfigEo.setValue(modifyReqDto.getValue());
                this.basicConfigDas.updateSelective((BaseEo)basicConfigEo);
                continue;
            }
            this.addBasicConfig(modifyReqDto);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBasicConfig(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.basicConfigDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public BasicConfigRespDto queryById(Long id) {
        BasicConfigEo basicConfigEo = (BasicConfigEo)this.basicConfigDas.selectByPrimaryKey(id);
        BasicConfigRespDto basicConfigRespDto = new BasicConfigRespDto();
        DtoHelper.eo2Dto((BaseEo)basicConfigEo, (BaseVo)basicConfigRespDto);
        return basicConfigRespDto;
    }

    @Override
    public PageInfo<BasicConfigRespDto> queryByPage(BasicConfigReqDto basicConfigReqDto) {
        BasicConfigEo basicConfigEo = new BasicConfigEo();
        DtoHelper.dto2Eo((BaseVo)basicConfigReqDto, (BaseEo)basicConfigEo);
        PageInfo eoPageInfo = this.basicConfigDas.selectPage((BaseEo)basicConfigEo, basicConfigReqDto.getPageNum(), basicConfigReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BasicConfigRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public BasicConfigRespDto queryByCodeAndType(String configCode, String type, Long orgId) {
        BasicConfigEo basicConfigEo = new BasicConfigEo();
        basicConfigEo.setConfigCode(configCode);
        basicConfigEo.setType(type);
        basicConfigEo.setOrganizationId(orgId);
        basicConfigEo = (BasicConfigEo)this.basicConfigDas.selectOne((BaseEo)basicConfigEo);
        BasicConfigRespDto basicConfigRespDto = null;
        if (basicConfigEo != null) {
            basicConfigRespDto = new BasicConfigRespDto();
            CubeBeanUtils.copyProperties((Object)basicConfigRespDto, (Object)basicConfigEo, (String[])new String[0]);
        }
        return basicConfigRespDto;
    }
}

