/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ExchangeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderDeliveryTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.FactoryDeliveryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderExtInfoDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OrderModTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OrderStatisticsReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.tob.OrderStatisticsRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.constants.BaseFlowDef;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.action.OrderFlowTobAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.OrderBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.enums.OrderTradeStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.OrderFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderTobService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.tob.IOptLogService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderAddressDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.tob.AttachementDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderAddressEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderStatisticsEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.tob.AttachementEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.tob.OptLogEo;
import com.dtyunxi.yundt.cube.center.trade.dao.vo.OrderStatisticsVo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class OrderServiceTobImpl
implements IOrderTobService {
    private static Logger logger = LoggerFactory.getLogger(OrderServiceTobImpl.class);
    @Resource
    private OrderDas orderDas;
    @Resource
    private IOptLogService optLogService;
    @Resource
    protected ICacheService cacheService;
    @Resource
    private TradeItemDas tradeItemDas;
    @Resource
    private OrderAddressDas orderAddressDas;
    @Resource
    private AttachementDas attachementDas;
    @Resource
    private ICacheService commonCacheService;
    @Resource
    private OrderFlowAction orderFlowAction;
    @Resource
    private OrderFlowTobAction orderFlowTobAction;
    @Autowired
    private IContext context;
    @Autowired
    private DeliveryOrderDas deliveryOrderDas;

    @Override
    public void modifyOrderInfo(OrderModTobReqDto orderModTobReq) {
        OrderEo orderEo = (OrderEo)this.orderDas.selectByPrimaryKey(orderModTobReq.getId());
        if (orderEo == null) {
            throw new BizException("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!OrderTradeStatusEnum.DRAFT.getCode().equals(orderEo.getOrderTradeStatus())) {
            throw new BizException("\u8349\u7a3f\u72b6\u6001\u624d\u80fd\u7f16\u8f91");
        }
        String orderExt = this.getTobOrderExt(orderModTobReq);
        OrderEo updateEo = new OrderEo();
        updateEo.setExtension(orderExt);
        updateEo.setDeliveryDate(orderModTobReq.getDeliveryDate());
        updateEo.setDeliveryAddress(JSON.toJSONString((Object)orderModTobReq.getDeliveryAddress()));
        updateEo.setId(orderModTobReq.getId());
        logger.info("modifyOrderInfo\u4e2d\u7684orderModTobReq>>>{}", (Object)JSON.toJSONString((Object)updateEo));
        this.orderDas.updateSelective((BaseEo)updateEo);
        if (CollectionUtils.isNotEmpty((Collection)orderModTobReq.getOrderItems())) {
            TradeItemEo tradeItemEo = new TradeItemEo();
            tradeItemEo.setTradeNo(orderEo.getOrderNo());
            this.tradeItemDas.logicDelete((BaseEo)tradeItemEo);
            this.cacheService.delCache("order_item_list_" + orderEo.getOrderNo());
            List tradeItemEos = orderModTobReq.getOrderItems().stream().filter(e -> e.getGift() == 0 && ExchangeEnum.NO.getType().equals(e.getIfExchange())).map(e -> {
                TradeItemEo eo = (TradeItemEo)EoUtil.dtoToEo((BaseVo)e, TradeItemEo.class);
                eo.setTradeItemNo(TradeUtil.generateTradeNo((String)orderEo.getOrderNo()));
                eo.setTradeNo(orderEo.getOrderNo());
                eo.setUserId(orderEo.getUserId());
                eo.setGift(e.getGift());
                eo.setCustomerId(orderEo.getCustomerId());
                eo.setItemMarketPrice(e.getItemOrigPrice());
                this.checkNullParams(eo);
                return eo;
            }).collect(Collectors.toList());
            logger.info("\u7f16\u8f91\u540e\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(tradeItemEos));
            if (CollectionUtils.isNotEmpty(tradeItemEos)) {
                this.tradeItemDas.insertBatch(tradeItemEos);
            }
        }
        OrderAddressEo orderAddressEo_query = OrderAddressEo.newInstance();
        orderAddressEo_query.setOrderNo(orderModTobReq.getOrderNo());
        OrderAddressEo orderAddressEo = (OrderAddressEo)this.orderAddressDas.selectOne((BaseEo)orderAddressEo_query);
        logger.info("\u66f4\u65b0\u5730\u5740,\u539f\u6765\u7684\u5730\u5740>>>{}", (Object)JSON.toJSONString((Object)orderAddressEo));
        if (Objects.nonNull(orderAddressEo)) {
            this.cacheService.delCache("order_address" + orderModTobReq.getOrderNo());
            OrderAddressEo needAddressEo = (OrderAddressEo)EoUtil.dtoToEo((BaseVo)orderModTobReq.getDeliveryAddress(), OrderAddressEo.class);
            needAddressEo.setId(orderAddressEo.getId());
            needAddressEo.setOrderNo(orderModTobReq.getOrderNo());
            logger.info("\u66f4\u65b0\u5730\u5740,\u65b0\u7684\u5730\u5740>>>{}", (Object)JSON.toJSONString((Object)orderAddressEo));
            this.orderAddressDas.updateSelective((BaseEo)needAddressEo);
        }
        AttachementEo delAttachmentEo = new AttachementEo();
        delAttachmentEo.setBizNo(orderEo.getOrderNo());
        delAttachmentEo.setBizType(OptBizTypeEnum.ORDER.getType());
        this.attachementDas.delete((BaseEo)delAttachmentEo);
        if (CollectionUtils.isNotEmpty((Collection)orderModTobReq.getAttachements())) {
            ArrayList attachmentEoList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)attachmentEoList, (Collection)orderModTobReq.getAttachements(), AttachementEo.class);
            this.attachementDas.insertBatch((List)attachmentEoList);
        }
    }

    @Override
    public boolean updateStatus(OrderModTobReqDto orderModTobReq) {
        OrderEo orderEo = new OrderEo();
        orderEo.setOrderNo(orderModTobReq.getOrderNo());
        OrderEo dbRecord = (OrderEo)this.orderDas.selectOne((BaseEo)orderEo);
        if (dbRecord == null) {
            return false;
        }
        dbRecord.setOrderStatus(orderModTobReq.getOrderStatus());
        int i = this.orderDas.updateSelective((BaseEo)dbRecord);
        return i > 0;
    }

    private String getTobOrderExt(OrderModTobReqDto orderModTobReq) {
        if (CollectionUtils.isNotEmpty((Collection)orderModTobReq.getExtInfos())) {
            OrderExtInfoDto orderExtInfoDto = (OrderExtInfoDto)orderModTobReq.getExtInfos().get(0);
            JSONObject extenJson = null;
            extenJson = StringUtils.isEmpty((CharSequence)orderModTobReq.getExtension()) ? new JSONObject() : JSONObject.parseObject((String)orderModTobReq.getExtension());
            if (StringUtils.isNotBlank((CharSequence)orderExtInfoDto.getInvoice())) {
                extenJson.put("invoice", (Object)orderExtInfoDto.getInvoice());
            }
            return extenJson.toJSONString();
        }
        return null;
    }

    private void checkNullParams(TradeItemEo tradeItemEo) {
        tradeItemEo.setItemPrice((BigDecimal)ObjectUtils.defaultIfNull((Object)tradeItemEo.getItemPrice(), (Object)BigDecimal.ZERO));
        tradeItemEo.setItemOrigPrice((BigDecimal)ObjectUtils.defaultIfNull((Object)tradeItemEo.getItemOrigPrice(), (Object)BigDecimal.ZERO));
        tradeItemEo.setShopType((String)StringUtils.defaultIfBlank((CharSequence)tradeItemEo.getShopType(), (CharSequence)"online"));
        tradeItemEo.setCatalogSerial((String)StringUtils.defaultIfBlank((CharSequence)tradeItemEo.getCatalogSerial(), (CharSequence)"0"));
        tradeItemEo.setBrandSerial((String)StringUtils.defaultIfBlank((CharSequence)tradeItemEo.getBrandSerial(), (CharSequence)"0"));
        tradeItemEo.setItemType((Integer)ObjectUtils.defaultIfNull((Object)tradeItemEo.getItemType(), (Object)1));
        tradeItemEo.setItemSerial((String)StringUtils.defaultIfBlank((CharSequence)tradeItemEo.getItemSerial(), (CharSequence)"0"));
        tradeItemEo.setItemVer((String)StringUtils.defaultIfBlank((CharSequence)tradeItemEo.getItemVer(), (CharSequence)"0"));
        tradeItemEo.setShopId((String)StringUtils.defaultIfBlank((CharSequence)tradeItemEo.getShopId(), (CharSequence)"0"));
        tradeItemEo.setSkuSerial((String)StringUtils.defaultIfBlank((CharSequence)tradeItemEo.getSkuSerial(), (CharSequence)"0"));
        tradeItemEo.setThirdSkuSerial((String)StringUtils.defaultIfBlank((CharSequence)tradeItemEo.getThirdSkuSerial(), (CharSequence)"0"));
        tradeItemEo.setCargoSrc(StringUtils.defaultString((String)tradeItemEo.getCargoSrc()));
        tradeItemEo.setCargoSerial(StringUtils.defaultString((String)tradeItemEo.getCargoSerial()));
        tradeItemEo.setItemName(StringUtils.defaultString((String)tradeItemEo.getItemName()));
        tradeItemEo.setItemNum((Integer)ObjectUtils.defaultIfNull((Object)tradeItemEo.getItemNum(), (Object)0));
        tradeItemEo.setPriceType((Integer)ObjectUtils.defaultIfNull((Object)tradeItemEo.getPriceType(), (Object)0));
        tradeItemEo.setPayTotalAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)tradeItemEo.getPayTotalAmount(), (Object)BigDecimal.ZERO));
        tradeItemEo.setSkuDesc(StringUtils.defaultString((String)tradeItemEo.getSkuDesc()));
        tradeItemEo.setDiscounted((Integer)ObjectUtils.defaultIfNull((Object)tradeItemEo.getDiscounted(), (Object)0));
        tradeItemEo.setIsNotCondition((Integer)ObjectUtils.defaultIfNull((Object)tradeItemEo.getIsNotCondition(), (Object)0));
        tradeItemEo.setDr((Integer)ObjectUtils.defaultIfNull((Object)tradeItemEo.getDr(), (Object)0));
    }

    @Override
    public PageInfo<OrderStatisticsRespDto> statisticsOrder(OrderStatisticsReqDto orderStatisticsReqDto) {
        OrderStatisticsEo orderStatisticsEo = new OrderStatisticsEo();
        CubeBeanUtils.copyProperties((Object)orderStatisticsEo, (Object)orderStatisticsReqDto, (String[])new String[0]);
        List orderStatisticsVos = new ArrayList();
        if ("0".equals(orderStatisticsReqDto.getType())) {
            String cacheKey = "ORDER_STATISTICS_CACHE_" + orderStatisticsReqDto.getSalesmanId() + "_" + orderStatisticsReqDto.getStartTime().getTime() + "_" + orderStatisticsReqDto.getEndTime().getTime() + "_" + orderStatisticsReqDto.getPageNum() + "_" + orderStatisticsReqDto.getPageSize();
            orderStatisticsVos = (List)this.commonCacheService.getCache(cacheKey, (TypeReference)new TypeReference<List<OrderStatisticsVo>>(){});
            if (CollectionUtils.isEmpty(orderStatisticsVos) && CollectionUtils.isNotEmpty(orderStatisticsVos = this.orderDas.statisticsOrder(orderStatisticsEo))) {
                this.commonCacheService.setCache(cacheKey, orderStatisticsVos, 600);
            }
        } else {
            orderStatisticsVos = this.orderDas.statisticsOrder(orderStatisticsEo);
        }
        return new PageInfo(orderStatisticsVos);
    }

    @Override
    public void updateOrderDeliveryStatus(String orderNo, String statusCode) {
        OrderEo orderEo = new OrderEo();
        orderEo.setOrderNo(orderNo);
        orderEo = (OrderEo)this.orderDas.selectOne((BaseEo)orderEo);
        if (orderEo == null) {
            throw new BizException(String.format("\u6839\u636e\u8ba2\u5355\u53f7[%s]\uff0c\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355", orderNo));
        }
        OrderBo orderBo = new OrderBo();
        orderBo.setOrderNo(orderNo);
        orderBo.setDriveFlowParam(BaseFlowDef.BASE_ORDER_TOB.getFlowId(), BaseFlowDef.BASE_ORDER_TOB.getFlowName(), orderNo);
        orderBo.setOrderEo(orderEo);
        if ("ALL_OUT_STORAGE".equals(statusCode)) {
            this.orderFlowAction.outStorageForAll(orderBo);
        } else if ("ALL_DELIVERY".equals(statusCode)) {
            this.orderFlowTobAction.deliveryForAll(orderBo);
        } else if ("CONFIRM".equals(statusCode)) {
            this.orderFlowAction.receiptAllOrder(orderBo);
            this.saveOptLog(orderBo.getOrderEo().getOrderNo());
        }
    }

    @Override
    public void factoryDelivery(FactoryDeliveryReqDto factoryDeliveryReqDto) {
        this.updateOrderDeliveryStatus(factoryDeliveryReqDto.getOrderNo(), "ALL_DELIVERY");
        if (factoryDeliveryReqDto.isShipping()) {
            DeliveryOrderEo deliveryOrderEo = new DeliveryOrderEo();
            DtoHelper.dto2Eo((BaseVo)factoryDeliveryReqDto, (BaseEo)deliveryOrderEo);
            deliveryOrderEo.setDeliveryType(OrderDeliveryTypeEnum.FACTORY.getType());
            this.deliveryOrderDas.insert((BaseEo)deliveryOrderEo);
        }
    }

    private void saveOptLog(String bizNo) {
        OptLogEo optLogEo = new OptLogEo();
        optLogEo.setBizType(OptBizTypeEnum.ORDER.getType());
        optLogEo.setBizNo(bizNo);
        optLogEo.setOptType(OptTypeEnum.ORDER_FINISH.getType());
        optLogEo.setOptTime(new Date());
        optLogEo.setOptPerson(this.context.userName());
        optLogEo.setDescription("\u3010\u5df2\u7b7e\u6536\u3011\u8ba2\u5355\u5df2\u7b7e\u6536,\u8ba2\u5355\u5b8c\u6210\u3002");
        this.optLogService.addBoOptLog(optLogEo);
    }
}

