/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl.tob;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.AttachementReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.trade.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.trade.biz.service.tob.IAttachementService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.tob.AttachementDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.tob.AttachementEo;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AttachementServiceImpl
implements IAttachementService {
    @Resource
    private AttachementDas attachementDas;

    @Override
    public Long addAttachement(AttachementEo attachementEo) {
        this.attachementDas.insert((BaseEo)attachementEo);
        return attachementEo.getId();
    }

    @Override
    public void modifyAttachement(AttachementEo attachementEo) {
        EoUtil.setNullVal((Object)attachementEo, (String[])new String[]{"createTime"});
        this.attachementDas.updateSelective((BaseEo)attachementEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAttachement(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.attachementDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public AttachementReqDto queryById(Long id) {
        AttachementEo attachementEo = (AttachementEo)this.attachementDas.selectByPrimaryKey(id);
        AttachementReqDto attachementReqDto = (AttachementReqDto)EoUtil.eoToDto((BaseEo)attachementEo, AttachementReqDto.class);
        return attachementReqDto;
    }

    @Override
    public List<AttachementReqDto> queryByIds(List<Long> attachementId) {
        AttachementEo query = (AttachementEo)SqlFilterBuilder.create(AttachementEo.class).in("id", attachementId).eo();
        List attachements = this.attachementDas.select((BaseEo)query);
        List attachementDtos = EoUtil.eoListToDtoList((Collection)attachements, AttachementReqDto.class);
        return attachementDtos;
    }

    @Override
    public PageInfo<AttachementReqDto> queryByPage(AttachementReqDto attachementReqDto, Integer pageNum, Integer pageSize) {
        AttachementEo queryEo = (AttachementEo)EoUtil.dtoToEo((BaseVo)attachementReqDto, AttachementEo.class);
        PageInfo eoPageInfo = this.attachementDas.selectPage((BaseEo)queryEo, pageNum, pageSize);
        return EoUtil.eoPageToDtoPage((PageInfo)eoPageInfo, AttachementReqDto.class);
    }

    @Override
    public List<AttachementReqDto> queryByNoAndType(String bizNo, String bizType) {
        AttachementEo query = (AttachementEo)SqlFilterBuilder.create(AttachementEo.class).eq("bizNo", (Object)bizNo).eq("bizType", (Object)bizType).eo();
        return EoUtil.eoListToDtoList((Collection)this.attachementDas.select((BaseEo)query), AttachementReqDto.class);
    }
}

