package com.dtyunxi.yundt.cube.biz.account.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.account.api.dto.request.MemberCardAppRefundReqDto;
import com.dtyunxi.yundt.cube.biz.account.api.dto.request.MemberCardPayReqDto;
import com.dtyunxi.yundt.cube.biz.account.api.dto.request.MemberCardRechargeRefundReqDto;
import com.dtyunxi.yundt.cube.biz.account.api.dto.request.MemberCardRefundReqDto;
import com.dtyunxi.yundt.cube.biz.account.api.dto.response.MemberCardPayRespDto;
import com.dtyunxi.yundt.cube.biz.account.api.dto.response.MemberCardRefundRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;

/**
 * @Description: 会员卡账户操作接口
 * @Author: 水镜
 * @Date: 2019/7/5 15:15
 * @Version: 0.1.0
 */
@Api(tags = {"会员卡账户操作接口"})
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-biz-account-api-IMemberCardAccountApi", name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}", path = "/v1/account", url = "${yundt.cube.center.account.api:}")
public interface IMemberCardAccountApi {

    /**
     * 会员卡支付
     *
     * @param memberCardPayReqDto   会员卡支付dto
     * @return
     */
    @PostMapping(value = "/pay", produces = "application/json")
    @ApiOperation(value = "会员卡支付", notes = "会员卡支付")
    RestResponse<MemberCardPayRespDto> pay(@Valid @RequestBody MemberCardPayReqDto memberCardPayReqDto);

    /**
     * 会员卡支付冲正
     *
     * @param paymentNo
     * @return
     */
    @PostMapping(value = "/pay-rtn", produces = "application/json")
    @ApiOperation(value = "会员卡支付冲正", notes = "会员卡支付冲正")
    RestResponse<Void> payRtn(@Valid @RequestParam("paymentNo") String paymentNo);

    /**
     * 会员卡退款
     *
     * @param memberCardRefundReqDto   会员卡退款Dto（用于线下退款）
     * @return
     */
    @PostMapping(value = "/refund", produces = "application/json")
    @ApiOperation(value = "会员卡退款", notes = "会员卡退款")
    RestResponse<MemberCardRefundRespDto> refund(@Valid @RequestBody MemberCardRefundReqDto memberCardRefundReqDto);

    /**
     * 小程序充值退款
     * @param memberCardRechargeRefundReqDto
     * @return
     */
    @PostMapping(value = "/recharge/refund", produces = "application/json")
    @ApiOperation(value = "会员卡退款", notes = "会员卡退款")
    RestResponse<MemberCardRefundRespDto> rechargeRefund(@RequestBody MemberCardRechargeRefundReqDto memberCardRechargeRefundReqDto);


    /**
     * 会员卡线上退款
     * @param memberCardAppRefundReqDto 会员卡线上退款Dto（监听OMS销退单/取消单）
     */
    @PostMapping(value = "/refund/online", produces = "application/json")
    @ApiOperation(value = "会员卡线上退款", notes = "会员卡线上退款")
    RestResponse<Void> refundOnline(@RequestBody MemberCardAppRefundReqDto memberCardAppRefundReqDto);
}
