package com.dtyunxi.yundt.cube.biz.account.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.account.api.dto.request.DisableMemberAllReqDto;
import com.dtyunxi.yundt.cube.biz.account.api.dto.request.MemberCardAccountUpdateReqDto;
import com.dtyunxi.yundt.cube.biz.account.api.dto.request.MemberCardAddReqDto;
import com.dtyunxi.yundt.cube.biz.account.api.dto.response.CardFinanceRecordRespDto;
import com.dtyunxi.yundt.cube.biz.account.api.dto.response.MmmberCardMonthAmountRespDto;
import com.dtyunxi.yundt.cube.biz.account.api.dto.response.TradeFlowRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @Description: 会员卡操作接口
 * @Author: 小骨
 * @Date: 2019/6/28 14:02
 * @Version: 0.1.0
 */
@Api(tags = {"会员卡操作接口"})
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-biz-account-api-IMemberCardApi", name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}", path = "/v1/memberCard", url = "${yundt.cube.center.account.api:}")
public interface IMemberCardApi {

    /**
     * 会员卡充值
     *
     * @param dto 会员卡生成Dto
     * @return
     */
    @PostMapping(value = "/recharge", produces = "application/json")
    @ApiOperation(value = "会员卡充值", notes = "会员卡充值")
    RestResponse<CardFinanceRecordRespDto> rechargeToCardAccount(@RequestBody MemberCardAccountUpdateReqDto dto);

    /**
     * 生成会员卡
     * @param dto
     * @return 会员卡，卡号
     */
    @PostMapping(value = "/save", produces = "application/json")
    @ApiOperation(value = "生成会员卡", notes = "生成会员卡")
    RestResponse<String> saveMemberCard(@RequestBody @Valid MemberCardAddReqDto dto);

    /**
     * 添加会员卡
     * @param dto
     * @return 会员卡，卡号
     */
    @PostMapping(value = "/add", produces = "application/json")
    @ApiOperation(value = "添加会员卡", notes = "添加会员卡")
    RestResponse<String> addMemberCard(@RequestBody @Valid MemberCardAddReqDto dto);

    /**
     * 账户绑定会员卡
     * @param memberId
     * @param cardNo
     */
    @PostMapping(value = "/bind", produces = "application/json")
    @ApiOperation(value = "账户绑定会员卡", notes = "账户绑定会员卡")
    RestResponse bindMemberCard(@NotNull @RequestParam(name = "memberId") Long memberId, @NotNull @RequestParam(name = "cardNo") String cardNo);

    /**
     * 会员卡冻结/解冻/挂失/解挂
     * @param dto
     * @return
     */
    @PostMapping(value = "/freeze", produces = "application/json")
    @ApiOperation(value = "会员卡冻结", notes = "会员卡冻结")
    RestResponse disableMemberCard(@RequestBody @Valid DisableMemberAllReqDto dto);

    /**
     * 接收营销中心的赠送规则
     * @param dto
     * @return
     */
    @PostMapping(value = "/updateAmount", produces = "application/json")
    @ApiOperation(value = "接收赠送规则", notes = "接收赠送规则")
    RestResponse updateAmount(@RequestBody @Valid MemberCardAccountUpdateReqDto dto);

    /**
     * 根据mameberId 修改账户 状态
     * @param memberId
     * @param status
     * @return
     */
    @PostMapping(value = "/updateStauts", produces = "application/json")
    @ApiOperation(value = "会员id", notes = "会员ID 和需要修改的状态")
    RestResponse updateStautsByMemberId(@RequestParam("memberId") Long memberId, @RequestParam("status") String status);

    @PostMapping(value = "/correction", produces = "application/json")
    @ApiOperation(value = "充值冲正", notes = "会员充值冲正")
    RestResponse<TradeFlowRespDto> correction(@RequestBody @Valid MemberCardAccountUpdateReqDto dto);

    @GetMapping(value = "/updatePassword", produces = "application/json")
    @ApiOperation(value = "修改密码", notes = "修改密码")
    RestResponse updatePassword(@RequestParam("memberId") Long memberId, @RequestParam("password") String password);

    @PostMapping(value = "/adjustment/amount", produces = "application/json")
    @ApiOperation(value = "线下金额调整", notes = "线下金额调整")
    RestResponse adjustmentAmount(@RequestBody @Valid MemberCardAccountUpdateReqDto dto);

    /**
     *根据memberid 进行统计
     * @param
     * @return
     */
    @GetMapping(value = "/month/amount", produces = "application/json")
    @ApiOperation(value = "月统计储值", notes = "月统计储值")
    RestResponse<MmmberCardMonthAmountRespDto> monthAmount(@RequestParam("monthAmount") BigDecimal monthAmount);

    @GetMapping(value = "/updateMemberInfo", produces = "application/json")
    @ApiOperation(value = "修改姓名,手机号", notes = "修改姓名，手机号")
    RestResponse updateMemberInfo(@RequestParam("memberId") Long memberId, @RequestParam(value = "name", required = false) String name, @RequestParam(value = "moblie", required = false) String moblie);

    @GetMapping(value = "/delete", produces = "application/json")
    @ApiOperation(value = "注销并逻辑删除", notes = "注销并逻辑删除")
    RestResponse delete(@RequestParam("memberId") Long memberId);

    @PutMapping(value = "/memberMerge")
    @ApiOperation(value = "会员账户合并", notes = "会员账户合并")
    RestResponse<String> memberAccountMerge(@RequestParam(name = "mainMemberId") Long mainMemberId, @RequestParam(name = "subMemberId") Long subMemberId);

    @GetMapping(value = "/export/card/flow", produces = "application/json")
    @ApiImplicitParams({@ApiImplicitParam(name = "filter", value = "查询条件json字符串,例如 {name:\"App1\"}", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "cardAccountId", value = "账户id", dataType = "integer", paramType = "query"),})
    @ApiOperation(value = "会员卡流水导出列表", notes = "会员卡流水导出列表,filter为查询条件的json字符串，内容如下：\n" +
            "示例：\n" +
            "{\n" +
            "\t\"tenantId\": 1,\n" +
            "\t\"instanceId\": 1,\n" +
            "\t\"filters\": [{\n" +
            "\t\t\t\"property\": \"cardAccount\",\n" +
            "\t\t\t\"operator\": \"eq\",\n" +
            "\t\t\t\"value\": \"23232323\"\n" +
            "\t\t},\n" +
            "\t\t{\n" +
            "\t\t\t\"property\": \"type\",\n" +
            "\t\t\t\"operator\": \"eq\",\n" +
            "\t\t\t\"value\": \"01\"\n" +
            "\t\t}\n" +
            "\t],\n" +
            "\t\"orderBy\": \"createTime\",\n" +
            "\t\"orderByDesc\": \"id\",\n" +
            "}")
    RestResponse<String> exportCardFlow(@RequestParam(value = "cardAccountId", required = false) Long cardAccountId,
                                        @RequestParam("filter") String filter,
                                        @RequestParam(name = "pageNum", required = false) Integer pageNum,
                                        @RequestParam("type") String type,
                                        @RequestParam(name = "pageSize", required = false) Integer pageSize);
}